/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class GaussianBlur
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;

    public GaussianBlur() {
    }

    public GaussianBlur(double radius) {
        this.setRadius(radius);
    }

    @Override
    com.sun.scenario.effect.GaussianBlur createPeer() {
        return new com.sun.scenario.effect.GaussianBlur();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 10.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DoublePropertyBase(10.0){

                public void invalidated() {
                    GaussianBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    GaussianBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return GaussianBlur.this;
                }

                public String getName() {
                    return "radius";
                }
            };
        }
        return this.radius;
    }

    private float getClampedRadius() {
        return (float)Utils.clamp(0.0, this.getRadius(), 63.0);
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.GaussianBlur peer = (com.sun.scenario.effect.GaussianBlur)this.getPeer();
        peer.setRadius(this.getClampedRadius());
        peer.setInput(localInput == null ? null : localInput.getPeer());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = GaussianBlur.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        float r = this.getClampedRadius();
        bounds = bounds.deriveWithPadding(r, r, 0.0f);
        return GaussianBlur.transformBounds(tx, bounds);
    }

    @Override
    Effect copy() {
        return new GaussianBlur(this.getRadius());
    }
}

