/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class Reflection
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty topOffset;
    private DoubleProperty topOpacity;
    private DoubleProperty bottomOpacity;
    private DoubleProperty fraction;

    public Reflection() {
    }

    public Reflection(double topOffset, double fraction, double topOpacity, double bottomOpacity) {
        this.setBottomOpacity(bottomOpacity);
        this.setTopOffset(topOffset);
        this.setTopOpacity(topOpacity);
        this.setFraction(fraction);
    }

    @Override
    com.sun.scenario.effect.Reflection createPeer() {
        return new com.sun.scenario.effect.Reflection();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setTopOffset(double value) {
        this.topOffsetProperty().set(value);
    }

    public final double getTopOffset() {
        return this.topOffset == null ? 0.0 : this.topOffset.get();
    }

    public final DoubleProperty topOffsetProperty() {
        if (this.topOffset == null) {
            this.topOffset = new DoublePropertyBase(){

                public void invalidated() {
                    Reflection.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    Reflection.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return Reflection.this;
                }

                public String getName() {
                    return "topOffset";
                }
            };
        }
        return this.topOffset;
    }

    public final void setTopOpacity(double value) {
        this.topOpacityProperty().set(value);
    }

    public final double getTopOpacity() {
        return this.topOpacity == null ? 0.5 : this.topOpacity.get();
    }

    public final DoubleProperty topOpacityProperty() {
        if (this.topOpacity == null) {
            this.topOpacity = new DoublePropertyBase(0.5){

                public void invalidated() {
                    Reflection.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Reflection.this;
                }

                public String getName() {
                    return "topOpacity";
                }
            };
        }
        return this.topOpacity;
    }

    public final void setBottomOpacity(double value) {
        this.bottomOpacityProperty().set(value);
    }

    public final double getBottomOpacity() {
        return this.bottomOpacity == null ? 0.0 : this.bottomOpacity.get();
    }

    public final DoubleProperty bottomOpacityProperty() {
        if (this.bottomOpacity == null) {
            this.bottomOpacity = new DoublePropertyBase(){

                public void invalidated() {
                    Reflection.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Reflection.this;
                }

                public String getName() {
                    return "bottomOpacity";
                }
            };
        }
        return this.bottomOpacity;
    }

    public final void setFraction(double value) {
        this.fractionProperty().set(value);
    }

    public final double getFraction() {
        return this.fraction == null ? 0.75 : this.fraction.get();
    }

    public final DoubleProperty fractionProperty() {
        if (this.fraction == null) {
            this.fraction = new DoublePropertyBase(0.75){

                public void invalidated() {
                    Reflection.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    Reflection.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return Reflection.this;
                }

                public String getName() {
                    return "fraction";
                }
            };
        }
        return this.fraction;
    }

    private float getClampedFraction() {
        return (float)Utils.clamp(0.0, this.getFraction(), 1.0);
    }

    private float getClampedBottomOpacity() {
        return (float)Utils.clamp(0.0, this.getBottomOpacity(), 1.0);
    }

    private float getClampedTopOpacity() {
        return (float)Utils.clamp(0.0, this.getTopOpacity(), 1.0);
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.Reflection peer = (com.sun.scenario.effect.Reflection)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setFraction(this.getClampedFraction());
        peer.setTopOffset((float)this.getTopOffset());
        peer.setBottomOpacity(this.getClampedBottomOpacity());
        peer.setTopOpacity(this.getClampedTopOpacity());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = Reflection.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        bounds.roundOut();
        float x1 = bounds.getMinX();
        float y1 = bounds.getMaxY() + (float)this.getTopOffset();
        float z1 = bounds.getMinZ();
        float x2 = bounds.getMaxX();
        float y2 = y1 + this.getClampedFraction() * bounds.getHeight();
        float z2 = bounds.getMaxZ();
        BaseBounds ret = BaseBounds.getInstance(x1, y1, z1, x2, y2, z2);
        ret = ret.deriveWithUnion(bounds);
        return Reflection.transformBounds(tx, ret);
    }

    @Override
    Effect copy() {
        Reflection ref = new Reflection(this.getTopOffset(), this.getFraction(), this.getTopOpacity(), this.getBottomOpacity());
        ref.setInput(ref.getInput());
        return ref;
    }
}

