/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.Toolkit;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.paint.Color;

public class WritableImage
extends Image {
    private ImageLoader tkImageLoader;
    private PixelBuffer<? extends Buffer> pixelBuffer = null;
    private PixelWriter writer;

    public WritableImage(@NamedArg(value="width") int width, @NamedArg(value="height") int height) {
        super(width, height);
    }

    public WritableImage(@NamedArg(value="PixelBuffer") PixelBuffer<? extends Buffer> pixelBuffer) {
        super(WritableImage.validatePixelBuffer(pixelBuffer));
        pixelBuffer.addImage(this);
        this.pixelBuffer = pixelBuffer;
    }

    public WritableImage(@NamedArg(value="reader") PixelReader reader, @NamedArg(value="width") int width, @NamedArg(value="height") int height) {
        super(width, height);
        this.getPixelWriter().setPixels(0, 0, width, height, reader, 0, 0);
    }

    public WritableImage(@NamedArg(value="reader") PixelReader reader, @NamedArg(value="x") int x, @NamedArg(value="y") int y, @NamedArg(value="width") int width, @NamedArg(value="height") int height) {
        super(width, height);
        this.getPixelWriter().setPixels(0, 0, width, height, reader, x, y);
    }

    @Override
    boolean isAnimation() {
        return true;
    }

    @Override
    boolean pixelsReadable() {
        return true;
    }

    void bufferDirty(Rectangle rect) {
        this.getWritablePlatformImage().bufferDirty(rect);
        this.pixelsDirty();
    }

    private static PixelBuffer<? extends Buffer> validatePixelBuffer(PixelBuffer<? extends Buffer> pixelBuffer) {
        return Objects.requireNonNull(pixelBuffer, "pixelBuffer must not be null.");
    }

    public final PixelWriter getPixelWriter() {
        if (this.pixelBuffer != null) {
            throw new UnsupportedOperationException("PixelWriter is not supported with PixelBuffer");
        }
        if (this.getProgress() < 1.0 || this.isError()) {
            return null;
        }
        if (this.writer == null) {
            this.writer = new PixelWriter(){
                ReadOnlyObjectProperty<PlatformImage> pimgprop;
                {
                    this.pimgprop = WritableImage.this.acc_platformImageProperty();
                }

                @Override
                public PixelFormat getPixelFormat() {
                    PlatformImage pimg = WritableImage.this.getWritablePlatformImage();
                    return pimg.getPlatformPixelFormat();
                }

                @Override
                public void setArgb(int x, int y, int argb) {
                    WritableImage.this.getWritablePlatformImage().setArgb(x, y, argb);
                    WritableImage.this.pixelsDirty();
                }

                @Override
                public void setColor(int x, int y, Color c) {
                    if (c == null) {
                        throw new NullPointerException("Color cannot be null");
                    }
                    int a = (int)Math.round(c.getOpacity() * 255.0);
                    int r = (int)Math.round(c.getRed() * 255.0);
                    int g = (int)Math.round(c.getGreen() * 255.0);
                    int b = (int)Math.round(c.getBlue() * 255.0);
                    this.setArgb(x, y, a << 24 | r << 16 | g << 8 | b);
                }

                @Override
                public <T extends Buffer> void setPixels(int x, int y, int w, int h, PixelFormat<T> pixelformat, T buffer, int scanlineStride) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    PlatformImage pimg = WritableImage.this.getWritablePlatformImage();
                    pimg.setPixels(x, y, w, h, pixelformat, buffer, scanlineStride);
                    WritableImage.this.pixelsDirty();
                }

                @Override
                public void setPixels(int x, int y, int w, int h, PixelFormat<ByteBuffer> pixelformat, byte[] buffer, int offset, int scanlineStride) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    PlatformImage pimg = WritableImage.this.getWritablePlatformImage();
                    pimg.setPixels(x, y, w, h, pixelformat, buffer, offset, scanlineStride);
                    WritableImage.this.pixelsDirty();
                }

                @Override
                public void setPixels(int x, int y, int w, int h, PixelFormat<IntBuffer> pixelformat, int[] buffer, int offset, int scanlineStride) {
                    if (pixelformat == null) {
                        throw new NullPointerException("PixelFormat cannot be null");
                    }
                    if (buffer == null) {
                        throw new NullPointerException("Buffer cannot be null");
                    }
                    PlatformImage pimg = WritableImage.this.getWritablePlatformImage();
                    pimg.setPixels(x, y, w, h, pixelformat, buffer, offset, scanlineStride);
                    WritableImage.this.pixelsDirty();
                }

                @Override
                public void setPixels(int writex, int writey, int w, int h, PixelReader reader, int readx, int ready) {
                    if (reader == null) {
                        throw new NullPointerException("Reader cannot be null");
                    }
                    PlatformImage pimg = WritableImage.this.getWritablePlatformImage();
                    pimg.setPixels(writex, writey, w, h, reader, readx, ready);
                    WritableImage.this.pixelsDirty();
                }
            };
        }
        return this.writer;
    }

    private void loadTkImage(Object loader) {
        if (!(loader instanceof ImageLoader)) {
            throw new IllegalArgumentException("Unrecognized image loader: " + loader);
        }
        ImageLoader tkLoader = (ImageLoader)loader;
        if (tkLoader.getWidth() != (double)((int)this.getWidth()) || tkLoader.getHeight() != (double)((int)this.getHeight())) {
            throw new IllegalArgumentException("Size of loader does not match size of image");
        }
        super.setPlatformImage(tkLoader.getFrame(0));
        this.tkImageLoader = tkLoader;
    }

    private Object getTkImageLoader() {
        return this.tkImageLoader;
    }

    static {
        Toolkit.setWritableImageAccessor(new Toolkit.WritableImageAccessor(){

            @Override
            public void loadTkImage(WritableImage wimg, Object loader) {
                wimg.loadTkImage(loader);
            }

            @Override
            public Object getTkImageLoader(WritableImage wimg) {
                return wimg.getTkImageLoader();
            }
        });
    }
}

