/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.PickResult;

public final class ZoomEvent
extends GestureEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<ZoomEvent> ANY = new EventType(GestureEvent.ANY, "ANY_ZOOM");
    public static final EventType<ZoomEvent> ZOOM = new EventType(ANY, "ZOOM");
    public static final EventType<ZoomEvent> ZOOM_STARTED = new EventType(ANY, "ZOOM_STARTED");
    public static final EventType<ZoomEvent> ZOOM_FINISHED = new EventType(ANY, "ZOOM_FINISHED");
    private final double zoomFactor;
    private final double totalZoomFactor;

    public ZoomEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<ZoomEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="zoomFactor") double zoomFactor, @NamedArg(value="totalZoomFactor") double totalZoomFactor, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, pickResult);
        this.zoomFactor = zoomFactor;
        this.totalZoomFactor = totalZoomFactor;
    }

    public ZoomEvent(@NamedArg(value="eventType") EventType<ZoomEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="zoomFactor") double zoomFactor, @NamedArg(value="totalZoomFactor") double totalZoomFactor, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, zoomFactor, totalZoomFactor, pickResult);
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public double getTotalZoomFactor() {
        return this.totalZoomFactor;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ZoomEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", zoomFactor = ").append(this.getZoomFactor());
        sb.append(", totalZoomFactor = ").append(this.getTotalZoomFactor());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isInertia()) {
            sb.append(", inertia");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    @Override
    public ZoomEvent copyFor(Object newSource, EventTarget newTarget) {
        return (ZoomEvent)super.copyFor(newSource, newTarget);
    }

    public ZoomEvent copyFor(Object newSource, EventTarget newTarget, EventType<ZoomEvent> type) {
        ZoomEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<ZoomEvent> getEventType() {
        return super.getEventType();
    }
}

