/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.geom.Vec2d;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class BorderPane
extends Pane {
    private static final String MARGIN = "borderpane-margin";
    private static final String ALIGNMENT = "borderpane-alignment";
    private ObjectProperty<Node> center;
    private ObjectProperty<Node> top;
    private ObjectProperty<Node> bottom;
    private ObjectProperty<Node> left;
    private ObjectProperty<Node> right;

    public static void setAlignment(Node child, Pos value) {
        BorderPane.setConstraint(child, ALIGNMENT, (Object)value);
    }

    public static Pos getAlignment(Node child) {
        return (Pos)((Object)BorderPane.getConstraint(child, ALIGNMENT));
    }

    public static void setMargin(Node child, Insets value) {
        BorderPane.setConstraint(child, MARGIN, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)BorderPane.getConstraint(child, MARGIN);
    }

    private static Insets getNodeMargin(Node child) {
        Insets margin = BorderPane.getMargin(child);
        return margin != null ? margin : Insets.EMPTY;
    }

    public static void clearConstraints(Node child) {
        BorderPane.setAlignment(child, null);
        BorderPane.setMargin(child, null);
    }

    public BorderPane() {
    }

    public BorderPane(Node center) {
        this.setCenter(center);
    }

    public BorderPane(Node center, Node top, Node right, Node bottom, Node left) {
        this.setCenter(center);
        this.setTop(top);
        this.setRight(right);
        this.setBottom(bottom);
        this.setLeft(left);
    }

    public final ObjectProperty<Node> centerProperty() {
        if (this.center == null) {
            this.center = new BorderPositionProperty("center");
        }
        return this.center;
    }

    public final void setCenter(Node value) {
        this.centerProperty().set((Object)value);
    }

    public final Node getCenter() {
        return this.center == null ? null : (Node)this.center.get();
    }

    public final ObjectProperty<Node> topProperty() {
        if (this.top == null) {
            this.top = new BorderPositionProperty("top");
        }
        return this.top;
    }

    public final void setTop(Node value) {
        this.topProperty().set((Object)value);
    }

    public final Node getTop() {
        return this.top == null ? null : (Node)this.top.get();
    }

    public final ObjectProperty<Node> bottomProperty() {
        if (this.bottom == null) {
            this.bottom = new BorderPositionProperty("bottom");
        }
        return this.bottom;
    }

    public final void setBottom(Node value) {
        this.bottomProperty().set((Object)value);
    }

    public final Node getBottom() {
        return this.bottom == null ? null : (Node)this.bottom.get();
    }

    public final ObjectProperty<Node> leftProperty() {
        if (this.left == null) {
            this.left = new BorderPositionProperty("left");
        }
        return this.left;
    }

    public final void setLeft(Node value) {
        this.leftProperty().set((Object)value);
    }

    public final Node getLeft() {
        return this.left == null ? null : (Node)this.left.get();
    }

    public final ObjectProperty<Node> rightProperty() {
        if (this.right == null) {
            this.right = new BorderPositionProperty("right");
        }
        return this.right;
    }

    public final void setRight(Node value) {
        this.rightProperty().set((Object)value);
    }

    public final Node getRight() {
        return this.right == null ? null : (Node)this.right.get();
    }

    @Override
    public Orientation getContentBias() {
        Node c = this.getCenter();
        if (c != null && c.isManaged() && c.getContentBias() != null) {
            return c.getContentBias();
        }
        Node r = this.getRight();
        if (r != null && r.isManaged() && r.getContentBias() == Orientation.VERTICAL) {
            return r.getContentBias();
        }
        Node l = this.getLeft();
        if (l != null && l.isManaged() && l.getContentBias() == Orientation.VERTICAL) {
            return l.getContentBias();
        }
        Node b = this.getBottom();
        if (b != null && b.isManaged() && b.getContentBias() == Orientation.HORIZONTAL) {
            return b.getContentBias();
        }
        Node t = this.getTop();
        if (t != null && t.isManaged() && t.getContentBias() == Orientation.HORIZONTAL) {
            return t.getContentBias();
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double height) {
        double centerMinWidth;
        double rightPrefWidth;
        double leftPrefWidth;
        double topMinWidth = this.getAreaWidth(this.getTop(), -1.0, true);
        double bottomMinWidth = this.getAreaWidth(this.getBottom(), -1.0, true);
        if (height != -1.0 && (this.childHasContentBias(this.getLeft(), Orientation.VERTICAL) || this.childHasContentBias(this.getRight(), Orientation.VERTICAL) || this.childHasContentBias(this.getCenter(), Orientation.VERTICAL))) {
            double topPrefHeight = this.getAreaHeight(this.getTop(), -1.0, false);
            double bottomPrefHeight = this.getAreaHeight(this.getBottom(), -1.0, false);
            double middleAreaHeight = Math.max(0.0, height - topPrefHeight - bottomPrefHeight);
            leftPrefWidth = this.getAreaWidth(this.getLeft(), middleAreaHeight, false);
            rightPrefWidth = this.getAreaWidth(this.getRight(), middleAreaHeight, false);
            centerMinWidth = this.getAreaWidth(this.getCenter(), middleAreaHeight, true);
        } else {
            leftPrefWidth = this.getAreaWidth(this.getLeft(), -1.0, false);
            rightPrefWidth = this.getAreaWidth(this.getRight(), -1.0, false);
            centerMinWidth = this.getAreaWidth(this.getCenter(), -1.0, true);
        }
        Insets insets = this.getInsets();
        return insets.getLeft() + Math.max(leftPrefWidth + centerMinWidth + rightPrefWidth, Math.max(topMinWidth, bottomMinWidth)) + insets.getRight();
    }

    @Override
    protected double computeMinHeight(double width) {
        double centerMinHeight;
        Insets insets = this.getInsets();
        double topPrefHeight = this.getAreaHeight(this.getTop(), width, false);
        double bottomPrefHeight = this.getAreaHeight(this.getBottom(), width, false);
        double leftMinHeight = this.getAreaHeight(this.getLeft(), -1.0, true);
        double rightMinHeight = this.getAreaHeight(this.getRight(), -1.0, true);
        if (width != -1.0 && this.childHasContentBias(this.getCenter(), Orientation.HORIZONTAL)) {
            double leftPrefWidth = this.getAreaWidth(this.getLeft(), -1.0, false);
            double rightPrefWidth = this.getAreaWidth(this.getRight(), -1.0, false);
            centerMinHeight = this.getAreaHeight(this.getCenter(), Math.max(0.0, width - leftPrefWidth - rightPrefWidth), true);
        } else {
            centerMinHeight = this.getAreaHeight(this.getCenter(), -1.0, true);
        }
        double middleAreaMinHeigh = Math.max(centerMinHeight, Math.max(rightMinHeight, leftMinHeight));
        return insets.getTop() + topPrefHeight + middleAreaMinHeigh + bottomPrefHeight + insets.getBottom();
    }

    @Override
    protected double computePrefWidth(double height) {
        double centerPrefWidth;
        double rightPrefWidth;
        double leftPrefWidth;
        double topPrefWidth = this.getAreaWidth(this.getTop(), -1.0, false);
        double bottomPrefWidth = this.getAreaWidth(this.getBottom(), -1.0, false);
        if (height != -1.0 && (this.childHasContentBias(this.getLeft(), Orientation.VERTICAL) || this.childHasContentBias(this.getRight(), Orientation.VERTICAL) || this.childHasContentBias(this.getCenter(), Orientation.VERTICAL))) {
            double topPrefHeight = this.getAreaHeight(this.getTop(), -1.0, false);
            double bottomPrefHeight = this.getAreaHeight(this.getBottom(), -1.0, false);
            double middleAreaHeight = Math.max(0.0, height - topPrefHeight - bottomPrefHeight);
            leftPrefWidth = this.getAreaWidth(this.getLeft(), middleAreaHeight, false);
            rightPrefWidth = this.getAreaWidth(this.getRight(), middleAreaHeight, false);
            centerPrefWidth = this.getAreaWidth(this.getCenter(), middleAreaHeight, false);
        } else {
            leftPrefWidth = this.getAreaWidth(this.getLeft(), -1.0, false);
            rightPrefWidth = this.getAreaWidth(this.getRight(), -1.0, false);
            centerPrefWidth = this.getAreaWidth(this.getCenter(), -1.0, false);
        }
        Insets insets = this.getInsets();
        return insets.getLeft() + Math.max(leftPrefWidth + centerPrefWidth + rightPrefWidth, Math.max(topPrefWidth, bottomPrefWidth)) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double width) {
        double centerPrefHeight;
        Insets insets = this.getInsets();
        double topPrefHeight = this.getAreaHeight(this.getTop(), width, false);
        double bottomPrefHeight = this.getAreaHeight(this.getBottom(), width, false);
        double leftPrefHeight = this.getAreaHeight(this.getLeft(), -1.0, false);
        double rightPrefHeight = this.getAreaHeight(this.getRight(), -1.0, false);
        if (width != -1.0 && this.childHasContentBias(this.getCenter(), Orientation.HORIZONTAL)) {
            double leftPrefWidth = this.getAreaWidth(this.getLeft(), -1.0, false);
            double rightPrefWidth = this.getAreaWidth(this.getRight(), -1.0, false);
            centerPrefHeight = this.getAreaHeight(this.getCenter(), Math.max(0.0, width - leftPrefWidth - rightPrefWidth), false);
        } else {
            centerPrefHeight = this.getAreaHeight(this.getCenter(), -1.0, false);
        }
        double middleAreaPrefHeigh = Math.max(centerPrefHeight, Math.max(rightPrefHeight, leftPrefHeight));
        return insets.getTop() + topPrefHeight + middleAreaPrefHeigh + bottomPrefHeight + insets.getBottom();
    }

    @Override
    protected void layoutChildren() {
        Pos alignment;
        double minHeight;
        double minWidth;
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        Orientation bias = this.getContentBias();
        if (bias == null) {
            minWidth = this.minWidth(-1.0);
            minHeight = this.minHeight(-1.0);
            width = width < minWidth ? minWidth : width;
            height = height < minHeight ? minHeight : height;
        } else if (bias == Orientation.HORIZONTAL) {
            minWidth = this.minWidth(-1.0);
            width = width < minWidth ? minWidth : width;
            minHeight = this.minHeight(width);
            height = height < minHeight ? minHeight : height;
        } else {
            double minHeight2 = this.minHeight(-1.0);
            height = height < minHeight2 ? minHeight2 : height;
            double minWidth2 = this.minWidth(height);
            width = width < minWidth2 ? minWidth2 : width;
        }
        double insideX = insets.getLeft();
        double insideY = insets.getTop();
        double insideWidth = width - insideX - insets.getRight();
        double insideHeight = height - insideY - insets.getBottom();
        Node c = this.getCenter();
        Node r = this.getRight();
        Node b = this.getBottom();
        Node l = this.getLeft();
        Node t = this.getTop();
        double topHeight = 0.0;
        if (t != null && t.isManaged()) {
            Insets topMargin = BorderPane.getNodeMargin(t);
            double adjustedWidth = this.adjustWidthByMargin(insideWidth, topMargin);
            double adjustedHeight = this.adjustHeightByMargin(insideHeight, topMargin);
            topHeight = this.snapSizeY(t.prefHeight(adjustedWidth));
            topHeight = Math.min(topHeight, adjustedHeight);
            Vec2d result = BorderPane.boundedNodeSizeWithBias(t, adjustedWidth, topHeight, true, true, TEMP_VEC2D);
            topHeight = this.snapSizeY(result.y);
            t.resize(this.snapSizeX(result.x), topHeight);
            topHeight = this.snapSpaceY(topMargin.getBottom()) + topHeight + this.snapSpaceY(topMargin.getTop());
            alignment = BorderPane.getAlignment(t);
            BorderPane.positionInArea(t, insideX, insideY, insideWidth, topHeight, 0.0, topMargin, alignment != null ? alignment.getHpos() : HPos.LEFT, alignment != null ? alignment.getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        double bottomHeight = 0.0;
        if (b != null && b.isManaged()) {
            Insets bottomMargin = BorderPane.getNodeMargin(b);
            double adjustedWidth = this.adjustWidthByMargin(insideWidth, bottomMargin);
            double adjustedHeight = this.adjustHeightByMargin(insideHeight - topHeight, bottomMargin);
            bottomHeight = this.snapSizeY(b.prefHeight(adjustedWidth));
            bottomHeight = Math.min(bottomHeight, adjustedHeight);
            Vec2d result = BorderPane.boundedNodeSizeWithBias(b, adjustedWidth, bottomHeight, true, true, TEMP_VEC2D);
            bottomHeight = this.snapSizeY(result.y);
            b.resize(this.snapSizeX(result.x), bottomHeight);
            bottomHeight = this.snapSpaceY(bottomMargin.getBottom()) + bottomHeight + this.snapSpaceY(bottomMargin.getTop());
            Pos alignment2 = BorderPane.getAlignment(b);
            BorderPane.positionInArea(b, insideX, insideY + insideHeight - bottomHeight, insideWidth, bottomHeight, 0.0, bottomMargin, alignment2 != null ? alignment2.getHpos() : HPos.LEFT, alignment2 != null ? alignment2.getVpos() : VPos.BOTTOM, this.isSnapToPixel());
        }
        double leftWidth = 0.0;
        if (l != null && l.isManaged()) {
            Insets leftMargin = BorderPane.getNodeMargin(l);
            double adjustedWidth = this.adjustWidthByMargin(insideWidth, leftMargin);
            double adjustedHeight = this.adjustHeightByMargin(insideHeight - topHeight - bottomHeight, leftMargin);
            leftWidth = this.snapSizeX(l.prefWidth(adjustedHeight));
            leftWidth = Math.min(leftWidth, adjustedWidth);
            Vec2d result = BorderPane.boundedNodeSizeWithBias(l, leftWidth, adjustedHeight, true, true, TEMP_VEC2D);
            leftWidth = this.snapSizeX(result.x);
            l.resize(leftWidth, this.snapSizeY(result.y));
            leftWidth = this.snapSpaceX(leftMargin.getLeft()) + leftWidth + this.snapSpaceX(leftMargin.getRight());
            Pos alignment3 = BorderPane.getAlignment(l);
            BorderPane.positionInArea(l, insideX, insideY + topHeight, leftWidth, insideHeight - topHeight - bottomHeight, 0.0, leftMargin, alignment3 != null ? alignment3.getHpos() : HPos.LEFT, alignment3 != null ? alignment3.getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        double rightWidth = 0.0;
        if (r != null && r.isManaged()) {
            Insets rightMargin = BorderPane.getNodeMargin(r);
            double adjustedWidth = this.adjustWidthByMargin(insideWidth - leftWidth, rightMargin);
            double adjustedHeight = this.adjustHeightByMargin(insideHeight - topHeight - bottomHeight, rightMargin);
            rightWidth = this.snapSizeX(r.prefWidth(adjustedHeight));
            rightWidth = Math.min(rightWidth, adjustedWidth);
            Vec2d result = BorderPane.boundedNodeSizeWithBias(r, rightWidth, adjustedHeight, true, true, TEMP_VEC2D);
            rightWidth = this.snapSizeX(result.x);
            r.resize(rightWidth, this.snapSizeY(result.y));
            rightWidth = this.snapSpaceX(rightMargin.getLeft()) + rightWidth + this.snapSpaceX(rightMargin.getRight());
            Pos alignment4 = BorderPane.getAlignment(r);
            BorderPane.positionInArea(r, insideX + insideWidth - rightWidth, insideY + topHeight, rightWidth, insideHeight - topHeight - bottomHeight, 0.0, rightMargin, alignment4 != null ? alignment4.getHpos() : HPos.RIGHT, alignment4 != null ? alignment4.getVpos() : VPos.TOP, this.isSnapToPixel());
        }
        if (c != null && c.isManaged()) {
            alignment = BorderPane.getAlignment(c);
            this.layoutInArea(c, insideX + leftWidth, insideY + topHeight, insideWidth - leftWidth - rightWidth, insideHeight - topHeight - bottomHeight, 0.0, BorderPane.getNodeMargin(c), alignment != null ? alignment.getHpos() : HPos.CENTER, alignment != null ? alignment.getVpos() : VPos.CENTER);
        }
    }

    private double getAreaWidth(Node child, double height, boolean minimum) {
        if (child != null && child.isManaged()) {
            Insets margin = BorderPane.getNodeMargin(child);
            return minimum ? this.computeChildMinAreaWidth(child, -1.0, margin, height, false) : this.computeChildPrefAreaWidth(child, -1.0, margin, height, false);
        }
        return 0.0;
    }

    private double getAreaHeight(Node child, double width, boolean minimum) {
        if (child != null && child.isManaged()) {
            Insets margin = BorderPane.getNodeMargin(child);
            return minimum ? this.computeChildMinAreaHeight(child, -1.0, margin, width) : this.computeChildPrefAreaHeight(child, -1.0, margin, width);
        }
        return 0.0;
    }

    private boolean childHasContentBias(Node child, Orientation orientation) {
        if (child != null && child.isManaged()) {
            return child.getContentBias() == orientation;
        }
        return false;
    }

    private final class BorderPositionProperty
    extends ObjectPropertyBase<Node> {
        private Node oldValue = null;
        private final String propertyName;
        private boolean isBeingInvalidated;

        BorderPositionProperty(String propertyName) {
            this.propertyName = propertyName;
            BorderPane.this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

                public void onChanged(ListChangeListener.Change<? extends Node> c) {
                    if (BorderPositionProperty.this.oldValue == null || BorderPositionProperty.this.isBeingInvalidated) {
                        return;
                    }
                    while (c.next()) {
                        if (!c.wasRemoved()) continue;
                        List removed = c.getRemoved();
                        int sz = removed.size();
                        for (int i = 0; i < sz; ++i) {
                            if (removed.get(i) != BorderPositionProperty.this.oldValue) continue;
                            BorderPositionProperty.this.oldValue = null;
                            BorderPositionProperty.this.set(null);
                        }
                    }
                }
            });
        }

        protected void invalidated() {
            ObservableList<Node> children = BorderPane.this.getChildren();
            this.isBeingInvalidated = true;
            try {
                Node _value;
                if (this.oldValue != null) {
                    children.remove(this.oldValue);
                }
                this.oldValue = _value = (Node)this.get();
                if (_value != null) {
                    children.add(_value);
                }
            }
            finally {
                this.isBeingInvalidated = false;
            }
        }

        public Object getBean() {
            return BorderPane.this;
        }

        public String getName() {
            return this.propertyName;
        }
    }
}

