/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.paint.MaterialHelper;
import com.sun.javafx.scene.shape.Shape3DHelper;
import com.sun.javafx.sg.prism.NGShape3D;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.PredefinedMeshManager;

public abstract class Shape3D
extends Node {
    private static final PhongMaterial DEFAULT_MATERIAL;
    PredefinedMeshManager manager = PredefinedMeshManager.getInstance();
    Key key;
    private ObjectProperty<Material> material;
    private ObjectProperty<DrawMode> drawMode;
    private ObjectProperty<CullFace> cullFace;

    protected Shape3D() {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String logname = Shape3D.class.getName();
            PlatformLogger.getLogger((String)logname).warning("System can't support ConditionalFeature.SCENE3D");
        }
    }

    public final void setMaterial(Material value) {
        this.materialProperty().set((Object)value);
    }

    public final Material getMaterial() {
        return this.material == null ? null : (Material)this.material.get();
    }

    public final ObjectProperty<Material> materialProperty() {
        if (this.material == null) {
            this.material = new SimpleObjectProperty<Material>((Object)this, "material"){
                private Material old;
                private final ChangeListener<Boolean> materialChangeListener;
                private final WeakChangeListener<Boolean> weakMaterialChangeListener;
                {
                    this.old = null;
                    this.materialChangeListener = (observable, oldValue, newValue) -> {
                        if (newValue.booleanValue()) {
                            NodeHelper.markDirty(Shape3D.this, DirtyBits.MATERIAL);
                        }
                    };
                    this.weakMaterialChangeListener = new WeakChangeListener(this.materialChangeListener);
                }

                protected void invalidated() {
                    Material newMaterial;
                    if (this.old != null) {
                        MaterialHelper.dirtyProperty(this.old).removeListener(this.weakMaterialChangeListener);
                    }
                    if ((newMaterial = (Material)this.get()) != null) {
                        MaterialHelper.dirtyProperty(newMaterial).addListener(this.weakMaterialChangeListener);
                    }
                    NodeHelper.markDirty(Shape3D.this, DirtyBits.MATERIAL);
                    NodeHelper.geomChanged(Shape3D.this);
                    this.old = newMaterial;
                }
            };
        }
        return this.material;
    }

    public final void setDrawMode(DrawMode value) {
        this.drawModeProperty().set((Object)value);
    }

    public final DrawMode getDrawMode() {
        return this.drawMode == null ? DrawMode.FILL : (DrawMode)((Object)this.drawMode.get());
    }

    public final ObjectProperty<DrawMode> drawModeProperty() {
        if (this.drawMode == null) {
            this.drawMode = new SimpleObjectProperty<DrawMode>((Object)this, "drawMode", DrawMode.FILL){

                protected void invalidated() {
                    NodeHelper.markDirty(Shape3D.this, DirtyBits.NODE_DRAWMODE);
                }
            };
        }
        return this.drawMode;
    }

    public final void setCullFace(CullFace value) {
        this.cullFaceProperty().set((Object)value);
    }

    public final CullFace getCullFace() {
        return this.cullFace == null ? CullFace.BACK : (CullFace)((Object)this.cullFace.get());
    }

    public final ObjectProperty<CullFace> cullFaceProperty() {
        if (this.cullFace == null) {
            this.cullFace = new SimpleObjectProperty<CullFace>((Object)this, "cullFace", CullFace.BACK){

                protected void invalidated() {
                    NodeHelper.markDirty(Shape3D.this, DirtyBits.NODE_CULLFACE);
                }
            };
        }
        return this.cullFace;
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        return new BoxBounds(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private boolean doComputeContains(double localX, double localY) {
        return false;
    }

    private void doUpdatePeer() {
        NGShape3D peer = (NGShape3D)NodeHelper.getPeer(this);
        if (NodeHelper.isDirty(this, DirtyBits.MATERIAL)) {
            Material mat = this.getMaterial() == null ? DEFAULT_MATERIAL : this.getMaterial();
            MaterialHelper.updatePG(mat);
            peer.setMaterial(MaterialHelper.getNGMaterial(mat));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_DRAWMODE)) {
            peer.setDrawMode((Object)(this.getDrawMode() == null ? DrawMode.FILL : this.getDrawMode()));
        }
        if (NodeHelper.isDirty(this, DirtyBits.NODE_CULLFACE)) {
            peer.setCullFace((Object)(this.getCullFace() == null ? CullFace.BACK : this.getCullFace()));
        }
    }

    static {
        Shape3DHelper.setShape3DAccessor(new Shape3DHelper.Shape3DAccessor(){

            @Override
            public void doUpdatePeer(Node node) {
                ((Shape3D)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Shape3D)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Shape3D)node).doComputeContains(localX, localY);
            }
        });
        DEFAULT_MATERIAL = new PhongMaterial();
    }

    static abstract class Key {
        Key() {
        }

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }
}

