/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.shape.MeshHelper;
import com.sun.javafx.scene.shape.SphereHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSphere;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;

public class Sphere
extends Shape3D {
    static final int DEFAULT_DIVISIONS = 64;
    static final double DEFAULT_RADIUS = 1.0;
    private int divisions = 64;
    private TriangleMesh mesh;
    private DoubleProperty radius;

    public Sphere() {
        this(1.0, 64);
    }

    public Sphere(double radius) {
        this(radius, 64);
    }

    public Sphere(double radius, int divisions) {
        SphereHelper.initHelper(this);
        this.divisions = divisions < 1 ? 1 : divisions;
        this.setRadius(radius);
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 1.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new SimpleDoubleProperty(this, "radius", 1.0){

                public void invalidated() {
                    NodeHelper.markDirty(Sphere.this, DirtyBits.MESH_GEOM);
                    Sphere.this.manager.invalidateSphereMesh(Sphere.this.key);
                    Sphere.this.key = null;
                    NodeHelper.geomChanged(Sphere.this);
                }
            };
        }
        return this.radius;
    }

    public int getDivisions() {
        return this.divisions;
    }

    private NGNode doCreatePeer() {
        return new NGSphere();
    }

    private void doUpdatePeer() {
        if (NodeHelper.isDirty(this, DirtyBits.MESH_GEOM)) {
            NGSphere pgSphere = (NGSphere)NodeHelper.getPeer(this);
            float r = (float)this.getRadius();
            if (r < 0.0f) {
                pgSphere.updateMesh(null);
            } else {
                if (this.key == null) {
                    this.key = new SphereKey(r, this.divisions);
                }
                this.mesh = this.manager.getSphereMesh(r, this.divisions, this.key);
                this.mesh.updatePG();
                pgSphere.updateMesh(this.mesh.getPGTriangleMesh());
            }
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        float r = (float)this.getRadius();
        if (r < 0.0f) {
            return bounds.makeEmpty();
        }
        bounds = bounds.deriveWithNewBounds(-r, -r, -r, r, r, r);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    private boolean doComputeContains(double localX, double localY) {
        double n2 = localX * localX + localY * localY;
        double r = this.getRadius();
        return n2 <= r * r;
    }

    private boolean doComputeIntersects(PickRay pickRay, PickResultChooser pickResult) {
        double t1;
        boolean exactPicking = this.divisions < 64 && this.mesh != null;
        double r = this.getRadius();
        Vec3d dir = pickRay.getDirectionNoClone();
        double dirX = dir.x;
        double dirY = dir.y;
        double dirZ = dir.z;
        Vec3d origin = pickRay.getOriginNoClone();
        double originX = origin.x;
        double originY = origin.y;
        double originZ = origin.z;
        double b = 2.0 * (dirX * originX + dirY * originY + dirZ * originZ);
        double a = dirX * dirX + dirY * dirY + dirZ * dirZ;
        double c = originX * originX + originY * originY + originZ * originZ - r * r;
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            return false;
        }
        double distSqrt = Math.sqrt(discriminant);
        double q = b < 0.0 ? (-b - distSqrt) / 2.0 : (-b + distSqrt) / 2.0;
        double t0 = q / a;
        if (t0 > (t1 = c / q)) {
            double temp = t0;
            t0 = t1;
            t1 = temp;
        }
        double minDistance = pickRay.getNearClip();
        double maxDistance = pickRay.getFarClip();
        if (t1 < minDistance || t0 > maxDistance) {
            return false;
        }
        double t = t0;
        CullFace cullFace = this.getCullFace();
        if (t0 < minDistance || cullFace == CullFace.FRONT) {
            if (t1 <= maxDistance && this.getCullFace() != CullFace.BACK) {
                t = t1;
            } else if (!exactPicking) {
                return false;
            }
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (exactPicking) {
            return MeshHelper.computeIntersects(this.mesh, pickRay, pickResult, this, cullFace, false);
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point3D point = PickResultChooser.computePoint(pickRay, t);
            Point3D proj = new Point3D(point.getX(), 0.0, point.getZ());
            Point3D cross = proj.crossProduct(Rotate.Z_AXIS);
            double angle = proj.angle(Rotate.Z_AXIS);
            if (cross.getY() > 0.0) {
                angle = 360.0 - angle;
            }
            Point2D txtCoords = new Point2D(1.0 - angle / 360.0, 0.5 + point.getY() / (2.0 * r));
            pickResult.offer(this, t, -1, point, txtCoords);
        }
        return true;
    }

    private static int correctDivisions(int div) {
        return (div + 3) / 4 * 4;
    }

    static TriangleMesh createMesh(int div, float r) {
        int p1;
        int t2;
        int t1;
        int i;
        div = Sphere.correctDivisions(div);
        int div2 = div / 2;
        int nPoints = div * (div2 - 1) + 2;
        int nTPoints = (div + 1) * (div2 - 1) + div * 2;
        int nFaces = div * (div2 - 2) * 2 + div * 2;
        float rDiv = 1.0f / (float)div;
        float[] points = new float[nPoints * 3];
        float[] tPoints = new float[nTPoints * 2];
        int[] faces = new int[nFaces * 6];
        int pPos = 0;
        int tPos = 0;
        for (int y = 0; y < div2 - 1; ++y) {
            float va = rDiv * (float)(y + 1 - div2 / 2) * 2.0f * (float)Math.PI;
            float sin_va = (float)Math.sin(va);
            float cos_va = (float)Math.cos(va);
            float ty = 0.5f + sin_va * 0.5f;
            for (int i2 = 0; i2 < div; ++i2) {
                double a = rDiv * (float)i2 * 2.0f * (float)Math.PI;
                float hSin = (float)Math.sin(a);
                float hCos = (float)Math.cos(a);
                points[pPos + 0] = hSin * cos_va * r;
                points[pPos + 2] = hCos * cos_va * r;
                points[pPos + 1] = sin_va * r;
                tPoints[tPos + 0] = 1.0f - rDiv * (float)i2;
                tPoints[tPos + 1] = ty;
                pPos += 3;
                tPos += 2;
            }
            tPoints[tPos + 0] = 0.0f;
            tPoints[tPos + 1] = ty;
            tPos += 2;
        }
        points[pPos + 0] = 0.0f;
        points[pPos + 1] = -r;
        points[pPos + 2] = 0.0f;
        points[pPos + 3] = 0.0f;
        points[pPos + 4] = r;
        points[pPos + 5] = 0.0f;
        pPos += 6;
        int pS = (div2 - 1) * div;
        float textureDelta = 0.00390625f;
        for (i = 0; i < div; ++i) {
            tPoints[tPos + 0] = 1.0f - rDiv * (0.5f + (float)i);
            tPoints[tPos + 1] = textureDelta;
            tPos += 2;
        }
        for (i = 0; i < div; ++i) {
            tPoints[tPos + 0] = 1.0f - rDiv * (0.5f + (float)i);
            tPoints[tPos + 1] = 1.0f - textureDelta;
            tPos += 2;
        }
        int fIndex = 0;
        for (int y = 0; y < div2 - 2; ++y) {
            for (int x = 0; x < div; ++x) {
                int p0 = y * div + x;
                int p12 = p0 + 1;
                int p2 = p0 + div;
                int p3 = p12 + div;
                int t0 = p0 + y;
                t1 = t0 + 1;
                t2 = t0 + (div + 1);
                int t3 = t1 + (div + 1);
                faces[fIndex + 0] = p0;
                faces[fIndex + 1] = t0;
                faces[fIndex + 2] = p12 % div == 0 ? p12 - div : p12;
                faces[fIndex + 3] = t1;
                faces[fIndex + 4] = p2;
                faces[fIndex + 5] = t2;
                faces[(fIndex += 6) + 0] = p3 % div == 0 ? p3 - div : p3;
                faces[fIndex + 1] = t3;
                faces[fIndex + 2] = p2;
                faces[fIndex + 3] = t2;
                faces[fIndex + 4] = p12 % div == 0 ? p12 - div : p12;
                faces[fIndex + 5] = t1;
                fIndex += 6;
            }
        }
        int p0 = pS;
        int tB = (div2 - 1) * (div + 1);
        for (int x = 0; x < div; ++x) {
            int p2 = x;
            p1 = x + 1;
            int t0 = tB + x;
            faces[fIndex + 0] = p0;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p1 == div ? 0 : p1;
            faces[fIndex + 3] = p1;
            faces[fIndex + 4] = p2;
            faces[fIndex + 5] = p2;
            fIndex += 6;
        }
        ++p0;
        tB += div;
        int pB = (div2 - 2) * div;
        for (int x = 0; x < div; ++x) {
            p1 = pB + x;
            int p2 = pB + x + 1;
            int t0 = tB + x;
            t1 = (div2 - 2) * (div + 1) + x;
            t2 = t1 + 1;
            faces[fIndex + 0] = p0;
            faces[fIndex + 1] = t0;
            faces[fIndex + 2] = p1;
            faces[fIndex + 3] = t1;
            faces[fIndex + 4] = p2 % div == 0 ? p2 - div : p2;
            faces[fIndex + 5] = t2;
            fIndex += 6;
        }
        TriangleMesh m = new TriangleMesh(true);
        m.getPoints().setAll(points);
        m.getTexCoords().setAll(tPoints);
        m.getFaces().setAll(faces);
        return m;
    }

    static {
        SphereHelper.setSphereAccessor(new SphereHelper.SphereAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((Sphere)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((Sphere)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((Sphere)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((Sphere)node).doComputeContains(localX, localY);
            }

            @Override
            public boolean doComputeIntersects(Node node, PickRay pickRay, PickResultChooser pickResult) {
                return ((Sphere)node).doComputeIntersects(pickRay, pickResult);
            }
        });
    }

    private static class SphereKey
    extends Shape3D.Key {
        final double radius;
        final int divisions;

        private SphereKey(double radius, int divisions) {
            this.radius = radius;
            this.divisions = divisions;
        }

        @Override
        public int hashCode() {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.radius);
            bits = 31L * bits + (long)this.divisions;
            return Long.hashCode(bits);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SphereKey)) {
                return false;
            }
            SphereKey other = (SphereKey)obj;
            if (this.divisions != other.divisions) {
                return false;
            }
            return Double.compare(this.radius, other.radius) == 0;
        }
    }
}

