/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class Shear
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;

    public Shear() {
    }

    public Shear(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public Shear(double x, double y, double pivotX, double pivotY) {
        this.setX(x);
        this.setY(y);
        this.setPivotX(pivotX);
        this.setPivotY(pivotY);
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                public void invalidated() {
                    Shear.this.transformChanged();
                }

                public Object getBean() {
                    return Shear.this;
                }

                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                public void invalidated() {
                    Shear.this.transformChanged();
                }

                public Object getBean() {
                    return Shear.this;
                }

                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setPivotX(double value) {
        this.pivotXProperty().set(value);
    }

    public final double getPivotX() {
        return this.pivotX == null ? 0.0 : this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new DoublePropertyBase(){

                public void invalidated() {
                    Shear.this.transformChanged();
                }

                public Object getBean() {
                    return Shear.this;
                }

                public String getName() {
                    return "pivotX";
                }
            };
        }
        return this.pivotX;
    }

    public final void setPivotY(double value) {
        this.pivotYProperty().set(value);
    }

    public final double getPivotY() {
        return this.pivotY == null ? 0.0 : this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new DoublePropertyBase(){

                public void invalidated() {
                    Shear.this.transformChanged();
                }

                public Object getBean() {
                    return Shear.this;
                }

                public String getName() {
                    return "pivotY";
                }
            };
        }
        return this.pivotY;
    }

    @Override
    public double getMxy() {
        return this.getX();
    }

    @Override
    public double getMyx() {
        return this.getY();
    }

    @Override
    public double getTx() {
        return -this.getX() * this.getPivotY();
    }

    @Override
    public double getTy() {
        return -this.getY() * this.getPivotX();
    }

    @Override
    boolean computeIs2D() {
        return true;
    }

    @Override
    boolean computeIsIdentity() {
        return this.getX() == 0.0 && this.getY() == 0.0;
    }

    @Override
    void fill2DArray(double[] array) {
        double sx = this.getX();
        double sy = this.getY();
        array[0] = 1.0;
        array[1] = sx;
        array[2] = -sx * this.getPivotY();
        array[3] = sy;
        array[4] = 1.0;
        array[5] = -sy * this.getPivotX();
    }

    @Override
    void fill3DArray(double[] array) {
        double sx = this.getX();
        double sy = this.getY();
        array[0] = 1.0;
        array[1] = sx;
        array[2] = 0.0;
        array[3] = -sx * this.getPivotY();
        array[4] = sy;
        array[5] = 1.0;
        array[6] = 0.0;
        array[7] = -sy * this.getPivotX();
        array[8] = 0.0;
        array[9] = 0.0;
        array[10] = 1.0;
        array[11] = 0.0;
    }

    @Override
    public Transform createConcatenation(Transform transform) {
        if (transform instanceof Affine) {
            Affine a = (Affine)transform.clone();
            a.prepend(this);
            return a;
        }
        double sx = this.getX();
        double sy = this.getY();
        double txx = transform.getMxx();
        double txy = transform.getMxy();
        double txz = transform.getMxz();
        double ttx = transform.getTx();
        double tyx = transform.getMyx();
        double tyy = transform.getMyy();
        double tyz = transform.getMyz();
        double tty = transform.getTy();
        return new Affine(txx + sx * tyx, txy + sx * tyy, txz + sx * tyz, ttx + sx * tty - sx * this.getPivotY(), sy * txx + tyx, sy * txy + tyy, sy * txz + tyz, sy * ttx + tty - sy * this.getPivotX(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
    }

    @Override
    public Transform createInverse() {
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            return new Shear(-sx, 0.0, 0.0, this.getPivotY());
        }
        if (sx == 0.0) {
            return new Shear(0.0, -sy, this.getPivotX(), 0.0);
        }
        double px = this.getPivotX();
        double py = this.getPivotY();
        double coef = 1.0 / (1.0 - sx * sy);
        return new Affine(coef, -sx * coef, 0.0, sx * (py - sy * px) * coef, -sy * coef, 1.0 + sx * sy * coef, 0.0, sy * px + sy * (sx * sy * px - sx * py) * coef, 0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public Shear clone() {
        return new Shear(this.getX(), this.getY(), this.getPivotX(), this.getPivotY());
    }

    @Override
    public Point2D transform(double x, double y) {
        double mxy = this.getX();
        double myx = this.getY();
        return new Point2D(x + mxy * y - mxy * this.getPivotY(), myx * x + y - myx * this.getPivotX());
    }

    @Override
    public Point3D transform(double x, double y, double z) {
        double mxy = this.getX();
        double myx = this.getY();
        return new Point3D(x + mxy * y - mxy * this.getPivotY(), myx * x + y - myx * this.getPivotX(), z);
    }

    @Override
    void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xy = this.getX();
        double yx = this.getY();
        double px = this.getPivotX();
        double py = this.getPivotY();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = x + xy * y - xy * py;
            dstPts[dstOff++] = yx * x + y - yx * px;
        }
    }

    @Override
    void transform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double xy = this.getX();
        double yx = this.getY();
        double px = this.getPivotX();
        double py = this.getPivotY();
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = x + xy * y - xy * py;
            dstPts[dstOff++] = yx * x + y - yx * px;
            dstPts[dstOff++] = srcPts[srcOff++];
        }
    }

    @Override
    public Point2D deltaTransform(double x, double y) {
        return new Point2D(x + this.getX() * y, this.getY() * x + y);
    }

    @Override
    public Point3D deltaTransform(double x, double y, double z) {
        return new Point3D(x + this.getX() * y, this.getY() * x + y, z);
    }

    @Override
    public Point2D inverseTransform(double x, double y) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            double mxy = -this.getX();
            return new Point2D(x + mxy * y - mxy * this.getPivotY(), y);
        }
        if (sx == 0.0) {
            double myx = -this.getY();
            return new Point2D(x, myx * x + y - myx * this.getPivotX());
        }
        return super.inverseTransform(x, y);
    }

    @Override
    public Point3D inverseTransform(double x, double y, double z) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            double mxy = -this.getX();
            return new Point3D(x + mxy * y - mxy * this.getPivotY(), y, z);
        }
        if (sx == 0.0) {
            double myx = -this.getY();
            return new Point3D(x, myx * x + y - myx * this.getPivotX(), z);
        }
        return super.inverseTransform(x, y, z);
    }

    @Override
    void inverseTransform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        double px = this.getPivotX();
        double py = this.getPivotY();
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            double xy = -sx;
            while (--numPts >= 0) {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                dstPts[dstOff++] = x + xy * y - xy * py;
                dstPts[dstOff++] = y;
            }
            return;
        }
        if (sx == 0.0) {
            double yx = -sy;
            while (--numPts >= 0) {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                dstPts[dstOff++] = x;
                dstPts[dstOff++] = yx * x + y - yx * px;
            }
            return;
        }
        super.inverseTransform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    void inverseTransform3DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NonInvertibleTransformException {
        double px = this.getPivotX();
        double py = this.getPivotY();
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            double xy = -sx;
            while (--numPts >= 0) {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                dstPts[dstOff++] = x + xy * y - xy * py;
                dstPts[dstOff++] = y;
                dstPts[dstOff++] = srcPts[srcOff++];
            }
            return;
        }
        if (sx == 0.0) {
            double yx = -sy;
            while (--numPts >= 0) {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                dstPts[dstOff++] = x;
                dstPts[dstOff++] = yx * x + y - yx * px;
                dstPts[dstOff++] = srcPts[srcOff++];
            }
            return;
        }
        super.inverseTransform3DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public Point2D inverseDeltaTransform(double x, double y) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            return new Point2D(x - this.getX() * y, y);
        }
        if (sx == 0.0) {
            return new Point2D(x, -this.getY() * x + y);
        }
        return super.inverseDeltaTransform(x, y);
    }

    @Override
    public Point3D inverseDeltaTransform(double x, double y, double z) throws NonInvertibleTransformException {
        double sx = this.getX();
        double sy = this.getY();
        if (sy == 0.0) {
            return new Point3D(x - this.getX() * y, y, z);
        }
        if (sx == 0.0) {
            return new Point3D(x, -this.getY() * x + y, z);
        }
        return super.inverseDeltaTransform(x, y, z);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Shear [");
        sb.append("x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", pivotX=").append(this.getPivotX());
        sb.append(", pivotY=").append(this.getPivotY());
        return sb.append("]").toString();
    }

    @Override
    void apply(Affine3D trans) {
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0) {
            trans.translate(this.getPivotX(), this.getPivotY());
            trans.shear(this.getX(), this.getY());
            trans.translate(-this.getPivotX(), -this.getPivotY());
        } else {
            trans.shear(this.getX(), this.getY());
        }
    }

    @Override
    BaseTransform derive(BaseTransform trans) {
        return trans.deriveWithConcatenation(1.0, this.getY(), this.getX(), 1.0, this.getTx(), this.getTy());
    }

    @Override
    void validate() {
        this.getX();
        this.getPivotX();
        this.getY();
        this.getPivotY();
    }

    @Override
    void appendTo(Affine a) {
        a.appendShear(this.getX(), this.getY(), this.getPivotX(), this.getPivotY());
    }

    @Override
    void prependTo(Affine a) {
        a.prependShear(this.getX(), this.getY(), this.getPivotX(), this.getPivotY());
    }
}

