/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.glass.ui.Application;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.ModuleHelper;
import com.sun.javafx.util.Utils;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.application.ConditionalFeature;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Scene;
import javafx.util.FXPermission;

public class PlatformImpl {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static AtomicBoolean platformExit = new AtomicBoolean(false);
    private static AtomicBoolean toolkitExit = new AtomicBoolean(false);
    private static CountDownLatch startupLatch = new CountDownLatch(1);
    private static AtomicBoolean listenersRegistered = new AtomicBoolean(false);
    private static TKListener toolkitListener = null;
    private static volatile boolean implicitExit = true;
    private static boolean taskbarApplication = true;
    private static boolean contextual2DNavigation;
    private static AtomicInteger pendingRunnables;
    private static AtomicInteger numWindows;
    private static volatile boolean firstWindowShown;
    private static volatile boolean lastWindowClosed;
    private static AtomicBoolean reallyIdle;
    private static Set<FinishListener> finishListeners;
    private static final Object runLaterLock;
    private static Boolean isGraphicsSupported;
    private static Boolean isControlsSupported;
    private static Boolean isMediaSupported;
    private static Boolean isWebSupported;
    private static Boolean isSWTSupported;
    private static Boolean isSwingSupported;
    private static Boolean isFXMLSupported;
    private static Boolean hasTwoLevelFocus;
    private static Boolean hasVirtualKeyboard;
    private static Boolean hasTouch;
    private static Boolean hasMultiTouch;
    private static Boolean hasPointer;
    private static boolean isThreadMerged;
    private static String applicationType;
    private static BooleanProperty accessibilityActive;
    private static CountDownLatch allNestedLoopsExitedLatch;
    private static final boolean verbose;
    private static final boolean DEBUG;
    private static final FXPermission FXCANVAS_PERMISSION;
    private static final CountDownLatch platformExitLatch;
    private static boolean isModena;
    private static boolean isCaspian;
    private static String accessibilityTheme;

    public static void setTaskbarApplication(boolean taskbarApplication) {
        PlatformImpl.taskbarApplication = taskbarApplication;
    }

    public static boolean isTaskbarApplication() {
        return taskbarApplication;
    }

    public static void setApplicationName(Class appClass) {
        PlatformImpl.runLater(() -> Application.GetApplication().setName(appClass.getName()));
    }

    public static boolean isContextual2DNavigation() {
        return contextual2DNavigation;
    }

    public static void startup(Runnable r) {
        PlatformImpl.startup(r, false);
    }

    public static void startup(Runnable r, boolean preventDuplicateCalls) {
        if (platformExit.get()) {
            throw new IllegalStateException("Platform.exit has been called");
        }
        if (initialized.getAndSet(true)) {
            if (preventDuplicateCalls) {
                throw new IllegalStateException("Toolkit already initialized");
            }
            PlatformImpl.runLater(r);
            return;
        }
        Module module = PlatformImpl.class.getModule();
        ModuleDescriptor moduleDesc = module.getDescriptor();
        if (!module.isNamed() || !"javafx.graphics".equals(module.getName()) || moduleDesc == null || moduleDesc.isAutomatic() || moduleDesc.isOpen()) {
            String warningStr = "Unsupported JavaFX configuration: classes were loaded from '" + module + "'";
            if (moduleDesc != null) {
                warningStr = warningStr + ", isAutomatic: " + moduleDesc.isAutomatic();
                warningStr = warningStr + ", isOpen: " + moduleDesc.isOpen();
            }
            Logging.getJavaFXLogger().warning(warningStr);
        }
        Void dummy = AccessController.doPrivileged(() -> {
            applicationType = System.getProperty("com.sun.javafx.application.type");
            if (applicationType == null) {
                applicationType = "";
            }
            contextual2DNavigation = Boolean.getBoolean("com.sun.javafx.isContextual2DNavigation");
            String s = System.getProperty("com.sun.javafx.twoLevelFocus");
            if (s != null) {
                hasTwoLevelFocus = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.virtualKeyboard")) != null) {
                if (s.equalsIgnoreCase("none")) {
                    hasVirtualKeyboard = false;
                } else if (s.equalsIgnoreCase("javafx")) {
                    hasVirtualKeyboard = true;
                } else if (s.equalsIgnoreCase("native")) {
                    hasVirtualKeyboard = true;
                }
            }
            if ((s = System.getProperty("com.sun.javafx.touch")) != null) {
                hasTouch = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.multiTouch")) != null) {
                hasMultiTouch = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("com.sun.javafx.pointer")) != null) {
                hasPointer = Boolean.valueOf(s);
            }
            if ((s = System.getProperty("javafx.embed.singleThread")) != null && (isThreadMerged = Boolean.valueOf(s).booleanValue()) && !PlatformImpl.isSupported(ConditionalFeature.SWING)) {
                isThreadMerged = false;
                if (verbose) {
                    System.err.println("WARNING: javafx.embed.singleThread ignored (javafx.swing module not found)");
                }
            }
            return null;
        });
        if (DEBUG) {
            System.err.println("PlatformImpl::startup : applicationType = " + applicationType);
        }
        if ("FXCanvas".equals(applicationType)) {
            PlatformImpl.initFXCanvas();
        }
        if (!taskbarApplication) {
            Void void_ = AccessController.doPrivileged(() -> {
                System.setProperty("glass.taskbarApplication", "false");
                return null;
            });
        }
        toolkitListener = new TKListener(){

            @Override
            public void changedTopLevelWindows(List<TKStage> windows) {
                numWindows.set(windows.size());
                PlatformImpl.checkIdle();
            }

            @Override
            public void exitedLastNestedLoop() {
                if (platformExit.get()) {
                    allNestedLoopsExitedLatch.countDown();
                }
                PlatformImpl.checkIdle();
            }
        };
        Toolkit.getToolkit().addTkListener(toolkitListener);
        Toolkit.getToolkit().startup(() -> {
            startupLatch.countDown();
            r.run();
        });
        if (isThreadMerged) {
            PlatformImpl.installFwEventQueue();
        }
    }

    private static void initDeviceDetailsFXCanvas() {
        String eventProcProperty = "javafx.embed.eventProc";
        long eventProc = AccessController.doPrivileged(() -> Long.getLong("javafx.embed.eventProc", 0L));
        if (eventProc != 0L) {
            HashMap<String, Long> map = Application.getDeviceDetails();
            if (map == null) {
                map = new HashMap<String, Long>();
                Application.setDeviceDetails(map);
            }
            if (map.get("javafx.embed.eventProc") == null) {
                map.put("javafx.embed.eventProc", eventProc);
            }
        }
    }

    private static void addExportsToFXCanvas(Class<?> fxCanvasClass) {
        String[] swtNeededPackages = new String[]{"com.sun.glass.ui", "com.sun.javafx.cursor", "com.sun.javafx.embed", "com.sun.javafx.stage", "com.sun.javafx.tk"};
        if (DEBUG) {
            System.err.println("addExportsToFXCanvas: class = " + fxCanvasClass);
        }
        Object thisModule = ModuleHelper.getModule(PlatformImpl.class);
        Object javafxSwtModule = ModuleHelper.getModule(fxCanvasClass);
        for (String pkg : swtNeededPackages) {
            if (DEBUG) {
                System.err.println("add export of " + pkg + " from " + thisModule + " to " + javafxSwtModule);
            }
            ModuleHelper.addExports(thisModule, pkg, javafxSwtModule);
        }
    }

    private static void initFXCanvas() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission((Permission)FXCANVAS_PERMISSION);
            }
            catch (SecurityException ex) {
                System.err.println("FXCanvas: no permission to access JavaFX internals");
                ex.printStackTrace();
                return;
            }
        }
        Predicate<StackWalker.StackFrame> classFilter = f -> !f.getClassName().startsWith("javafx.application.") && !f.getClassName().startsWith("com.sun.javafx.application.");
        StackWalker walker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
        Optional frame = walker.walk(s -> s.filter(classFilter).findFirst());
        if (frame.isPresent()) {
            Class<?> caller = ((StackWalker.StackFrame)frame.get()).getDeclaringClass();
            if (DEBUG) {
                System.err.println("callerClassName = " + caller);
            }
            if ("javafx.embed.swt.FXCanvas".equals(caller.getName())) {
                PlatformImpl.initDeviceDetailsFXCanvas();
                PlatformImpl.addExportsToFXCanvas(caller);
            }
        }
    }

    private static void installFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("installFwEventQueue");
    }

    private static void removeFwEventQueue() {
        PlatformImpl.invokeSwingFXUtilsMethod("removeFwEventQueue");
    }

    private static void invokeSwingFXUtilsMethod(String methodName) {
        try {
            Class<?> swingFXUtilsClass = Class.forName("com.sun.javafx.embed.swing.SwingFXUtilsImpl");
            Method installFwEventQueue = swingFXUtilsClass.getDeclaredMethod(methodName, new Class[0]);
            PlatformImpl.waitForStart();
            installFwEventQueue.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Property javafx.embed.singleThread is not supported");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void waitForStart() {
        if (startupLatch.getCount() > 0L) {
            try {
                startupLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static boolean isFxApplicationThread() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    public static void runLater(Runnable r) {
        PlatformImpl.runLater(r, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLater(Runnable r, boolean exiting) {
        if (!initialized.get()) {
            throw new IllegalStateException("Toolkit not initialized");
        }
        pendingRunnables.incrementAndGet();
        PlatformImpl.waitForStart();
        Object object = runLaterLock;
        synchronized (object) {
            if (!exiting && toolkitExit.get()) {
                pendingRunnables.decrementAndGet();
                return;
            }
            AccessControlContext acc = AccessController.getContext();
            Toolkit.getToolkit().defer(() -> {
                try {
                    Void void_ = AccessController.doPrivileged(() -> {
                        r.run();
                        return null;
                    }, acc);
                }
                finally {
                    pendingRunnables.decrementAndGet();
                    PlatformImpl.checkIdle();
                }
            });
        }
    }

    public static void runAndWait(Runnable r) {
        PlatformImpl.runAndWait(r, false);
    }

    private static void runAndWait(Runnable r, boolean exiting) {
        if (PlatformImpl.isFxApplicationThread()) {
            try {
                r.run();
            }
            catch (Throwable t) {
                System.err.println("Exception in runnable");
                t.printStackTrace();
            }
        } else {
            CountDownLatch doneLatch = new CountDownLatch(1);
            PlatformImpl.runLater(() -> {
                try {
                    r.run();
                }
                finally {
                    doneLatch.countDown();
                }
            }, exiting);
            if (!exiting && toolkitExit.get()) {
                throw new IllegalStateException("Toolkit has exited");
            }
            try {
                doneLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setImplicitExit(boolean implicitExit) {
        PlatformImpl.implicitExit = implicitExit;
        PlatformImpl.checkIdle();
    }

    public static boolean isImplicitExit() {
        return implicitExit;
    }

    public static void addListener(FinishListener l) {
        listenersRegistered.set(true);
        finishListeners.add(l);
    }

    public static void removeListener(FinishListener l) {
        finishListeners.remove(l);
        listenersRegistered.set(!finishListeners.isEmpty());
        if (!listenersRegistered.get()) {
            PlatformImpl.checkIdle();
        }
    }

    private static void notifyFinishListeners(boolean exitCalled) {
        if (listenersRegistered.get()) {
            for (FinishListener l : finishListeners) {
                if (exitCalled) {
                    l.exitCalled();
                    continue;
                }
                l.idle(implicitExit);
            }
        } else if (implicitExit || platformExit.get()) {
            PlatformImpl.tkExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIdle() {
        if (!initialized.get()) {
            return;
        }
        if (!PlatformImpl.isFxApplicationThread()) {
            PlatformImpl.runLater(() -> {});
            return;
        }
        boolean doNotify = false;
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            int numWin = numWindows.get();
            if (numWin > 0) {
                firstWindowShown = true;
                lastWindowClosed = false;
                reallyIdle.set(false);
            } else if (numWin == 0 && firstWindowShown) {
                lastWindowClosed = true;
            }
            if (lastWindowClosed && pendingRunnables.get() == 0 && (toolkitExit.get() || !Toolkit.getToolkit().isNestedLoopRunning())) {
                if (reallyIdle.getAndSet(true)) {
                    doNotify = true;
                    lastWindowClosed = false;
                } else {
                    PlatformImpl.runLater(() -> {});
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (doNotify) {
                PlatformImpl.notifyFinishListeners(false);
            }
            return;
        }
    }

    static CountDownLatch test_getPlatformExitLatch() {
        return platformExitLatch;
    }

    public static void tkExit() {
        if (toolkitExit.getAndSet(true)) {
            return;
        }
        if (initialized.get()) {
            if (platformExit.get()) {
                PlatformImpl.runAndWait(() -> {
                    if (Toolkit.getToolkit().isNestedLoopRunning()) {
                        Toolkit.getToolkit().exitAllNestedEventLoops();
                    } else {
                        allNestedLoopsExitedLatch.countDown();
                    }
                }, true);
                try {
                    allNestedLoopsExitedLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Could not exit all nested event loops");
                }
            }
            PlatformImpl.runAndWait(() -> Toolkit.getToolkit().exit(), true);
            if (isThreadMerged) {
                PlatformImpl.removeFwEventQueue();
            }
            Toolkit.getToolkit().removeTkListener(toolkitListener);
            toolkitListener = null;
            platformExitLatch.countDown();
        }
    }

    public static BooleanProperty accessibilityActiveProperty() {
        return accessibilityActive;
    }

    public static void exit() {
        platformExit.set(true);
        PlatformImpl.notifyFinishListeners(true);
    }

    private static Boolean checkForClass(String classname) {
        try {
            Class.forName(classname, false, PlatformImpl.class.getClassLoader());
            return Boolean.TRUE;
        }
        catch (ClassNotFoundException cnfe) {
            return Boolean.FALSE;
        }
    }

    public static boolean isSupported(ConditionalFeature feature) {
        boolean supported = PlatformImpl.isSupportedImpl(feature);
        if (supported && feature == ConditionalFeature.TRANSPARENT_WINDOW) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission((Permission)FXPermissions.CREATE_TRANSPARENT_WINDOW_PERMISSION);
                }
                catch (SecurityException e) {
                    return false;
                }
            }
            return true;
        }
        return supported;
    }

    public static void setDefaultPlatformUserAgentStylesheet() {
        PlatformImpl.setPlatformUserAgentStylesheet("MODENA");
    }

    public static boolean isModena() {
        return isModena;
    }

    public static boolean isCaspian() {
        return isCaspian;
    }

    public static void setPlatformUserAgentStylesheet(String stylesheetUrl) {
        if (PlatformImpl.isFxApplicationThread()) {
            PlatformImpl._setPlatformUserAgentStylesheet(stylesheetUrl);
        } else {
            PlatformImpl.runLater(() -> PlatformImpl._setPlatformUserAgentStylesheet(stylesheetUrl));
        }
    }

    public static boolean setAccessibilityTheme(String platformTheme) {
        if (accessibilityTheme != null) {
            StyleManager.getInstance().removeUserAgentStylesheet(accessibilityTheme);
            accessibilityTheme = null;
        }
        PlatformImpl._setAccessibilityTheme(platformTheme);
        if (accessibilityTheme != null) {
            StyleManager.getInstance().addUserAgentStylesheet(accessibilityTheme);
            return true;
        }
        return false;
    }

    private static void _setAccessibilityTheme(String platformTheme) {
        String userTheme = AccessController.doPrivileged(() -> System.getProperty("com.sun.javafx.highContrastTheme"));
        if (PlatformImpl.isCaspian()) {
            if (platformTheme != null || userTheme != null) {
                accessibilityTheme = "com/sun/javafx/scene/control/skin/caspian/highcontrast.css";
            }
        } else if (PlatformImpl.isModena()) {
            if (userTheme != null) {
                switch (userTheme.toUpperCase()) {
                    case "BLACKONWHITE": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        break;
                    }
                    case "WHITEONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        break;
                    }
                    case "YELLOWONBLACK": {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                        break;
                    }
                }
            } else if (platformTheme != null) {
                switch (HighContrastScheme.valueOf(platformTheme)) {
                    case HIGH_CONTRAST_WHITE: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/blackOnWhite.css";
                        break;
                    }
                    case HIGH_CONTRAST_BLACK: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/whiteOnBlack.css";
                        break;
                    }
                    case HIGH_CONTRAST_1: 
                    case HIGH_CONTRAST_2: {
                        accessibilityTheme = "com/sun/javafx/scene/control/skin/modena/yellowOnBlack.css";
                        break;
                    }
                }
            }
        }
    }

    private static void _setPlatformUserAgentStylesheet(String stylesheetUrl) {
        isCaspian = false;
        isModena = false;
        String overrideStylesheetUrl = AccessController.doPrivileged(() -> System.getProperty("javafx.userAgentStylesheetUrl"));
        if (overrideStylesheetUrl != null) {
            stylesheetUrl = overrideStylesheetUrl;
        }
        ArrayList<String> uaStylesheets = new ArrayList<String>();
        if ("CASPIAN".equalsIgnoreCase(stylesheetUrl)) {
            isCaspian = true;
            uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/caspian.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/embedded.css");
                if (Utils.isQVGAScreen()) {
                    uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/embedded-qvga.css");
                }
                if (PlatformUtil.isAndroid()) {
                    uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/android.css");
                }
                if (PlatformUtil.isIOS()) {
                    uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/ios.css");
                }
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
            }
        } else if ("MODENA".equalsIgnoreCase(stylesheetUrl)) {
            isModena = true;
            uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena.css");
            if (PlatformImpl.isSupported(ConditionalFeature.INPUT_TOUCH)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/touch.css");
            }
            if (PlatformUtil.isEmbedded()) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena-embedded-performance.css");
            }
            if (PlatformUtil.isAndroid()) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/android.css");
            }
            if (PlatformUtil.isIOS()) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/ios.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.TWO_LEVEL_FOCUS)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/two-level-focus.css");
            }
            if (PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/caspian/fxvk.css");
            }
            if (!PlatformImpl.isSupported(ConditionalFeature.TRANSPARENT_WINDOW)) {
                uaStylesheets.add("com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
            }
        } else {
            uaStylesheets.add(stylesheetUrl);
        }
        PlatformImpl._setAccessibilityTheme(Toolkit.getToolkit().getThemeName());
        if (accessibilityTheme != null) {
            uaStylesheets.add(accessibilityTheme);
        }
        Object dummy = AccessController.doPrivileged(() -> {
            StyleManager.getInstance().setUserAgentStylesheets(uaStylesheets);
            return null;
        });
    }

    public static void addNoTransparencyStylesheetToScene(Scene scene) {
        if (PlatformImpl.isCaspian()) {
            AccessController.doPrivileged(() -> {
                StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/caspian/caspian-no-transparency.css");
                return null;
            });
        } else if (PlatformImpl.isModena()) {
            AccessController.doPrivileged(() -> {
                StyleManager.getInstance().addUserAgentStylesheet(scene, "com/sun/javafx/scene/control/skin/modena/modena-no-transparency.css");
                return null;
            });
        }
    }

    private static boolean isSupportedImpl(ConditionalFeature feature) {
        switch (feature) {
            case GRAPHICS: {
                if (isGraphicsSupported == null) {
                    isGraphicsSupported = PlatformImpl.checkForClass("javafx.stage.Stage");
                }
                return isGraphicsSupported;
            }
            case CONTROLS: {
                if (isControlsSupported == null) {
                    isControlsSupported = PlatformImpl.checkForClass("javafx.scene.control.Control");
                }
                return isControlsSupported;
            }
            case MEDIA: {
                if (isMediaSupported == null && (isMediaSupported = PlatformImpl.checkForClass("javafx.scene.media.MediaView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    Void void_ = AccessController.doPrivileged(() -> {
                        String s = System.getProperty("com.sun.javafx.experimental.embedded.media", "false");
                        isMediaSupported = Boolean.valueOf(s);
                        return null;
                    });
                }
                return isMediaSupported;
            }
            case WEB: {
                if (isWebSupported == null && (isWebSupported = PlatformImpl.checkForClass("javafx.scene.web.WebView")).booleanValue() && PlatformUtil.isEmbedded()) {
                    Void void_ = AccessController.doPrivileged(() -> {
                        String s = System.getProperty("com.sun.javafx.experimental.embedded.web", "false");
                        isWebSupported = Boolean.valueOf(s);
                        return null;
                    });
                }
                return isWebSupported;
            }
            case SWT: {
                if (isSWTSupported == null) {
                    isSWTSupported = PlatformImpl.checkForClass("javafx.embed.swt.FXCanvas");
                }
                return isSWTSupported;
            }
            case SWING: {
                if (isSwingSupported == null) {
                    isSwingSupported = PlatformImpl.checkForClass("javax.swing.JComponent") != false && PlatformImpl.checkForClass("javafx.embed.swing.JFXPanel") != false;
                }
                return isSwingSupported;
            }
            case FXML: {
                if (isFXMLSupported == null) {
                    isFXMLSupported = PlatformImpl.checkForClass("javafx.fxml.FXMLLoader") != false && PlatformImpl.checkForClass("javax.xml.stream.XMLInputFactory") != false;
                }
                return isFXMLSupported;
            }
            case TWO_LEVEL_FOCUS: {
                if (hasTwoLevelFocus == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasTwoLevelFocus;
            }
            case VIRTUAL_KEYBOARD: {
                if (hasVirtualKeyboard == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasVirtualKeyboard;
            }
            case INPUT_TOUCH: {
                if (hasTouch == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasTouch;
            }
            case INPUT_MULTITOUCH: {
                if (hasMultiTouch == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasMultiTouch;
            }
            case INPUT_POINTER: {
                if (hasPointer == null) {
                    return Toolkit.getToolkit().isSupported(feature);
                }
                return hasPointer;
            }
        }
        return Toolkit.getToolkit().isSupported(feature);
    }

    static {
        pendingRunnables = new AtomicInteger(0);
        numWindows = new AtomicInteger(0);
        firstWindowShown = false;
        lastWindowClosed = false;
        reallyIdle = new AtomicBoolean(false);
        finishListeners = new CopyOnWriteArraySet<FinishListener>();
        runLaterLock = new Object();
        isThreadMerged = false;
        applicationType = "";
        accessibilityActive = new SimpleBooleanProperty();
        allNestedLoopsExitedLatch = new CountDownLatch(1);
        verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        DEBUG = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.application.debug"));
        FXCANVAS_PERMISSION = new FXPermission("accessFXCanvasInternals");
        platformExitLatch = new CountDownLatch(1);
        isModena = false;
        isCaspian = false;
    }

    public static interface FinishListener {
        public void idle(boolean var1);

        public void exitCalled();
    }

    public static enum HighContrastScheme {
        HIGH_CONTRAST_BLACK("high.contrast.black.theme"),
        HIGH_CONTRAST_WHITE("high.contrast.white.theme"),
        HIGH_CONTRAST_1("high.contrast.1.theme"),
        HIGH_CONTRAST_2("high.contrast.2.theme");

        private final String themeKey;

        private HighContrastScheme(String themeKey) {
            this.themeKey = themeKey;
        }

        public String getThemeKey() {
            return this.themeKey;
        }

        public static String fromThemeName(Function<String, String> keyFunction, String themeName) {
            if (keyFunction == null || themeName == null) {
                return null;
            }
            for (HighContrastScheme item : HighContrastScheme.values()) {
                if (!themeName.equalsIgnoreCase(keyFunction.apply(item.getThemeKey()))) continue;
                return item.toString();
            }
            return null;
        }
    }
}

