/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.geom.transform.Translate2D;

public abstract class AffineBase
extends BaseTransform {
    protected static final int APPLY_IDENTITY = 0;
    protected static final int APPLY_TRANSLATE = 1;
    protected static final int APPLY_SCALE = 2;
    protected static final int APPLY_SHEAR = 4;
    protected static final int APPLY_3D = 8;
    protected static final int APPLY_2D_MASK = 7;
    protected static final int APPLY_2D_DELTA_MASK = 6;
    protected static final int HI_SHIFT = 4;
    protected static final int HI_IDENTITY = 0;
    protected static final int HI_TRANSLATE = 16;
    protected static final int HI_SCALE = 32;
    protected static final int HI_SHEAR = 64;
    protected static final int HI_3D = 128;
    protected double mxx;
    protected double myx;
    protected double mxy;
    protected double myy;
    protected double mxt;
    protected double myt;
    protected transient int state;
    protected transient int type;
    private static final int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    protected static void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    protected void updateState() {
        this.updateState2D();
    }

    protected void updateState2D() {
        if (this.mxy == 0.0 && this.myx == 0.0) {
            if (this.mxx == 1.0 && this.myy == 1.0) {
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 0;
                    this.type = 0;
                } else {
                    this.state = 1;
                    this.type = 1;
                }
            } else {
                this.state = this.mxt == 0.0 && this.myt == 0.0 ? 2 : 3;
                this.type = -1;
            }
        } else {
            this.state = this.mxx == 0.0 && this.myy == 0.0 ? (this.mxt == 0.0 && this.myt == 0.0 ? 4 : 5) : (this.mxt == 0.0 && this.myt == 0.0 ? 6 : 7);
            this.type = -1;
        }
    }

    @Override
    public int getType() {
        if (this.type == -1) {
            this.updateState();
            if (this.type == -1) {
                this.type = this.calculateType();
            }
        }
        return this.type;
    }

    protected int calculateType() {
        int ret = (this.state & 8) == 0 ? 0 : 128;
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                ret |= 1;
            }
            case 6: {
                boolean sgn1;
                if (this.mxx * this.mxy + this.myx * this.myy != 0.0) {
                    ret |= 0x20;
                    break;
                }
                boolean sgn0 = this.mxx >= 0.0;
                boolean bl = sgn1 = this.myy >= 0.0;
                if (sgn0 == sgn1) {
                    if (this.mxx != this.myy || this.mxy != -this.myx) {
                        ret |= 0x14;
                        break;
                    }
                    if (this.mxx * this.myy - this.mxy * this.myx != 1.0) {
                        ret |= 0x12;
                        break;
                    }
                    ret |= 0x10;
                    break;
                }
                if (this.mxx != -this.myy || this.mxy != this.myx) {
                    ret |= 0x54;
                    break;
                }
                if (this.mxx * this.myy - this.mxy * this.myx != 1.0) {
                    ret |= 0x52;
                    break;
                }
                ret |= 0x50;
                break;
            }
            case 5: {
                ret |= 1;
            }
            case 4: {
                boolean sgn1;
                boolean sgn0 = this.mxy >= 0.0;
                boolean bl = sgn1 = this.myx >= 0.0;
                if (sgn0 != sgn1) {
                    if (this.mxy != -this.myx) {
                        ret |= 0xC;
                        break;
                    }
                    if (this.mxy != 1.0 && this.mxy != -1.0) {
                        ret |= 0xA;
                        break;
                    }
                    ret |= 8;
                    break;
                }
                if (this.mxy == this.myx) {
                    ret |= 0x4A;
                    break;
                }
                ret |= 0x4C;
                break;
            }
            case 3: {
                ret |= 1;
            }
            case 2: {
                boolean sgn1;
                boolean sgn0 = this.mxx >= 0.0;
                boolean bl = sgn1 = this.myy >= 0.0;
                if (sgn0 == sgn1) {
                    if (sgn0) {
                        if (this.mxx == this.myy) {
                            ret |= 2;
                            break;
                        }
                        ret |= 4;
                        break;
                    }
                    if (this.mxx != this.myy) {
                        ret |= 0xC;
                        break;
                    }
                    if (this.mxx != -1.0) {
                        ret |= 0xA;
                        break;
                    }
                    ret |= 8;
                    break;
                }
                if (this.mxx == -this.myy) {
                    if (this.mxx == 1.0 || this.mxx == -1.0) {
                        ret |= 0x40;
                        break;
                    }
                    ret |= 0x42;
                    break;
                }
                ret |= 0x44;
                break;
            }
            case 1: {
                ret |= 1;
            }
            case 0: 
        }
        return ret;
    }

    @Override
    public double getMxx() {
        return this.mxx;
    }

    @Override
    public double getMyy() {
        return this.myy;
    }

    @Override
    public double getMxy() {
        return this.mxy;
    }

    @Override
    public double getMyx() {
        return this.myx;
    }

    @Override
    public double getMxt() {
        return this.mxt;
    }

    @Override
    public double getMyt() {
        return this.myt;
    }

    @Override
    public boolean isIdentity() {
        return this.state == 0 || this.getType() == 0;
    }

    @Override
    public boolean isTranslateOrIdentity() {
        return this.state <= 1 || this.getType() <= 1;
    }

    @Override
    public boolean is2D() {
        return this.state < 8 || this.getType() <= 127;
    }

    @Override
    public double getDeterminant() {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                return this.mxx * this.myy - this.mxy * this.myx;
            }
            case 4: 
            case 5: {
                return -(this.mxy * this.myx);
            }
            case 2: 
            case 3: {
                return this.mxx * this.myy;
            }
            case 0: 
            case 1: 
        }
        return 1.0;
    }

    protected abstract void reset3Delements();

    @Override
    public void setToIdentity() {
        this.myy = 1.0;
        this.mxx = 1.0;
        this.myt = 0.0;
        this.mxt = 0.0;
        this.mxy = 0.0;
        this.myx = 0.0;
        this.reset3Delements();
        this.state = 0;
        this.type = 0;
    }

    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.mxx = mxx;
        this.myx = myx;
        this.mxy = mxy;
        this.myy = myy;
        this.mxt = mxt;
        this.myt = myt;
        this.reset3Delements();
        this.updateState2D();
    }

    public void setToShear(double shx, double shy) {
        this.mxx = 1.0;
        this.mxy = shx;
        this.myx = shy;
        this.myy = 1.0;
        this.mxt = 0.0;
        this.myt = 0.0;
        this.reset3Delements();
        if (shx != 0.0 || shy != 0.0) {
            this.state = 6;
            this.type = -1;
        } else {
            this.state = 0;
            this.type = 0;
        }
    }

    public Point2D transform(Point2D pt) {
        return this.transform(pt, pt);
    }

    @Override
    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = new Point2D();
        }
        double x = ptSrc.x;
        double y = ptSrc.y;
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                ptDst.setLocation((float)(x * this.mxx + y * this.mxy + this.mxt), (float)(x * this.myx + y * this.myy + this.myt));
                return ptDst;
            }
            case 6: {
                ptDst.setLocation((float)(x * this.mxx + y * this.mxy), (float)(x * this.myx + y * this.myy));
                return ptDst;
            }
            case 5: {
                ptDst.setLocation((float)(y * this.mxy + this.mxt), (float)(x * this.myx + this.myt));
                return ptDst;
            }
            case 4: {
                ptDst.setLocation((float)(y * this.mxy), (float)(x * this.myx));
                return ptDst;
            }
            case 3: {
                ptDst.setLocation((float)(x * this.mxx + this.mxt), (float)(y * this.myy + this.myt));
                return ptDst;
            }
            case 2: {
                ptDst.setLocation((float)(x * this.mxx), (float)(y * this.myy));
                return ptDst;
            }
            case 1: {
                ptDst.setLocation((float)(x + this.mxt), (float)(y + this.myt));
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation((float)x, (float)y);
        return ptDst;
    }

    @Override
    public Vec3d transform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                dst.x = x * this.mxx + y * this.mxy + this.mxt;
                dst.y = x * this.myx + y * this.myy + this.myt;
                dst.z = z;
                return dst;
            }
            case 6: {
                dst.x = x * this.mxx + y * this.mxy;
                dst.y = x * this.myx + y * this.myy;
                dst.z = z;
                return dst;
            }
            case 5: {
                dst.x = y * this.mxy + this.mxt;
                dst.y = x * this.myx + this.myt;
                dst.z = z;
                return dst;
            }
            case 4: {
                dst.x = y * this.mxy;
                dst.y = x * this.myx;
                dst.z = z;
                return dst;
            }
            case 3: {
                dst.x = x * this.mxx + this.mxt;
                dst.y = y * this.myy + this.myt;
                dst.z = z;
                return dst;
            }
            case 2: {
                dst.x = x * this.mxx;
                dst.y = y * this.myy;
                dst.z = z;
                return dst;
            }
            case 1: {
                dst.x = x + this.mxt;
                dst.y = y + this.myt;
                dst.z = z;
                return dst;
            }
            case 0: 
        }
        dst.x = x;
        dst.y = y;
        dst.z = z;
        return dst;
    }

    @Override
    public Vec3d deltaTransform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                dst.x = x * this.mxx + y * this.mxy;
                dst.y = x * this.myx + y * this.myy;
                dst.z = z;
                return dst;
            }
            case 4: 
            case 5: {
                dst.x = y * this.mxy;
                dst.y = x * this.myx;
                dst.z = z;
                return dst;
            }
            case 2: 
            case 3: {
                dst.x = x * this.mxx;
                dst.y = y * this.myy;
                dst.z = z;
                return dst;
            }
            case 0: 
            case 1: 
        }
        dst.x = x;
        dst.y = y;
        dst.z = z;
        return dst;
    }

    private BaseBounds transform2DBounds(RectBounds src, RectBounds dst) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double x1 = src.getMinX();
                double y1 = src.getMinY();
                double x2 = src.getMaxX();
                double y2 = src.getMaxY();
                dst.setBoundsAndSort((float)(x1 * this.mxx + y1 * this.mxy), (float)(x1 * this.myx + y1 * this.myy), (float)(x2 * this.mxx + y2 * this.mxy), (float)(x2 * this.myx + y2 * this.myy));
                dst.add((float)(x1 * this.mxx + y2 * this.mxy), (float)(x1 * this.myx + y2 * this.myy));
                dst.add((float)(x2 * this.mxx + y1 * this.mxy), (float)(x2 * this.myx + y1 * this.myy));
                dst.setBounds((float)((double)dst.getMinX() + this.mxt), (float)((double)dst.getMinY() + this.myt), (float)((double)dst.getMaxX() + this.mxt), (float)((double)dst.getMaxY() + this.myt));
                break;
            }
            case 5: {
                dst.setBoundsAndSort((float)((double)src.getMinY() * this.mxy + this.mxt), (float)((double)src.getMinX() * this.myx + this.myt), (float)((double)src.getMaxY() * this.mxy + this.mxt), (float)((double)src.getMaxX() * this.myx + this.myt));
                break;
            }
            case 4: {
                dst.setBoundsAndSort((float)((double)src.getMinY() * this.mxy), (float)((double)src.getMinX() * this.myx), (float)((double)src.getMaxY() * this.mxy), (float)((double)src.getMaxX() * this.myx));
                break;
            }
            case 3: {
                dst.setBoundsAndSort((float)((double)src.getMinX() * this.mxx + this.mxt), (float)((double)src.getMinY() * this.myy + this.myt), (float)((double)src.getMaxX() * this.mxx + this.mxt), (float)((double)src.getMaxY() * this.myy + this.myt));
                break;
            }
            case 2: {
                dst.setBoundsAndSort((float)((double)src.getMinX() * this.mxx), (float)((double)src.getMinY() * this.myy), (float)((double)src.getMaxX() * this.mxx), (float)((double)src.getMaxY() * this.myy));
                break;
            }
            case 1: {
                dst.setBounds((float)((double)src.getMinX() + this.mxt), (float)((double)src.getMinY() + this.myt), (float)((double)src.getMaxX() + this.mxt), (float)((double)src.getMaxY() + this.myt));
                break;
            }
            case 0: {
                if (src == dst) break;
                dst.setBounds(src);
            }
        }
        return dst;
    }

    private BaseBounds transform3DBounds(BaseBounds src, BaseBounds dst) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double x1 = src.getMinX();
                double y1 = src.getMinY();
                double z1 = src.getMinZ();
                double x2 = src.getMaxX();
                double y2 = src.getMaxY();
                double z2 = src.getMaxZ();
                dst.setBoundsAndSort((float)(x1 * this.mxx + y1 * this.mxy), (float)(x1 * this.myx + y1 * this.myy), (float)z1, (float)(x2 * this.mxx + y2 * this.mxy), (float)(x2 * this.myx + y2 * this.myy), (float)z2);
                dst.add((float)(x1 * this.mxx + y2 * this.mxy), (float)(x1 * this.myx + y2 * this.myy), 0.0f);
                dst.add((float)(x2 * this.mxx + y1 * this.mxy), (float)(x2 * this.myx + y1 * this.myy), 0.0f);
                dst.deriveWithNewBounds((float)((double)dst.getMinX() + this.mxt), (float)((double)dst.getMinY() + this.myt), dst.getMinZ(), (float)((double)dst.getMaxX() + this.mxt), (float)((double)dst.getMaxY() + this.myt), dst.getMaxZ());
                break;
            }
            case 5: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinY() * this.mxy + this.mxt), (float)((double)src.getMinX() * this.myx + this.myt), src.getMinZ(), (float)((double)src.getMaxY() * this.mxy + this.mxt), (float)((double)src.getMaxX() * this.myx + this.myt), src.getMaxZ());
                break;
            }
            case 4: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinY() * this.mxy), (float)((double)src.getMinX() * this.myx), src.getMinZ(), (float)((double)src.getMaxY() * this.mxy), (float)((double)src.getMaxX() * this.myx), src.getMaxZ());
                break;
            }
            case 3: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinX() * this.mxx + this.mxt), (float)((double)src.getMinY() * this.myy + this.myt), src.getMinZ(), (float)((double)src.getMaxX() * this.mxx + this.mxt), (float)((double)src.getMaxY() * this.myy + this.myt), src.getMaxZ());
                break;
            }
            case 2: {
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinX() * this.mxx), (float)((double)src.getMinY() * this.myy), src.getMinZ(), (float)((double)src.getMaxX() * this.mxx), (float)((double)src.getMaxY() * this.myy), src.getMaxZ());
                break;
            }
            case 1: {
                dst = dst.deriveWithNewBounds((float)((double)src.getMinX() + this.mxt), (float)((double)src.getMinY() + this.myt), src.getMinZ(), (float)((double)src.getMaxX() + this.mxt), (float)((double)src.getMaxY() + this.myt), src.getMaxZ());
                break;
            }
            case 0: {
                if (src == dst) break;
                dst = dst.deriveWithNewBounds(src);
            }
        }
        return dst;
    }

    @Override
    public BaseBounds transform(BaseBounds src, BaseBounds dst) {
        if (src.getBoundsType() != BaseBounds.BoundsType.RECTANGLE || dst.getBoundsType() != BaseBounds.BoundsType.RECTANGLE) {
            return this.transform3DBounds(src, dst);
        }
        return this.transform2DBounds((RectBounds)src, (RectBounds)dst);
    }

    @Override
    public void transform(Rectangle src, Rectangle dst) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                RectBounds b = new RectBounds(src);
                b = (RectBounds)this.transform(b, b);
                dst.setBounds(b);
                return;
            }
            case 1: {
                Translate2D.transform(src, dst, this.mxt, this.myt);
                return;
            }
            case 0: 
        }
        if (dst != src) {
            dst.setBounds(src);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        this.doTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state & 7);
    }

    @Override
    public void deltaTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        this.doTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state & 6);
    }

    private void doTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts, int thestate) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (thestate) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxx * x + Mxy * y + Mxt);
                    dstPts[dstOff++] = (float)(Myx * x + Myy * y + Myt);
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxx * x + Mxy * y);
                    dstPts[dstOff++] = (float)(Myx * x + Myy * y);
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxy * (double)srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)(Myx * x + Myt);
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxy * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(Myx * x);
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Mxx * (double)srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)(Myy * (double)srcPts[srcOff++] + Myt);
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Mxx * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(Myy * (double)srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + Myt);
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.doTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state & 7);
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.doTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state & 6);
    }

    private void doTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, int thestate) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (thestate) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxx * x + Mxy * y + Mxt;
                    dstPts[dstOff++] = Myx * x + Myy * y + Myt;
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxx * x + Mxy * y;
                    dstPts[dstOff++] = Myx * x + Myy * y;
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxy * srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = Myx * x + Myt;
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxy * srcPts[srcOff++];
                    dstPts[dstOff++] = Myx * x;
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Mxx * srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = Myy * srcPts[srcOff++] + Myt;
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Mxx * srcPts[srcOff++];
                    dstPts[dstOff++] = Myy * srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = srcPts[srcOff++] + Myt;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxx * x + Mxy * y + Mxt;
                    dstPts[dstOff++] = Myx * x + Myy * y + Myt;
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxx * x + Mxy * y;
                    dstPts[dstOff++] = Myx * x + Myy * y;
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxy * (double)srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = Myx * x + Myt;
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = Mxy * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = Myx * x;
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Mxx * (double)srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = Myy * (double)srcPts[srcOff++] + Myt;
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Mxx * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = Myy * (double)srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + Mxt;
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + Myt;
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++];
            dstPts[dstOff++] = srcPts[srcOff++];
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        switch (this.state & 7) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxx * x + Mxy * y + Mxt);
                    dstPts[dstOff++] = (float)(Myx * x + Myy * y + Myt);
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxx * x + Mxy * y);
                    dstPts[dstOff++] = (float)(Myx * x + Myy * y);
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxy * srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)(Myx * x + Myt);
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(Mxy * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(Myx * x);
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Mxx * srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)(Myy * srcPts[srcOff++] + Myt);
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Mxx * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(Myy * srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + Mxt);
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + Myt);
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)srcPts[srcOff++];
            dstPts[dstOff++] = (float)srcPts[srcOff++];
        }
    }

    @Override
    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) throws NoninvertibleTransformException {
        if (ptDst == null) {
            ptDst = new Point2D();
        }
        double x = ptSrc.x;
        double y = ptSrc.y;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 6: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                ptDst.setLocation((float)((x * this.myy - y * this.mxy) / det), (float)((y * this.mxx - x * this.myx) / det));
                return ptDst;
            }
            case 5: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation((float)(y / this.myx), (float)(x / this.mxy));
                return ptDst;
            }
            case 3: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation((float)(x / this.mxx), (float)(y / this.myy));
                return ptDst;
            }
            case 1: {
                ptDst.setLocation((float)(x - this.mxt), (float)(y - this.myt));
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation((float)x, (float)y);
        return ptDst;
    }

    @Override
    public Vec3d inverseTransform(Vec3d src, Vec3d dst) throws NoninvertibleTransformException {
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 6: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                dst.set((x * this.myy - y * this.mxy) / det, (y * this.mxx - x * this.myx) / det, z);
                return dst;
            }
            case 5: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.set(y / this.myx, x / this.mxy, z);
                return dst;
            }
            case 3: {
                x -= this.mxt;
                y -= this.myt;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.set(x / this.mxx, y / this.myy, z);
                return dst;
            }
            case 1: {
                dst.set(x - this.mxt, y - this.myt, z);
                return dst;
            }
            case 0: 
        }
        dst.set(x, y, z);
        return dst;
    }

    @Override
    public Vec3d inverseDeltaTransform(Vec3d src, Vec3d dst) throws NoninvertibleTransformException {
        if (dst == null) {
            dst = new Vec3d();
        }
        double x = src.x;
        double y = src.y;
        double z = src.z;
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                dst.set((x * this.myy - y * this.mxy) / det, (y * this.mxx - x * this.myx) / det, z);
                return dst;
            }
            case 4: 
            case 5: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.set(y / this.myx, x / this.mxy, z);
                return dst;
            }
            case 2: 
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.set(x / this.mxx, y / this.myy, z);
                return dst;
            }
            case 0: 
            case 1: 
        }
        dst.set(x, y, z);
        return dst;
    }

    private BaseBounds inversTransform2DBounds(RectBounds src, RectBounds dst) throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                double x1 = (double)src.getMinX() - this.mxt;
                double y1 = (double)src.getMinY() - this.myt;
                double x2 = (double)src.getMaxX() - this.mxt;
                double y2 = (double)src.getMaxY() - this.myt;
                dst.setBoundsAndSort((float)((x1 * this.myy - y1 * this.mxy) / det), (float)((y1 * this.mxx - x1 * this.myx) / det), (float)((x2 * this.myy - y2 * this.mxy) / det), (float)((y2 * this.mxx - x2 * this.myx) / det));
                dst.add((float)((x2 * this.myy - y1 * this.mxy) / det), (float)((y1 * this.mxx - x2 * this.myx) / det));
                dst.add((float)((x1 * this.myy - y2 * this.mxy) / det), (float)((y2 * this.mxx - x1 * this.myx) / det));
                return dst;
            }
            case 5: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.setBoundsAndSort((float)(((double)src.getMinY() - this.myt) / this.myx), (float)(((double)src.getMinX() - this.mxt) / this.mxy), (float)(((double)src.getMaxY() - this.myt) / this.myx), (float)(((double)src.getMaxX() - this.mxt) / this.mxy));
                break;
            }
            case 4: {
                if (this.mxy == 0.0 || this.myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.setBoundsAndSort((float)((double)src.getMinY() / this.myx), (float)((double)src.getMinX() / this.mxy), (float)((double)src.getMaxY() / this.myx), (float)((double)src.getMaxX() / this.mxy));
                break;
            }
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.setBoundsAndSort((float)(((double)src.getMinX() - this.mxt) / this.mxx), (float)(((double)src.getMinY() - this.myt) / this.myy), (float)(((double)src.getMaxX() - this.mxt) / this.mxx), (float)(((double)src.getMaxY() - this.myt) / this.myy));
                break;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst.setBoundsAndSort((float)((double)src.getMinX() / this.mxx), (float)((double)src.getMinY() / this.myy), (float)((double)src.getMaxX() / this.mxx), (float)((double)src.getMaxY() / this.myy));
                break;
            }
            case 1: {
                dst.setBounds((float)((double)src.getMinX() - this.mxt), (float)((double)src.getMinY() - this.myt), (float)((double)src.getMaxX() - this.mxt), (float)((double)src.getMaxY() - this.myt));
                break;
            }
            case 0: {
                if (dst == src) break;
                dst.setBounds(src);
            }
        }
        return dst;
    }

    private BaseBounds inversTransform3DBounds(BaseBounds src, BaseBounds dst) throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                double det = this.mxx * this.myy - this.mxy * this.myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                double x1 = (double)src.getMinX() - this.mxt;
                double y1 = (double)src.getMinY() - this.myt;
                double z1 = src.getMinZ();
                double x2 = (double)src.getMaxX() - this.mxt;
                double y2 = (double)src.getMaxY() - this.myt;
                double z2 = src.getMaxZ();
                dst = dst.deriveWithNewBoundsAndSort((float)((x1 * this.myy - y1 * this.mxy) / det), (float)((y1 * this.mxx - x1 * this.myx) / det), (float)(z1 / det), (float)((x2 * this.myy - y2 * this.mxy) / det), (float)((y2 * this.mxx - x2 * this.myx) / det), (float)(z2 / det));
                dst.add((float)((x2 * this.myy - y1 * this.mxy) / det), (float)((y1 * this.mxx - x2 * this.myx) / det), 0.0f);
                dst.add((float)((x1 * this.myy - y2 * this.mxy) / det), (float)((y2 * this.mxx - x1 * this.myx) / det), 0.0f);
                return dst;
            }
            case 3: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst = dst.deriveWithNewBoundsAndSort((float)(((double)src.getMinX() - this.mxt) / this.mxx), (float)(((double)src.getMinY() - this.myt) / this.myy), src.getMinZ(), (float)(((double)src.getMaxX() - this.mxt) / this.mxx), (float)(((double)src.getMaxY() - this.myt) / this.myy), src.getMaxZ());
                break;
            }
            case 2: {
                if (this.mxx == 0.0 || this.myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                dst = dst.deriveWithNewBoundsAndSort((float)((double)src.getMinX() / this.mxx), (float)((double)src.getMinY() / this.myy), src.getMinZ(), (float)((double)src.getMaxX() / this.mxx), (float)((double)src.getMaxY() / this.myy), src.getMaxZ());
                break;
            }
            case 1: {
                dst = dst.deriveWithNewBounds((float)((double)src.getMinX() - this.mxt), (float)((double)src.getMinY() - this.myt), src.getMinZ(), (float)((double)src.getMaxX() - this.mxt), (float)((double)src.getMaxY() - this.myt), src.getMaxZ());
                break;
            }
            case 0: {
                if (dst == src) break;
                dst = dst.deriveWithNewBounds(src);
            }
        }
        return dst;
    }

    @Override
    public BaseBounds inverseTransform(BaseBounds src, BaseBounds dst) throws NoninvertibleTransformException {
        if (src.getBoundsType() != BaseBounds.BoundsType.RECTANGLE || dst.getBoundsType() != BaseBounds.BoundsType.RECTANGLE) {
            return this.inversTransform3DBounds(src, dst);
        }
        return this.inversTransform2DBounds((RectBounds)src, (RectBounds)dst);
    }

    @Override
    public void inverseTransform(Rectangle src, Rectangle dst) throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                RectBounds b = new RectBounds(src);
                b = (RectBounds)this.inverseTransform(b, b);
                dst.setBounds(b);
                return;
            }
            case 1: {
                Translate2D.transform(src, dst, -this.mxt, -this.myt);
                return;
            }
            case 0: 
        }
        if (dst != src) {
            dst.setBounds(src);
        }
    }

    @Override
    public void inverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        this.doInverseTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state);
    }

    @Override
    public void inverseDeltaTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        this.doInverseTransform(srcPts, srcOff, dstPts, dstOff, numPts, this.state & 0xFFFFFFFE);
    }

    private void doInverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts, int thestate) throws NoninvertibleTransformException {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (thestate) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = (double)srcPts[srcOff++] - Mxt;
                    double y = (double)srcPts[srcOff++] - Myt;
                    dstPts[dstOff++] = (float)((x * Myy - y * Mxy) / det);
                    dstPts[dstOff++] = (float)((y * Mxx - x * Myx) / det);
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)((x * Myy - y * Mxy) / det);
                    dstPts[dstOff++] = (float)((y * Mxx - x * Myx) / det);
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = (double)srcPts[srcOff++] - Mxt;
                    dstPts[dstOff++] = (float)(((double)srcPts[srcOff++] - Myt) / Myx);
                    dstPts[dstOff++] = (float)(x / Mxy);
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] / Myx);
                    dstPts[dstOff++] = (float)(x / Mxy);
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(((double)srcPts[srcOff++] - Mxt) / Mxx);
                    dstPts[dstOff++] = (float)(((double)srcPts[srcOff++] - Myt) / Myy);
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] / Mxx);
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] / Myy);
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] - Mxt);
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] - Myt);
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++] - Mxt;
                    double y = srcPts[srcOff++] - Myt;
                    dstPts[dstOff++] = (x * Myy - y * Mxy) / det;
                    dstPts[dstOff++] = (y * Mxx - x * Myx) / det;
                }
                return;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (x * Myy - y * Mxy) / det;
                    dstPts[dstOff++] = (y * Mxx - x * Myx) / det;
                }
                return;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++] - Mxt;
                    dstPts[dstOff++] = (srcPts[srcOff++] - Myt) / Myx;
                    dstPts[dstOff++] = x / Mxy;
                }
                return;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = srcPts[srcOff++] / Myx;
                    dstPts[dstOff++] = x / Mxy;
                }
                return;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (srcPts[srcOff++] - Mxt) / Mxx;
                    dstPts[dstOff++] = (srcPts[srcOff++] - Myt) / Myy;
                }
                return;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] / Mxx;
                    dstPts[dstOff++] = srcPts[srcOff++] / Myy;
                }
                return;
            }
            case 1: {
                double Mxt = this.mxt;
                double Myt = this.myt;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] - Mxt;
                    dstPts[dstOff++] = srcPts[srcOff++] - Myt;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public Shape createTransformedShape(Shape s) {
        if (s == null) {
            return null;
        }
        return new Path2D(s, this);
    }

    public void translate(double tx, double ty) {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                this.mxt = tx * this.mxx + ty * this.mxy + this.mxt;
                this.myt = tx * this.myx + ty * this.myy + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 6;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 6: {
                this.mxt = tx * this.mxx + ty * this.mxy;
                this.myt = tx * this.myx + ty * this.myy;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 7;
                    this.type |= 1;
                }
                return;
            }
            case 5: {
                this.mxt = ty * this.mxy + this.mxt;
                this.myt = tx * this.myx + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 4;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 4: {
                this.mxt = ty * this.mxy;
                this.myt = tx * this.myx;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 5;
                    this.type |= 1;
                }
                return;
            }
            case 3: {
                this.mxt = tx * this.mxx + this.mxt;
                this.myt = ty * this.myy + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 2;
                    if (this.type != -1) {
                        this.type &= 0xFFFFFFFE;
                    }
                }
                return;
            }
            case 2: {
                this.mxt = tx * this.mxx;
                this.myt = ty * this.myy;
                if (this.mxt != 0.0 || this.myt != 0.0) {
                    this.state = 3;
                    this.type |= 1;
                }
                return;
            }
            case 1: {
                this.mxt = tx + this.mxt;
                this.myt = ty + this.myt;
                if (this.mxt == 0.0 && this.myt == 0.0) {
                    this.state = 0;
                    this.type = 0;
                }
                return;
            }
            case 0: 
        }
        this.mxt = tx;
        this.myt = ty;
        if (tx != 0.0 || ty != 0.0) {
            this.state = 1;
            this.type = 1;
        }
    }

    protected final void rotate90() {
        double M0 = this.mxx;
        this.mxx = this.mxy;
        this.mxy = -M0;
        M0 = this.myx;
        this.myx = this.myy;
        this.myy = -M0;
        int newstate = rot90conversion[this.state];
        if ((newstate & 6) == 2 && this.mxx == 1.0 && this.myy == 1.0) {
            newstate -= 2;
        }
        this.state = newstate;
        this.type = -1;
    }

    protected final void rotate180() {
        this.mxx = -this.mxx;
        this.myy = -this.myy;
        int oldstate = this.state;
        if ((oldstate & 4) != 0) {
            this.mxy = -this.mxy;
            this.myx = -this.myx;
        } else {
            this.state = this.mxx == 1.0 && this.myy == 1.0 ? oldstate & 0xFFFFFFFD : oldstate | 2;
        }
        this.type = -1;
    }

    protected final void rotate270() {
        double M0 = this.mxx;
        this.mxx = -this.mxy;
        this.mxy = M0;
        M0 = this.myx;
        this.myx = -this.myy;
        this.myy = M0;
        int newstate = rot90conversion[this.state];
        if ((newstate & 6) == 2 && this.mxx == 1.0 && this.myy == 1.0) {
            newstate -= 2;
        }
        this.state = newstate;
        this.type = -1;
    }

    public void rotate(double theta) {
        double sin = Math.sin(theta);
        if (sin == 1.0) {
            this.rotate90();
        } else if (sin == -1.0) {
            this.rotate270();
        } else {
            double cos = Math.cos(theta);
            if (cos == -1.0) {
                this.rotate180();
            } else if (cos != 1.0) {
                double M0 = this.mxx;
                double M1 = this.mxy;
                this.mxx = cos * M0 + sin * M1;
                this.mxy = -sin * M0 + cos * M1;
                M0 = this.myx;
                M1 = this.myy;
                this.myx = cos * M0 + sin * M1;
                this.myy = -sin * M0 + cos * M1;
                this.updateState2D();
            }
        }
    }

    public void scale(double sx, double sy) {
        int mystate = this.state;
        switch (mystate) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                this.mxx *= sx;
                this.myy *= sy;
            }
            case 4: 
            case 5: {
                this.mxy *= sy;
                this.myx *= sx;
                if (this.mxy == 0.0 && this.myx == 0.0) {
                    mystate &= 1;
                    if (this.mxx == 1.0 && this.myy == 1.0) {
                        this.type = mystate == 0 ? 0 : 1;
                    } else {
                        mystate |= 2;
                        this.type = -1;
                    }
                    this.state = mystate;
                }
                return;
            }
            case 2: 
            case 3: {
                this.mxx *= sx;
                this.myy *= sy;
                if (this.mxx == 1.0 && this.myy == 1.0) {
                    this.state = mystate &= 1;
                    this.type = mystate == 0 ? 0 : 1;
                } else {
                    this.type = -1;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        this.mxx = sx;
        this.myy = sy;
        if (sx != 1.0 || sy != 1.0) {
            this.state = mystate | 2;
            this.type = -1;
        }
    }

    public void shear(double shx, double shy) {
        int mystate = this.state;
        switch (mystate) {
            default: {
                AffineBase.stateError();
            }
            case 6: 
            case 7: {
                double M0 = this.mxx;
                double M1 = this.mxy;
                this.mxx = M0 + M1 * shy;
                this.mxy = M0 * shx + M1;
                M0 = this.myx;
                M1 = this.myy;
                this.myx = M0 + M1 * shy;
                this.myy = M0 * shx + M1;
                this.updateState2D();
                return;
            }
            case 4: 
            case 5: {
                this.mxx = this.mxy * shy;
                this.myy = this.myx * shx;
                if (this.mxx != 0.0 || this.myy != 0.0) {
                    this.state = mystate | 2;
                }
                this.type = -1;
                return;
            }
            case 2: 
            case 3: {
                this.mxy = this.mxx * shx;
                this.myx = this.myy * shy;
                if (this.mxy != 0.0 || this.myx != 0.0) {
                    this.state = mystate | 4;
                }
                this.type = -1;
                return;
            }
            case 0: 
            case 1: 
        }
        this.mxy = shx;
        this.myx = shy;
        if (this.mxy != 0.0 || this.myx != 0.0) {
            this.state = mystate | 2 | 4;
            this.type = -1;
        }
    }

    public void concatenate(BaseTransform Tx) {
        switch (Tx.getDegree()) {
            case IDENTITY: {
                return;
            }
            case TRANSLATE_2D: {
                this.translate(Tx.getMxt(), Tx.getMyt());
                return;
            }
            case AFFINE_2D: {
                break;
            }
            default: {
                if (!Tx.is2D()) {
                    AffineBase.degreeError(BaseTransform.Degree.AFFINE_2D);
                }
                if (Tx instanceof AffineBase) break;
                Tx = new Affine2D(Tx);
            }
        }
        int mystate = this.state;
        AffineBase at = (AffineBase)Tx;
        int txstate = at.state;
        switch (txstate << 4 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 112: {
                this.mxy = at.mxy;
                this.myx = at.myx;
            }
            case 48: {
                this.mxx = at.mxx;
                this.myy = at.myy;
            }
            case 16: {
                this.mxt = at.mxt;
                this.myt = at.myt;
                this.state = txstate;
                this.type = at.type;
                return;
            }
            case 96: {
                this.mxy = at.mxy;
                this.myx = at.myx;
            }
            case 32: {
                this.mxx = at.mxx;
                this.myy = at.myy;
                this.state = txstate;
                this.type = at.type;
                return;
            }
            case 80: {
                this.mxt = at.mxt;
                this.myt = at.myt;
            }
            case 64: {
                this.mxy = at.mxy;
                this.myx = at.myx;
                this.myy = 0.0;
                this.mxx = 0.0;
                this.state = txstate;
                this.type = at.type;
                return;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.translate(at.mxt, at.myt);
                return;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                this.scale(at.mxx, at.myy);
                return;
            }
            case 70: 
            case 71: {
                double Txy = at.mxy;
                double Tyx = at.myx;
                double M0 = this.mxx;
                this.mxx = this.mxy * Tyx;
                this.mxy = M0 * Txy;
                M0 = this.myx;
                this.myx = this.myy * Tyx;
                this.myy = M0 * Txy;
                this.type = -1;
                return;
            }
            case 68: 
            case 69: {
                this.mxx = this.mxy * at.myx;
                this.mxy = 0.0;
                this.myy = this.myx * at.mxy;
                this.myx = 0.0;
                this.state = mystate ^ 6;
                this.type = -1;
                return;
            }
            case 66: 
            case 67: {
                this.mxy = this.mxx * at.mxy;
                this.mxx = 0.0;
                this.myx = this.myy * at.myx;
                this.myy = 0.0;
                this.state = mystate ^ 6;
                this.type = -1;
                return;
            }
            case 65: {
                this.mxx = 0.0;
                this.mxy = at.mxy;
                this.myx = at.myx;
                this.myy = 0.0;
                this.state = 5;
                this.type = -1;
                return;
            }
        }
        double Txx = at.mxx;
        double Txy = at.mxy;
        double Txt = at.mxt;
        double Tyx = at.myx;
        double Tyy = at.myy;
        double Tyt = at.myt;
        switch (mystate) {
            default: {
                AffineBase.stateError();
            }
            case 6: {
                this.state = mystate | txstate;
            }
            case 7: {
                double M0 = this.mxx;
                double M1 = this.mxy;
                this.mxx = Txx * M0 + Tyx * M1;
                this.mxy = Txy * M0 + Tyy * M1;
                this.mxt += Txt * M0 + Tyt * M1;
                M0 = this.myx;
                M1 = this.myy;
                this.myx = Txx * M0 + Tyx * M1;
                this.myy = Txy * M0 + Tyy * M1;
                this.myt += Txt * M0 + Tyt * M1;
                this.type = -1;
                return;
            }
            case 4: 
            case 5: {
                double M0 = this.mxy;
                this.mxx = Tyx * M0;
                this.mxy = Tyy * M0;
                this.mxt += Tyt * M0;
                M0 = this.myx;
                this.myx = Txx * M0;
                this.myy = Txy * M0;
                this.myt += Txt * M0;
                break;
            }
            case 2: 
            case 3: {
                double M0 = this.mxx;
                this.mxx = Txx * M0;
                this.mxy = Txy * M0;
                this.mxt += Txt * M0;
                M0 = this.myy;
                this.myx = Tyx * M0;
                this.myy = Tyy * M0;
                this.myt += Tyt * M0;
                break;
            }
            case 1: {
                this.mxx = Txx;
                this.mxy = Txy;
                this.mxt += Txt;
                this.myx = Tyx;
                this.myy = Tyy;
                this.myt += Tyt;
                this.state = txstate | 1;
                this.type = -1;
                return;
            }
        }
        this.updateState2D();
    }

    public void concatenate(double Txx, double Txy, double Txt, double Tyx, double Tyy, double Tyt) {
        double rxx = this.mxx * Txx + this.mxy * Tyx;
        double rxy = this.mxx * Txy + this.mxy * Tyy;
        double rxt = this.mxx * Txt + this.mxy * Tyt + this.mxt;
        double ryx = this.myx * Txx + this.myy * Tyx;
        double ryy = this.myx * Txy + this.myy * Tyy;
        double ryt = this.myx * Txt + this.myy * Tyt + this.myt;
        this.mxx = rxx;
        this.mxy = rxy;
        this.mxt = rxt;
        this.myx = ryx;
        this.myy = ryy;
        this.myt = ryt;
        this.updateState();
    }

    @Override
    public void invert() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                AffineBase.stateError();
            }
            case 7: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myy = this.myy;
                double Myt = this.myt;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                this.mxx = Myy / det;
                this.myx = -Myx / det;
                this.mxy = -Mxy / det;
                this.myy = Mxx / det;
                this.mxt = (Mxy * Myt - Myy * Mxt) / det;
                this.myt = (Myx * Mxt - Mxx * Myt) / det;
                break;
            }
            case 6: {
                double Mxx = this.mxx;
                double Mxy = this.mxy;
                double Myx = this.myx;
                double Myy = this.myy;
                double det = Mxx * Myy - Mxy * Myx;
                if (det == 0.0 || Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                this.mxx = Myy / det;
                this.myx = -Myx / det;
                this.mxy = -Mxy / det;
                this.myy = Mxx / det;
                break;
            }
            case 5: {
                double Mxy = this.mxy;
                double Mxt = this.mxt;
                double Myx = this.myx;
                double Myt = this.myt;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.myx = 1.0 / Mxy;
                this.mxy = 1.0 / Myx;
                this.mxt = -Myt / Myx;
                this.myt = -Mxt / Mxy;
                break;
            }
            case 4: {
                double Mxy = this.mxy;
                double Myx = this.myx;
                if (Mxy == 0.0 || Myx == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.myx = 1.0 / Mxy;
                this.mxy = 1.0 / Myx;
                break;
            }
            case 3: {
                double Mxx = this.mxx;
                double Mxt = this.mxt;
                double Myy = this.myy;
                double Myt = this.myt;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.mxx = 1.0 / Mxx;
                this.myy = 1.0 / Myy;
                this.mxt = -Mxt / Mxx;
                this.myt = -Myt / Myy;
                break;
            }
            case 2: {
                double Mxx = this.mxx;
                double Myy = this.myy;
                if (Mxx == 0.0 || Myy == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                this.mxx = 1.0 / Mxx;
                this.myy = 1.0 / Myy;
                break;
            }
            case 1: {
                this.mxt = -this.mxt;
                this.myt = -this.myt;
            }
            case 0: 
        }
    }
}

