/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.jpeg;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.jpeg.JPEGDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;

public class JPEGImageLoader
extends ImageLoaderImpl {
    public static final int JCS_UNKNOWN = 0;
    public static final int JCS_GRAYSCALE = 1;
    public static final int JCS_RGB = 2;
    public static final int JCS_YCbCr = 3;
    public static final int JCS_CMYK = 4;
    public static final int JCS_YCC = 5;
    public static final int JCS_RGBA = 6;
    public static final int JCS_YCbCrA = 7;
    public static final int JCS_YCCA = 10;
    public static final int JCS_YCCK = 11;
    private long structPointer = 0L;
    private int inWidth;
    private int inHeight;
    private int inColorSpaceCode;
    private int outColorSpaceCode;
    private byte[] iccData;
    private int outWidth;
    private int outHeight;
    private ImageStorage.ImageType outImageType;
    private boolean isDisposed = false;
    private Lock accessLock = new Lock();

    private static native void initJPEGMethodIDs(Class var0);

    private static native void disposeNative(long var0);

    private native long initDecompressor(InputStream var1) throws IOException;

    private native int startDecompression(long var1, int var3, int var4, int var5);

    private native boolean decompressIndirect(long var1, boolean var3, byte[] var4) throws IOException;

    private void setInputAttributes(int width, int height, int colorSpaceCode, int outColorSpaceCode, int numComponents, byte[] iccData) {
        this.inWidth = width;
        this.inHeight = height;
        this.inColorSpaceCode = colorSpaceCode;
        this.outColorSpaceCode = outColorSpaceCode;
        this.iccData = iccData;
        block0 : switch (outColorSpaceCode) {
            case 1: {
                this.outImageType = ImageStorage.ImageType.GRAY;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.outImageType = ImageStorage.ImageType.RGB;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                this.outImageType = ImageStorage.ImageType.RGBA_PRE;
                break;
            }
            case 0: {
                switch (numComponents) {
                    case 1: {
                        this.outImageType = ImageStorage.ImageType.GRAY;
                        break block0;
                    }
                    case 3: {
                        this.outImageType = ImageStorage.ImageType.RGB;
                        break block0;
                    }
                    case 4: {
                        this.outImageType = ImageStorage.ImageType.RGBA_PRE;
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void setOutputAttributes(int width, int height) {
        this.outWidth = width;
        this.outHeight = height;
    }

    private void updateImageProgress(int outLinesDecoded) {
        this.updateImageProgress(100.0f * (float)outLinesDecoded / (float)this.outHeight);
    }

    JPEGImageLoader(InputStream input) throws IOException {
        super(JPEGDescriptor.getInstance());
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            this.structPointer = this.initDecompressor(input);
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        if (this.structPointer == 0L) {
            throw new IOException("Unable to initialize JPEG decompressor");
        }
    }

    @Override
    public synchronized void dispose() {
        if (!this.accessLock.isLocked() && !this.isDisposed && this.structPointer != 0L) {
            this.isDisposed = true;
            JPEGImageLoader.disposeNative(this.structPointer);
            this.structPointer = 0L;
        }
    }

    @Override
    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        int outNumComponents;
        if (imageIndex != 0) {
            return null;
        }
        this.accessLock.lock();
        int[] widthHeight = ImageTools.computeDimensions(this.inWidth, this.inHeight, width, height, preserveAspectRatio);
        width = widthHeight[0];
        height = widthHeight[1];
        ImageMetadata md = new ImageMetadata(null, true, null, null, null, null, null, width, height, null, null, null);
        this.updateImageMetadata(md);
        ByteBuffer buffer = null;
        try {
            outNumComponents = this.startDecompression(this.structPointer, this.outColorSpaceCode, width, height);
            if (this.outWidth < 0 || this.outHeight < 0 || outNumComponents < 0) {
                throw new IOException("negative dimension.");
            }
            if (this.outWidth > Integer.MAX_VALUE / outNumComponents) {
                throw new IOException("bad width.");
            }
            int scanlineStride = this.outWidth * outNumComponents;
            if (scanlineStride > Integer.MAX_VALUE / this.outHeight) {
                throw new IOException("bad height.");
            }
            byte[] array = new byte[scanlineStride * this.outHeight];
            buffer = ByteBuffer.wrap(array);
            this.decompressIndirect(this.structPointer, this.listeners != null && !this.listeners.isEmpty(), buffer.array());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            this.accessLock.unlock();
            this.dispose();
        }
        if (buffer == null) {
            throw new IOException("Error decompressing JPEG stream!");
        }
        if (this.outWidth != width || this.outHeight != height) {
            buffer = ImageTools.scaleImage(buffer, this.outWidth, this.outHeight, outNumComponents, width, height, smooth);
        }
        return new ImageFrame(this.outImageType, buffer, width, height, width * outNumComponents, null, md);
    }

    static {
        Object dummy = AccessController.doPrivileged(() -> {
            NativeLibLoader.loadLibrary("javafx_iio");
            return null;
        });
        JPEGImageLoader.initJPEGMethodIDs(InputStream.class);
    }

    private static class Lock {
        private boolean locked = false;

        public synchronized boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() {
            if (this.locked) {
                throw new IllegalStateException("Recursive loading is not allowed.");
            }
            this.locked = true;
        }

        public synchronized void unlock() {
            if (!this.locked) {
                throw new IllegalStateException("Invalid loader state.");
            }
            this.locked = false;
        }
    }
}

