/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.IntArgb;
import com.sun.javafx.image.impl.IntArgbPre;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class ByteBgra {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraConv;

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        if (ToByteBgraConv == null) {
            ToByteBgraConv = BaseByteToByteConverter.create(accessor);
        }
        return ToByteBgraConv;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        return ToByteBgraPreConv.instance;
    }

    public static ByteToIntPixelConverter ToIntArgbConverter() {
        return ToIntArgbSameConv.nonpremul;
    }

    public static ByteToIntPixelConverter ToIntArgbPreConverter() {
        return ToIntArgbPreConv.instance;
    }

    static class ToByteBgraPreConv
    extends BaseByteToByteConverter {
        static final ByteToBytePixelConverter instance = new ToByteBgraPreConv();

        private ToByteBgraPreConv() {
            super(getter, ByteBgraPre.setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int a;
                    byte b = srcarr[srcoff++];
                    byte g = srcarr[srcoff++];
                    byte r = srcarr[srcoff++];
                    if ((a = srcarr[srcoff++] & 0xFF) < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = (byte)(((b & 0xFF) * a + 127) / 255);
                            g = (byte)(((g & 0xFF) * a + 127) / 255);
                            r = (byte)(((r & 0xFF) * a + 127) / 255);
                        }
                    }
                    dstarr[dstoff++] = b;
                    dstarr[dstoff++] = g;
                    dstarr[dstoff++] = r;
                    dstarr[dstoff++] = (byte)a;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    byte b = srcbuf.get(srcoff);
                    byte g = srcbuf.get(srcoff + 1);
                    byte r = srcbuf.get(srcoff + 2);
                    int a = srcbuf.get(srcoff + 3) & 0xFF;
                    srcoff += 4;
                    if (a < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = (byte)(((b & 0xFF) * a + 127) / 255);
                            g = (byte)(((g & 0xFF) * a + 127) / 255);
                            r = (byte)(((r & 0xFF) * a + 127) / 255);
                        }
                    }
                    dstbuf.put(dstoff, b);
                    dstbuf.put(dstoff + 1, g);
                    dstbuf.put(dstoff + 2, r);
                    dstbuf.put(dstoff + 3, (byte)a);
                    dstoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    static class ToIntArgbSameConv
    extends BaseByteToIntConverter {
        static final ByteToIntPixelConverter nonpremul = new ToIntArgbSameConv(false);
        static final ByteToIntPixelConverter premul = new ToIntArgbSameConv(true);

        private ToIntArgbSameConv(boolean isPremult) {
            super(isPremult ? ByteBgraPre.getter : getter, isPremult ? IntArgbPre.setter : IntArgb.setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanints -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    dstarr[dstoff++] = srcarr[srcoff++] & 0xFF | (srcarr[srcoff++] & 0xFF) << 8 | (srcarr[srcoff++] & 0xFF) << 16 | srcarr[srcoff++] << 24;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanints;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    dstbuf.put(dstoff + x, srcbuf.get(srcoff) & 0xFF | (srcbuf.get(srcoff + 1) & 0xFF) << 8 | (srcbuf.get(srcoff + 2) & 0xFF) << 16 | srcbuf.get(srcoff + 3) << 24);
                    srcoff += 4;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanints;
            }
        }
    }

    static class ToIntArgbPreConv
    extends BaseByteToIntConverter {
        public static final ByteToIntPixelConverter instance = new ToIntArgbPreConv();

        private ToIntArgbPreConv() {
            super(getter, IntArgbPre.setter);
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            dstscanints -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int a;
                    int b = srcarr[srcoff++] & 0xFF;
                    int g = srcarr[srcoff++] & 0xFF;
                    int r = srcarr[srcoff++] & 0xFF;
                    if ((a = srcarr[srcoff++] & 0xFF) < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = (b * a + 127) / 255;
                            g = (g * a + 127) / 255;
                            r = (r * a + 127) / 255;
                        }
                    }
                    dstarr[dstoff++] = a << 24 | r << 16 | g << 8 | b;
                }
                dstoff += dstscanints;
                srcoff += srcscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanints, int w, int h) {
            srcscanbytes -= w * 4;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    int b = srcbuf.get(srcoff) & 0xFF;
                    int g = srcbuf.get(srcoff + 1) & 0xFF;
                    int r = srcbuf.get(srcoff + 2) & 0xFF;
                    int a = srcbuf.get(srcoff + 3) & 0xFF;
                    srcoff += 4;
                    if (a < 255) {
                        if (a == 0) {
                            r = 0;
                            g = 0;
                            b = 0;
                        } else {
                            b = (b * a + 127) / 255;
                            g = (g * a + 127) / 255;
                            r = (r * a + 127) / 255;
                        }
                    }
                    dstbuf.put(dstoff + x, a << 24 | r << 16 | g << 8 | b);
                }
                dstoff += dstscanints;
                srcoff += srcscanbytes;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.NONPREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] arr, int offset) {
            return arr[offset] & 0xFF | (arr[offset + 1] & 0xFF) << 8 | (arr[offset + 2] & 0xFF) << 16 | arr[offset + 3] << 24;
        }

        @Override
        public int getArgbPre(byte[] arr, int offset) {
            return PixelUtils.NonPretoPre(this.getArgb(arr, offset));
        }

        @Override
        public int getArgb(ByteBuffer buf, int offset) {
            return buf.get(offset) & 0xFF | (buf.get(offset + 1) & 0xFF) << 8 | (buf.get(offset + 2) & 0xFF) << 16 | buf.get(offset + 3) << 24;
        }

        @Override
        public int getArgbPre(ByteBuffer buf, int offset) {
            return PixelUtils.NonPretoPre(this.getArgb(buf, offset));
        }

        @Override
        public void setArgb(byte[] arr, int offset, int argb) {
            arr[offset] = (byte)argb;
            arr[offset + 1] = (byte)(argb >> 8);
            arr[offset + 2] = (byte)(argb >> 16);
            arr[offset + 3] = (byte)(argb >> 24);
        }

        @Override
        public void setArgbPre(byte[] arr, int offset, int argbpre) {
            this.setArgb(arr, offset, PixelUtils.PretoNonPre(argbpre));
        }

        @Override
        public void setArgb(ByteBuffer buf, int offset, int argb) {
            buf.put(offset, (byte)argb);
            buf.put(offset + 1, (byte)(argb >> 8));
            buf.put(offset + 2, (byte)(argb >> 16));
            buf.put(offset + 3, (byte)(argb >> 24));
        }

        @Override
        public void setArgbPre(ByteBuffer buf, int offset, int argbpre) {
            this.setArgb(buf, offset, PixelUtils.PretoNonPre(argbpre));
        }
    }
}

