/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToBytePixelConverter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.image.impl.BaseIntToByteConverter;
import com.sun.javafx.image.impl.BaseIntToIntConverter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class General {
    public static ByteToBytePixelConverter create(BytePixelGetter src, BytePixelSetter dst) {
        return new ByteToByteGeneralConverter(src, dst);
    }

    public static ByteToIntPixelConverter create(BytePixelGetter src, IntPixelSetter dst) {
        return new ByteToIntGeneralConverter(src, dst);
    }

    public static IntToBytePixelConverter create(IntPixelGetter src, BytePixelSetter dst) {
        return new IntToByteGeneralConverter(src, dst);
    }

    public static IntToIntPixelConverter create(IntPixelGetter src, IntPixelSetter dst) {
        return new IntToIntGeneralConverter(src, dst);
    }

    static class ByteToByteGeneralConverter
    extends BaseByteToByteConverter {
        boolean usePremult;

        ByteToByteGeneralConverter(BytePixelGetter getter, BytePixelSetter setter) {
            super(getter, setter);
            this.usePremult = getter.getAlphaType() != AlphaType.NONPREMULTIPLIED && setter.getAlphaType() != AlphaType.NONPREMULTIPLIED;
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= this.nSrcElems * w;
            dstscanbytes -= this.nDstElems * w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstarr, dstoff, this.getter.getArgbPre(srcarr, srcoff));
                    } else {
                        this.setter.setArgb(dstarr, dstoff, this.getter.getArgb(srcarr, srcoff));
                    }
                    srcoff += this.nSrcElems;
                    dstoff += this.nDstElems;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= this.nSrcElems * w;
            dstscanbytes -= this.nDstElems * w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstbuf, dstoff, this.getter.getArgbPre(srcbuf, srcoff));
                    } else {
                        this.setter.setArgb(dstbuf, dstoff, this.getter.getArgb(srcbuf, srcoff));
                    }
                    srcoff += this.nSrcElems;
                    dstoff += this.nDstElems;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    static class ByteToIntGeneralConverter
    extends BaseByteToIntConverter {
        boolean usePremult;

        ByteToIntGeneralConverter(BytePixelGetter getter, IntPixelSetter setter) {
            super(getter, setter);
            this.usePremult = getter.getAlphaType() != AlphaType.NONPREMULTIPLIED && setter.getAlphaType() != AlphaType.NONPREMULTIPLIED;
        }

        @Override
        void doConvert(byte[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= this.nSrcElems * w;
            dstscanbytes -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstarr, dstoff, this.getter.getArgbPre(srcarr, srcoff));
                    } else {
                        this.setter.setArgb(dstarr, dstoff, this.getter.getArgb(srcarr, srcoff));
                    }
                    srcoff += this.nSrcElems;
                    ++dstoff;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(ByteBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= this.nSrcElems * w;
            dstscanbytes -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstbuf, dstoff, this.getter.getArgbPre(srcbuf, srcoff));
                    } else {
                        this.setter.setArgb(dstbuf, dstoff, this.getter.getArgb(srcbuf, srcoff));
                    }
                    srcoff += this.nSrcElems;
                    ++dstoff;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    static class IntToByteGeneralConverter
    extends BaseIntToByteConverter {
        boolean usePremult;

        public IntToByteGeneralConverter(IntPixelGetter getter, BytePixelSetter setter) {
            super(getter, setter);
            this.usePremult = getter.getAlphaType() != AlphaType.NONPREMULTIPLIED && setter.getAlphaType() != AlphaType.NONPREMULTIPLIED;
        }

        @Override
        void doConvert(int[] srcarr, int srcoff, int srcscanbytes, byte[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w;
            dstscanbytes -= this.nDstElems * w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstarr, dstoff, this.getter.getArgbPre(srcarr, srcoff));
                    } else {
                        this.setter.setArgb(dstarr, dstoff, this.getter.getArgb(srcarr, srcoff));
                    }
                    ++srcoff;
                    dstoff += this.nDstElems;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(IntBuffer srcbuf, int srcoff, int srcscanbytes, ByteBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w;
            dstscanbytes -= this.nDstElems * w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstbuf, dstoff, this.getter.getArgbPre(srcbuf, srcoff));
                    } else {
                        this.setter.setArgb(dstbuf, dstoff, this.getter.getArgb(srcbuf, srcoff));
                    }
                    ++srcoff;
                    dstoff += this.nDstElems;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }

    static class IntToIntGeneralConverter
    extends BaseIntToIntConverter {
        boolean usePremult;

        public IntToIntGeneralConverter(IntPixelGetter getter, IntPixelSetter setter) {
            super(getter, setter);
            this.usePremult = getter.getAlphaType() != AlphaType.NONPREMULTIPLIED && setter.getAlphaType() != AlphaType.NONPREMULTIPLIED;
        }

        @Override
        void doConvert(int[] srcarr, int srcoff, int srcscanbytes, int[] dstarr, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w;
            dstscanbytes -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstarr, dstoff, this.getter.getArgbPre(srcarr, srcoff));
                    } else {
                        this.setter.setArgb(dstarr, dstoff, this.getter.getArgb(srcarr, srcoff));
                    }
                    ++srcoff;
                    ++dstoff;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }

        @Override
        void doConvert(IntBuffer srcbuf, int srcoff, int srcscanbytes, IntBuffer dstbuf, int dstoff, int dstscanbytes, int w, int h) {
            srcscanbytes -= w;
            dstscanbytes -= w;
            while (--h >= 0) {
                for (int x = 0; x < w; ++x) {
                    if (this.usePremult) {
                        this.setter.setArgbPre(dstbuf, dstoff, this.getter.getArgbPre(srcbuf, srcoff));
                    } else {
                        this.setter.setArgb(dstbuf, dstoff, this.getter.getArgb(srcbuf, srcoff));
                    }
                    ++srcoff;
                    ++dstoff;
                }
                srcoff += srcscanbytes;
                dstoff += dstscanbytes;
            }
        }
    }
}

