/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.prism.Image;
import com.sun.prism.impl.PrismSettings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class PrismImageLoader2
implements ImageLoader {
    private static PlatformLogger imageioLogger = null;
    private Image[] images;
    private int[] delayTimes;
    private int loopCount;
    private double width;
    private double height;
    private float pixelScale;
    private Exception exception;

    public PrismImageLoader2(String url, double width, double height, boolean preserveRatio, float pixelScale, boolean smooth) {
        this.loadAll(url, width, height, preserveRatio, pixelScale, smooth);
    }

    public PrismImageLoader2(InputStream stream, double width, double height, boolean preserveRatio, boolean smooth) {
        this.loadAll(stream, width, height, preserveRatio, smooth);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public int getFrameCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.length;
    }

    @Override
    public PlatformImage getFrame(int index) {
        if (this.images == null) {
            return null;
        }
        return this.images[index];
    }

    @Override
    public int getFrameDelay(int index) {
        if (this.images == null) {
            return 0;
        }
        return this.delayTimes[index];
    }

    @Override
    public int getLoopCount() {
        if (this.images == null) {
            return 0;
        }
        return this.loopCount;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    private void loadAll(String url, double w, double h, boolean preserveRatio, float pixelScale, boolean smooth) {
        PrismLoadListener listener = new PrismLoadListener();
        try {
            ImageFrame[] imgFrames = ImageStorage.loadAll(url, (ImageLoadListener)listener, w, h, preserveRatio, pixelScale, smooth);
            this.convertAll(imgFrames);
        }
        catch (ImageStorageException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void loadAll(InputStream stream, double w, double h, boolean preserveRatio, boolean smooth) {
        PrismLoadListener listener = new PrismLoadListener();
        try {
            ImageFrame[] imgFrames = ImageStorage.loadAll(stream, (ImageLoadListener)listener, w, h, preserveRatio, 1.0f, smooth);
            this.convertAll(imgFrames);
        }
        catch (ImageStorageException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(ImageStorageException isException) {
        Throwable exceptionCause = isException.getCause();
        if (exceptionCause instanceof Exception) {
            this.handleException((Exception)exceptionCause);
        } else {
            this.handleException((Exception)isException);
        }
    }

    private void handleException(Exception exception) {
        if (PrismSettings.verbose) {
            exception.printStackTrace(System.err);
        }
        this.exception = exception;
    }

    private void convertAll(ImageFrame[] imgFrames) {
        int numFrames = imgFrames.length;
        this.images = new Image[numFrames];
        this.delayTimes = new int[numFrames];
        for (int i = 0; i < numFrames; ++i) {
            ImageFrame frame = imgFrames[i];
            this.images[i] = Image.convertImageFrame(frame);
            ImageMetadata metadata = frame.getMetadata();
            if (metadata != null) {
                Integer loopCount;
                Integer delay = metadata.delayTime;
                if (delay != null) {
                    this.delayTimes[i] = delay;
                }
                if ((loopCount = metadata.loopCount) != null) {
                    this.loopCount = loopCount;
                }
            }
            if (i != 0) continue;
            this.width = frame.getWidth();
            this.height = frame.getHeight();
        }
    }

    private static synchronized PlatformLogger getImageioLogger() {
        if (imageioLogger == null) {
            imageioLogger = PlatformLogger.getLogger((String)"javafx.scene.image");
        }
        return imageioLogger;
    }

    private class PrismLoadListener
    implements ImageLoadListener {
        private PrismLoadListener() {
        }

        @Override
        public void imageLoadWarning(com.sun.javafx.iio.ImageLoader loader, String message) {
            PrismImageLoader2.getImageioLogger().warning(message);
        }

        @Override
        public void imageLoadProgress(com.sun.javafx.iio.ImageLoader loader, float percentageComplete) {
        }

        @Override
        public void imageLoadMetaData(com.sun.javafx.iio.ImageLoader loader, ImageMetadata metadata) {
        }
    }

    static final class AsyncImageLoader
    extends AbstractRemoteResource<PrismImageLoader2> {
        private static final ExecutorService BG_LOADING_EXECUTOR = AsyncImageLoader.createExecutor();
        private final AccessControlContext acc;
        double width;
        double height;
        boolean preserveRatio;
        boolean smooth;

        public AsyncImageLoader(AsyncOperationListener<PrismImageLoader2> listener, String url, double width, double height, boolean preserveRatio, boolean smooth) {
            super(url, listener);
            this.width = width;
            this.height = height;
            this.preserveRatio = preserveRatio;
            this.smooth = smooth;
            this.acc = AccessController.getContext();
        }

        @Override
        protected PrismImageLoader2 processStream(InputStream stream) throws IOException {
            return new PrismImageLoader2(stream, this.width, this.height, this.preserveRatio, this.smooth);
        }

        @Override
        public PrismImageLoader2 call() throws IOException {
            try {
                return AccessController.doPrivileged(() -> (PrismImageLoader2)AsyncImageLoader.super.call(), this.acc);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }

        @Override
        public void start() {
            BG_LOADING_EXECUTOR.execute(this.future);
        }

        private static ExecutorService createExecutor() {
            ThreadGroup bgLoadingThreadGroup = AccessController.doPrivileged(() -> new ThreadGroup(QuantumToolkit.getFxUserThread().getThreadGroup(), "Background image loading thread pool"));
            ThreadFactory bgLoadingThreadFactory = runnable -> AccessController.doPrivileged(() -> {
                Thread newThread = new Thread(bgLoadingThreadGroup, runnable);
                newThread.setPriority(1);
                return newThread;
            });
            ExecutorService bgLoadingExecutor = Executors.newCachedThreadPool(bgLoadingThreadFactory);
            ((ThreadPoolExecutor)bgLoadingExecutor).setKeepAliveTime(1L, TimeUnit.SECONDS);
            return bgLoadingExecutor;
        }
    }
}

