/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.impl.PrismSettings;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.LinkedList;

public class Disposer {
    private static Disposer disposerInstance;
    private static final int WEAK = 0;
    private static final int PHANTOM = 1;
    private static final int SOFT = 2;
    private static int refType;
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Hashtable records = new Hashtable();
    private final LinkedList<Record> disposalQueue = new LinkedList();

    private Disposer() {
    }

    public static void addRecord(Object target, Record rec) {
        disposerInstance.add(target, rec);
    }

    public static void disposeRecord(Record rec) {
        disposerInstance.addToDisposalQueue(rec);
    }

    public static void cleanUp() {
        disposerInstance.disposeUnreachables();
        disposerInstance.processDisposalQueue();
    }

    private synchronized void add(Object target, Record rec) {
        if (target instanceof Target) {
            target = ((Target)target).getDisposerReferent();
        }
        Reference ref = refType == 1 ? new PhantomReference<Object>(target, this.queue) : (refType == 2 ? new SoftReference<Object>(target, this.queue) : new WeakReference<Object>(target, this.queue));
        this.records.put(ref, rec);
    }

    private synchronized void addToDisposalQueue(Record rec) {
        this.disposalQueue.add(rec);
    }

    private synchronized void disposeUnreachables() {
        Reference obj;
        while ((obj = this.queue.poll()) != null) {
            try {
                obj.clear();
                Record rec = (Record)this.records.remove(obj);
                rec.dispose();
                obj = null;
                rec = null;
            }
            catch (Exception e) {
                System.out.println("Exception while removing reference: " + e);
                e.printStackTrace();
            }
        }
    }

    private synchronized void processDisposalQueue() {
        while (!this.disposalQueue.isEmpty()) {
            this.disposalQueue.remove().dispose();
        }
    }

    static {
        refType = 1;
        String type = PrismSettings.refType;
        if (type != null) {
            if (type.equals("weak")) {
                refType = 0;
                if (PrismSettings.verbose) {
                    System.err.println("Using WEAK refs");
                }
            } else if (type.equals("soft")) {
                refType = 2;
                if (PrismSettings.verbose) {
                    System.err.println("Using SOFT refs");
                }
            } else {
                refType = 1;
                if (PrismSettings.verbose) {
                    System.err.println("Using PHANTOM refs");
                }
            }
        }
        disposerInstance = new Disposer();
    }

    public static interface Record {
        public void dispose();
    }

    public static interface Target {
        public Object getDisposerReferent();
    }
}

