/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.paint;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Image;
import com.sun.prism.paint.Paint;

public final class ImagePattern
extends Paint {
    private final Image image;
    private final float x;
    private final float y;
    private final float width;
    private final float height;
    private final BaseTransform patternTransform;

    public ImagePattern(Image image, float x, float y, float width, float height, BaseTransform patternTransform, boolean proportional, boolean isMutable) {
        super(Paint.Type.IMAGE_PATTERN, proportional, isMutable);
        if (image == null) {
            throw new IllegalArgumentException("Image must be non-null");
        }
        this.image = image;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.patternTransform = patternTransform != null ? patternTransform.copy() : BaseTransform.IDENTITY_TRANSFORM;
    }

    public ImagePattern(Image image, float x, float y, float width, float height, boolean proportional, boolean isMutable) {
        this(image, x, y, width, height, null, proportional, isMutable);
    }

    public Image getImage() {
        return this.image;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public BaseTransform getPatternTransformNoClone() {
        return this.patternTransform;
    }

    @Override
    public boolean isOpaque() {
        return this.image.isOpaque();
    }
}

