/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.VetoableListDecorator;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;

public final class ParallelTransition
extends Transition {
    private static final Animation[] EMPTY_ANIMATION_ARRAY = new Animation[0];
    private static final double EPSILON = 1.0E-12;
    private Animation[] cachedChildren = EMPTY_ANIMATION_ARRAY;
    private long[] durations;
    private long[] delays;
    private double[] rates;
    private long[] offsetTicks;
    private boolean[] forceChildSync;
    private long oldTicks;
    private long cycleTime;
    private boolean childrenChanged = true;
    private boolean toggledRate;
    private final InvalidationListener childrenListener = observable -> {
        this.childrenChanged = true;
        if (this.getStatus() == Animation.Status.STOPPED) {
            this.setCycleDuration(this.computeCycleDuration());
        }
    };
    private final ChangeListener<Number> rateListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (oldValue.doubleValue() * newValue.doubleValue() < 0.0) {
                for (int i = 0; i < ParallelTransition.this.cachedChildren.length; ++i) {
                    Animation child = ParallelTransition.this.cachedChildren[i];
                    child.clipEnvelope.setRate(ParallelTransition.this.rates[i] * Math.signum(ParallelTransition.this.getCurrentRate()));
                }
                ParallelTransition.this.toggledRate = true;
            }
        }
    };
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private final Set<Animation> childrenSet = new HashSet<Animation>();
    private final ObservableList<Animation> children = new VetoableListDecorator<Animation>((ObservableList)new TrackableObservableList<Animation>(){

        protected void onChanged(ListChangeListener.Change<Animation> c) {
            while (c.next()) {
                for (Animation animation : c.getRemoved()) {
                    animation.parent = null;
                    animation.rateProperty().removeListener(ParallelTransition.this.childrenListener);
                    animation.totalDurationProperty().removeListener(ParallelTransition.this.childrenListener);
                    animation.delayProperty().removeListener(ParallelTransition.this.childrenListener);
                }
                for (Animation animation : c.getAddedSubList()) {
                    animation.parent = ParallelTransition.this;
                    animation.rateProperty().addListener(ParallelTransition.this.childrenListener);
                    animation.totalDurationProperty().addListener(ParallelTransition.this.childrenListener);
                    animation.delayProperty().addListener(ParallelTransition.this.childrenListener);
                }
            }
            ParallelTransition.this.childrenListener.invalidated(ParallelTransition.this.children);
        }
    }){

        protected void onProposedChange(List<Animation> toBeAdded, int ... indexes) {
            IllegalArgumentException exception = null;
            for (int i = 0; i < indexes.length; i += 2) {
                for (int idx = indexes[i]; idx < indexes[i + 1]; ++idx) {
                    ParallelTransition.this.childrenSet.remove(ParallelTransition.this.children.get(idx));
                }
            }
            for (Animation child : toBeAdded) {
                if (child == null) {
                    exception = new IllegalArgumentException("Child cannot be null");
                    break;
                }
                if (!ParallelTransition.this.childrenSet.add(child)) {
                    exception = new IllegalArgumentException("Attempting to add a duplicate to the list of children");
                    break;
                }
                if (!ParallelTransition.checkCycle(child, ParallelTransition.this)) continue;
                exception = new IllegalArgumentException("This change would create cycle");
                break;
            }
            if (exception != null) {
                ParallelTransition.this.childrenSet.clear();
                ParallelTransition.this.childrenSet.addAll((Collection<Animation>)ParallelTransition.this.children);
                throw exception;
            }
        }
    };

    public final void setNode(Node value) {
        if (this.node != null || value != null) {
            this.nodeProperty().set((Object)value);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty((Object)this, "node", (Object)DEFAULT_NODE);
        }
        return this.node;
    }

    private static boolean checkCycle(Animation child, Animation parent) {
        Animation a = parent;
        while (a != child) {
            if (a.parent != null) {
                a = a.parent;
                continue;
            }
            return false;
        }
        return true;
    }

    public final ObservableList<Animation> getChildren() {
        return this.children;
    }

    public ParallelTransition(Node node, Animation ... children) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
        this.getChildren().setAll((Object[])children);
    }

    public ParallelTransition(Animation ... children) {
        this((Node)null, children);
    }

    public ParallelTransition(Node node) {
        this.setInterpolator(Interpolator.LINEAR);
        this.setNode(node);
    }

    public ParallelTransition() {
        this((Node)null);
    }

    ParallelTransition(AbstractPrimaryTimer timer) {
        super(timer);
        this.setInterpolator(Interpolator.LINEAR);
    }

    @Override
    protected Node getParentTargetNode() {
        Node node = this.getNode();
        return node != null ? node : (this.parent != null && this.parent instanceof Transition ? ((Transition)this.parent).getParentTargetNode() : null);
    }

    private Duration computeCycleDuration() {
        Duration maxTime = Duration.ZERO;
        for (Animation animation : this.getChildren()) {
            double absRate = Math.abs(animation.getRate());
            Duration totalDuration = absRate < 1.0E-12 ? animation.getTotalDuration() : animation.getTotalDuration().divide(absRate);
            Duration childDuration = totalDuration.add(animation.getDelay());
            if (childDuration.isIndefinite()) {
                return Duration.INDEFINITE;
            }
            if (!childDuration.greaterThan(maxTime)) continue;
            maxTime = childDuration;
        }
        return maxTime;
    }

    private double calculateFraction(long currentTicks, long cycleTicks) {
        double frac = (double)currentTicks / (double)cycleTicks;
        return frac <= 0.0 ? 0.0 : (frac >= 1.0 ? 1.0 : frac);
    }

    private boolean startChild(Animation child, int index) {
        boolean forceSync = this.forceChildSync[index];
        if (child.startable(forceSync)) {
            child.clipEnvelope.setRate(this.rates[index] * Math.signum(this.getCurrentRate()));
            child.doStart(forceSync);
            this.forceChildSync[index] = false;
            return true;
        }
        return false;
    }

    @Override
    void sync(boolean forceSync) {
        super.sync(forceSync);
        if (forceSync && this.childrenChanged || this.durations == null) {
            this.cachedChildren = (Animation[])this.getChildren().toArray((Object[])EMPTY_ANIMATION_ARRAY);
            int n = this.cachedChildren.length;
            this.durations = new long[n];
            this.delays = new long[n];
            this.rates = new double[n];
            this.offsetTicks = new long[n];
            this.forceChildSync = new boolean[n];
            this.cycleTime = 0L;
            int i = 0;
            for (Animation animation : this.cachedChildren) {
                this.rates[i] = Math.abs(animation.getRate());
                if (this.rates[i] < 1.0E-12) {
                    this.rates[i] = 1.0;
                }
                this.durations[i] = TickCalculation.fromDuration(animation.getTotalDuration(), this.rates[i]);
                this.delays[i] = TickCalculation.fromDuration(animation.getDelay());
                this.cycleTime = Math.max(this.cycleTime, TickCalculation.add(this.durations[i], this.delays[i]));
                this.forceChildSync[i] = true;
                ++i;
            }
            this.childrenChanged = false;
        } else if (forceSync) {
            int n = this.forceChildSync.length;
            for (int i = 0; i < n; ++i) {
                this.forceChildSync[i] = true;
            }
        }
    }

    @Override
    void doPause() {
        super.doPause();
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() != Animation.Status.RUNNING) continue;
            animation.doPause();
        }
    }

    @Override
    void doResume() {
        super.doResume();
        int i = 0;
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() == Animation.Status.PAUSED) {
                animation.doResume();
                animation.clipEnvelope.setRate(this.rates[i] * Math.signum(this.getCurrentRate()));
            }
            ++i;
        }
    }

    @Override
    void doStart(boolean forceSync) {
        super.doStart(forceSync);
        this.toggledRate = false;
        this.rateProperty().addListener(this.rateListener);
        double curRate = this.getCurrentRate();
        long currentTicks = TickCalculation.fromDuration(this.getCurrentTime());
        if (curRate < 0.0) {
            this.jumpToEnd();
            if (currentTicks < this.cycleTime) {
                this.doJumpTo(currentTicks, this.cycleTime, false);
            }
        } else {
            this.jumpToStart();
            if (currentTicks > 0L) {
                this.doJumpTo(currentTicks, this.cycleTime, false);
            }
        }
    }

    @Override
    void doStop() {
        super.doStop();
        for (Animation animation : this.cachedChildren) {
            if (animation.getStatus() == Animation.Status.STOPPED) continue;
            animation.doStop();
        }
        if (this.childrenChanged) {
            this.setCycleDuration(this.computeCycleDuration());
        }
        this.rateProperty().removeListener(this.rateListener);
    }

    @Override
    void doPlayTo(long currentTicks, long cycleTicks) {
        int i;
        this.setCurrentTicks(currentTicks);
        double frac = this.calculateFraction(currentTicks, cycleTicks);
        long newTicks = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, cycleTicks, frac), cycleTicks));
        if (this.toggledRate) {
            for (i = 0; i < this.cachedChildren.length; ++i) {
                if (this.cachedChildren[i].getStatus() != Animation.Status.RUNNING) continue;
                int n = i;
                this.offsetTicks[n] = (long)((double)this.offsetTicks[n] - Math.signum(this.getCurrentRate()) * (double)(this.durations[i] - 2L * (this.oldTicks - this.delays[i])));
            }
            this.toggledRate = false;
        }
        if (this.getCurrentRate() > 0.0) {
            i = 0;
            for (Animation animation : this.cachedChildren) {
                if (newTicks >= this.delays[i] && (this.oldTicks <= this.delays[i] || newTicks < TickCalculation.add(this.delays[i], this.durations[i]) && animation.getStatus() == Animation.Status.STOPPED)) {
                    boolean enteringCycle;
                    boolean bl = enteringCycle = this.oldTicks <= this.delays[i];
                    if (this.startChild(animation, i)) {
                        animation.clipEnvelope.jumpTo(0L);
                    } else {
                        EventHandler<ActionEvent> handler;
                        if (!enteringCycle || (handler = animation.getOnFinished()) == null) continue;
                        handler.handle((Event)new ActionEvent((Object)this, null));
                        continue;
                    }
                }
                if (newTicks >= TickCalculation.add(this.durations[i], this.delays[i])) {
                    if (animation.getStatus() == Animation.Status.RUNNING) {
                        animation.doTimePulse(TickCalculation.sub(this.durations[i], this.offsetTicks[i]));
                        this.offsetTicks[i] = 0L;
                    }
                } else if (newTicks > this.delays[i]) {
                    animation.doTimePulse(TickCalculation.sub(newTicks - this.delays[i], this.offsetTicks[i]));
                }
                ++i;
            }
        } else {
            i = 0;
            for (Animation animation : this.cachedChildren) {
                if (newTicks < TickCalculation.add(this.durations[i], this.delays[i])) {
                    if (this.oldTicks >= TickCalculation.add(this.durations[i], this.delays[i]) || newTicks >= this.delays[i] && animation.getStatus() == Animation.Status.STOPPED) {
                        boolean enteringCycle;
                        boolean bl = enteringCycle = this.oldTicks >= TickCalculation.add(this.durations[i], this.delays[i]);
                        if (this.startChild(animation, i)) {
                            animation.clipEnvelope.jumpTo(Math.round((double)this.durations[i] * this.rates[i]));
                        } else {
                            EventHandler<ActionEvent> handler;
                            if (!enteringCycle || (handler = animation.getOnFinished()) == null) continue;
                            handler.handle((Event)new ActionEvent((Object)this, null));
                            continue;
                        }
                    }
                    if (newTicks <= this.delays[i]) {
                        if (animation.getStatus() == Animation.Status.RUNNING) {
                            animation.doTimePulse(TickCalculation.sub(this.durations[i], this.offsetTicks[i]));
                            this.offsetTicks[i] = 0L;
                        }
                    } else {
                        animation.doTimePulse(TickCalculation.sub(TickCalculation.add(this.durations[i], this.delays[i]) - newTicks, this.offsetTicks[i]));
                    }
                }
                ++i;
            }
        }
        this.oldTicks = newTicks;
    }

    @Override
    void doJumpTo(long currentTicks, long cycleTicks, boolean forceJump) {
        this.setCurrentTicks(currentTicks);
        if (this.getStatus() == Animation.Status.STOPPED && !forceJump) {
            return;
        }
        this.sync(false);
        double frac = this.calculateFraction(currentTicks, cycleTicks);
        long newTicks = Math.max(0L, Math.min(this.getCachedInterpolator().interpolate(0L, cycleTicks, frac), cycleTicks));
        int i = 0;
        for (Animation animation : this.cachedChildren) {
            Animation.Status status = animation.getStatus();
            if (newTicks <= this.delays[i]) {
                this.offsetTicks[i] = 0L;
                if (status != Animation.Status.STOPPED) {
                    animation.clipEnvelope.jumpTo(0L);
                    animation.doStop();
                } else if (TickCalculation.fromDuration(animation.getCurrentTime()) != 0L) {
                    animation.doJumpTo(0L, this.durations[i], true);
                }
            } else if (newTicks >= TickCalculation.add(this.durations[i], this.delays[i])) {
                this.offsetTicks[i] = 0L;
                if (status != Animation.Status.STOPPED) {
                    animation.clipEnvelope.jumpTo(Math.round((double)this.durations[i] * this.rates[i]));
                    animation.doStop();
                } else if (TickCalculation.fromDuration(animation.getCurrentTime()) != this.durations[i]) {
                    animation.doJumpTo(this.durations[i], this.durations[i], true);
                }
            } else {
                if (status == Animation.Status.STOPPED) {
                    this.startChild(animation, i);
                    if (this.getStatus() == Animation.Status.PAUSED) {
                        animation.doPause();
                    }
                    this.offsetTicks[i] = this.getCurrentRate() > 0.0 ? newTicks - this.delays[i] : TickCalculation.add(this.durations[i], this.delays[i]) - newTicks;
                } else if (status == Animation.Status.PAUSED) {
                    int n = i;
                    this.offsetTicks[n] = (long)((double)this.offsetTicks[n] + (double)(newTicks - this.oldTicks) * Math.signum(this.clipEnvelope.getCurrentRate()));
                } else {
                    int n = i;
                    this.offsetTicks[n] = this.offsetTicks[n] + (this.getCurrentRate() > 0.0 ? newTicks - this.oldTicks : this.oldTicks - newTicks);
                }
                animation.clipEnvelope.jumpTo(Math.round((double)TickCalculation.sub(newTicks, this.delays[i]) * this.rates[i]));
            }
            ++i;
        }
        this.oldTicks = newTicks;
    }

    @Override
    protected void interpolate(double frac) {
    }

    private void jumpToEnd() {
        for (int i = 0; i < this.cachedChildren.length; ++i) {
            if (this.forceChildSync[i]) {
                this.cachedChildren[i].sync(true);
            }
            this.cachedChildren[i].doJumpTo(this.durations[i], this.durations[i], true);
        }
    }

    private void jumpToStart() {
        for (int i = this.cachedChildren.length - 1; i >= 0; --i) {
            if (this.forceChildSync[i]) {
                this.cachedChildren[i].sync(true);
            }
            this.cachedChildren[i].doJumpTo(0L, this.durations[i], true);
        }
    }
}

