/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.layout.region.BackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.BackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.BorderImageSliceConverter;
import com.sun.javafx.scene.layout.region.BorderImageWidthConverter;
import com.sun.javafx.scene.layout.region.BorderImageWidthsSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStrokeStyleSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStyleConverter;
import com.sun.javafx.scene.layout.region.CornerRadiiConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.scene.layout.region.SliceSequenceConverter;
import com.sun.javafx.scene.layout.region.StrokeBorderPaintConverter;
import com.sun.javafx.util.Logging;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.Styleable;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.css.converter.CursorConverter;
import javafx.css.converter.DeriveColorConverter;
import javafx.css.converter.DeriveSizeConverter;
import javafx.css.converter.DurationConverter;
import javafx.css.converter.EffectConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.FontConverter;
import javafx.css.converter.InsetsConverter;
import javafx.css.converter.LadderConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.css.converter.StopConverter;
import javafx.css.converter.StringConverter;
import javafx.css.converter.URLConverter;
import javafx.geometry.Insets;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class StyleConverter<F, T> {
    private static Map<ParsedValue, Object> cache;
    private static Map<String, StyleConverter<?, ?>> tmap;

    public T convert(ParsedValue<F, T> value, Font font) {
        return (T)value.getValue();
    }

    public static StyleConverter<String, Boolean> getBooleanConverter() {
        return BooleanConverter.getInstance();
    }

    public static StyleConverter<?, Duration> getDurationConverter() {
        return DurationConverter.getInstance();
    }

    public static StyleConverter<String, Color> getColorConverter() {
        return ColorConverter.getInstance();
    }

    public static StyleConverter<ParsedValue[], Effect> getEffectConverter() {
        return EffectConverter.getInstance();
    }

    public static <E extends Enum<E>> StyleConverter<String, E> getEnumConverter(Class<E> enumClass) {
        EnumConverter<E> converter = new EnumConverter<E>(enumClass);
        return converter;
    }

    public static StyleConverter<ParsedValue[], Font> getFontConverter() {
        return FontConverter.getInstance();
    }

    public static StyleConverter<ParsedValue[], Insets> getInsetsConverter() {
        return InsetsConverter.getInstance();
    }

    public static StyleConverter<ParsedValue<?, Paint>, Paint> getPaintConverter() {
        return PaintConverter.getInstance();
    }

    public static StyleConverter<?, Number> getSizeConverter() {
        return SizeConverter.getInstance();
    }

    public static StyleConverter<String, String> getStringConverter() {
        return StringConverter.getInstance();
    }

    public static StyleConverter<ParsedValue[], String> getUrlConverter() {
        return URLConverter.getInstance();
    }

    public T convert(Map<CssMetaData<? extends Styleable, ?>, Object> convertedValues) {
        return null;
    }

    public void writeBinary(DataOutputStream os, StringStore sstore) throws IOException {
        String cname = this.getClass().getName();
        int index = sstore.addString(cname);
        os.writeShort(index);
    }

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    protected T getCachedValue(ParsedValue key) {
        if (cache != null) {
            return (T)cache.get(key);
        }
        return null;
    }

    protected void cacheValue(ParsedValue key, Object value) {
        if (cache == null) {
            cache = new WeakHashMap<ParsedValue, Object>();
        }
        cache.put(key, value);
    }

    public static StyleConverter<?, ?> readBinary(DataInputStream is, String[] strings) throws IOException {
        short index = is.readShort();
        Object cname = strings[index];
        if (cname == null || ((String)cname).isEmpty()) {
            return null;
        }
        if (((String)cname).startsWith("com.sun.javafx.css.converters.")) {
            cname = "javafx.css.converter." + ((String)cname).substring("com.sun.javafx.css.converters.".length());
        }
        if (((String)cname).startsWith("javafx.css.converter.EnumConverter")) {
            return EnumConverter.readBinary(is, strings);
        }
        if (tmap == null || !tmap.containsKey(cname)) {
            PlatformLogger logger;
            StyleConverter<?, ?> converter = StyleConverter.getInstance((String)cname);
            if (converter == null && (logger = Logging.getCSSLogger()).isLoggable(PlatformLogger.Level.SEVERE)) {
                logger.severe("could not deserialize " + (String)cname);
            }
            if (converter == null) {
                System.err.println("could not deserialize " + (String)cname);
            }
            if (tmap == null) {
                tmap = new HashMap();
            }
            tmap.put((String)cname, converter);
            return converter;
        }
        return tmap.get(cname);
    }

    static StyleConverter<?, ?> getInstance(String converterClass) {
        StyleConverter styleConverter = null;
        switch (converterClass) {
            case "javafx.css.converter.BooleanConverter": {
                styleConverter = BooleanConverter.getInstance();
                break;
            }
            case "javafx.css.converter.ColorConverter": {
                styleConverter = ColorConverter.getInstance();
                break;
            }
            case "javafx.css.converter.CursorConverter": {
                styleConverter = CursorConverter.getInstance();
                break;
            }
            case "javafx.css.converter.EffectConverter": {
                styleConverter = EffectConverter.getInstance();
                break;
            }
            case "javafx.css.converter.EffectConverter$DropShadowConverter": {
                styleConverter = EffectConverter.DropShadowConverter.getInstance();
                break;
            }
            case "javafx.css.converter.EffectConverter$InnerShadowConverter": {
                styleConverter = EffectConverter.InnerShadowConverter.getInstance();
                break;
            }
            case "javafx.css.converter.FontConverter": {
                styleConverter = FontConverter.getInstance();
                break;
            }
            case "javafx.css.converter.FontConverter$FontStyleConverter": 
            case "javafx.css.converter.FontConverter$StyleConverter": {
                styleConverter = FontConverter.FontStyleConverter.getInstance();
                break;
            }
            case "javafx.css.converter.FontConverter$FontWeightConverter": 
            case "javafx.css.converter.FontConverter$WeightConverter": {
                styleConverter = FontConverter.FontWeightConverter.getInstance();
                break;
            }
            case "javafx.css.converter.FontConverter$FontSizeConverter": 
            case "javafx.css.converter.FontConverter$SizeConverter": {
                styleConverter = FontConverter.FontSizeConverter.getInstance();
                break;
            }
            case "javafx.css.converter.InsetsConverter": {
                styleConverter = InsetsConverter.getInstance();
                break;
            }
            case "javafx.css.converter.InsetsConverter$SequenceConverter": {
                styleConverter = InsetsConverter.SequenceConverter.getInstance();
                break;
            }
            case "javafx.css.converter.PaintConverter": {
                styleConverter = PaintConverter.getInstance();
                break;
            }
            case "javafx.css.converter.PaintConverter$SequenceConverter": {
                styleConverter = PaintConverter.SequenceConverter.getInstance();
                break;
            }
            case "javafx.css.converter.PaintConverter$LinearGradientConverter": {
                styleConverter = PaintConverter.LinearGradientConverter.getInstance();
                break;
            }
            case "javafx.css.converter.PaintConverter$RadialGradientConverter": {
                styleConverter = PaintConverter.RadialGradientConverter.getInstance();
                break;
            }
            case "javafx.css.converter.SizeConverter": {
                styleConverter = SizeConverter.getInstance();
                break;
            }
            case "javafx.css.converter.SizeConverter$SequenceConverter": {
                styleConverter = SizeConverter.SequenceConverter.getInstance();
                break;
            }
            case "javafx.css.converter.StringConverter": {
                styleConverter = StringConverter.getInstance();
                break;
            }
            case "javafx.css.converter.StringConverter$SequenceConverter": {
                styleConverter = StringConverter.SequenceConverter.getInstance();
                break;
            }
            case "javafx.css.converter.URLConverter": {
                styleConverter = URLConverter.getInstance();
                break;
            }
            case "javafx.css.converter.URLConverter$SequenceConverter": {
                styleConverter = URLConverter.SequenceConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BackgroundPositionConverter": 
            case "com.sun.javafx.scene.layout.region.BackgroundImage$BackgroundPositionConverter": {
                styleConverter = BackgroundPositionConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BackgroundSizeConverter": 
            case "com.sun.javafx.scene.layout.region.BackgroundImage$BackgroundSizeConverter": {
                styleConverter = BackgroundSizeConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BorderImageSliceConverter": 
            case "com.sun.javafx.scene.layout.region.BorderImage$SliceConverter": {
                styleConverter = BorderImageSliceConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BorderImageWidthConverter": {
                styleConverter = BorderImageWidthConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BorderImageWidthsSequenceConverter": {
                styleConverter = BorderImageWidthsSequenceConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BorderStrokeStyleSequenceConverter": 
            case "com.sun.javafx.scene.layout.region.StrokeBorder$BorderStyleSequenceConverter": {
                styleConverter = BorderStrokeStyleSequenceConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.BorderStyleConverter": 
            case "com.sun.javafx.scene.layout.region.StrokeBorder$BorderStyleConverter": {
                styleConverter = BorderStyleConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.LayeredBackgroundPositionConverter": 
            case "com.sun.javafx.scene.layout.region.BackgroundImage$LayeredBackgroundPositionConverter": {
                styleConverter = LayeredBackgroundPositionConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.LayeredBackgroundSizeConverter": 
            case "com.sun.javafx.scene.layout.region.BackgroundImage$LayeredBackgroundSizeConverter": {
                styleConverter = LayeredBackgroundSizeConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter": 
            case "com.sun.javafx.scene.layout.region.StrokeBorder$LayeredBorderPaintConverter": {
                styleConverter = LayeredBorderPaintConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter": 
            case "com.sun.javafx.scene.layout.region.StrokeBorder$LayeredBorderStyleConverter": {
                styleConverter = LayeredBorderStyleConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.RepeatStructConverter": 
            case "com.sun.javafx.scene.layout.region.BackgroundImage$BackgroundRepeatConverter": 
            case "com.sun.javafx.scene.layout.region.BorderImage$RepeatConverter": {
                styleConverter = RepeatStructConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.SliceSequenceConverter": 
            case "com.sun.javafx.scene.layout.region.BorderImage$SliceSequenceConverter": {
                styleConverter = SliceSequenceConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.StrokeBorderPaintConverter": 
            case "com.sun.javafx.scene.layout.region.StrokeBorder$BorderPaintConverter": {
                styleConverter = StrokeBorderPaintConverter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.Margins$Converter": {
                styleConverter = Margins.Converter.getInstance();
                break;
            }
            case "com.sun.javafx.scene.layout.region.Margins$SequenceConverter": {
                styleConverter = Margins.SequenceConverter.getInstance();
                break;
            }
            case "javafx.scene.layout.CornerRadiiConverter": 
            case "com.sun.javafx.scene.layout.region.CornerRadiiConverter": {
                styleConverter = CornerRadiiConverter.getInstance();
                break;
            }
            case "javafx.css.converter.DeriveColorConverter": 
            case "com.sun.javafx.css.parser.DeriveColorConverter": {
                styleConverter = DeriveColorConverter.getInstance();
                break;
            }
            case "javafx.css.converter.DeriveSizeConverter": 
            case "com.sun.javafx.css.parser.DeriveSizeConverter": {
                styleConverter = DeriveSizeConverter.getInstance();
                break;
            }
            case "javafx.css.converter.LadderConverter": 
            case "com.sun.javafx.css.parser.LadderConverter": {
                styleConverter = LadderConverter.getInstance();
                break;
            }
            case "javafx.css.converter.StopConverter": 
            case "com.sun.javafx.css.parser.StopConverter": {
                styleConverter = StopConverter.getInstance();
                break;
            }
            default: {
                PlatformLogger logger = Logging.getCSSLogger();
                if (!logger.isLoggable(PlatformLogger.Level.SEVERE)) break;
                logger.severe("StyleConverter : converter Class is null for : " + converterClass);
            }
        }
        return styleConverter;
    }

    public static class StringStore {
        private final Map<String, Integer> stringMap = new HashMap<String, Integer>();
        public final List<String> strings = new ArrayList<String>();

        public int addString(String s) {
            Integer index = this.stringMap.get(s);
            if (index == null) {
                index = this.strings.size();
                this.strings.add(s);
                this.stringMap.put(s, index);
            }
            return index;
        }

        public void writeBinary(DataOutputStream os) throws IOException {
            os.writeShort(this.strings.size());
            if (this.stringMap.containsKey(null)) {
                Integer index = this.stringMap.get(null);
                os.writeShort(index);
            } else {
                os.writeShort(-1);
            }
            for (int n = 0; n < this.strings.size(); ++n) {
                String s = this.strings.get(n);
                if (s == null) continue;
                os.writeUTF(s);
            }
        }

        public static String[] readBinary(DataInputStream is) throws IOException {
            int nStrings = is.readShort();
            short nullIndex = is.readShort();
            Object[] strings = new String[nStrings];
            Arrays.fill(strings, null);
            for (int n = 0; n < nStrings; ++n) {
                if (n == nullIndex) continue;
                strings[n] = is.readUTF();
            }
            return strings;
        }
    }
}

