/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.FontFaceImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.Declaration;
import javafx.css.FontFace;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;

public class Stylesheet {
    static final int BINARY_CSS_VERSION = 6;
    private final String url;
    private StyleOrigin origin = StyleOrigin.AUTHOR;
    private final ObservableList<Rule> rules = new TrackableObservableList<Rule>(){

        protected void onChanged(ListChangeListener.Change<Rule> c) {
            c.reset();
            while (c.next()) {
                if (c.wasAdded()) {
                    for (Rule rule : c.getAddedSubList()) {
                        rule.setStylesheet(Stylesheet.this);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                for (Rule rule : c.getRemoved()) {
                    if (rule.getStylesheet() != Stylesheet.this) continue;
                    rule.setStylesheet(null);
                }
            }
        }
    };
    private final List<FontFace> fontFaces = new ArrayList<FontFace>();
    private String[] stringStore;

    public String getUrl() {
        return this.url;
    }

    public StyleOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(StyleOrigin origin) {
        this.origin = origin;
    }

    Stylesheet() {
        this(null);
    }

    Stylesheet(String url) {
        this.url = url;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<FontFace> getFontFaces() {
        return this.fontFaces;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Stylesheet) {
            Stylesheet other = (Stylesheet)obj;
            if (this.url == null && other.url == null) {
                return true;
            }
            if (this.url == null || other.url == null) {
                return false;
            }
            return this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("/* ");
        if (this.url != null) {
            sbuf.append(this.url);
        }
        if (this.rules.isEmpty()) {
            sbuf.append(" */");
        } else {
            sbuf.append(" */\n");
            for (int r = 0; r < this.rules.size(); ++r) {
                sbuf.append(this.rules.get(r));
                sbuf.append('\n');
            }
        }
        return sbuf.toString();
    }

    final void writeBinary(DataOutputStream os, StyleConverter.StringStore stringStore) throws IOException {
        int index = stringStore.addString(this.origin.name());
        os.writeShort(index);
        os.writeShort(this.rules.size());
        for (Rule r : this.rules) {
            r.writeBinary(os, stringStore);
        }
        List<FontFace> fontFaceList = this.getFontFaces();
        int nFontFaces = fontFaceList != null ? fontFaceList.size() : 0;
        os.writeShort(nFontFaces);
        for (int n = 0; n < nFontFaces; ++n) {
            FontFace fontFace = fontFaceList.get(n);
            if (!(fontFace instanceof FontFaceImpl)) continue;
            ((FontFaceImpl)fontFace).writeBinary(os, stringStore);
        }
    }

    final void readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        this.stringStore = strings;
        short index = is.readShort();
        this.setOrigin(StyleOrigin.valueOf(strings[index]));
        int nRules = is.readShort();
        ArrayList<Rule> persistedRules = new ArrayList<Rule>(nRules);
        for (int n = 0; n < nRules; ++n) {
            persistedRules.add(Rule.readBinary(bssVersion, is, strings));
        }
        this.rules.addAll(persistedRules);
        if (bssVersion >= 5) {
            List<FontFace> fontFaceList = this.getFontFaces();
            int nFontFaces = is.readShort();
            for (int n = 0; n < nFontFaces; ++n) {
                FontFaceImpl fontFace = FontFaceImpl.readBinary(bssVersion, is, strings);
                fontFaceList.add(fontFace);
            }
        }
    }

    final String[] getStringStore() {
        return this.stringStore;
    }

    public static Stylesheet loadBinary(URL url) throws IOException {
        Stylesheet stylesheet;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            try {
                stylesheet = Stylesheet.loadBinary(stream, url.toExternalForm());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    return null;
                }
            }
            stream.close();
        }
        return stylesheet;
    }

    public static Stylesheet loadBinary(InputStream stream) throws IOException {
        return Stylesheet.loadBinary(stream, null);
    }

    private static Stylesheet loadBinary(InputStream stream, String uri) throws IOException {
        Stylesheet stylesheet;
        block9: {
            stylesheet = null;
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(stream, 40960));){
                short bssVersion = dataInputStream.readShort();
                if (bssVersion > 6) {
                    throw new IOException(String.format("Wrong binary CSS version %s, expected version less than or equal to %s", uri != null ? bssVersion + " in stylesheet \"" + uri + "\"" : Integer.valueOf(bssVersion), 6));
                }
                String[] strings = StyleConverter.StringStore.readBinary(dataInputStream);
                stylesheet = new Stylesheet(uri);
                try {
                    dataInputStream.mark(Integer.MAX_VALUE);
                    stylesheet.readBinary(bssVersion, dataInputStream, strings);
                }
                catch (Exception e) {
                    stylesheet = new Stylesheet(uri);
                    dataInputStream.reset();
                    if (bssVersion == 2) {
                        stylesheet.readBinary(3, dataInputStream, strings);
                        break block9;
                    }
                    stylesheet.readBinary(6, dataInputStream, strings);
                }
            }
        }
        return stylesheet;
    }

    public static void convertToBinary(File source, File destination) throws IOException {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("parameters may not be null");
        }
        if (source.getAbsolutePath().equals(destination.getAbsolutePath())) {
            throw new IllegalArgumentException("source and destination may not be the same");
        }
        if (!source.canRead()) {
            throw new IllegalArgumentException("cannot read source file");
        }
        if (destination.exists() ? !destination.canWrite() : !destination.createNewFile()) {
            throw new IllegalArgumentException("cannot write destination file");
        }
        URI sourceURI = source.toURI();
        Stylesheet stylesheet = new CssParser().parse(sourceURI.toURL());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        StyleConverter.StringStore stringStore = new StyleConverter.StringStore();
        stylesheet.writeBinary(dos, stringStore);
        dos.flush();
        dos.close();
        FileOutputStream fos = new FileOutputStream(destination);
        DataOutputStream os = new DataOutputStream(fos);
        os.writeShort(6);
        stringStore.writeBinary(os);
        os.write(baos.toByteArray());
        os.flush();
        os.close();
    }

    void importStylesheet(Stylesheet importedStylesheet) {
        if (importedStylesheet == null) {
            return;
        }
        List<Rule> rulesToImport = importedStylesheet.getRules();
        if (rulesToImport == null || rulesToImport.isEmpty()) {
            return;
        }
        ArrayList<Rule> importedRules = new ArrayList<Rule>(rulesToImport.size());
        for (Rule rule : rulesToImport) {
            ObservableList<Selector> selectors = rule.getSelectors();
            List<Declaration> declarations = rule.getUnobservedDeclarationList();
            importedRules.add(new Rule((List<Selector>)selectors, declarations));
        }
        this.rules.addAll(importedRules);
    }
}

