/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.PerspectiveCameraHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPerspectiveCamera;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Camera;
import javafx.scene.Node;

public class PerspectiveCamera
extends Camera {
    private boolean fixedEyeAtCameraZero = false;
    private static final Affine3D LOOK_AT_TX = new Affine3D();
    private static final Affine3D LOOK_AT_TX_FIXED_EYE = new Affine3D();
    private DoubleProperty fieldOfView;
    private BooleanProperty verticalFieldOfView;

    public final void setFieldOfView(double value) {
        this.fieldOfViewProperty().set(value);
    }

    public final double getFieldOfView() {
        return this.fieldOfView == null ? 30.0 : this.fieldOfView.get();
    }

    public final DoubleProperty fieldOfViewProperty() {
        if (this.fieldOfView == null) {
            this.fieldOfView = new SimpleDoubleProperty(this, "fieldOfView", 30.0){

                protected void invalidated() {
                    NodeHelper.markDirty(PerspectiveCamera.this, DirtyBits.NODE_CAMERA);
                }
            };
        }
        return this.fieldOfView;
    }

    public final void setVerticalFieldOfView(boolean value) {
        this.verticalFieldOfViewProperty().set(value);
    }

    public final boolean isVerticalFieldOfView() {
        return this.verticalFieldOfView == null ? true : this.verticalFieldOfView.get();
    }

    public final BooleanProperty verticalFieldOfViewProperty() {
        if (this.verticalFieldOfView == null) {
            this.verticalFieldOfView = new SimpleBooleanProperty(this, "verticalFieldOfView", true){

                protected void invalidated() {
                    NodeHelper.markDirty(PerspectiveCamera.this, DirtyBits.NODE_CAMERA);
                }
            };
        }
        return this.verticalFieldOfView;
    }

    public PerspectiveCamera() {
        this(false);
    }

    public PerspectiveCamera(boolean fixedEyeAtCameraZero) {
        PerspectiveCameraHelper.initHelper(this);
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String logname = PerspectiveCamera.class.getName();
            PlatformLogger.getLogger((String)logname).warning("System can't support ConditionalFeature.SCENE3D");
        }
        this.fixedEyeAtCameraZero = fixedEyeAtCameraZero;
    }

    public final boolean isFixedEyeAtCameraZero() {
        return this.fixedEyeAtCameraZero;
    }

    @Override
    final PickRay computePickRay(double x, double y, PickRay pickRay) {
        return PickRay.computePerspectivePickRay(x, y, this.fixedEyeAtCameraZero, this.getViewWidth(), this.getViewHeight(), Math.toRadians(this.getFieldOfView()), this.isVerticalFieldOfView(), this.getCameraTransform(), this.getNearClip(), this.getFarClip(), pickRay);
    }

    @Override
    Camera copy() {
        PerspectiveCamera c = new PerspectiveCamera(this.fixedEyeAtCameraZero);
        c.setNearClip(this.getNearClip());
        c.setFarClip(this.getFarClip());
        c.setFieldOfView(this.getFieldOfView());
        return c;
    }

    private NGNode doCreatePeer() {
        NGPerspectiveCamera peer = new NGPerspectiveCamera(this.fixedEyeAtCameraZero);
        peer.setNearClip((float)this.getNearClip());
        peer.setFarClip((float)this.getFarClip());
        peer.setFieldOfView((float)this.getFieldOfView());
        return peer;
    }

    private void doUpdatePeer() {
        NGPerspectiveCamera pgPerspectiveCamera = (NGPerspectiveCamera)this.getPeer();
        if (this.isDirty(DirtyBits.NODE_CAMERA)) {
            pgPerspectiveCamera.setVerticalFieldOfView(this.isVerticalFieldOfView());
            pgPerspectiveCamera.setFieldOfView((float)this.getFieldOfView());
        }
    }

    @Override
    void computeProjectionTransform(GeneralTransform3D proj) {
        proj.perspective(this.isVerticalFieldOfView(), Math.toRadians(this.getFieldOfView()), this.getViewWidth() / this.getViewHeight(), this.getNearClip(), this.getFarClip());
    }

    @Override
    void computeViewTransform(Affine3D view) {
        if (this.isFixedEyeAtCameraZero()) {
            view.setTransform(LOOK_AT_TX_FIXED_EYE);
        } else {
            double viewWidth = this.getViewWidth();
            double viewHeight = this.getViewHeight();
            boolean verticalFOV = this.isVerticalFieldOfView();
            double aspect = viewWidth / viewHeight;
            double tanOfHalfFOV = Math.tan(Math.toRadians(this.getFieldOfView()) / 2.0);
            double xOffset = -tanOfHalfFOV * (verticalFOV ? aspect : 1.0);
            double yOffset = tanOfHalfFOV * (verticalFOV ? 1.0 : 1.0 / aspect);
            double scale = 2.0 * tanOfHalfFOV / (verticalFOV ? viewHeight : viewWidth);
            view.setToTranslation(xOffset, yOffset, 0.0);
            view.concatenate(LOOK_AT_TX);
            view.scale(scale, scale, scale);
        }
    }

    @Override
    Vec3d computePosition(Vec3d position) {
        if (position == null) {
            position = new Vec3d();
        }
        if (this.fixedEyeAtCameraZero) {
            position.set(0.0, 0.0, 0.0);
        } else {
            double halfViewWidth = this.getViewWidth() / 2.0;
            double halfViewHeight = this.getViewHeight() / 2.0;
            double halfViewDim = this.isVerticalFieldOfView() ? halfViewHeight : halfViewWidth;
            double distanceZ = halfViewDim / Math.tan(Math.toRadians(this.getFieldOfView() / 2.0));
            position.set(halfViewWidth, halfViewHeight, -distanceZ);
        }
        return position;
    }

    static {
        PerspectiveCameraHelper.setPerspectiveCameraAccessor(new PerspectiveCameraHelper.PerspectiveCameraAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((PerspectiveCamera)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((PerspectiveCamera)node).doUpdatePeer();
            }
        });
        LOOK_AT_TX.setToTranslation(0.0, 0.0, -1.0);
        LOOK_AT_TX.rotate(Math.PI, 1.0, 0.0, 0.0);
        LOOK_AT_TX_FIXED_EYE.rotate(Math.PI, 1.0, 0.0, 0.0);
    }
}

