/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.effect.Effect;

public class BoxBlur
extends Effect {
    private ObjectProperty<Effect> input;
    private DoubleProperty width;
    private DoubleProperty height;
    private IntegerProperty iterations;

    public BoxBlur() {
    }

    public BoxBlur(double width, double height, int iterations) {
        this.setWidth(width);
        this.setHeight(height);
        this.setIterations(iterations);
    }

    @Override
    com.sun.scenario.effect.BoxBlur createPeer() {
        return new com.sun.scenario.effect.BoxBlur();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty("input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 5.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DoublePropertyBase(5.0){

                public void invalidated() {
                    BoxBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    BoxBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return BoxBlur.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 5.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DoublePropertyBase(5.0){

                public void invalidated() {
                    BoxBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    BoxBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return BoxBlur.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    public final void setIterations(int value) {
        this.iterationsProperty().set(value);
    }

    public final int getIterations() {
        return this.iterations == null ? 1 : this.iterations.get();
    }

    public final IntegerProperty iterationsProperty() {
        if (this.iterations == null) {
            this.iterations = new IntegerPropertyBase(1){

                public void invalidated() {
                    BoxBlur.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    BoxBlur.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return BoxBlur.this;
                }

                public String getName() {
                    return "iterations";
                }
            };
        }
        return this.iterations;
    }

    private int getClampedWidth() {
        return Utils.clamp(0, (int)this.getWidth(), 255);
    }

    private int getClampedHeight() {
        return Utils.clamp(0, (int)this.getHeight(), 255);
    }

    private int getClampedIterations() {
        return Utils.clamp(0, this.getIterations(), 3);
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        com.sun.scenario.effect.BoxBlur peer = (com.sun.scenario.effect.BoxBlur)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setHorizontalSize(this.getClampedWidth());
        peer.setVerticalSize(this.getClampedHeight());
        peer.setPasses(this.getClampedIterations());
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = BoxBlur.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        int localIterations = this.getClampedIterations();
        int hgrow = BoxBlur.getKernelSize(this.getClampedWidth(), localIterations);
        int vgrow = BoxBlur.getKernelSize(this.getClampedHeight(), localIterations);
        bounds = bounds.deriveWithPadding(hgrow, vgrow, 0.0f);
        return BoxBlur.transformBounds(tx, bounds);
    }

    @Override
    Effect copy() {
        BoxBlur bb = new BoxBlur(this.getWidth(), this.getHeight(), this.getIterations());
        bb.setInput(this.getInput());
        return bb;
    }
}

