/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.effect.GeneralShadow;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;

public class Shadow
extends Effect {
    private boolean changeIsLocal;
    private ObjectProperty<Effect> input;
    private DoubleProperty radius;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<BlurType> blurType;
    private ObjectProperty<Color> color;

    public Shadow() {
    }

    public Shadow(double radius, Color color) {
        this.setRadius(radius);
        this.setColor(color);
    }

    public Shadow(BlurType blurType, Color color, double radius) {
        this.setBlurType(blurType);
        this.setColor(color);
        this.setRadius(radius);
    }

    @Override
    GeneralShadow createPeer() {
        return new GeneralShadow();
    }

    public final void setInput(Effect value) {
        this.inputProperty().set((Object)value);
    }

    public final Effect getInput() {
        return this.input == null ? null : (Effect)this.input.get();
    }

    public final ObjectProperty<Effect> inputProperty() {
        if (this.input == null) {
            this.input = new Effect.EffectInputProperty(this, "input");
        }
        return this.input;
    }

    @Override
    boolean checkChainContains(Effect e) {
        Effect localInput = this.getInput();
        if (localInput == null) {
            return false;
        }
        if (localInput == e) {
            return true;
        }
        return localInput.checkChainContains(e);
    }

    public final void setRadius(double value) {
        this.radiusProperty().set(value);
    }

    public final double getRadius() {
        return this.radius == null ? 10.0 : this.radius.get();
    }

    public final DoubleProperty radiusProperty() {
        if (this.radius == null) {
            this.radius = new DoublePropertyBase(10.0){

                public void invalidated() {
                    double localRadius = Shadow.this.getRadius();
                    if (!Shadow.this.changeIsLocal) {
                        Shadow.this.changeIsLocal = true;
                        Shadow.this.updateRadius(localRadius);
                        Shadow.this.changeIsLocal = false;
                        Shadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        Shadow.this.effectBoundsChanged();
                    }
                }

                public Object getBean() {
                    return Shadow.this;
                }

                public String getName() {
                    return "radius";
                }
            };
        }
        return this.radius;
    }

    private void updateRadius(double value) {
        double newdim = value * 2.0 + 1.0;
        if (this.width != null && this.width.isBound()) {
            if (this.height == null || !this.height.isBound()) {
                this.setHeight(newdim * 2.0 - this.getWidth());
            }
        } else if (this.height != null && this.height.isBound()) {
            this.setWidth(newdim * 2.0 - this.getHeight());
        } else {
            this.setWidth(newdim);
            this.setHeight(newdim);
        }
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 21.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DoublePropertyBase(21.0){

                public void invalidated() {
                    double localWidth = Shadow.this.getWidth();
                    if (!Shadow.this.changeIsLocal) {
                        Shadow.this.changeIsLocal = true;
                        Shadow.this.updateWidth(localWidth);
                        Shadow.this.changeIsLocal = false;
                        Shadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        Shadow.this.effectBoundsChanged();
                    }
                }

                public Object getBean() {
                    return Shadow.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    private void updateWidth(double value) {
        if (this.radius == null || !this.radius.isBound()) {
            double newrad = (value + this.getHeight()) / 2.0;
            if ((newrad = (newrad - 1.0) / 2.0) < 0.0) {
                newrad = 0.0;
            }
            this.setRadius(newrad);
        } else if (this.height == null || !this.height.isBound()) {
            double newdim = this.getRadius() * 2.0 + 1.0;
            this.setHeight(newdim * 2.0 - value);
        }
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 21.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DoublePropertyBase(21.0){

                public void invalidated() {
                    double localHeight = Shadow.this.getHeight();
                    if (!Shadow.this.changeIsLocal) {
                        Shadow.this.changeIsLocal = true;
                        Shadow.this.updateHeight(localHeight);
                        Shadow.this.changeIsLocal = false;
                        Shadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                        Shadow.this.effectBoundsChanged();
                    }
                }

                public Object getBean() {
                    return Shadow.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    private void updateHeight(double value) {
        if (this.radius == null || !this.radius.isBound()) {
            double newrad = (this.getWidth() + value) / 2.0;
            if ((newrad = (newrad - 1.0) / 2.0) < 0.0) {
                newrad = 0.0;
            }
            this.setRadius(newrad);
        } else if (this.width == null || !this.width.isBound()) {
            double newdim = this.getRadius() * 2.0 + 1.0;
            this.setWidth(newdim * 2.0 - value);
        }
    }

    public final void setBlurType(BlurType value) {
        this.blurTypeProperty().set((Object)value);
    }

    public final BlurType getBlurType() {
        return this.blurType == null ? BlurType.THREE_PASS_BOX : (BlurType)((Object)this.blurType.get());
    }

    public final ObjectProperty<BlurType> blurTypeProperty() {
        if (this.blurType == null) {
            this.blurType = new ObjectPropertyBase<BlurType>(BlurType.THREE_PASS_BOX){

                public void invalidated() {
                    Shadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    Shadow.this.effectBoundsChanged();
                }

                public Object getBean() {
                    return Shadow.this;
                }

                public String getName() {
                    return "blurType";
                }
            };
        }
        return this.blurType;
    }

    public final void setColor(Color value) {
        this.colorProperty().set((Object)value);
    }

    public final Color getColor() {
        return this.color == null ? Color.BLACK : (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new ObjectPropertyBase<Color>(Color.BLACK){

                public void invalidated() {
                    Shadow.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                }

                public Object getBean() {
                    return Shadow.this;
                }

                public String getName() {
                    return "color";
                }
            };
        }
        return this.color;
    }

    private float getClampedWidth() {
        return (float)Utils.clamp(0.0, this.getWidth(), 255.0);
    }

    private float getClampedHeight() {
        return (float)Utils.clamp(0.0, this.getHeight(), 255.0);
    }

    private Color getColorInternal() {
        Color c = this.getColor();
        return c == null ? Color.BLACK : c;
    }

    private BlurType getBlurTypeInternal() {
        BlurType bt = this.getBlurType();
        return bt == null ? BlurType.THREE_PASS_BOX : bt;
    }

    @Override
    void update() {
        Effect localInput = this.getInput();
        if (localInput != null) {
            localInput.sync();
        }
        GeneralShadow peer = (GeneralShadow)this.getPeer();
        peer.setInput(localInput == null ? null : localInput.getPeer());
        peer.setGaussianWidth(this.getClampedWidth());
        peer.setGaussianHeight(this.getClampedHeight());
        peer.setShadowMode(Toolkit.getToolkit().toShadowMode(this.getBlurTypeInternal()));
        peer.setColor(Toolkit.getToolkit().toColor4f(this.getColorInternal()));
    }

    @Override
    BaseBounds getBounds(BaseBounds bounds, BaseTransform tx, Node node, BoundsAccessor boundsAccessor) {
        bounds = Shadow.getInputBounds(bounds, BaseTransform.IDENTITY_TRANSFORM, node, boundsAccessor, this.getInput());
        return Shadow.getShadowBounds(bounds, tx, this.getClampedWidth(), this.getClampedHeight(), this.getBlurTypeInternal());
    }

    @Override
    Effect copy() {
        Shadow shadow = new Shadow(this.getBlurType(), this.getColor(), this.getRadius());
        shadow.setInput(this.getInput());
        shadow.setHeight(this.getHeight());
        shadow.setWidth(this.getWidth());
        return shadow;
    }
}

