/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.collections.TrackableObservableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.util.Callback;

public class GridPane
extends Pane {
    public static final int REMAINING = Integer.MAX_VALUE;
    private static final String MARGIN_CONSTRAINT = "gridpane-margin";
    private static final String HALIGNMENT_CONSTRAINT = "gridpane-halignment";
    private static final String VALIGNMENT_CONSTRAINT = "gridpane-valignment";
    private static final String HGROW_CONSTRAINT = "gridpane-hgrow";
    private static final String VGROW_CONSTRAINT = "gridpane-vgrow";
    private static final String ROW_INDEX_CONSTRAINT = "gridpane-row";
    private static final String COLUMN_INDEX_CONSTRAINT = "gridpane-column";
    private static final String ROW_SPAN_CONSTRAINT = "gridpane-row-span";
    private static final String COLUMN_SPAN_CONSTRAINT = "gridpane-column-span";
    private static final String FILL_WIDTH_CONSTRAINT = "gridpane-fill-width";
    private static final String FILL_HEIGHT_CONSTRAINT = "gridpane-fill-height";
    private static final Callback<Node, Insets> marginAccessor = n -> GridPane.getMargin(n);
    private static final Color GRID_LINE_COLOR = Color.rgb(30, 30, 30);
    private static final double GRID_LINE_DASH = 3.0;
    private DoubleProperty hgap;
    private DoubleProperty vgap;
    private ObjectProperty<Pos> alignment;
    private BooleanProperty gridLinesVisible;
    private final ObservableList<RowConstraints> rowConstraints = new TrackableObservableList<RowConstraints>(){

        protected void onChanged(ListChangeListener.Change<RowConstraints> c) {
            while (c.next()) {
                for (RowConstraints constraints : c.getRemoved()) {
                    if (constraints == null || GridPane.this.rowConstraints.contains((Object)constraints)) continue;
                    constraints.remove(GridPane.this);
                }
                for (RowConstraints constraints : c.getAddedSubList()) {
                    if (constraints == null) continue;
                    constraints.add(GridPane.this);
                }
            }
            GridPane.this.requestLayout();
        }
    };
    private final ObservableList<ColumnConstraints> columnConstraints = new TrackableObservableList<ColumnConstraints>(){

        protected void onChanged(ListChangeListener.Change<ColumnConstraints> c) {
            while (c.next()) {
                for (ColumnConstraints constraints : c.getRemoved()) {
                    if (constraints == null || GridPane.this.columnConstraints.contains((Object)constraints)) continue;
                    constraints.remove(GridPane.this);
                }
                for (ColumnConstraints constraints : c.getAddedSubList()) {
                    if (constraints == null) continue;
                    constraints.add(GridPane.this);
                }
            }
            GridPane.this.requestLayout();
        }
    };
    private Group gridLines;
    private Orientation bias;
    private double[] rowPercentHeight;
    private double rowPercentTotal = 0.0;
    private CompositeSize rowMinHeight;
    private CompositeSize rowPrefHeight;
    private CompositeSize rowMaxHeight;
    private List<Node>[] rowBaseline;
    private double[] rowMinBaselineComplement;
    private double[] rowPrefBaselineComplement;
    private double[] rowMaxBaselineComplement;
    private Priority[] rowGrow;
    private double[] columnPercentWidth;
    private double columnPercentTotal = 0.0;
    private CompositeSize columnMinWidth;
    private CompositeSize columnPrefWidth;
    private CompositeSize columnMaxWidth;
    private Priority[] columnGrow;
    private boolean metricsDirty = true;
    private boolean performingLayout = false;
    private int numRows;
    private int numColumns;
    private CompositeSize currentHeights;
    private CompositeSize currentWidths;

    public static void setRowIndex(Node child, Integer value) {
        if (value != null && value < 0) {
            throw new IllegalArgumentException("rowIndex must be greater or equal to 0, but was " + value);
        }
        GridPane.setConstraint(child, ROW_INDEX_CONSTRAINT, value);
    }

    public static Integer getRowIndex(Node child) {
        return (Integer)GridPane.getConstraint(child, ROW_INDEX_CONSTRAINT);
    }

    public static void setColumnIndex(Node child, Integer value) {
        if (value != null && value < 0) {
            throw new IllegalArgumentException("columnIndex must be greater or equal to 0, but was " + value);
        }
        GridPane.setConstraint(child, COLUMN_INDEX_CONSTRAINT, value);
    }

    public static Integer getColumnIndex(Node child) {
        return (Integer)GridPane.getConstraint(child, COLUMN_INDEX_CONSTRAINT);
    }

    public static void setRowSpan(Node child, Integer value) {
        if (value != null && value < 1) {
            throw new IllegalArgumentException("rowSpan must be greater or equal to 1, but was " + value);
        }
        GridPane.setConstraint(child, ROW_SPAN_CONSTRAINT, value);
    }

    public static Integer getRowSpan(Node child) {
        return (Integer)GridPane.getConstraint(child, ROW_SPAN_CONSTRAINT);
    }

    public static void setColumnSpan(Node child, Integer value) {
        if (value != null && value < 1) {
            throw new IllegalArgumentException("columnSpan must be greater or equal to 1, but was " + value);
        }
        GridPane.setConstraint(child, COLUMN_SPAN_CONSTRAINT, value);
    }

    public static Integer getColumnSpan(Node child) {
        return (Integer)GridPane.getConstraint(child, COLUMN_SPAN_CONSTRAINT);
    }

    public static void setMargin(Node child, Insets value) {
        GridPane.setConstraint(child, MARGIN_CONSTRAINT, value);
    }

    public static Insets getMargin(Node child) {
        return (Insets)GridPane.getConstraint(child, MARGIN_CONSTRAINT);
    }

    private double getBaselineComplementForChild(Node child) {
        if (this.isNodePositionedByBaseline(child)) {
            return this.rowMinBaselineComplement[GridPane.getNodeRowIndex(child)];
        }
        return -1.0;
    }

    public static void setHalignment(Node child, HPos value) {
        GridPane.setConstraint(child, HALIGNMENT_CONSTRAINT, (Object)value);
    }

    public static HPos getHalignment(Node child) {
        return (HPos)((Object)GridPane.getConstraint(child, HALIGNMENT_CONSTRAINT));
    }

    public static void setValignment(Node child, VPos value) {
        GridPane.setConstraint(child, VALIGNMENT_CONSTRAINT, (Object)value);
    }

    public static VPos getValignment(Node child) {
        return (VPos)((Object)GridPane.getConstraint(child, VALIGNMENT_CONSTRAINT));
    }

    public static void setHgrow(Node child, Priority value) {
        GridPane.setConstraint(child, HGROW_CONSTRAINT, (Object)value);
    }

    public static Priority getHgrow(Node child) {
        return (Priority)((Object)GridPane.getConstraint(child, HGROW_CONSTRAINT));
    }

    public static void setVgrow(Node child, Priority value) {
        GridPane.setConstraint(child, VGROW_CONSTRAINT, (Object)value);
    }

    public static Priority getVgrow(Node child) {
        return (Priority)((Object)GridPane.getConstraint(child, VGROW_CONSTRAINT));
    }

    public static void setFillWidth(Node child, Boolean value) {
        GridPane.setConstraint(child, FILL_WIDTH_CONSTRAINT, value);
    }

    public static Boolean isFillWidth(Node child) {
        return (Boolean)GridPane.getConstraint(child, FILL_WIDTH_CONSTRAINT);
    }

    public static void setFillHeight(Node child, Boolean value) {
        GridPane.setConstraint(child, FILL_HEIGHT_CONSTRAINT, value);
    }

    public static Boolean isFillHeight(Node child) {
        return (Boolean)GridPane.getConstraint(child, FILL_HEIGHT_CONSTRAINT);
    }

    public static void setConstraints(Node child, int columnIndex, int rowIndex) {
        GridPane.setRowIndex(child, rowIndex);
        GridPane.setColumnIndex(child, columnIndex);
    }

    public static void setConstraints(Node child, int columnIndex, int rowIndex, int columnspan, int rowspan) {
        GridPane.setRowIndex(child, rowIndex);
        GridPane.setColumnIndex(child, columnIndex);
        GridPane.setRowSpan(child, rowspan);
        GridPane.setColumnSpan(child, columnspan);
    }

    public static void setConstraints(Node child, int columnIndex, int rowIndex, int columnspan, int rowspan, HPos halignment, VPos valignment) {
        GridPane.setRowIndex(child, rowIndex);
        GridPane.setColumnIndex(child, columnIndex);
        GridPane.setRowSpan(child, rowspan);
        GridPane.setColumnSpan(child, columnspan);
        GridPane.setHalignment(child, halignment);
        GridPane.setValignment(child, valignment);
    }

    public static void setConstraints(Node child, int columnIndex, int rowIndex, int columnspan, int rowspan, HPos halignment, VPos valignment, Priority hgrow, Priority vgrow) {
        GridPane.setRowIndex(child, rowIndex);
        GridPane.setColumnIndex(child, columnIndex);
        GridPane.setRowSpan(child, rowspan);
        GridPane.setColumnSpan(child, columnspan);
        GridPane.setHalignment(child, halignment);
        GridPane.setValignment(child, valignment);
        GridPane.setHgrow(child, hgrow);
        GridPane.setVgrow(child, vgrow);
    }

    public static void setConstraints(Node child, int columnIndex, int rowIndex, int columnspan, int rowspan, HPos halignment, VPos valignment, Priority hgrow, Priority vgrow, Insets margin) {
        GridPane.setRowIndex(child, rowIndex);
        GridPane.setColumnIndex(child, columnIndex);
        GridPane.setRowSpan(child, rowspan);
        GridPane.setColumnSpan(child, columnspan);
        GridPane.setHalignment(child, halignment);
        GridPane.setValignment(child, valignment);
        GridPane.setHgrow(child, hgrow);
        GridPane.setVgrow(child, vgrow);
        GridPane.setMargin(child, margin);
    }

    public static void clearConstraints(Node child) {
        GridPane.setRowIndex(child, null);
        GridPane.setColumnIndex(child, null);
        GridPane.setRowSpan(child, null);
        GridPane.setColumnSpan(child, null);
        GridPane.setHalignment(child, null);
        GridPane.setValignment(child, null);
        GridPane.setHgrow(child, null);
        GridPane.setVgrow(child, null);
        GridPane.setMargin(child, null);
    }

    static void createRow(int rowIndex, int columnIndex, Node ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            GridPane.setConstraints(nodes[i], columnIndex + i, rowIndex);
        }
    }

    static void createColumn(int columnIndex, int rowIndex, Node ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            GridPane.setConstraints(nodes[i], columnIndex, rowIndex + i);
        }
    }

    static int getNodeRowIndex(Node node) {
        Integer rowIndex = GridPane.getRowIndex(node);
        return rowIndex != null ? rowIndex : 0;
    }

    private static int getNodeRowSpan(Node node) {
        Integer rowspan = GridPane.getRowSpan(node);
        return rowspan != null ? rowspan : 1;
    }

    static int getNodeRowEnd(Node node) {
        int rowSpan = GridPane.getNodeRowSpan(node);
        return rowSpan != Integer.MAX_VALUE ? GridPane.getNodeRowIndex(node) + rowSpan - 1 : Integer.MAX_VALUE;
    }

    static int getNodeColumnIndex(Node node) {
        Integer columnIndex = GridPane.getColumnIndex(node);
        return columnIndex != null ? columnIndex : 0;
    }

    private static int getNodeColumnSpan(Node node) {
        Integer colspan = GridPane.getColumnSpan(node);
        return colspan != null ? colspan : 1;
    }

    static int getNodeColumnEnd(Node node) {
        int columnSpan = GridPane.getNodeColumnSpan(node);
        return columnSpan != Integer.MAX_VALUE ? GridPane.getNodeColumnIndex(node) + columnSpan - 1 : Integer.MAX_VALUE;
    }

    private static Priority getNodeHgrow(Node node) {
        Priority hgrow = GridPane.getHgrow(node);
        return hgrow != null ? hgrow : Priority.NEVER;
    }

    private static Priority getNodeVgrow(Node node) {
        Priority vgrow = GridPane.getVgrow(node);
        return vgrow != null ? vgrow : Priority.NEVER;
    }

    private static Priority[] createPriorityArray(int length, Priority value) {
        Priority[] array = new Priority[length];
        Arrays.fill((Object[])array, (Object)value);
        return array;
    }

    public GridPane() {
        this.getChildren().addListener(o -> this.requestLayout());
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new StyleableDoubleProperty(0.0){

                public void invalidated() {
                    GridPane.this.requestLayout();
                }

                @Override
                public CssMetaData<GridPane, Number> getCssMetaData() {
                    return StyleableProperties.HGAP;
                }

                public Object getBean() {
                    return GridPane.this;
                }

                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double value) {
        this.hgapProperty().set(value);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new StyleableDoubleProperty(0.0){

                public void invalidated() {
                    GridPane.this.requestLayout();
                }

                @Override
                public CssMetaData<GridPane, Number> getCssMetaData() {
                    return StyleableProperties.VGAP;
                }

                public Object getBean() {
                    return GridPane.this;
                }

                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double value) {
        this.vgapProperty().set(value);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    GridPane.this.requestLayout();
                }

                @Override
                public CssMetaData<GridPane, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                public Object getBean() {
                    return GridPane.this;
                }

                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set((Object)value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final BooleanProperty gridLinesVisibleProperty() {
        if (this.gridLinesVisible == null) {
            this.gridLinesVisible = new StyleableBooleanProperty(){

                protected void invalidated() {
                    if (this.get()) {
                        GridPane.this.gridLines = new Group();
                        GridPane.this.gridLines.setManaged(false);
                        GridPane.this.getChildren().add((Object)GridPane.this.gridLines);
                    } else {
                        GridPane.this.getChildren().remove((Object)GridPane.this.gridLines);
                        GridPane.this.gridLines = null;
                    }
                    GridPane.this.requestLayout();
                }

                @Override
                public CssMetaData<GridPane, Boolean> getCssMetaData() {
                    return StyleableProperties.GRID_LINES_VISIBLE;
                }

                public Object getBean() {
                    return GridPane.this;
                }

                public String getName() {
                    return "gridLinesVisible";
                }
            };
        }
        return this.gridLinesVisible;
    }

    public final void setGridLinesVisible(boolean value) {
        this.gridLinesVisibleProperty().set(value);
    }

    public final boolean isGridLinesVisible() {
        return this.gridLinesVisible == null ? false : this.gridLinesVisible.get();
    }

    public final ObservableList<RowConstraints> getRowConstraints() {
        return this.rowConstraints;
    }

    public final ObservableList<ColumnConstraints> getColumnConstraints() {
        return this.columnConstraints;
    }

    public void add(Node child, int columnIndex, int rowIndex) {
        GridPane.setConstraints(child, columnIndex, rowIndex);
        this.getChildren().add((Object)child);
    }

    public void add(Node child, int columnIndex, int rowIndex, int colspan, int rowspan) {
        GridPane.setConstraints(child, columnIndex, rowIndex, colspan, rowspan);
        this.getChildren().add((Object)child);
    }

    public void addRow(int rowIndex, Node ... children) {
        int columnIndex = 0;
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)managed.get(i);
            int nodeRowIndex = GridPane.getNodeRowIndex(child);
            int nodeRowEnd = GridPane.getNodeRowEnd(child);
            if (rowIndex < nodeRowIndex || rowIndex > nodeRowEnd && nodeRowEnd != Integer.MAX_VALUE) continue;
            int index = GridPane.getNodeColumnIndex(child);
            int end = GridPane.getNodeColumnEnd(child);
            columnIndex = Math.max(columnIndex, (end != Integer.MAX_VALUE ? end : index) + 1);
        }
        GridPane.createRow(rowIndex, columnIndex, children);
        this.getChildren().addAll((Object[])children);
    }

    public void addColumn(int columnIndex, Node ... children) {
        int rowIndex = 0;
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)managed.get(i);
            int nodeColumnIndex = GridPane.getNodeColumnIndex(child);
            int nodeColumnEnd = GridPane.getNodeColumnEnd(child);
            if (columnIndex < nodeColumnIndex || columnIndex > nodeColumnEnd && nodeColumnEnd != Integer.MAX_VALUE) continue;
            int index = GridPane.getNodeRowIndex(child);
            int end = GridPane.getNodeRowEnd(child);
            rowIndex = Math.max(rowIndex, (end != Integer.MAX_VALUE ? end : index) + 1);
        }
        GridPane.createColumn(columnIndex, rowIndex, children);
        this.getChildren().addAll((Object[])children);
    }

    private int getNumberOfRows() {
        this.computeGridMetrics();
        return this.numRows;
    }

    private int getNumberOfColumns() {
        this.computeGridMetrics();
        return this.numColumns;
    }

    private boolean isNodePositionedByBaseline(Node n) {
        return this.getRowValignment(GridPane.getNodeRowIndex(n)) == VPos.BASELINE && GridPane.getValignment(n) == null || GridPane.getValignment(n) == VPos.BASELINE;
    }

    private void computeGridMetrics() {
        if (this.metricsDirty) {
            Node child;
            int i;
            this.numRows = this.rowConstraints.size();
            this.numColumns = this.columnConstraints.size();
            List managed = this.getManagedChildren();
            int size = managed.size();
            for (i = 0; i < size; ++i) {
                child = (Node)managed.get(i);
                int rowIndex = GridPane.getNodeRowIndex(child);
                int columnIndex = GridPane.getNodeColumnIndex(child);
                int rowEnd = GridPane.getNodeRowEnd(child);
                int columnEnd = GridPane.getNodeColumnEnd(child);
                this.numRows = Math.max(this.numRows, (rowEnd != Integer.MAX_VALUE ? rowEnd : rowIndex) + 1);
                this.numColumns = Math.max(this.numColumns, (columnEnd != Integer.MAX_VALUE ? columnEnd : columnIndex) + 1);
            }
            this.rowPercentHeight = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowPercentTotal = 0.0;
            this.columnPercentWidth = GridPane.createDoubleArray(this.numColumns, -1.0);
            this.columnPercentTotal = 0.0;
            this.columnGrow = GridPane.createPriorityArray(this.numColumns, Priority.NEVER);
            this.rowGrow = GridPane.createPriorityArray(this.numRows, Priority.NEVER);
            this.rowMinBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowPrefBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowMaxBaselineComplement = GridPane.createDoubleArray(this.numRows, -1.0);
            this.rowBaseline = new List[this.numRows];
            int sz = this.numRows;
            for (i = 0; i < sz; ++i) {
                if (i < this.rowConstraints.size()) {
                    RowConstraints rc = (RowConstraints)this.rowConstraints.get(i);
                    double percentHeight = rc.getPercentHeight();
                    Priority vGrow = rc.getVgrow();
                    if (percentHeight >= 0.0) {
                        this.rowPercentHeight[i] = percentHeight;
                    }
                    if (vGrow != null) {
                        this.rowGrow[i] = vGrow;
                    }
                }
                ArrayList<Node> baselineNodes = new ArrayList<Node>(this.numColumns);
                int size2 = managed.size();
                for (int j = 0; j < size2; ++j) {
                    Node n = (Node)managed.get(j);
                    if (GridPane.getNodeRowIndex(n) != i || !this.isNodePositionedByBaseline(n)) continue;
                    baselineNodes.add(n);
                }
                this.rowMinBaselineComplement[i] = GridPane.getMinBaselineComplement(baselineNodes);
                this.rowPrefBaselineComplement[i] = GridPane.getPrefBaselineComplement(baselineNodes);
                this.rowMaxBaselineComplement[i] = GridPane.getMaxBaselineComplement(baselineNodes);
                this.rowBaseline[i] = baselineNodes;
            }
            sz = Math.min(this.numColumns, this.columnConstraints.size());
            for (i = 0; i < sz; ++i) {
                ColumnConstraints cc = (ColumnConstraints)this.columnConstraints.get(i);
                double percentWidth = cc.getPercentWidth();
                Priority hGrow = cc.getHgrow();
                if (percentWidth >= 0.0) {
                    this.columnPercentWidth[i] = percentWidth;
                }
                if (hGrow == null) continue;
                this.columnGrow[i] = hGrow;
            }
            size = managed.size();
            for (i = 0; i < size; ++i) {
                int idx;
                child = (Node)managed.get(i);
                if (GridPane.getNodeColumnSpan(child) == 1) {
                    Priority hg = GridPane.getNodeHgrow(child);
                    idx = GridPane.getNodeColumnIndex(child);
                    this.columnGrow[idx] = Priority.max(this.columnGrow[idx], hg);
                }
                if (GridPane.getNodeRowSpan(child) != 1) continue;
                Priority vg = GridPane.getNodeVgrow(child);
                idx = GridPane.getNodeRowIndex(child);
                this.rowGrow[idx] = Priority.max(this.rowGrow[idx], vg);
            }
            for (i = 0; i < this.rowPercentHeight.length; ++i) {
                if (!(this.rowPercentHeight[i] > 0.0)) continue;
                this.rowPercentTotal += this.rowPercentHeight[i];
            }
            if (this.rowPercentTotal > 100.0) {
                double weight = 100.0 / this.rowPercentTotal;
                for (int i2 = 0; i2 < this.rowPercentHeight.length; ++i2) {
                    if (!(this.rowPercentHeight[i2] > 0.0)) continue;
                    int n = i2;
                    this.rowPercentHeight[n] = this.rowPercentHeight[n] * weight;
                }
                this.rowPercentTotal = 100.0;
            }
            for (int i3 = 0; i3 < this.columnPercentWidth.length; ++i3) {
                if (!(this.columnPercentWidth[i3] > 0.0)) continue;
                this.columnPercentTotal += this.columnPercentWidth[i3];
            }
            if (this.columnPercentTotal > 100.0) {
                double weight = 100.0 / this.columnPercentTotal;
                for (int i4 = 0; i4 < this.columnPercentWidth.length; ++i4) {
                    if (!(this.columnPercentWidth[i4] > 0.0)) continue;
                    int n = i4;
                    this.columnPercentWidth[n] = this.columnPercentWidth[n] * weight;
                }
                this.columnPercentTotal = 100.0;
            }
            this.bias = null;
            for (int i5 = 0; i5 < managed.size(); ++i5) {
                Orientation b = ((Node)managed.get(i5)).getContentBias();
                if (b == null) continue;
                this.bias = b;
                if (b == Orientation.HORIZONTAL) break;
            }
            this.metricsDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double computeMinWidth(double height) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] heights = height == -1.0 ? null : this.computeHeightsToFit(height).asArray();
            double d = this.snapSpaceX(this.getInsets().getLeft()) + this.computeMinWidths(heights).computeTotalWithMultiSize() + this.snapSpaceX(this.getInsets().getRight());
            return d;
        }
        finally {
            this.performingLayout = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double computeMinHeight(double width) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] widths = width == -1.0 ? null : this.computeWidthsToFit(width).asArray();
            double d = this.snapSpaceY(this.getInsets().getTop()) + this.computeMinHeights(widths).computeTotalWithMultiSize() + this.snapSpaceY(this.getInsets().getBottom());
            return d;
        }
        finally {
            this.performingLayout = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double computePrefWidth(double height) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] heights = height == -1.0 ? null : this.computeHeightsToFit(height).asArray();
            double d = this.snapSpaceX(this.getInsets().getLeft()) + this.computePrefWidths(heights).computeTotalWithMultiSize() + this.snapSpaceX(this.getInsets().getRight());
            return d;
        }
        finally {
            this.performingLayout = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected double computePrefHeight(double width) {
        this.computeGridMetrics();
        this.performingLayout = true;
        try {
            double[] widths = width == -1.0 ? null : this.computeWidthsToFit(width).asArray();
            double d = this.snapSpaceY(this.getInsets().getTop()) + this.computePrefHeights(widths).computeTotalWithMultiSize() + this.snapSpaceY(this.getInsets().getBottom());
            return d;
        }
        finally {
            this.performingLayout = false;
        }
    }

    private VPos getRowValignment(int rowIndex) {
        RowConstraints constraints;
        if (rowIndex < this.getRowConstraints().size() && (constraints = (RowConstraints)this.getRowConstraints().get(rowIndex)).getValignment() != null) {
            return constraints.getValignment();
        }
        return VPos.CENTER;
    }

    private HPos getColumnHalignment(int columnIndex) {
        ColumnConstraints constraints;
        if (columnIndex < this.getColumnConstraints().size() && (constraints = (ColumnConstraints)this.getColumnConstraints().get(columnIndex)).getHalignment() != null) {
            return constraints.getHalignment();
        }
        return HPos.LEFT;
    }

    private double getColumnMinWidth(int columnIndex) {
        if (columnIndex < this.getColumnConstraints().size()) {
            ColumnConstraints constraints = (ColumnConstraints)this.getColumnConstraints().get(columnIndex);
            return constraints.getMinWidth();
        }
        return -1.0;
    }

    private double getRowMinHeight(int rowIndex) {
        if (rowIndex < this.getRowConstraints().size()) {
            RowConstraints constraints = (RowConstraints)this.getRowConstraints().get(rowIndex);
            return constraints.getMinHeight();
        }
        return -1.0;
    }

    private double getColumnMaxWidth(int columnIndex) {
        if (columnIndex < this.getColumnConstraints().size()) {
            ColumnConstraints constraints = (ColumnConstraints)this.getColumnConstraints().get(columnIndex);
            return constraints.getMaxWidth();
        }
        return -1.0;
    }

    private double getColumnPrefWidth(int columnIndex) {
        if (columnIndex < this.getColumnConstraints().size()) {
            ColumnConstraints constraints = (ColumnConstraints)this.getColumnConstraints().get(columnIndex);
            return constraints.getPrefWidth();
        }
        return -1.0;
    }

    private double getRowPrefHeight(int rowIndex) {
        if (rowIndex < this.getRowConstraints().size()) {
            RowConstraints constraints = (RowConstraints)this.getRowConstraints().get(rowIndex);
            return constraints.getPrefHeight();
        }
        return -1.0;
    }

    private double getRowMaxHeight(int rowIndex) {
        if (rowIndex < this.getRowConstraints().size()) {
            RowConstraints constraints = (RowConstraints)this.getRowConstraints().get(rowIndex);
            return constraints.getMaxHeight();
        }
        return -1.0;
    }

    private boolean shouldRowFillHeight(int rowIndex) {
        if (rowIndex < this.getRowConstraints().size()) {
            return ((RowConstraints)this.getRowConstraints().get(rowIndex)).isFillHeight();
        }
        return true;
    }

    private boolean shouldColumnFillWidth(int columnIndex) {
        if (columnIndex < this.getColumnConstraints().size()) {
            return ((ColumnConstraints)this.getColumnConstraints().get(columnIndex)).isFillWidth();
        }
        return true;
    }

    private double getTotalWidthOfNodeColumns(Node child, double[] widths) {
        if (GridPane.getNodeColumnSpan(child) == 1) {
            return widths[GridPane.getNodeColumnIndex(child)];
        }
        double total = 0.0;
        int last = this.getNodeColumnEndConvertRemaining(child);
        for (int i = GridPane.getNodeColumnIndex(child); i <= last; ++i) {
            total += widths[i];
        }
        return total;
    }

    private CompositeSize computeMaxHeights() {
        if (this.rowMaxHeight == null) {
            this.rowMaxHeight = this.createCompositeRows(Double.MAX_VALUE);
            ObservableList<RowConstraints> rowConstr = this.getRowConstraints();
            CompositeSize prefHeights = null;
            for (int i = 0; i < rowConstr.size(); ++i) {
                RowConstraints curConstraint = (RowConstraints)rowConstr.get(i);
                double constrMaxH = curConstraint.getMaxHeight();
                if (constrMaxH == Double.NEGATIVE_INFINITY) {
                    if (prefHeights == null) {
                        prefHeights = this.computePrefHeights(null);
                    }
                    this.rowMaxHeight.setPresetSize(i, prefHeights.getSize(i));
                    continue;
                }
                if (constrMaxH == -1.0) continue;
                double maxRowHeight = this.snapSizeY(constrMaxH);
                double constrMinH = curConstraint.getMinHeight();
                if (constrMinH >= 0.0) {
                    double min = this.snapSizeY(curConstraint.getMinHeight());
                    this.rowMaxHeight.setPresetSize(i, GridPane.boundedSize(min, maxRowHeight, maxRowHeight));
                    continue;
                }
                this.rowMaxHeight.setPresetSize(i, maxRowHeight);
            }
        }
        return this.rowMaxHeight;
    }

    private CompositeSize computePrefHeights(double[] widths) {
        CompositeSize result;
        if (widths == null) {
            if (this.rowPrefHeight != null) {
                return this.rowPrefHeight;
            }
            result = this.rowPrefHeight = this.createCompositeRows(0.0);
        } else {
            result = this.createCompositeRows(0.0);
        }
        ObservableList<RowConstraints> rowConstr = this.getRowConstraints();
        for (int i = 0; i < rowConstr.size(); ++i) {
            RowConstraints curConstraint = (RowConstraints)rowConstr.get(i);
            double constrMinH = curConstraint.getMinHeight();
            double constrPrefH = curConstraint.getPrefHeight();
            if (constrPrefH != -1.0) {
                double prefRowHeight = this.snapSizeY(constrPrefH);
                double constrMaxH = curConstraint.getMaxHeight();
                if (constrMinH >= 0.0 || constrMaxH >= 0.0) {
                    double min = constrMinH < 0.0 ? 0.0 : this.snapSizeY(constrMinH);
                    double max = constrMaxH < 0.0 ? Double.POSITIVE_INFINITY : this.snapSizeY(constrMaxH);
                    result.setPresetSize(i, GridPane.boundedSize(min, prefRowHeight, max));
                    continue;
                }
                result.setPresetSize(i, prefRowHeight);
                continue;
            }
            if (!(constrMinH > 0.0)) continue;
            result.setSize(i, this.snapSizeY(constrMinH));
        }
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)managed.get(i);
            int start = GridPane.getNodeRowIndex(child);
            int end = this.getNodeRowEndConvertRemaining(child);
            double childPrefAreaHeight = this.computeChildPrefAreaHeight(child, this.isNodePositionedByBaseline(child) ? this.rowPrefBaselineComplement[start] : -1.0, GridPane.getMargin(child), widths == null ? -1.0 : this.getTotalWidthOfNodeColumns(child, widths));
            if (start == end && !result.isPreset(start)) {
                double min = this.getRowMinHeight(start);
                double max = this.getRowMaxHeight(start);
                result.setMaxSize(start, GridPane.boundedSize(min < 0.0 ? 0.0 : min, childPrefAreaHeight, max < 0.0 ? Double.MAX_VALUE : max));
                continue;
            }
            if (start == end) continue;
            result.setMaxMultiSize(start, end + 1, childPrefAreaHeight);
        }
        return result;
    }

    private CompositeSize computeMinHeights(double[] widths) {
        CompositeSize result;
        if (widths == null) {
            if (this.rowMinHeight != null) {
                return this.rowMinHeight;
            }
            result = this.rowMinHeight = this.createCompositeRows(0.0);
        } else {
            result = this.createCompositeRows(0.0);
        }
        ObservableList<RowConstraints> rowConstr = this.getRowConstraints();
        CompositeSize prefHeights = null;
        for (int i = 0; i < rowConstr.size(); ++i) {
            double constrMinH = ((RowConstraints)rowConstr.get(i)).getMinHeight();
            if (constrMinH == Double.NEGATIVE_INFINITY) {
                if (prefHeights == null) {
                    prefHeights = this.computePrefHeights(widths);
                }
                result.setPresetSize(i, prefHeights.getSize(i));
                continue;
            }
            if (constrMinH == -1.0) continue;
            result.setPresetSize(i, this.snapSizeY(constrMinH));
        }
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)managed.get(i);
            int start = GridPane.getNodeRowIndex(child);
            int end = this.getNodeRowEndConvertRemaining(child);
            double childMinAreaHeight = this.computeChildMinAreaHeight(child, this.isNodePositionedByBaseline(child) ? this.rowMinBaselineComplement[start] : -1.0, GridPane.getMargin(child), widths == null ? -1.0 : this.getTotalWidthOfNodeColumns(child, widths));
            if (start == end && !result.isPreset(start)) {
                result.setMaxSize(start, childMinAreaHeight);
                continue;
            }
            if (start == end) continue;
            result.setMaxMultiSize(start, end + 1, childMinAreaHeight);
        }
        return result;
    }

    private double getTotalHeightOfNodeRows(Node child, double[] heights) {
        if (GridPane.getNodeRowSpan(child) == 1) {
            return heights[GridPane.getNodeRowIndex(child)];
        }
        double total = 0.0;
        int last = this.getNodeRowEndConvertRemaining(child);
        for (int i = GridPane.getNodeRowIndex(child); i <= last; ++i) {
            total += heights[i];
        }
        return total;
    }

    private CompositeSize computeMaxWidths() {
        if (this.columnMaxWidth == null) {
            this.columnMaxWidth = this.createCompositeColumns(Double.MAX_VALUE);
            ObservableList<ColumnConstraints> columnConstr = this.getColumnConstraints();
            CompositeSize prefWidths = null;
            for (int i = 0; i < columnConstr.size(); ++i) {
                ColumnConstraints curConstraint = (ColumnConstraints)columnConstr.get(i);
                double constrMaxW = curConstraint.getMaxWidth();
                if (constrMaxW == Double.NEGATIVE_INFINITY) {
                    if (prefWidths == null) {
                        prefWidths = this.computePrefWidths(null);
                    }
                    this.columnMaxWidth.setPresetSize(i, prefWidths.getSize(i));
                    continue;
                }
                if (constrMaxW == -1.0) continue;
                double maxColumnWidth = this.snapSizeX(constrMaxW);
                double constrMinW = curConstraint.getMinWidth();
                if (constrMinW >= 0.0) {
                    double min = this.snapSizeX(constrMinW);
                    this.columnMaxWidth.setPresetSize(i, GridPane.boundedSize(min, maxColumnWidth, maxColumnWidth));
                    continue;
                }
                this.columnMaxWidth.setPresetSize(i, maxColumnWidth);
            }
        }
        return this.columnMaxWidth;
    }

    private CompositeSize computePrefWidths(double[] heights) {
        CompositeSize result;
        if (heights == null) {
            if (this.columnPrefWidth != null) {
                return this.columnPrefWidth;
            }
            result = this.columnPrefWidth = this.createCompositeColumns(0.0);
        } else {
            result = this.createCompositeColumns(0.0);
        }
        ObservableList<ColumnConstraints> columnConstr = this.getColumnConstraints();
        for (int i = 0; i < columnConstr.size(); ++i) {
            ColumnConstraints curConstraint = (ColumnConstraints)columnConstr.get(i);
            double constrPrefW = curConstraint.getPrefWidth();
            double constrMinW = curConstraint.getMinWidth();
            if (constrPrefW != -1.0) {
                double prefColumnWidth = this.snapSizeX(constrPrefW);
                double constrMaxW = curConstraint.getMaxWidth();
                if (constrMinW >= 0.0 || constrMaxW >= 0.0) {
                    double min = constrMinW < 0.0 ? 0.0 : this.snapSizeX(constrMinW);
                    double max = constrMaxW < 0.0 ? Double.POSITIVE_INFINITY : this.snapSizeX(constrMaxW);
                    result.setPresetSize(i, GridPane.boundedSize(min < 0.0 ? 0.0 : min, prefColumnWidth, max < 0.0 ? Double.POSITIVE_INFINITY : max));
                    continue;
                }
                result.setPresetSize(i, prefColumnWidth);
                continue;
            }
            if (!(constrMinW > 0.0)) continue;
            result.setSize(i, this.snapSizeX(constrMinW));
        }
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            int end;
            Node child = (Node)managed.get(i);
            int start = GridPane.getNodeColumnIndex(child);
            if (start == (end = this.getNodeColumnEndConvertRemaining(child)) && !result.isPreset(start)) {
                double min = this.getColumnMinWidth(start);
                double max = this.getColumnMaxWidth(start);
                result.setMaxSize(start, GridPane.boundedSize(min < 0.0 ? 0.0 : min, this.computeChildPrefAreaWidth(child, this.getBaselineComplementForChild(child), GridPane.getMargin(child), heights == null ? -1.0 : this.getTotalHeightOfNodeRows(child, heights), false), max < 0.0 ? Double.MAX_VALUE : max));
                continue;
            }
            if (start == end) continue;
            result.setMaxMultiSize(start, end + 1, this.computeChildPrefAreaWidth(child, this.getBaselineComplementForChild(child), GridPane.getMargin(child), heights == null ? -1.0 : this.getTotalHeightOfNodeRows(child, heights), false));
        }
        return result;
    }

    private CompositeSize computeMinWidths(double[] heights) {
        CompositeSize result;
        if (heights == null) {
            if (this.columnMinWidth != null) {
                return this.columnMinWidth;
            }
            result = this.columnMinWidth = this.createCompositeColumns(0.0);
        } else {
            result = this.createCompositeColumns(0.0);
        }
        ObservableList<ColumnConstraints> columnConstr = this.getColumnConstraints();
        CompositeSize prefWidths = null;
        for (int i = 0; i < columnConstr.size(); ++i) {
            double constrMinW = ((ColumnConstraints)columnConstr.get(i)).getMinWidth();
            if (constrMinW == Double.NEGATIVE_INFINITY) {
                if (prefWidths == null) {
                    prefWidths = this.computePrefWidths(heights);
                }
                result.setPresetSize(i, prefWidths.getSize(i));
                continue;
            }
            if (constrMinW == -1.0) continue;
            result.setPresetSize(i, this.snapSizeX(constrMinW));
        }
        List managed = this.getManagedChildren();
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            int end;
            Node child = (Node)managed.get(i);
            int start = GridPane.getNodeColumnIndex(child);
            if (start == (end = this.getNodeColumnEndConvertRemaining(child)) && !result.isPreset(start)) {
                result.setMaxSize(start, this.computeChildMinAreaWidth(child, this.getBaselineComplementForChild(child), GridPane.getMargin(child), heights == null ? -1.0 : this.getTotalHeightOfNodeRows(child, heights), false));
                continue;
            }
            if (start == end) continue;
            result.setMaxMultiSize(start, end + 1, this.computeChildMinAreaWidth(child, this.getBaselineComplementForChild(child), GridPane.getMargin(child), heights == null ? -1.0 : this.getTotalHeightOfNodeRows(child, heights), false));
        }
        return result;
    }

    private CompositeSize computeHeightsToFit(double height) {
        assert (height != -1.0);
        CompositeSize heights = this.rowPercentTotal == 100.0 ? this.createCompositeRows(0.0) : (CompositeSize)this.computePrefHeights(null).clone();
        this.adjustRowHeights(heights, height);
        return heights;
    }

    private CompositeSize computeWidthsToFit(double width) {
        assert (width != -1.0);
        CompositeSize widths = this.columnPercentTotal == 100.0 ? this.createCompositeColumns(0.0) : (CompositeSize)this.computePrefWidths(null).clone();
        this.adjustColumnWidths(widths, width);
        return widths;
    }

    @Override
    public Orientation getContentBias() {
        this.computeGridMetrics();
        return this.bias;
    }

    @Override
    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        if (this.metricsDirty) {
            super.requestLayout();
            return;
        }
        this.metricsDirty = true;
        this.bias = null;
        this.rowGrow = null;
        this.rowMaxHeight = null;
        this.rowPrefHeight = null;
        this.rowMinHeight = null;
        this.columnGrow = null;
        this.columnMaxWidth = null;
        this.columnPrefWidth = null;
        this.columnMinWidth = null;
        this.rowMaxBaselineComplement = null;
        this.rowPrefBaselineComplement = null;
        this.rowMinBaselineComplement = null;
        super.requestLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren() {
        this.performingLayout = true;
        try {
            double columnTotal;
            double rowTotal;
            CompositeSize widths;
            CompositeSize heights;
            double snaphgap = this.snapSpaceX(this.getHgap());
            double snapvgap = this.snapSpaceY(this.getVgap());
            double top = this.snapSpaceY(this.getInsets().getTop());
            double bottom = this.snapSpaceY(this.getInsets().getBottom());
            double left = this.snapSpaceX(this.getInsets().getLeft());
            double right = this.snapSpaceX(this.getInsets().getRight());
            double width = this.getWidth();
            double height = this.getHeight();
            double contentHeight = height - top - bottom;
            double contentWidth = width - left - right;
            this.computeGridMetrics();
            Orientation contentBias = this.getContentBias();
            if (contentBias == null) {
                heights = (CompositeSize)this.computePrefHeights(null).clone();
                widths = (CompositeSize)this.computePrefWidths(null).clone();
                rowTotal = this.adjustRowHeights(heights, height);
                columnTotal = this.adjustColumnWidths(widths, width);
            } else if (contentBias == Orientation.HORIZONTAL) {
                widths = (CompositeSize)this.computePrefWidths(null).clone();
                columnTotal = this.adjustColumnWidths(widths, width);
                heights = this.computePrefHeights(widths.asArray());
                rowTotal = this.adjustRowHeights(heights, height);
            } else {
                heights = (CompositeSize)this.computePrefHeights(null).clone();
                rowTotal = this.adjustRowHeights(heights, height);
                widths = this.computePrefWidths(heights.asArray());
                columnTotal = this.adjustColumnWidths(widths, width);
            }
            double x = left + GridPane.computeXOffset(contentWidth, columnTotal, this.getAlignmentInternal().getHpos());
            double y = top + GridPane.computeYOffset(contentHeight, rowTotal, this.getAlignmentInternal().getVpos());
            List managed = this.getManagedChildren();
            double[] baselineOffsets = GridPane.createDoubleArray(this.numRows, -1.0);
            int size = managed.size();
            for (int i = 0; i < size; ++i) {
                int rowspan;
                Node child = (Node)managed.get(i);
                int rowIndex = GridPane.getNodeRowIndex(child);
                int columnIndex = GridPane.getNodeColumnIndex(child);
                int colspan = GridPane.getNodeColumnSpan(child);
                if (colspan == Integer.MAX_VALUE) {
                    colspan = widths.getLength() - columnIndex;
                }
                if ((rowspan = GridPane.getNodeRowSpan(child)) == Integer.MAX_VALUE) {
                    rowspan = heights.getLength() - rowIndex;
                }
                double areaX = x;
                for (int j = 0; j < columnIndex; ++j) {
                    areaX += widths.getSize(j) + snaphgap;
                }
                double areaY = y;
                for (int j = 0; j < rowIndex; ++j) {
                    areaY += heights.getSize(j) + snapvgap;
                }
                double areaW = widths.getSize(columnIndex);
                for (int j = 2; j <= colspan; ++j) {
                    areaW += widths.getSize(columnIndex + j - 1) + snaphgap;
                }
                double areaH = heights.getSize(rowIndex);
                for (int j = 2; j <= rowspan; ++j) {
                    areaH += heights.getSize(rowIndex + j - 1) + snapvgap;
                }
                HPos halign = GridPane.getHalignment(child);
                VPos valign = GridPane.getValignment(child);
                Boolean fillWidth = GridPane.isFillWidth(child);
                Boolean fillHeight = GridPane.isFillHeight(child);
                if (halign == null) {
                    halign = this.getColumnHalignment(columnIndex);
                }
                if (valign == null) {
                    valign = this.getRowValignment(rowIndex);
                }
                if (fillWidth == null) {
                    fillWidth = this.shouldColumnFillWidth(columnIndex);
                }
                if (fillHeight == null) {
                    fillHeight = this.shouldRowFillHeight(rowIndex);
                }
                double baselineOffset = 0.0;
                if (valign == VPos.BASELINE) {
                    if (baselineOffsets[rowIndex] == -1.0) {
                        baselineOffsets[rowIndex] = this.getAreaBaselineOffset(this.rowBaseline[rowIndex], marginAccessor, (Integer t) -> {
                            Node n = this.rowBaseline[rowIndex].get((int)t);
                            int c = GridPane.getNodeColumnIndex(n);
                            int cs = GridPane.getNodeColumnSpan(n);
                            if (cs == Integer.MAX_VALUE) {
                                cs = widths.getLength() - c;
                            }
                            double w = widths.getSize(c);
                            for (int j = 2; j <= cs; ++j) {
                                w += widths.getSize(c + j - 1) + snaphgap;
                            }
                            return w;
                        }, areaH, t -> {
                            Boolean b = GridPane.isFillHeight(child);
                            if (b != null) {
                                return b;
                            }
                            return this.shouldRowFillHeight(GridPane.getNodeRowIndex(child));
                        }, this.rowMinBaselineComplement[rowIndex]);
                    }
                    baselineOffset = baselineOffsets[rowIndex];
                }
                Insets margin = GridPane.getMargin(child);
                this.layoutInArea(child, areaX, areaY, areaW, areaH, baselineOffset, margin, fillWidth, fillHeight, halign, valign);
            }
            this.layoutGridLines(widths, heights, x, y, rowTotal, columnTotal);
            this.currentHeights = heights;
            this.currentWidths = widths;
        }
        finally {
            this.performingLayout = false;
        }
    }

    private double adjustRowHeights(CompositeSize heights, double height) {
        double heightAvailable;
        assert (height != -1.0);
        double snapvgap = this.snapSpaceY(this.getVgap());
        double top = this.snapSpaceY(this.getInsets().getTop());
        double bottom = this.snapSpaceY(this.getInsets().getBottom());
        double vgaps = snapvgap * (double)(this.getNumberOfRows() - 1);
        double contentHeight = height - top - bottom;
        if (this.rowPercentTotal > 0.0) {
            double remainder = 0.0;
            for (int i = 0; i < this.rowPercentHeight.length; ++i) {
                if (!(this.rowPercentHeight[i] >= 0.0)) continue;
                double size = (contentHeight - vgaps) * (this.rowPercentHeight[i] / 100.0);
                double floor = Math.floor(size);
                remainder += size - floor;
                size = floor;
                if (remainder >= 0.5) {
                    size += 1.0;
                    remainder = -1.0 + remainder;
                }
                heights.setSize(i, size);
            }
        }
        double rowTotal = heights.computeTotal();
        if (this.rowPercentTotal < 100.0 && (heightAvailable = height - top - bottom - rowTotal) != 0.0) {
            double remaining = this.growToMultiSpanPreferredHeights(heights, heightAvailable);
            remaining = this.growOrShrinkRowHeights(heights, Priority.ALWAYS, remaining);
            remaining = this.growOrShrinkRowHeights(heights, Priority.SOMETIMES, remaining);
            rowTotal += heightAvailable - remaining;
        }
        return rowTotal;
    }

    private double growToMultiSpanPreferredHeights(CompositeSize heights, double extraHeight) {
        double portionUsed;
        double bounded;
        double current;
        double curLength;
        int intervalRows;
        double actualPortion;
        double prefOfRow;
        double maxOfRow;
        int i;
        Iterator it;
        if (extraHeight <= 0.0) {
            return extraHeight;
        }
        TreeSet<Integer> rowsAlways = new TreeSet<Integer>();
        TreeSet<Integer> rowsSometimes = new TreeSet<Integer>();
        TreeSet<Integer> lastRows = new TreeSet<Integer>();
        for (Map.Entry<Interval, Double> ms : heights.multiSizes()) {
            Interval interval = ms.getKey();
            block5: for (int i2 = interval.begin; i2 < interval.end; ++i2) {
                if (!(this.rowPercentHeight[i2] < 0.0)) continue;
                switch (this.rowGrow[i2]) {
                    case ALWAYS: {
                        rowsAlways.add(i2);
                        continue block5;
                    }
                    case SOMETIMES: {
                        rowsSometimes.add(i2);
                    }
                }
            }
            if (!(this.rowPercentHeight[interval.end - 1] < 0.0)) continue;
            lastRows.add(interval.end - 1);
        }
        double remaining = extraHeight;
        while (rowsAlways.size() > 0 && remaining > (double)rowsAlways.size()) {
            double rowPortion = Math.floor(remaining / (double)rowsAlways.size());
            it = rowsAlways.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfRow = this.getRowMaxHeight(i);
                prefOfRow = this.getRowPrefHeight(i);
                actualPortion = rowPortion;
                for (Map.Entry<Interval, Double> ms : heights.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (!interval.contains(i)) continue;
                    intervalRows = 0;
                    for (int j = interval.begin; j < interval.end; ++j) {
                        if (!rowsAlways.contains(j)) continue;
                        ++intervalRows;
                    }
                    curLength = heights.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.floor(Math.max(0.0, (ms.getValue() - curLength) / (double)intervalRows)), actualPortion);
                }
                current = heights.getSize(i);
                bounded = maxOfRow >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfRow) : (maxOfRow == Double.NEGATIVE_INFINITY && prefOfRow > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfRow) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                heights.setSize(i, bounded);
            }
        }
        while (rowsSometimes.size() > 0 && remaining > (double)rowsSometimes.size()) {
            double colPortion = Math.floor(remaining / (double)rowsSometimes.size());
            it = rowsSometimes.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfRow = this.getRowMaxHeight(i);
                prefOfRow = this.getRowPrefHeight(i);
                actualPortion = colPortion;
                for (Map.Entry<Interval, Double> ms : heights.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (!interval.contains(i)) continue;
                    intervalRows = 0;
                    for (int j = interval.begin; j < interval.end; ++j) {
                        if (!rowsSometimes.contains(j)) continue;
                        ++intervalRows;
                    }
                    curLength = heights.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.floor(Math.max(0.0, (ms.getValue() - curLength) / (double)intervalRows)), actualPortion);
                }
                current = heights.getSize(i);
                bounded = maxOfRow >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfRow) : (maxOfRow == Double.NEGATIVE_INFINITY && prefOfRow > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfRow) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                heights.setSize(i, bounded);
            }
        }
        while (lastRows.size() > 0 && remaining > (double)lastRows.size()) {
            double colPortion = Math.floor(remaining / (double)lastRows.size());
            it = lastRows.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfRow = this.getRowMaxHeight(i);
                prefOfRow = this.getRowPrefHeight(i);
                actualPortion = colPortion;
                for (Map.Entry<Interval, Double> ms : heights.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (interval.end - 1 != i) continue;
                    double curLength2 = heights.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.max(0.0, ms.getValue() - curLength2), actualPortion);
                }
                current = heights.getSize(i);
                bounded = maxOfRow >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfRow) : (maxOfRow == Double.NEGATIVE_INFINITY && prefOfRow > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfRow) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                heights.setSize(i, bounded);
            }
        }
        return remaining;
    }

    private double growOrShrinkRowHeights(CompositeSize heights, Priority priority, double extraHeight) {
        CompositeSize limitSize;
        boolean wasPositive;
        boolean shrinking = extraHeight < 0.0;
        ArrayList<Integer> adjusting = new ArrayList<Integer>();
        for (int i = 0; i < this.rowGrow.length; ++i) {
            if (!(this.rowPercentHeight[i] < 0.0) || !shrinking && this.rowGrow[i] != priority) continue;
            adjusting.add(i);
        }
        double available = extraHeight;
        boolean handleRemainder = false;
        double portion = 0.0;
        boolean isPositive = wasPositive = available >= 0.0;
        CompositeSize compositeSize = limitSize = shrinking ? this.computeMinHeights(null) : this.computeMaxHeights();
        block1: while (available != 0.0 && wasPositive == isPositive && adjusting.size() > 0) {
            if (!handleRemainder) {
                double d = portion = available > 0.0 ? Math.floor(available / (double)adjusting.size()) : Math.ceil(available / (double)adjusting.size());
            }
            if (portion != 0.0) {
                Iterator i = adjusting.iterator();
                while (i.hasNext()) {
                    int index = (Integer)i.next();
                    double limit = this.snapSpaceY(limitSize.getProportionalMinOrMaxSize(index, shrinking)) - heights.getSize(index);
                    if (shrinking && limit > 0.0 || !shrinking && limit < 0.0) {
                        limit = 0.0;
                    }
                    double change = Math.abs(limit) <= Math.abs(portion) ? limit : portion;
                    heights.addSize(index, change);
                    boolean bl = isPositive = (available -= change) >= 0.0;
                    if (Math.abs(change) < Math.abs(portion)) {
                        i.remove();
                    }
                    if (available != 0.0) continue;
                    continue block1;
                }
                continue;
            }
            portion = (int)available % adjusting.size();
            if (portion == 0.0) break;
            portion = shrinking ? -1.0 : 1.0;
            handleRemainder = true;
        }
        return available;
    }

    private double adjustColumnWidths(CompositeSize widths, double width) {
        double widthAvailable;
        assert (width != -1.0);
        double snaphgap = this.snapSpaceX(this.getHgap());
        double left = this.snapSpaceX(this.getInsets().getLeft());
        double right = this.snapSpaceX(this.getInsets().getRight());
        double hgaps = snaphgap * (double)(this.getNumberOfColumns() - 1);
        double contentWidth = width - left - right;
        if (this.columnPercentTotal > 0.0) {
            double remainder = 0.0;
            for (int i = 0; i < this.columnPercentWidth.length; ++i) {
                if (!(this.columnPercentWidth[i] >= 0.0)) continue;
                double size = (contentWidth - hgaps) * (this.columnPercentWidth[i] / 100.0);
                double floor = Math.floor(size);
                remainder += size - floor;
                size = floor;
                if (remainder >= 0.5) {
                    size += 1.0;
                    remainder = -1.0 + remainder;
                }
                widths.setSize(i, size);
            }
        }
        double columnTotal = widths.computeTotal();
        if (this.columnPercentTotal < 100.0 && (widthAvailable = width - left - right - columnTotal) != 0.0) {
            double remaining = this.growToMultiSpanPreferredWidths(widths, widthAvailable);
            remaining = this.growOrShrinkColumnWidths(widths, Priority.ALWAYS, remaining);
            remaining = this.growOrShrinkColumnWidths(widths, Priority.SOMETIMES, remaining);
            columnTotal += widthAvailable - remaining;
        }
        return columnTotal;
    }

    private double growToMultiSpanPreferredWidths(CompositeSize widths, double extraWidth) {
        double portionUsed;
        double bounded;
        double current;
        double curLength;
        int intervalColumns;
        double actualPortion;
        double prefOfColumn;
        double maxOfColumn;
        int i;
        Iterator it;
        if (extraWidth <= 0.0) {
            return extraWidth;
        }
        TreeSet<Integer> columnsAlways = new TreeSet<Integer>();
        TreeSet<Integer> columnsSometimes = new TreeSet<Integer>();
        TreeSet<Integer> lastColumns = new TreeSet<Integer>();
        for (Map.Entry<Interval, Double> ms : widths.multiSizes()) {
            Interval interval = ms.getKey();
            block5: for (int i2 = interval.begin; i2 < interval.end; ++i2) {
                if (!(this.columnPercentWidth[i2] < 0.0)) continue;
                switch (this.columnGrow[i2]) {
                    case ALWAYS: {
                        columnsAlways.add(i2);
                        continue block5;
                    }
                    case SOMETIMES: {
                        columnsSometimes.add(i2);
                    }
                }
            }
            if (!(this.columnPercentWidth[interval.end - 1] < 0.0)) continue;
            lastColumns.add(interval.end - 1);
        }
        double remaining = extraWidth;
        while (columnsAlways.size() > 0 && remaining > (double)columnsAlways.size()) {
            double colPortion = Math.floor(remaining / (double)columnsAlways.size());
            it = columnsAlways.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfColumn = this.getColumnMaxWidth(i);
                prefOfColumn = this.getColumnPrefWidth(i);
                actualPortion = colPortion;
                for (Map.Entry<Interval, Double> ms : widths.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (!interval.contains(i)) continue;
                    intervalColumns = 0;
                    for (int j = interval.begin; j < interval.end; ++j) {
                        if (!columnsAlways.contains(j)) continue;
                        ++intervalColumns;
                    }
                    curLength = widths.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.floor(Math.max(0.0, (ms.getValue() - curLength) / (double)intervalColumns)), actualPortion);
                }
                current = widths.getSize(i);
                bounded = maxOfColumn >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfColumn) : (maxOfColumn == Double.NEGATIVE_INFINITY && prefOfColumn > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfColumn) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                widths.setSize(i, bounded);
            }
        }
        while (columnsSometimes.size() > 0 && remaining > (double)columnsSometimes.size()) {
            double colPortion = Math.floor(remaining / (double)columnsSometimes.size());
            it = columnsSometimes.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfColumn = this.getColumnMaxWidth(i);
                prefOfColumn = this.getColumnPrefWidth(i);
                actualPortion = colPortion;
                for (Map.Entry<Interval, Double> ms : widths.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (!interval.contains(i)) continue;
                    intervalColumns = 0;
                    for (int j = interval.begin; j < interval.end; ++j) {
                        if (!columnsSometimes.contains(j)) continue;
                        ++intervalColumns;
                    }
                    curLength = widths.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.floor(Math.max(0.0, (ms.getValue() - curLength) / (double)intervalColumns)), actualPortion);
                }
                current = widths.getSize(i);
                bounded = maxOfColumn >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfColumn) : (maxOfColumn == Double.NEGATIVE_INFINITY && prefOfColumn > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfColumn) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                widths.setSize(i, bounded);
            }
        }
        while (lastColumns.size() > 0 && remaining > (double)lastColumns.size()) {
            double colPortion = Math.floor(remaining / (double)lastColumns.size());
            it = lastColumns.iterator();
            while (it.hasNext()) {
                i = (Integer)it.next();
                maxOfColumn = this.getColumnMaxWidth(i);
                prefOfColumn = this.getColumnPrefWidth(i);
                actualPortion = colPortion;
                for (Map.Entry<Interval, Double> ms : widths.multiSizes()) {
                    Interval interval = ms.getKey();
                    if (interval.end - 1 != i) continue;
                    double curLength2 = widths.computeTotal(interval.begin, interval.end);
                    actualPortion = Math.min(Math.max(0.0, ms.getValue() - curLength2), actualPortion);
                }
                current = widths.getSize(i);
                bounded = maxOfColumn >= 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, maxOfColumn) : (maxOfColumn == Double.NEGATIVE_INFINITY && prefOfColumn > 0.0 ? GridPane.boundedSize(0.0, current + actualPortion, prefOfColumn) : current + actualPortion);
                portionUsed = bounded - current;
                remaining -= portionUsed;
                if (portionUsed != actualPortion || portionUsed == 0.0) {
                    it.remove();
                }
                widths.setSize(i, bounded);
            }
        }
        return remaining;
    }

    private double growOrShrinkColumnWidths(CompositeSize widths, Priority priority, double extraWidth) {
        CompositeSize limitSize;
        boolean wasPositive;
        if (extraWidth == 0.0) {
            return 0.0;
        }
        boolean shrinking = extraWidth < 0.0;
        ArrayList<Integer> adjusting = new ArrayList<Integer>();
        for (int i = 0; i < this.columnGrow.length; ++i) {
            if (!(this.columnPercentWidth[i] < 0.0) || !shrinking && this.columnGrow[i] != priority) continue;
            adjusting.add(i);
        }
        double available = extraWidth;
        boolean handleRemainder = false;
        double portion = 0.0;
        boolean isPositive = wasPositive = available >= 0.0;
        CompositeSize compositeSize = limitSize = shrinking ? this.computeMinWidths(null) : this.computeMaxWidths();
        block1: while (available != 0.0 && wasPositive == isPositive && adjusting.size() > 0) {
            if (!handleRemainder) {
                double d = portion = available > 0.0 ? Math.floor(available / (double)adjusting.size()) : Math.ceil(available / (double)adjusting.size());
            }
            if (portion != 0.0) {
                Iterator i = adjusting.iterator();
                while (i.hasNext()) {
                    int index = (Integer)i.next();
                    double limit = this.snapSpaceX(limitSize.getProportionalMinOrMaxSize(index, shrinking)) - widths.getSize(index);
                    if (shrinking && limit > 0.0 || !shrinking && limit < 0.0) {
                        limit = 0.0;
                    }
                    double change = Math.abs(limit) <= Math.abs(portion) ? limit : portion;
                    widths.addSize(index, change);
                    boolean bl = isPositive = (available -= change) >= 0.0;
                    if (Math.abs(change) < Math.abs(portion)) {
                        i.remove();
                    }
                    if (available != 0.0) continue;
                    continue block1;
                }
                continue;
            }
            portion = (int)available % adjusting.size();
            if (portion == 0.0) break;
            portion = shrinking ? -1.0 : 1.0;
            handleRemainder = true;
        }
        return available;
    }

    private void layoutGridLines(CompositeSize columnWidths, CompositeSize rowHeights, double x, double y, double columnHeight, double rowWidth) {
        int i;
        if (!this.isGridLinesVisible()) {
            return;
        }
        if (!this.gridLines.getChildren().isEmpty()) {
            this.gridLines.getChildren().clear();
        }
        double hGap = this.snapSpaceX(this.getHgap());
        double vGap = this.snapSpaceY(this.getVgap());
        double linex = x;
        double liney = y;
        for (i = 0; i <= columnWidths.getLength(); ++i) {
            this.gridLines.getChildren().add((Object)this.createGridLine(linex, liney, linex, liney + columnHeight));
            if (i > 0 && i < columnWidths.getLength() && hGap != 0.0) {
                this.gridLines.getChildren().add((Object)this.createGridLine(linex += hGap, liney, linex, liney + columnHeight));
            }
            if (i >= columnWidths.getLength()) continue;
            linex += columnWidths.getSize(i);
        }
        linex = x;
        for (i = 0; i <= rowHeights.getLength(); ++i) {
            this.gridLines.getChildren().add((Object)this.createGridLine(linex, liney, linex + rowWidth, liney));
            if (i > 0 && i < rowHeights.getLength() && vGap != 0.0) {
                this.gridLines.getChildren().add((Object)this.createGridLine(linex, liney += vGap, linex + rowWidth, liney));
            }
            if (i >= rowHeights.getLength()) continue;
            liney += rowHeights.getSize(i);
        }
    }

    private Line createGridLine(double startX, double startY, double endX, double endY) {
        Line line = new Line();
        line.setStartX(startX);
        line.setStartY(startY);
        line.setEndX(endX);
        line.setEndY(endY);
        line.setStroke(GRID_LINE_COLOR);
        line.setStrokeDashOffset(3.0);
        return line;
    }

    @Override
    public String toString() {
        return "Grid hgap=" + this.getHgap() + ", vgap=" + this.getVgap() + ", alignment=" + this.getAlignment();
    }

    private CompositeSize createCompositeRows(double initSize) {
        return new CompositeSize(this.getNumberOfRows(), this.rowPercentHeight, this.rowPercentTotal, this.snapSpaceY(this.getVgap()), initSize);
    }

    private CompositeSize createCompositeColumns(double initSize) {
        return new CompositeSize(this.getNumberOfColumns(), this.columnPercentWidth, this.columnPercentTotal, this.snapSpaceX(this.getHgap()), initSize);
    }

    private int getNodeRowEndConvertRemaining(Node child) {
        int rowSpan = GridPane.getNodeRowSpan(child);
        return rowSpan != Integer.MAX_VALUE ? GridPane.getNodeRowIndex(child) + rowSpan - 1 : this.getNumberOfRows() - 1;
    }

    private int getNodeColumnEndConvertRemaining(Node child) {
        int columnSpan = GridPane.getNodeColumnSpan(child);
        return columnSpan != Integer.MAX_VALUE ? GridPane.getNodeColumnIndex(child) + columnSpan - 1 : this.getNumberOfColumns() - 1;
    }

    double[][] getGrid() {
        if (this.currentHeights == null || this.currentWidths == null) {
            return null;
        }
        return new double[][]{this.currentWidths.asArray(), this.currentHeights.asArray()};
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GridPane.getClassCssMetaData();
    }

    public final int getRowCount() {
        int nRows = this.getRowConstraints().size();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node child = (Node)this.getChildren().get(i);
            if (!child.isManaged()) continue;
            int rowIndex = GridPane.getNodeRowIndex(child);
            int rowEnd = GridPane.getNodeRowEnd(child);
            nRows = Math.max(nRows, (rowEnd != Integer.MAX_VALUE ? rowEnd : rowIndex) + 1);
        }
        return nRows;
    }

    public final int getColumnCount() {
        int nColumns = this.getColumnConstraints().size();
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node child = (Node)this.getChildren().get(i);
            if (!child.isManaged()) continue;
            int columnIndex = GridPane.getNodeColumnIndex(child);
            int columnEnd = GridPane.getNodeColumnEnd(child);
            nColumns = Math.max(nColumns, (columnEnd != Integer.MAX_VALUE ? columnEnd : columnIndex) + 1);
        }
        return nColumns;
    }

    public final Bounds getCellBounds(int columnIndex, int rowIndex) {
        double[] columnWidths;
        double[] rowHeights;
        double snaphgap = this.snapSpaceX(this.getHgap());
        double snapvgap = this.snapSpaceY(this.getVgap());
        double top = this.snapSpaceY(this.getInsets().getTop());
        double right = this.snapSpaceX(this.getInsets().getRight());
        double bottom = this.snapSpaceY(this.getInsets().getBottom());
        double left = this.snapSpaceX(this.getInsets().getLeft());
        double gridPaneHeight = this.snapSizeY(this.getHeight()) - (top + bottom);
        double gridPaneWidth = this.snapSizeX(this.getWidth()) - (left + right);
        double[][] grid = this.getGrid();
        if (grid == null) {
            rowHeights = new double[]{0.0};
            rowIndex = 0;
            columnWidths = new double[]{0.0};
            columnIndex = 0;
        } else {
            columnWidths = grid[0];
            rowHeights = grid[1];
        }
        double rowTotal = 0.0;
        for (int i = 0; i < rowHeights.length; ++i) {
            rowTotal += rowHeights[i];
        }
        double minY = top + Region.computeYOffset(gridPaneHeight, rowTotal += (double)(rowHeights.length - 1) * snapvgap, this.getAlignment().getVpos());
        double height = rowHeights[rowIndex];
        for (int j = 0; j < rowIndex; ++j) {
            minY += rowHeights[j] + snapvgap;
        }
        double columnTotal = 0.0;
        for (int i = 0; i < columnWidths.length; ++i) {
            columnTotal += columnWidths[i];
        }
        double minX = left + Region.computeXOffset(gridPaneWidth, columnTotal += (double)(columnWidths.length - 1) * snaphgap, this.getAlignment().getHpos());
        double width = columnWidths[columnIndex];
        for (int j = 0; j < columnIndex; ++j) {
            minX += columnWidths[j] + snaphgap;
        }
        return new BoundingBox(minX, minY, width, height);
    }

    private static final class CompositeSize
    implements Cloneable {
        double[] singleSizes;
        private SortedMap<Interval, Double> multiSizes;
        private BitSet preset;
        private final double[] fixedPercent;
        private final double totalFixedPercent;
        private final double gap;

        public CompositeSize(int capacity, double[] fixedPercent, double totalFixedPercent, double gap, double initSize) {
            this.singleSizes = new double[capacity];
            Arrays.fill(this.singleSizes, initSize);
            this.fixedPercent = fixedPercent;
            this.totalFixedPercent = totalFixedPercent;
            this.gap = gap;
        }

        private void setSize(int position, double size) {
            this.singleSizes[position] = size;
        }

        private void setPresetSize(int position, double size) {
            this.setSize(position, size);
            if (this.preset == null) {
                this.preset = new BitSet(this.singleSizes.length);
            }
            this.preset.set(position);
        }

        private boolean isPreset(int position) {
            if (this.preset == null) {
                return false;
            }
            return this.preset.get(position);
        }

        private void addSize(int position, double change) {
            this.singleSizes[position] = this.singleSizes[position] + change;
        }

        private double getSize(int position) {
            return this.singleSizes[position];
        }

        private void setMaxSize(int position, double size) {
            this.singleSizes[position] = Math.max(this.singleSizes[position], size);
        }

        private void setMultiSize(int startPosition, int endPosition, double size) {
            if (this.multiSizes == null) {
                this.multiSizes = new TreeMap<Interval, Double>();
            }
            Interval i = new Interval(startPosition, endPosition);
            this.multiSizes.put(i, size);
        }

        private Iterable<Map.Entry<Interval, Double>> multiSizes() {
            if (this.multiSizes == null) {
                return Collections.EMPTY_LIST;
            }
            return this.multiSizes.entrySet();
        }

        private void setMaxMultiSize(int startPosition, int endPosition, double size) {
            Interval i;
            Double sz;
            if (this.multiSizes == null) {
                this.multiSizes = new TreeMap<Interval, Double>();
            }
            if ((sz = (Double)this.multiSizes.get(i = new Interval(startPosition, endPosition))) == null) {
                this.multiSizes.put(i, size);
            } else {
                this.multiSizes.put(i, Math.max(size, sz));
            }
        }

        private double getProportionalMinOrMaxSize(int position, boolean min) {
            double result = this.singleSizes[position];
            if (!this.isPreset(position) && this.multiSizes != null) {
                for (Interval i : this.multiSizes.keySet()) {
                    double segment;
                    if (!i.contains(position)) continue;
                    double propSize = segment = (Double)this.multiSizes.get(i) / (double)i.size();
                    for (int j = i.begin; j < i.end; ++j) {
                        if (j == position || !(min ? this.singleSizes[j] > segment : this.singleSizes[j] < segment)) continue;
                        propSize += segment - this.singleSizes[j];
                    }
                    result = min ? Math.max(result, propSize) : Math.min(result, propSize);
                }
            }
            return result;
        }

        private double computeTotal(int from, int to) {
            double total = this.gap * (double)(to - from - 1);
            for (int i = from; i < to; ++i) {
                total += this.singleSizes[i];
            }
            return total;
        }

        private double computeTotal() {
            return this.computeTotal(0, this.singleSizes.length);
        }

        private boolean allPreset(int begin, int end) {
            if (this.preset == null) {
                return false;
            }
            for (int i = begin; i < end; ++i) {
                if (this.preset.get(i)) continue;
                return false;
            }
            return true;
        }

        private double computeTotalWithMultiSize() {
            double total = this.computeTotal();
            if (this.multiSizes != null) {
                for (Map.Entry<Interval, Double> e : this.multiSizes.entrySet()) {
                    Interval i = e.getKey();
                    if (this.allPreset(i.begin, i.end)) continue;
                    double subTotal = this.computeTotal(i.begin, i.end);
                    if (!(e.getValue() > subTotal)) continue;
                    total += e.getValue() - subTotal;
                }
            }
            if (this.totalFixedPercent > 0.0) {
                int i;
                double totalNotFixed = 0.0;
                for (i = 0; i < this.fixedPercent.length; ++i) {
                    if (this.fixedPercent[i] != 0.0) continue;
                    total -= this.singleSizes[i];
                }
                for (i = 0; i < this.fixedPercent.length; ++i) {
                    if (this.fixedPercent[i] > 0.0) {
                        total = Math.max(total, this.singleSizes[i] * (100.0 / this.fixedPercent[i]));
                        continue;
                    }
                    if (!(this.fixedPercent[i] < 0.0)) continue;
                    totalNotFixed += this.singleSizes[i];
                }
                if (this.totalFixedPercent < 100.0) {
                    total = Math.max(total, totalNotFixed * 100.0 / (100.0 - this.totalFixedPercent));
                }
            }
            return total;
        }

        private int getLength() {
            return this.singleSizes.length;
        }

        protected Object clone() {
            try {
                CompositeSize clone = (CompositeSize)super.clone();
                clone.singleSizes = (double[])clone.singleSizes.clone();
                if (this.multiSizes != null) {
                    clone.multiSizes = new TreeMap<Interval, Double>(clone.multiSizes);
                }
                return clone;
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        private double[] asArray() {
            return this.singleSizes;
        }
    }

    private static final class Interval
    implements Comparable<Interval> {
        public final int begin;
        public final int end;

        public Interval(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public int compareTo(Interval o) {
            return this.begin != o.begin ? this.begin - o.begin : this.end - o.end;
        }

        private boolean contains(int position) {
            return this.begin <= position && position < this.end;
        }

        private int size() {
            return this.end - this.begin;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<GridPane, Boolean> GRID_LINES_VISIBLE = new CssMetaData<GridPane, Boolean>("-fx-grid-lines-visible", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(GridPane node) {
                return node.gridLinesVisible == null || !node.gridLinesVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(GridPane node) {
                return (StyleableProperty)node.gridLinesVisibleProperty();
            }
        };
        private static final CssMetaData<GridPane, Number> HGAP = new CssMetaData<GridPane, Number>("-fx-hgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(GridPane node) {
                return node.hgap == null || !node.hgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(GridPane node) {
                return (StyleableProperty)node.hgapProperty();
            }
        };
        private static final CssMetaData<GridPane, Pos> ALIGNMENT = new CssMetaData<GridPane, Pos>("-fx-alignment", new EnumConverter<Pos>(Pos.class), Pos.TOP_LEFT){

            @Override
            public boolean isSettable(GridPane node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            @Override
            public StyleableProperty<Pos> getStyleableProperty(GridPane node) {
                return (StyleableProperty)node.alignmentProperty();
            }
        };
        private static final CssMetaData<GridPane, Number> VGAP = new CssMetaData<GridPane, Number>("-fx-vgap", SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(GridPane node) {
                return node.vgap == null || !node.vgap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(GridPane node) {
                return (StyleableProperty)node.vgapProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(GRID_LINES_VISIBLE);
            styleables.add(HGAP);
            styleables.add(ALIGNMENT);
            styleables.add(VGAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

