/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.security.AccessController;
import java.util.Locale;

final class Platform {
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Win";
    public static final String GTK = "Gtk";
    public static final String IOS = "Ios";
    public static final String UNKNOWN = "unknown";
    private static String type = null;

    Platform() {
    }

    public static synchronized String determinePlatform() {
        if (type == null) {
            String userPlatform = AccessController.doPrivileged(() -> System.getProperty("glass.platform"));
            if (userPlatform != null) {
                type = userPlatform.equals("macosx") ? MAC : (userPlatform.equals("windows") ? WINDOWS : (userPlatform.equals("linux") ? GTK : (userPlatform.equals("gtk") ? GTK : (userPlatform.equals("ios") ? IOS : userPlatform))));
                return type;
            }
            String osName = System.getProperty("os.name");
            String osNameLowerCase = osName.toLowerCase(Locale.ROOT);
            if (osNameLowerCase.startsWith("mac") || osNameLowerCase.startsWith("darwin")) {
                type = MAC;
            } else if (osNameLowerCase.startsWith("wind")) {
                type = WINDOWS;
            } else if (osNameLowerCase.startsWith("linux")) {
                type = GTK;
            } else if (osNameLowerCase.startsWith("ios")) {
                type = IOS;
            }
        }
        return type;
    }
}

