/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Screen {
    private static volatile List<Screen> screens = null;
    private static final int dpiOverride = AccessController.doPrivileged(() -> Integer.getInteger("com.sun.javafx.screenDPI", 0));
    private static EventHandler eventHandler;
    private volatile long ptr;
    private volatile int adapter;
    private final int depth;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int platformX;
    private final int platformY;
    private final int platformWidth;
    private final int platformHeight;
    private final int visibleX;
    private final int visibleY;
    private final int visibleWidth;
    private final int visibleHeight;
    private final int resolutionX;
    private final int resolutionY;
    private final float platformScaleX;
    private final float platformScaleY;
    private final float outputScaleX;
    private final float outputScaleY;

    public static double getVideoRefreshPeriod() {
        Application.checkEventThread();
        return Application.GetApplication().staticScreen_getVideoRefreshPeriod();
    }

    public static Screen getMainScreen() {
        return Screen.getScreens().get(0);
    }

    public static List<Screen> getScreens() {
        if (screens == null) {
            throw new RuntimeException("Internal graphics not initialized yet");
        }
        return screens;
    }

    public Screen(long nativePtr, int depth, int x, int y, int width, int height, int platformX, int platformY, int platformWidth, int platformHeight, int visibleX, int visibleY, int visibleWidth, int visibleHeight, int resolutionX, int resolutionY, float platformScaleX, float platformScaleY, float outputScaleX, float outputScaleY) {
        this.ptr = nativePtr;
        this.depth = depth;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.platformX = platformX;
        this.platformY = platformY;
        this.platformWidth = platformWidth;
        this.platformHeight = platformHeight;
        this.visibleX = visibleX;
        this.visibleY = visibleY;
        this.visibleWidth = visibleWidth;
        this.visibleHeight = visibleHeight;
        if (dpiOverride > 0) {
            this.resolutionX = this.resolutionY = dpiOverride;
        } else {
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
        }
        this.platformScaleX = platformScaleX;
        this.platformScaleY = platformScaleY;
        this.outputScaleX = outputScaleX;
        this.outputScaleY = outputScaleY;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPlatformX() {
        return this.platformX;
    }

    public int getPlatformY() {
        return this.platformY;
    }

    public int getPlatformWidth() {
        return this.platformWidth;
    }

    public int getPlatformHeight() {
        return this.platformHeight;
    }

    public float fromPlatformX(int px) {
        return (float)this.x + (float)(px - this.platformX) / this.platformScaleX;
    }

    public float fromPlatformY(int py) {
        return (float)this.y + (float)(py - this.platformY) / this.platformScaleY;
    }

    public int toPlatformX(float ux) {
        return this.platformX + Math.round((ux - (float)this.x) * this.platformScaleX);
    }

    public int toPlatformY(float uy) {
        return this.platformY + Math.round((uy - (float)this.y) * this.platformScaleY);
    }

    public float portionIntersectsPlatformRect(int x, int y, int w, int h) {
        int x0 = Math.max(x, this.platformX);
        int y0 = Math.max(y, this.platformY);
        int x1 = Math.min(x + w, this.platformX + this.platformWidth);
        int y1 = Math.min(y + h, this.platformY + this.platformHeight);
        if ((x1 -= x0) <= 0) {
            return 0.0f;
        }
        if ((y1 -= y0) <= 0) {
            return 0.0f;
        }
        float ret = x1 * y1;
        return ret / (float)w / (float)h;
    }

    public boolean containsPlatformRect(int x, int y, int w, int h) {
        if (!this.containsPlatformCoords(x, y)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return true;
        }
        return x + w <= this.platformX + this.platformWidth && y + h <= this.platformY + this.platformHeight;
    }

    public boolean containsPlatformCoords(int x, int y) {
        return (x -= this.platformX) >= 0 && x < this.platformWidth && (y -= this.platformY) >= 0 && y < this.platformHeight;
    }

    public float getPlatformScaleX() {
        return this.platformScaleX;
    }

    public float getPlatformScaleY() {
        return this.platformScaleY;
    }

    public float getRecommendedOutputScaleX() {
        return this.outputScaleX;
    }

    public float getRecommendedOutputScaleY() {
        return this.outputScaleY;
    }

    public int getVisibleX() {
        return this.visibleX;
    }

    public int getVisibleY() {
        return this.visibleY;
    }

    public int getVisibleWidth() {
        return this.visibleWidth;
    }

    public int getVisibleHeight() {
        return this.visibleHeight;
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public long getNativeScreen() {
        return this.ptr;
    }

    private void dispose() {
        this.ptr = 0L;
    }

    public int getAdapterOrdinal() {
        return this.adapter;
    }

    public void setAdapterOrdinal(int adapter) {
        this.adapter = adapter;
    }

    public static void setEventHandler(EventHandler eh) {
        Application.checkEventThread();
        eventHandler = eh;
    }

    public static void notifySettingsChanged() {
        List<Screen> oldScreens = screens;
        Screen.initScreens();
        if (eventHandler != null) {
            eventHandler.handleSettingsChanged();
        }
        List<Window> windows = Window.getWindows();
        block0: for (Window w : windows) {
            Screen oldScreen = w.getScreen();
            for (Screen newScreen : screens) {
                if (oldScreen.getNativeScreen() != newScreen.getNativeScreen()) continue;
                w.setScreen(newScreen);
                continue block0;
            }
        }
        if (oldScreens != null) {
            for (Screen screen : oldScreens) {
                screen.dispose();
            }
        }
    }

    static void initScreens() {
        Application.checkEventThread();
        Screen[] newScreens = Application.GetApplication().staticScreen_getScreens();
        if (newScreens == null) {
            throw new RuntimeException("Internal graphics failed to initialize");
        }
        screens = Collections.unmodifiableList(Arrays.asList(newScreens));
    }

    public String toString() {
        return "Screen:\n    ptr:" + this.getNativeScreen() + "\n    adapter:" + this.getAdapterOrdinal() + "\n    depth:" + this.getDepth() + "\n    x:" + this.getX() + "\n    y:" + this.getY() + "\n    width:" + this.getWidth() + "\n    height:" + this.getHeight() + "\n    platformX:" + this.getPlatformX() + "\n    platformY:" + this.getPlatformY() + "\n    platformWidth:" + this.getPlatformWidth() + "\n    platformHeight:" + this.getPlatformHeight() + "\n    visibleX:" + this.getVisibleX() + "\n    visibleY:" + this.getVisibleY() + "\n    visibleWidth:" + this.getVisibleWidth() + "\n    visibleHeight:" + this.getVisibleHeight() + "\n    platformScaleX:" + this.getPlatformScaleX() + "\n    platformScaleY:" + this.getPlatformScaleY() + "\n    outputScaleX:" + this.getRecommendedOutputScaleX() + "\n    outputScaleY:" + this.getRecommendedOutputScaleY() + "\n    resolutionX:" + this.getResolutionX() + "\n    resolutionY:" + this.getResolutionY() + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Screen screen = (Screen)o;
        return this.ptr == screen.ptr && this.adapter == screen.adapter && this.depth == screen.depth && this.x == screen.x && this.y == screen.y && this.width == screen.width && this.height == screen.height && this.visibleX == screen.visibleX && this.visibleY == screen.visibleY && this.visibleWidth == screen.visibleWidth && this.visibleHeight == screen.visibleHeight && this.resolutionX == screen.resolutionX && this.resolutionY == screen.resolutionY && Float.compare(screen.platformScaleX, this.platformScaleX) == 0 && Float.compare(screen.platformScaleY, this.platformScaleY) == 0 && Float.compare(screen.outputScaleX, this.outputScaleX) == 0 && Float.compare(screen.outputScaleY, this.outputScaleY) == 0;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.ptr ^ this.ptr >>> 32);
        result = 31 * result + this.adapter;
        result = 31 * result + this.depth;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.visibleX;
        result = 31 * result + this.visibleY;
        result = 31 * result + this.visibleWidth;
        result = 31 * result + this.visibleHeight;
        result = 31 * result + this.resolutionX;
        result = 31 * result + this.resolutionY;
        result = 31 * result + (this.platformScaleX != 0.0f ? Float.floatToIntBits(this.platformScaleX) : 0);
        result = 31 * result + (this.platformScaleY != 0.0f ? Float.floatToIntBits(this.platformScaleY) : 0);
        result = 31 * result + (this.outputScaleX != 0.0f ? Float.floatToIntBits(this.outputScaleX) : 0);
        result = 31 * result + (this.outputScaleY != 0.0f ? Float.floatToIntBits(this.outputScaleY) : 0);
        return result;
    }

    public static class EventHandler {
        public void handleSettingsChanged() {
        }
    }
}

