/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Platform;
import com.sun.glass.ui.Window;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Map;

public abstract class View {
    public static final int GESTURE_NO_VALUE = Integer.MAX_VALUE;
    public static final double GESTURE_NO_DOUBLE_VALUE = Double.NaN;
    public static final byte IME_ATTR_INPUT = 0;
    public static final byte IME_ATTR_TARGET_CONVERTED = 1;
    public static final byte IME_ATTR_CONVERTED = 2;
    public static final byte IME_ATTR_TARGET_NOTCONVERTED = 3;
    public static final byte IME_ATTR_INPUT_ERROR = 4;
    static final boolean accessible = AccessController.doPrivileged(() -> {
        String force = System.getProperty("glass.accessible.force");
        if (force != null) {
            return Boolean.parseBoolean(force);
        }
        try {
            String platform = Platform.determinePlatform();
            String major = System.getProperty("os.version").replaceFirst("(\\d+)\\.\\d+.*", "$1");
            String minor = System.getProperty("os.version").replaceFirst("\\d+\\.(\\d+).*", "$1");
            int v = Integer.parseInt(major) * 100 + Integer.parseInt(minor);
            return platform.equals("Mac") && v >= 1009 || platform.equals("Win") && v >= 601;
        }
        catch (Exception e) {
            return false;
        }
    });
    private volatile long ptr;
    private Window window;
    private EventHandler eventHandler;
    private int width = -1;
    private int height = -1;
    private boolean isValid = false;
    private boolean isVisible = false;
    private boolean inFullscreen = false;
    private static WeakReference<View> lastClickedView = null;
    private static int lastClickedButton;
    private static long lastClickedTime;
    private static int lastClickedX;
    private static int lastClickedY;
    private static int clickCount;
    private static boolean dragProcessed;
    private ClipboardAssistance dropSourceAssistant;
    ClipboardAssistance dropTargetAssistant;

    public static long getMultiClickTime() {
        Application.checkEventThread();
        return Application.GetApplication().staticView_getMultiClickTime();
    }

    public static int getMultiClickMaxX() {
        Application.checkEventThread();
        return Application.GetApplication().staticView_getMultiClickMaxX();
    }

    public static int getMultiClickMaxY() {
        Application.checkEventThread();
        return Application.GetApplication().staticView_getMultiClickMaxY();
    }

    protected abstract void _enableInputMethodEvents(long var1, boolean var3);

    protected void _finishInputMethodComposition(long ptr) {
    }

    protected abstract long _create(Map var1);

    protected View() {
        Application.checkEventThread();
        Application.GetApplication();
        this.ptr = this._create(Application.getDeviceDetails());
        if (this.ptr == 0L) {
            throw new RuntimeException("could not create platform view");
        }
    }

    private void checkNotClosed() {
        if (this.ptr == 0L) {
            throw new IllegalStateException("The view has already been closed");
        }
    }

    public boolean isClosed() {
        Application.checkEventThread();
        return this.ptr == 0L;
    }

    protected abstract long _getNativeView(long var1);

    public long getNativeView() {
        Application.checkEventThread();
        this.checkNotClosed();
        return this._getNativeView(this.ptr);
    }

    public Window getWindow() {
        Application.checkEventThread();
        return this.window;
    }

    protected abstract int _getX(long var1);

    public int getX() {
        Application.checkEventThread();
        this.checkNotClosed();
        return this._getX(this.ptr);
    }

    protected abstract int _getY(long var1);

    public int getY() {
        Application.checkEventThread();
        this.checkNotClosed();
        return this._getY(this.ptr);
    }

    public int getWidth() {
        Application.checkEventThread();
        return this.width;
    }

    public int getHeight() {
        Application.checkEventThread();
        return this.height;
    }

    protected abstract void _setParent(long var1, long var3);

    void setWindow(Window window) {
        Application.checkEventThread();
        this.checkNotClosed();
        this.window = window;
        this._setParent(this.ptr, window == null ? 0L : window.getNativeHandle());
        this.isValid = this.ptr != 0L && window != null;
    }

    void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    protected abstract boolean _close(long var1);

    public void close() {
        Window host;
        Application.checkEventThread();
        if (this.ptr == 0L) {
            return;
        }
        if (this.isInFullscreen()) {
            this._exitFullscreen(this.ptr, false);
        }
        if ((host = this.getWindow()) != null) {
            host.setView(null);
        }
        this.isValid = false;
        this._close(this.ptr);
        this.ptr = 0L;
    }

    public EventHandler getEventHandler() {
        Application.checkEventThread();
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        Application.checkEventThread();
        this.eventHandler = eventHandler;
    }

    private void handleViewEvent(long time, int type) {
        if (this.eventHandler != null) {
            this.eventHandler.handleViewEvent(this, time, type);
        }
    }

    private void handleKeyEvent(long time, int action, int keyCode, char[] keyChars, int modifiers) {
        if (this.eventHandler != null) {
            this.eventHandler.handleKeyEvent(this, time, action, keyCode, keyChars, modifiers);
        }
    }

    private void handleMouseEvent(long time, int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        if (this.eventHandler != null) {
            this.eventHandler.handleMouseEvent(this, time, type, button, x, y, xAbs, yAbs, modifiers, isPopupTrigger, isSynthesized);
        }
    }

    private void handleMenuEvent(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        if (this.eventHandler != null) {
            this.eventHandler.handleMenuEvent(this, x, y, xAbs, yAbs, isKeyboardTrigger);
        }
    }

    public void handleBeginTouchEvent(View view, long time, int modifiers, boolean isDirect, int touchEventCount) {
        if (this.eventHandler != null) {
            this.eventHandler.handleBeginTouchEvent(view, time, modifiers, isDirect, touchEventCount);
        }
    }

    public void handleNextTouchEvent(View view, long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        if (this.eventHandler != null) {
            this.eventHandler.handleNextTouchEvent(view, time, type, touchId, x, y, xAbs, yAbs);
        }
    }

    public void handleEndTouchEvent(View view, long time) {
        if (this.eventHandler != null) {
            this.eventHandler.handleEndTouchEvent(view, time);
        }
    }

    public void handleScrollGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double totaldx, double totaldy, double multiplierX, double multiplierY) {
        if (this.eventHandler != null) {
            this.eventHandler.handleScrollGestureEvent(view, time, type, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy, totaldx, totaldy, multiplierX, multiplierY);
        }
    }

    public void handleZoomGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double scale, double expansion, double totalscale, double totalexpansion) {
        if (this.eventHandler != null) {
            this.eventHandler.handleZoomGestureEvent(view, time, type, modifiers, isDirect, isInertia, originx, originy, originxAbs, originyAbs, scale, expansion, totalscale, totalexpansion);
        }
    }

    public void handleRotateGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double dangle, double totalangle) {
        if (this.eventHandler != null) {
            this.eventHandler.handleRotateGestureEvent(view, time, type, modifiers, isDirect, isInertia, originx, originy, originxAbs, originyAbs, dangle, totalangle);
        }
    }

    public void handleSwipeGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int originx, int originy, int originxAbs, int originyAbs) {
        if (this.eventHandler != null) {
            this.eventHandler.handleSwipeGestureEvent(view, time, type, modifiers, isDirect, isInertia, touchCount, dir, originx, originy, originxAbs, originyAbs);
        }
    }

    private void handleInputMethodEvent(long time, String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int commitCount, int cursorPos) {
        if (this.eventHandler != null) {
            this.eventHandler.handleInputMethodEvent(time, text, clauseBoundary, attrBoundary, attrValue, commitCount, cursorPos);
        }
    }

    public void enableInputMethodEvents(boolean enable) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._enableInputMethodEvents(this.ptr, enable);
    }

    public void finishInputMethodComposition() {
        Application.checkEventThread();
        this.checkNotClosed();
        this._finishInputMethodComposition(this.ptr);
    }

    private double[] getInputMethodCandidatePos(int offset) {
        if (this.eventHandler != null) {
            return this.eventHandler.getInputMethodCandidatePos(offset);
        }
        return null;
    }

    private void handleDragStart(int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance dropSourceAssistant) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragStart(this, button, x, y, xAbs, yAbs, dropSourceAssistant);
        }
    }

    private void handleDragEnd(int performedAction) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragEnd(this, performedAction);
        }
    }

    private int handleDragEnter(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragEnter(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return recommendedDropAction;
    }

    private int handleDragOver(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragOver(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return recommendedDropAction;
    }

    private void handleDragLeave(ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            this.eventHandler.handleDragLeave(this, dropTargetAssistant);
        }
    }

    private int handleDragDrop(int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
        if (this.eventHandler != null) {
            return this.eventHandler.handleDragDrop(this, x, y, xAbs, yAbs, recommendedDropAction, dropTargetAssistant);
        }
        return 0;
    }

    protected abstract void _scheduleRepaint(long var1);

    public void scheduleRepaint() {
        Application.checkEventThread();
        this.checkNotClosed();
        this._scheduleRepaint(this.ptr);
    }

    protected abstract void _begin(long var1);

    public void lock() {
        this.checkNotClosed();
        this._begin(this.ptr);
    }

    protected abstract void _end(long var1);

    public void unlock() {
        this.checkNotClosed();
        this._end(this.ptr);
    }

    protected abstract int _getNativeFrameBuffer(long var1);

    public int getNativeFrameBuffer() {
        return this._getNativeFrameBuffer(this.ptr);
    }

    protected abstract void _uploadPixels(long var1, Pixels var3);

    public void uploadPixels(Pixels pixels) {
        Application.checkEventThread();
        this.checkNotClosed();
        this.lock();
        try {
            this._uploadPixels(this.ptr, pixels);
        }
        finally {
            this.unlock();
        }
    }

    protected abstract boolean _enterFullscreen(long var1, boolean var3, boolean var4, boolean var5);

    public boolean enterFullscreen(boolean animate, boolean keepRatio, boolean hideCursor) {
        Application.checkEventThread();
        this.checkNotClosed();
        return this._enterFullscreen(this.ptr, animate, keepRatio, hideCursor);
    }

    protected abstract void _exitFullscreen(long var1, boolean var3);

    public void exitFullscreen(boolean animate) {
        Application.checkEventThread();
        this.checkNotClosed();
        this._exitFullscreen(this.ptr, animate);
    }

    public boolean isInFullscreen() {
        Application.checkEventThread();
        return this.inFullscreen;
    }

    public boolean toggleFullscreen(boolean animate, boolean keepRatio, boolean hideCursor) {
        Application.checkEventThread();
        this.checkNotClosed();
        if (!this.inFullscreen) {
            this.enterFullscreen(animate, keepRatio, hideCursor);
        } else {
            this.exitFullscreen(animate);
        }
        this._scheduleRepaint(this.ptr);
        return this.inFullscreen;
    }

    public void updateLocation() {
        this.notifyView(423);
    }

    protected void notifyView(int type) {
        if (type == 421) {
            if (this.isValid) {
                this.handleViewEvent(System.nanoTime(), type);
            }
        } else {
            boolean synthesizeMOVE = false;
            switch (type) {
                case 412: {
                    this.isValid = false;
                    synthesizeMOVE = true;
                    break;
                }
                case 411: {
                    this.isValid = true;
                    synthesizeMOVE = true;
                    break;
                }
                case 431: {
                    this.inFullscreen = true;
                    synthesizeMOVE = true;
                    if (this.getWindow() == null) break;
                    this.getWindow().notifyFullscreen(true);
                    break;
                }
                case 432: {
                    this.inFullscreen = false;
                    synthesizeMOVE = true;
                    if (this.getWindow() == null) break;
                    this.getWindow().notifyFullscreen(false);
                    break;
                }
                case 422: 
                case 423: {
                    break;
                }
                default: {
                    System.err.println("Unknown view event type: " + type);
                    return;
                }
            }
            this.handleViewEvent(System.nanoTime(), type);
            if (synthesizeMOVE) {
                this.handleViewEvent(System.nanoTime(), 423);
            }
        }
    }

    protected void notifyResize(int width, int height) {
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.handleViewEvent(System.nanoTime(), 422);
    }

    protected void notifyRepaint(int x, int y, int width, int height) {
        this.notifyView(421);
    }

    protected void notifyMenu(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        this.handleMenuEvent(x, y, xAbs, yAbs, isKeyboardTrigger);
    }

    protected void notifyMouse(int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        if (this.window != null && this.window.handleMouseEvent(type, button, x, y, xAbs, yAbs)) {
            return;
        }
        long now = System.nanoTime();
        if (type == 221) {
            View lastClickedView;
            View view = lastClickedView = View.lastClickedView == null ? null : (View)View.lastClickedView.get();
            if (lastClickedView == this && lastClickedButton == button && now - lastClickedTime <= 1000000L * View.getMultiClickTime() && Math.abs(x - lastClickedX) <= View.getMultiClickMaxX() && Math.abs(y - lastClickedY) <= View.getMultiClickMaxY()) {
                ++clickCount;
            } else {
                clickCount = 1;
                View.lastClickedView = new WeakReference<View>(this);
                lastClickedButton = button;
                lastClickedX = x;
                lastClickedY = y;
            }
            lastClickedTime = now;
        }
        this.handleMouseEvent(now, type, button, x, y, xAbs, yAbs, modifiers, isPopupTrigger, isSynthesized);
        if (type == 223) {
            if (!dragProcessed) {
                this.notifyDragStart(button, x, y, xAbs, yAbs);
                dragProcessed = true;
            }
        } else {
            dragProcessed = false;
        }
    }

    protected void notifyScroll(int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        if (this.eventHandler != null) {
            this.eventHandler.handleScrollEvent(this, System.nanoTime(), x, y, xAbs, yAbs, deltaX, deltaY, modifiers, lines, chars, defaultLines, defaultChars, xMultiplier, yMultiplier);
        }
    }

    protected void notifyKey(int type, int keyCode, char[] keyChars, int modifiers) {
        this.handleKeyEvent(System.nanoTime(), type, keyCode, keyChars, modifiers);
    }

    protected void notifyInputMethod(String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int committedTextLength, int caretPos, int visiblePos) {
        this.handleInputMethodEvent(System.nanoTime(), text, clauseBoundary, attrBoundary, attrValue, committedTextLength, caretPos);
    }

    protected double[] notifyInputMethodCandidatePosRequest(int offset) {
        double[] ret = this.getInputMethodCandidatePos(offset);
        if (ret == null) {
            ret = new double[]{0.0, 0.0};
        }
        return ret;
    }

    protected void notifyDragStart(int button, int x, int y, int xAbs, int yAbs) {
        this.dropSourceAssistant = new ClipboardAssistance("DND"){

            @Override
            public void actionPerformed(int performedAction) {
                View.this.notifyDragEnd(performedAction);
            }
        };
        this.handleDragStart(button, x, y, xAbs, yAbs, this.dropSourceAssistant);
        if (this.dropSourceAssistant != null) {
            this.dropSourceAssistant.close();
            this.dropSourceAssistant = null;
        }
    }

    protected void notifyDragEnd(int performedAction) {
        this.handleDragEnd(performedAction);
        if (this.dropSourceAssistant != null) {
            this.dropSourceAssistant.close();
            this.dropSourceAssistant = null;
        }
    }

    protected int notifyDragEnter(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        this.dropTargetAssistant = new ClipboardAssistance("DND"){

            @Override
            public void flush() {
                throw new UnsupportedOperationException("Flush is forbidden from target!");
            }
        };
        return this.handleDragEnter(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
    }

    protected int notifyDragOver(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        return this.handleDragOver(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
    }

    protected void notifyDragLeave() {
        this.handleDragLeave(this.dropTargetAssistant);
        this.dropTargetAssistant.close();
    }

    protected int notifyDragDrop(int x, int y, int xAbs, int yAbs, int recommendedDropAction) {
        int performedAction = this.handleDragDrop(x, y, xAbs, yAbs, recommendedDropAction, this.dropTargetAssistant);
        this.dropTargetAssistant.close();
        return performedAction;
    }

    public void notifyBeginTouchEvent(int modifiers, boolean isDirect, int touchEventCount) {
        this.handleBeginTouchEvent(this, System.nanoTime(), modifiers, isDirect, touchEventCount);
    }

    public void notifyNextTouchEvent(int type, long touchId, int x, int y, int xAbs, int yAbs) {
        this.handleNextTouchEvent(this, System.nanoTime(), type, touchId, x, y, xAbs, yAbs);
    }

    public void notifyEndTouchEvent() {
        this.handleEndTouchEvent(this, System.nanoTime());
    }

    public void notifyScrollGestureEvent(int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double totaldx, double totaldy, double multiplierX, double multiplierY) {
        this.handleScrollGestureEvent(this, System.nanoTime(), type, modifiers, isDirect, isInertia, touchCount, x, y, xAbs, yAbs, dx, dy, totaldx, totaldy, multiplierX, multiplierY);
    }

    public void notifyZoomGestureEvent(int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double scale, double expansion, double totalscale, double totalexpansion) {
        this.handleZoomGestureEvent(this, System.nanoTime(), type, modifiers, isDirect, isInertia, originx, originy, originxAbs, originyAbs, scale, expansion, totalscale, totalexpansion);
    }

    public void notifyRotateGestureEvent(int type, int modifiers, boolean isDirect, boolean isInertia, int originx, int originy, int originxAbs, int originyAbs, double dangle, double totalangle) {
        this.handleRotateGestureEvent(this, System.nanoTime(), type, modifiers, isDirect, isInertia, originx, originy, originxAbs, originyAbs, dangle, totalangle);
    }

    public void notifySwipeGestureEvent(int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int originx, int originy, int originxAbs, int originyAbs) {
        this.handleSwipeGestureEvent(this, System.nanoTime(), type, modifiers, isDirect, isInertia, touchCount, dir, originx, originy, originxAbs, originyAbs);
    }

    long getAccessible() {
        Accessible acc;
        Application.checkEventThread();
        this.checkNotClosed();
        if (accessible && (acc = this.eventHandler.getSceneAccessible()) != null) {
            acc.setView(this);
            return acc.getNativeAccessible();
        }
        return 0L;
    }

    static {
        dragProcessed = false;
    }

    public static final class Capability {
        public static final int k3dKeyValue = 0;
        public static final int kSyncKeyValue = 1;
        public static final int k3dProjectionKeyValue = 2;
        public static final int k3dProjectionAngleKeyValue = 3;
        public static final int k3dDepthKeyValue = 4;
        public static final int kHiDPIAwareKeyValue = 5;
        public static final Object k3dKey = 0;
        public static final Object kSyncKey = 1;
        public static final Object k3dProjectionKey = 2;
        public static final Object k3dProjectionAngleKey = 3;
        public static final Object k3dDepthKey = 4;
        public static final Object kHiDPIAwareKey = 5;
    }

    public static class EventHandler {
        public void handleViewEvent(View view, long time, int type) {
        }

        public void handleKeyEvent(View view, long time, int action, int keyCode, char[] keyChars, int modifiers) {
        }

        public void handleMenuEvent(View view, int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        }

        public void handleMouseEvent(View view, long time, int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        }

        public void handleScrollEvent(View view, long time, int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        }

        public void handleInputMethodEvent(long time, String text, int[] clauseBoundary, int[] attrBoundary, byte[] attrValue, int commitCount, int cursorPos) {
        }

        public double[] getInputMethodCandidatePos(int offset) {
            return null;
        }

        public void handleDragStart(View view, int button, int x, int y, int xAbs, int yAbs, ClipboardAssistance dropSourceAssistant) {
        }

        public void handleDragEnd(View view, int performedAction) {
        }

        public int handleDragEnter(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return recommendedDropAction;
        }

        public int handleDragOver(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return recommendedDropAction;
        }

        public void handleDragLeave(View view, ClipboardAssistance dropTargetAssistant) {
        }

        public int handleDragDrop(View view, int x, int y, int xAbs, int yAbs, int recommendedDropAction, ClipboardAssistance dropTargetAssistant) {
            return 0;
        }

        public void handleBeginTouchEvent(View view, long time, int modifiers, boolean isDirect, int touchEventCount) {
        }

        public void handleNextTouchEvent(View view, long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        }

        public void handleEndTouchEvent(View view, long time) {
        }

        public void handleScrollGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int x, int y, int xAbs, int yAbs, double dx, double dy, double totaldx, double totaldy, double multiplierX, double multiplierY) {
        }

        public void handleZoomGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double scale, double expansion, double totalscale, double totalexpansion) {
        }

        public void handleRotateGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int x, int y, int xAbs, int yAbs, double dangle, double totalangle) {
        }

        public void handleSwipeGestureEvent(View view, long time, int type, int modifiers, boolean isDirect, boolean isInertia, int touchCount, int dir, int x, int y, int xAbs, int yAbs) {
        }

        public Accessible getSceneAccessible() {
            return null;
        }
    }
}

