/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.View;
import com.sun.glass.ui.win.WinTextRangeProvider;
import com.sun.glass.ui.win.WinVariant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;

final class WinAccessible
extends Accessible {
    private static int idCount;
    private static final int UIA_BoundingRectanglePropertyId = 30001;
    private static final int UIA_ProcessIdPropertyId = 30002;
    private static final int UIA_ControlTypePropertyId = 30003;
    private static final int UIA_LocalizedControlTypePropertyId = 30004;
    private static final int UIA_NamePropertyId = 30005;
    private static final int UIA_AcceleratorKeyPropertyId = 30006;
    private static final int UIA_AccessKeyPropertyId = 30007;
    private static final int UIA_HasKeyboardFocusPropertyId = 30008;
    private static final int UIA_IsKeyboardFocusablePropertyId = 30009;
    private static final int UIA_IsEnabledPropertyId = 30010;
    private static final int UIA_AutomationIdPropertyId = 30011;
    private static final int UIA_ClassNamePropertyId = 30012;
    private static final int UIA_HelpTextPropertyId = 30013;
    private static final int UIA_ClickablePointPropertyId = 30014;
    private static final int UIA_CulturePropertyId = 30015;
    private static final int UIA_IsControlElementPropertyId = 30016;
    private static final int UIA_IsContentElementPropertyId = 30017;
    private static final int UIA_LabeledByPropertyId = 30018;
    private static final int UIA_IsPasswordPropertyId = 30019;
    private static final int UIA_NativeWindowHandlePropertyId = 30020;
    private static final int UIA_ItemTypePropertyId = 30021;
    private static final int UIA_IsOffscreenPropertyId = 30022;
    private static final int UIA_OrientationPropertyId = 30023;
    private static final int UIA_FrameworkIdPropertyId = 30024;
    private static final int UIA_ValueValuePropertyId = 30045;
    private static final int UIA_RangeValueValuePropertyId = 30047;
    private static final int UIA_ExpandCollapseExpandCollapseStatePropertyId = 30070;
    private static final int UIA_ToggleToggleStatePropertyId = 30086;
    private static final int UIA_AriaRolePropertyId = 30101;
    private static final int UIA_ProviderDescriptionPropertyId = 30107;
    private static final int UIA_InvokePatternId = 10000;
    private static final int UIA_SelectionPatternId = 10001;
    private static final int UIA_ValuePatternId = 10002;
    private static final int UIA_RangeValuePatternId = 10003;
    private static final int UIA_ScrollPatternId = 10004;
    private static final int UIA_ExpandCollapsePatternId = 10005;
    private static final int UIA_GridPatternId = 10006;
    private static final int UIA_GridItemPatternId = 10007;
    private static final int UIA_SelectionItemPatternId = 10010;
    private static final int UIA_TablePatternId = 10012;
    private static final int UIA_TableItemPatternId = 10013;
    private static final int UIA_TextPatternId = 10014;
    private static final int UIA_TogglePatternId = 10015;
    private static final int UIA_TransformPatternId = 10016;
    private static final int UIA_ScrollItemPatternId = 10017;
    private static final int UIA_ItemContainerPatternId = 10019;
    private static final int UIA_ButtonControlTypeId = 50000;
    private static final int UIA_CheckBoxControlTypeId = 50002;
    private static final int UIA_ComboBoxControlTypeId = 50003;
    private static final int UIA_EditControlTypeId = 50004;
    private static final int UIA_HyperlinkControlTypeId = 50005;
    private static final int UIA_ImageControlTypeId = 50006;
    private static final int UIA_ListItemControlTypeId = 50007;
    private static final int UIA_ListControlTypeId = 50008;
    private static final int UIA_MenuControlTypeId = 50009;
    private static final int UIA_MenuBarControlTypeId = 50010;
    private static final int UIA_MenuItemControlTypeId = 50011;
    private static final int UIA_ProgressBarControlTypeId = 50012;
    private static final int UIA_RadioButtonControlTypeId = 50013;
    private static final int UIA_ScrollBarControlTypeId = 50014;
    private static final int UIA_SliderControlTypeId = 50015;
    private static final int UIA_SpinnerControlTypeId = 50016;
    private static final int UIA_TabControlTypeId = 50018;
    private static final int UIA_TabItemControlTypeId = 50019;
    private static final int UIA_TextControlTypeId = 50020;
    private static final int UIA_ToolBarControlTypeId = 50021;
    private static final int UIA_TreeControlTypeId = 50023;
    private static final int UIA_TreeItemControlTypeId = 50024;
    private static final int UIA_GroupControlTypeId = 50026;
    private static final int UIA_ThumbControlTypeId = 50027;
    private static final int UIA_DataGridControlTypeId = 50028;
    private static final int UIA_DataItemControlTypeId = 50029;
    private static final int UIA_SplitButtonControlTypeId = 50031;
    private static final int UIA_WindowControlTypeId = 50032;
    private static final int UIA_PaneControlTypeId = 50033;
    private static final int UIA_TableControlTypeId = 50036;
    private static final int NavigateDirection_Parent = 0;
    private static final int NavigateDirection_NextSibling = 1;
    private static final int NavigateDirection_PreviousSibling = 2;
    private static final int NavigateDirection_FirstChild = 3;
    private static final int NavigateDirection_LastChild = 4;
    private static final int RowOrColumnMajor_RowMajor = 0;
    private static final int RowOrColumnMajor_ColumnMajor = 1;
    private static final int RowOrColumnMajor_Indeterminate = 2;
    private static final int UIA_MenuOpenedEventId = 20003;
    private static final int UIA_AutomationPropertyChangedEventId = 20004;
    private static final int UIA_AutomationFocusChangedEventId = 20005;
    private static final int UIA_MenuClosedEventId = 20007;
    private static final int UIA_SelectionItem_ElementRemovedFromSelectionEventId = 20011;
    private static final int UIA_SelectionItem_ElementSelectedEventId = 20012;
    private static final int UIA_Text_TextSelectionChangedEventId = 20014;
    private static final int UIA_Text_TextChangedEventId = 20015;
    private static final int UIA_MenuModeStartEventId = 20018;
    private static final int UIA_MenuModeEndEventId = 20019;
    private static final int SupportedTextSelection_None = 0;
    private static final int SupportedTextSelection_Single = 1;
    private static final int SupportedTextSelection_Multiple = 2;
    private static final int ExpandCollapseState_Collapsed = 0;
    private static final int ExpandCollapseState_Expanded = 1;
    private static final int ExpandCollapseState_PartiallyExpanded = 2;
    private static final int ExpandCollapseState_LeafNode = 3;
    private static final int ScrollAmount_LargeDecrement = 0;
    private static final int ScrollAmount_SmallDecrement = 1;
    private static final int ScrollAmount_NoAmount = 2;
    private static final int ScrollAmount_LargeIncrement = 3;
    private static final int ScrollAmount_SmallIncrement = 4;
    private static final int UIA_ScrollPatternNoScroll = -1;
    private static final int ToggleState_Off = 0;
    private static final int ToggleState_On = 1;
    private static final int ToggleState_Indeterminate = 2;
    private static final int UiaAppendRuntimeId = 3;
    private long peer = this._createGlassAccessible();
    private int id;
    private WinTextRangeProvider documentRange;
    private WinTextRangeProvider selectionRange;
    private int lastIndex = 0;

    private static native void _initIDs();

    private native long _createGlassAccessible();

    private native void _destroyGlassAccessible(long var1);

    private static native long UiaRaiseAutomationEvent(long var0, int var2);

    private static native long UiaRaiseAutomationPropertyChangedEvent(long var0, int var2, WinVariant var3, WinVariant var4);

    private static native boolean UiaClientsAreListening();

    WinAccessible() {
        if (this.peer == 0L) {
            throw new RuntimeException("could not create platform accessible");
        }
        this.id = idCount++;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.selectionRange != null) {
            this.selectionRange.dispose();
            this.selectionRange = null;
        }
        if (this.documentRange != null) {
            this.documentRange.dispose();
            this.documentRange = null;
        }
        if (this.peer != 0L) {
            this._destroyGlassAccessible(this.peer);
            this.peer = 0L;
        }
    }

    @Override
    public void sendNotification(AccessibleAttribute notification) {
        if (this.isDisposed()) {
            return;
        }
        switch (notification) {
            case FOCUS_NODE: {
                if (this.getView() != null) {
                    long focus = this.GetFocus();
                    if (focus == 0L) break;
                    WinAccessible.UiaRaiseAutomationEvent(focus, 20005);
                    break;
                }
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                if (node != null) {
                    WinAccessible.UiaRaiseAutomationEvent(this.getNativeAccessible(node), 20005);
                    break;
                }
                Scene scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]);
                Accessible acc = this.getAccessible(scene);
                if (acc == null) break;
                acc.sendNotification(AccessibleAttribute.FOCUS_NODE);
                break;
            }
            case FOCUS_ITEM: {
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                long id = this.getNativeAccessible(node);
                if (id == 0L) break;
                WinAccessible.UiaRaiseAutomationEvent(id, 20005);
                break;
            }
            case INDETERMINATE: {
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) != AccessibleRole.CHECK_BOX) break;
                this.notifyToggleState();
                break;
            }
            case SELECTED: {
                Object role = this.getAttribute(AccessibleAttribute.ROLE, new Object[0]);
                if (role == AccessibleRole.CHECK_BOX || role == AccessibleRole.TOGGLE_BUTTON) {
                    this.notifyToggleState();
                    break;
                }
                Boolean selected = (Boolean)this.getAttribute(AccessibleAttribute.SELECTED, new Object[0]);
                if (selected == null) break;
                if (selected.booleanValue()) {
                    WinAccessible.UiaRaiseAutomationEvent(this.peer, 20012);
                    break;
                }
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20011);
                break;
            }
            case FOCUSED: {
                break;
            }
            case VALUE: {
                Double value = (Double)this.getAttribute(AccessibleAttribute.VALUE, new Object[0]);
                if (value == null) break;
                WinVariant vo = new WinVariant();
                vo.vt = (short)5;
                vo.dblVal = 0.0;
                WinVariant vn = new WinVariant();
                vn.vt = (short)5;
                vn.dblVal = value;
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30047, vo, vn);
                break;
            }
            case SELECTION_START: 
            case SELECTION_END: {
                boolean newEnd;
                if (this.selectionRange == null) break;
                Integer start = (Integer)this.getAttribute(AccessibleAttribute.SELECTION_START, new Object[0]);
                boolean newStart = start != null && start.intValue() != this.selectionRange.getStart();
                Integer end = (Integer)this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                boolean bl = newEnd = end != null && end.intValue() != this.selectionRange.getEnd();
                if (!newStart && !newEnd) break;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20014);
                break;
            }
            case TEXT: {
                String value = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                if (value != null) {
                    WinVariant vo = new WinVariant();
                    vo.vt = (short)8;
                    vo.bstrVal = "";
                    WinVariant vn = new WinVariant();
                    vn.vt = (short)8;
                    vn.bstrVal = value;
                    if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.SPINNER) {
                        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30005, vo, vn);
                    } else {
                        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30045, vo, vn);
                    }
                }
                if (this.selectionRange == null && this.documentRange == null) break;
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20015);
                break;
            }
            case EXPANDED: {
                Boolean expanded = (Boolean)this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]);
                if (expanded == null) break;
                WinVariant vo = new WinVariant();
                vo.vt = (short)3;
                vo.lVal = expanded != false ? 0 : 1;
                WinVariant vn = new WinVariant();
                vn.vt = (short)3;
                int n = vn.lVal = expanded != false ? 1 : 0;
                if (this.getAttribute(AccessibleAttribute.ROLE, new Object[0]) == AccessibleRole.TREE_TABLE_ROW) {
                    Node node;
                    Accessible treeTableView = this.getContainer();
                    Integer rowIndex = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                    if (treeTableView == null || rowIndex == null || (node = (Node)treeTableView.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, rowIndex, 0)) == null) break;
                    long ptr = ((WinAccessible)this.getAccessible(node)).getNativeAccessible();
                    WinAccessible.UiaRaiseAutomationPropertyChangedEvent(ptr, 30070, vo, vn);
                    break;
                }
                WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30070, vo, vn);
                break;
            }
            case PARENT: {
                break;
            }
            default: {
                WinAccessible.UiaRaiseAutomationEvent(this.peer, 20004);
            }
        }
    }

    private void notifyToggleState() {
        int state = this.get_ToggleState();
        WinVariant vo = new WinVariant();
        vo.vt = (short)3;
        vo.lVal = state;
        WinVariant vn = new WinVariant();
        vn.vt = (short)3;
        vn.lVal = state;
        WinAccessible.UiaRaiseAutomationPropertyChangedEvent(this.peer, 30086, vo, vn);
    }

    @Override
    protected long getNativeAccessible() {
        return this.peer;
    }

    private Accessible getContainer() {
        if (this.isDisposed()) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_ROW: 
                case TABLE_CELL: {
                    return this.getContainerAccessible(AccessibleRole.TABLE_VIEW);
                }
                case LIST_ITEM: {
                    return this.getContainerAccessible(AccessibleRole.LIST_VIEW);
                }
                case TAB_ITEM: {
                    return this.getContainerAccessible(AccessibleRole.TAB_PANE);
                }
                case PAGE_ITEM: {
                    return this.getContainerAccessible(AccessibleRole.PAGINATION);
                }
                case TREE_ITEM: {
                    return this.getContainerAccessible(AccessibleRole.TREE_VIEW);
                }
                case TREE_TABLE_ROW: 
                case TREE_TABLE_CELL: {
                    return this.getContainerAccessible(AccessibleRole.TREE_TABLE_VIEW);
                }
            }
        }
        return null;
    }

    private int getControlType() {
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return 50026;
        }
        switch (role) {
            case CONTEXT_MENU: {
                return 50009;
            }
            case RADIO_MENU_ITEM: 
            case CHECK_MENU_ITEM: 
            case MENU: 
            case MENU_ITEM: {
                return 50011;
            }
            case BUTTON: 
            case MENU_BUTTON: 
            case TOGGLE_BUTTON: 
            case INCREMENT_BUTTON: 
            case DECREMENT_BUTTON: {
                return 50000;
            }
            case SPLIT_MENU_BUTTON: {
                return 50031;
            }
            case PAGINATION: 
            case TAB_PANE: {
                return 50018;
            }
            case TAB_ITEM: 
            case PAGE_ITEM: {
                return 50019;
            }
            case SLIDER: {
                return 50015;
            }
            case PARENT: {
                return this.getView() != null ? 50032 : 50033;
            }
            case TEXT: {
                return 50020;
            }
            case TEXT_FIELD: 
            case PASSWORD_FIELD: 
            case TEXT_AREA: {
                return 50004;
            }
            case TREE_TABLE_VIEW: 
            case TABLE_VIEW: {
                return 50036;
            }
            case LIST_VIEW: {
                return 50008;
            }
            case LIST_ITEM: {
                return 50007;
            }
            case TABLE_CELL: 
            case TREE_TABLE_CELL: {
                return 50029;
            }
            case IMAGE_VIEW: {
                return 50006;
            }
            case RADIO_BUTTON: {
                return 50013;
            }
            case CHECK_BOX: {
                return 50002;
            }
            case COMBO_BOX: {
                return 50003;
            }
            case HYPERLINK: {
                return 50005;
            }
            case TREE_VIEW: {
                return 50023;
            }
            case TREE_ITEM: {
                return 50024;
            }
            case PROGRESS_INDICATOR: {
                return 50012;
            }
            case TOOL_BAR: {
                return 50021;
            }
            case TITLED_PANE: {
                return 50026;
            }
            case SCROLL_PANE: {
                return 50033;
            }
            case SCROLL_BAR: {
                return 50014;
            }
            case THUMB: {
                return 50027;
            }
            case MENU_BAR: {
                return 50010;
            }
            case DATE_PICKER: {
                return 50033;
            }
            case SPINNER: {
                return 50016;
            }
        }
        return 0;
    }

    private List<Node> getUnignoredChildren(WinAccessible acc) {
        if (acc == null) {
            return FXCollections.emptyObservableList();
        }
        ObservableList children = (ObservableList)acc.getAttribute(AccessibleAttribute.CHILDREN, new Object[0]);
        if (children == null) {
            return FXCollections.emptyObservableList();
        }
        return children.stream().filter(Node::isVisible).collect(Collectors.toList());
    }

    private Accessible getRow() {
        Integer columnIndex = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
        if (columnIndex == null) {
            return null;
        }
        if (columnIndex != 0) {
            return null;
        }
        Integer rowIndex = (Integer)this.getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
        if (rowIndex == null) {
            return null;
        }
        Accessible treeTableView = this.getContainer();
        if (treeTableView == null) {
            return null;
        }
        Node treeTableRow = (Node)treeTableView.getAttribute(AccessibleAttribute.ROW_AT_INDEX, rowIndex);
        return this.getAccessible(treeTableRow);
    }

    private void changeSelection(boolean add, boolean clear) {
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return;
        }
        Accessible container = this.getContainer();
        if (container == null) {
            return;
        }
        Node item = null;
        switch (role) {
            case LIST_ITEM: {
                Integer index = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                if (index == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, index);
                break;
            }
            case TREE_ITEM: {
                Integer index = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                if (index == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.ROW_AT_INDEX, index);
                break;
            }
            case TABLE_CELL: 
            case TREE_TABLE_CELL: {
                Integer rowIndex = (Integer)this.getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
                Integer columnIndex = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
                if (rowIndex == null || columnIndex == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, rowIndex, columnIndex);
                break;
            }
        }
        if (item != null) {
            ObservableList items;
            ObservableList newItems = FXCollections.observableArrayList();
            if (!clear && (items = (ObservableList)container.getAttribute(AccessibleAttribute.SELECTED_ITEMS, new Object[0])) != null) {
                newItems.addAll((Collection)items);
            }
            if (add) {
                newItems.add(item);
            } else {
                newItems.remove(item);
            }
            container.executeAction(AccessibleAction.SET_SELECTED_ITEMS, newItems);
        }
    }

    private long GetPatternProvider(int patternId) {
        if (this.isDisposed()) {
            return 0L;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return 0L;
        }
        boolean impl = false;
        switch (role) {
            case MENU: 
            case SPLIT_MENU_BUTTON: {
                impl = patternId == 10000 || patternId == 10005;
                break;
            }
            case RADIO_MENU_ITEM: 
            case CHECK_MENU_ITEM: {
                impl = patternId == 10000 || patternId == 10015;
                break;
            }
            case MENU_ITEM: 
            case BUTTON: 
            case MENU_BUTTON: 
            case INCREMENT_BUTTON: 
            case DECREMENT_BUTTON: 
            case HYPERLINK: {
                impl = patternId == 10000;
                break;
            }
            case TAB_ITEM: 
            case PAGE_ITEM: {
                impl = patternId == 10010;
                break;
            }
            case PAGINATION: 
            case TAB_PANE: {
                impl = patternId == 10001;
                break;
            }
            case SCROLL_PANE: {
                impl = patternId == 10004;
                break;
            }
            case TREE_TABLE_VIEW: 
            case TABLE_VIEW: {
                impl = patternId == 10001 || patternId == 10006 || patternId == 10012 || patternId == 10004;
                break;
            }
            case TREE_TABLE_CELL: {
                impl = patternId == 10010 || patternId == 10007 || patternId == 10013 || patternId == 10005 || patternId == 10017;
                break;
            }
            case TABLE_CELL: {
                impl = patternId == 10010 || patternId == 10007 || patternId == 10013 || patternId == 10017;
                break;
            }
            case TREE_VIEW: {
                impl = patternId == 10001 || patternId == 10004;
                break;
            }
            case TREE_ITEM: {
                impl = patternId == 10010 || patternId == 10005 || patternId == 10017;
                break;
            }
            case LIST_VIEW: {
                impl = patternId == 10001 || patternId == 10004;
                break;
            }
            case LIST_ITEM: {
                impl = patternId == 10010 || patternId == 10017;
                break;
            }
            case TEXT_FIELD: 
            case TEXT_AREA: {
                impl = patternId == 10014 || patternId == 10002;
                break;
            }
            case TEXT: {
                break;
            }
            case RADIO_BUTTON: {
                impl = patternId == 10010;
                break;
            }
            case TOGGLE_BUTTON: 
            case CHECK_BOX: {
                impl = patternId == 10015;
                break;
            }
            case TOOL_BAR: 
            case TITLED_PANE: {
                impl = patternId == 10005;
                break;
            }
            case COMBO_BOX: {
                impl = patternId == 10005 || patternId == 10002;
                break;
            }
            case SLIDER: 
            case PROGRESS_INDICATOR: 
            case SCROLL_BAR: {
                impl = patternId == 10003;
                break;
            }
        }
        return impl ? this.getNativeAccessible() : 0L;
    }

    private long get_HostRawElementProvider() {
        if (this.isDisposed()) {
            return 0L;
        }
        View view = this.getView();
        return view != null ? view.getNativeView() : 0L;
    }

    private WinVariant GetPropertyValue(int propertyId) {
        if (this.isDisposed()) {
            return null;
        }
        WinVariant variant = null;
        switch (propertyId) {
            case 30003: {
                int controlType = this.getControlType();
                if (controlType == 0) break;
                variant = new WinVariant();
                variant.vt = (short)3;
                variant.lVal = controlType;
                break;
            }
            case 30007: {
                String mnemonic = (String)this.getAttribute(AccessibleAttribute.MNEMONIC, new Object[0]);
                if (mnemonic == null) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = "Alt+" + mnemonic.toLowerCase();
                break;
            }
            case 30006: {
                KeyCombination kc = (KeyCombination)this.getAttribute(AccessibleAttribute.ACCELERATOR, new Object[0]);
                if (kc == null) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = kc.toString().replaceAll("Shortcut", "Ctrl");
                break;
            }
            case 30005: {
                Node label;
                String name;
                AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                if (role == null) {
                    role = AccessibleRole.NODE;
                }
                switch (role) {
                    case TEXT_FIELD: 
                    case TEXT_AREA: 
                    case COMBO_BOX: {
                        name = null;
                        break;
                    }
                    case INCREMENT_BUTTON: 
                    case DECREMENT_BUTTON: {
                        name = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                        if (name != null && name.length() != 0) break;
                        if (role == AccessibleRole.INCREMENT_BUTTON) {
                            name = "increment";
                            break;
                        }
                        name = "decrement";
                        break;
                    }
                    default: {
                        name = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                    }
                }
                if ((name == null || name.length() == 0) && (label = (Node)this.getAttribute(AccessibleAttribute.LABELED_BY, new Object[0])) != null) {
                    name = (String)this.getAccessible(label).getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                }
                if (name == null || name.length() == 0) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = name;
                break;
            }
            case 30013: {
                String help = (String)this.getAttribute(AccessibleAttribute.HELP, new Object[0]);
                if (help == null) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = help;
                break;
            }
            case 30004: {
                String description = (String)this.getAttribute(AccessibleAttribute.ROLE_DESCRIPTION, new Object[0]);
                if (description == null) {
                    AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                    if (role == null) {
                        role = AccessibleRole.NODE;
                    }
                    switch (role) {
                        case TITLED_PANE: {
                            description = "title pane";
                            break;
                        }
                        case PAGE_ITEM: {
                            description = "page";
                            break;
                        }
                    }
                }
                if (description == null) break;
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = description;
                break;
            }
            case 30008: {
                Node item;
                Node node;
                Accessible acc;
                Scene scene;
                Boolean focus = (Boolean)this.getAttribute(AccessibleAttribute.FOCUSED, new Object[0]);
                if (Boolean.FALSE.equals(focus) && (scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0])) != null && (acc = this.getAccessible(scene)) != null && (node = (Node)acc.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0])) != null && this.getNativeAccessible(item = (Node)this.getAccessible(node).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0])) == this.peer) {
                    focus = true;
                }
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = focus != null ? focus : false;
                break;
            }
            case 30016: 
            case 30017: {
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = this.getView() != null || !this.isIgnored();
                break;
            }
            case 30010: {
                Boolean disabled = (Boolean)this.getAttribute(AccessibleAttribute.DISABLED, new Object[0]);
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = disabled != null ? !disabled.booleanValue() : true;
                break;
            }
            case 30009: {
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = true;
                break;
            }
            case 30019: {
                AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
                variant = new WinVariant();
                variant.vt = (short)11;
                variant.boolVal = role == AccessibleRole.PASSWORD_FIELD;
                break;
            }
            case 30011: {
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = "JavaFX" + this.id;
                break;
            }
            case 30107: {
                variant = new WinVariant();
                variant.vt = (short)8;
                variant.bstrVal = "JavaFXProvider";
                break;
            }
        }
        return variant;
    }

    private float[] get_BoundingRectangle() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        Bounds bounds = (Bounds)this.getAttribute(AccessibleAttribute.BOUNDS, new Object[0]);
        if (bounds != null) {
            return new float[]{(float)bounds.getMinX(), (float)bounds.getMinY(), (float)bounds.getWidth(), (float)bounds.getHeight()};
        }
        return null;
    }

    private long get_FragmentRoot() {
        if (this.isDisposed()) {
            return 0L;
        }
        Scene scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]);
        if (scene == null) {
            return 0L;
        }
        WinAccessible acc = (WinAccessible)this.getAccessible(scene);
        if (acc == null || acc.isDisposed()) {
            return 0L;
        }
        return acc.getNativeAccessible();
    }

    private long[] GetEmbeddedFragmentRoots() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private int[] GetRuntimeId() {
        if (this.isDisposed()) {
            return null;
        }
        if (this.getView() != null) {
            return null;
        }
        return new int[]{3, this.id};
    }

    private long NavigateListView(WinAccessible listItemAccessible, int direction) {
        Accessible listAccessible = listItemAccessible.getContainer();
        if (listAccessible == null) {
            return 0L;
        }
        Integer count = (Integer)listAccessible.getAttribute(AccessibleAttribute.ITEM_COUNT, new Object[0]);
        if (count == null || count == 0) {
            return 0L;
        }
        Integer index = (Integer)listItemAccessible.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
        if (index == null) {
            return 0L;
        }
        if (0 > index || index >= count) {
            return 0L;
        }
        switch (direction) {
            case 1: {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                break;
            }
            case 2: {
                Integer n = index;
                Integer n3 = index = Integer.valueOf(index - 1);
                break;
            }
            case 3: {
                index = 0;
                break;
            }
            case 4: {
                index = count - 1;
            }
        }
        if (0 > index || index >= count) {
            return 0L;
        }
        Node node = (Node)listAccessible.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, index);
        return this.getNativeAccessible(node);
    }

    private long Navigate(int direction) {
        if (this.isDisposed()) {
            return 0L;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        boolean treeCell = role == AccessibleRole.TREE_ITEM;
        Node node = null;
        switch (direction) {
            case 0: {
                if (this.getView() != null) {
                    return 0L;
                }
                if (treeCell) {
                    node = (Node)this.getAttribute(AccessibleAttribute.TREE_ITEM_PARENT, new Object[0]);
                    if (node != null) break;
                    WinAccessible acc = (WinAccessible)this.getContainer();
                    return acc != null ? acc.getNativeAccessible() : 0L;
                }
                node = (Node)this.getAttribute(AccessibleAttribute.PARENT, new Object[0]);
                if (node != null) break;
                Scene scene = (Scene)this.getAttribute(AccessibleAttribute.SCENE, new Object[0]);
                WinAccessible acc = (WinAccessible)this.getAccessible(scene);
                if (acc == null || acc == this || acc.isDisposed()) {
                    return 0L;
                }
                return acc.getNativeAccessible();
            }
            case 1: 
            case 2: {
                Function<Integer, Node> getChild;
                if (role == AccessibleRole.LIST_ITEM) {
                    return this.NavigateListView(this, direction);
                }
                Node parent = (Node)this.getAttribute(treeCell ? AccessibleAttribute.TREE_ITEM_PARENT : AccessibleAttribute.PARENT, new Object[0]);
                if (parent == null) break;
                WinAccessible parentAccessible = (WinAccessible)this.getAccessible(parent);
                int count = 0;
                if (treeCell) {
                    Integer result = (Integer)parentAccessible.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                    if (result == null) {
                        return 0L;
                    }
                    count = result;
                    getChild = index -> (Node)parentAccessible.getAttribute(AccessibleAttribute.TREE_ITEM_AT_INDEX, index);
                } else {
                    List<Node> children = this.getUnignoredChildren(parentAccessible);
                    if (children == null) {
                        return 0L;
                    }
                    count = children.size();
                    getChild = index -> (Node)children.get((int)index);
                }
                int lastIndex = parentAccessible.lastIndex;
                int currentIndex = -1;
                if (0 <= lastIndex && lastIndex < count && this.getNativeAccessible(getChild.apply(lastIndex)) == this.peer) {
                    currentIndex = lastIndex;
                } else {
                    for (int i = 0; i < count; ++i) {
                        if (this.getNativeAccessible(getChild.apply(i)) != this.peer) continue;
                        currentIndex = i;
                        break;
                    }
                }
                if (currentIndex == -1) break;
                currentIndex = direction == 1 ? ++currentIndex : --currentIndex;
                if (0 > currentIndex || currentIndex >= count) break;
                node = getChild.apply(currentIndex);
                parentAccessible.lastIndex = currentIndex;
                break;
            }
            case 3: 
            case 4: {
                this.lastIndex = -1;
                if (role == AccessibleRole.LIST_VIEW) {
                    this.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, 0);
                }
                if (role == AccessibleRole.TREE_VIEW) {
                    this.lastIndex = 0;
                    node = (Node)this.getAttribute(AccessibleAttribute.ROW_AT_INDEX, 0);
                    break;
                }
                if (treeCell) {
                    Integer count = (Integer)this.getAttribute(AccessibleAttribute.TREE_ITEM_COUNT, new Object[0]);
                    if (count == null || count <= 0) break;
                    this.lastIndex = direction == 3 ? 0 : count - 1;
                    node = (Node)this.getAttribute(AccessibleAttribute.TREE_ITEM_AT_INDEX, this.lastIndex);
                    break;
                }
                List<Node> children = this.getUnignoredChildren(this);
                if (children != null && children.size() > 0) {
                    this.lastIndex = direction == 3 ? 0 : children.size() - 1;
                    node = children.get(this.lastIndex);
                }
                if (node == null || (role = (AccessibleRole)((Object)this.getAccessible(node).getAttribute(AccessibleAttribute.ROLE, new Object[0]))) != AccessibleRole.LIST_ITEM) break;
                WinAccessible itemAcc = (WinAccessible)this.getAccessible(node);
                return this.NavigateListView(itemAcc, direction);
            }
        }
        return this.getNativeAccessible(node);
    }

    private void SetFocus() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(AccessibleAction.REQUEST_FOCUS, new Object[0]);
    }

    private long ElementProviderFromPoint(double x, double y) {
        if (this.isDisposed()) {
            return 0L;
        }
        Node node = (Node)this.getAttribute(AccessibleAttribute.NODE_AT_POINT, new Point2D(x, y));
        return this.getNativeAccessible(node);
    }

    private long GetFocus() {
        if (this.isDisposed()) {
            return 0L;
        }
        Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
        if (node == null) {
            return 0L;
        }
        Node item = (Node)this.getAccessible(node).getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
        if (item != null) {
            return this.getNativeAccessible(item);
        }
        return this.getNativeAccessible(node);
    }

    private void AdviseEventAdded(int eventId, long propertyIDs) {
    }

    private void AdviseEventRemoved(int eventId, long propertyIDs) {
    }

    private void Invoke() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(AccessibleAction.FIRE, new Object[0]);
    }

    private long[] GetSelection() {
        if (this.isDisposed()) {
            return null;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return null;
        }
        switch (role) {
            case TREE_TABLE_VIEW: 
            case TABLE_VIEW: 
            case LIST_VIEW: 
            case TREE_VIEW: {
                ObservableList selection = (ObservableList)this.getAttribute(AccessibleAttribute.SELECTED_ITEMS, new Object[0]);
                if (selection == null) break;
                return selection.stream().mapToLong(n -> this.getNativeAccessible((Node)n)).toArray();
            }
            case PAGINATION: 
            case TAB_PANE: {
                Node node = (Node)this.getAttribute(AccessibleAttribute.FOCUS_ITEM, new Object[0]);
                if (node == null) break;
                return new long[]{this.getNativeAccessible(node)};
            }
            case TEXT_FIELD: 
            case TEXT_AREA: {
                Integer result;
                if (this.selectionRange == null) {
                    this.selectionRange = new WinTextRangeProvider(this);
                }
                int start = (result = (Integer)this.getAttribute(AccessibleAttribute.SELECTION_START, new Object[0])) != null ? result : 0;
                int end = -1;
                int length = -1;
                if (start >= 0) {
                    result = (Integer)this.getAttribute(AccessibleAttribute.SELECTION_END, new Object[0]);
                    int n2 = end = result != null ? result : 0;
                    if (end >= start) {
                        String string = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
                        int n3 = length = string != null ? string.length() : 0;
                    }
                }
                if (length != -1 && end <= length) {
                    this.selectionRange.setRange(start, end);
                } else {
                    this.selectionRange.setRange(0, 0);
                }
                return new long[]{this.selectionRange.getNativeProvider()};
            }
        }
        return null;
    }

    private boolean get_CanSelectMultiple() {
        if (this.isDisposed()) {
            return false;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TREE_TABLE_VIEW: 
                case TABLE_VIEW: 
                case LIST_VIEW: 
                case TREE_VIEW: {
                    return Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.MULTIPLE_SELECTION, new Object[0]));
                }
            }
        }
        return false;
    }

    private boolean get_IsSelectionRequired() {
        return !this.isDisposed();
    }

    private void SetValue(double val) {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case SLIDER: 
                case SCROLL_BAR: {
                    this.executeAction(AccessibleAction.SET_VALUE, val);
                    break;
                }
            }
        }
    }

    private double get_Value() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) {
            return 0.0;
        }
        Double value = (Double)this.getAttribute(AccessibleAttribute.VALUE, new Object[0]);
        return value != null ? value : 0.0;
    }

    private boolean get_IsReadOnly() {
        if (this.isDisposed()) {
            return false;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case SLIDER: {
                    return false;
                }
                case SCROLL_BAR: {
                    return true;
                }
                case TEXT_FIELD: 
                case TEXT_AREA: 
                case COMBO_BOX: {
                    return Boolean.FALSE.equals(this.getAttribute(AccessibleAttribute.EDITABLE, new Object[0]));
                }
            }
        }
        return true;
    }

    private double get_Maximum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double value = (Double)this.getAttribute(AccessibleAttribute.MAX_VALUE, new Object[0]);
        return value != null ? value : 0.0;
    }

    private double get_Minimum() {
        if (this.isDisposed()) {
            return 0.0;
        }
        Double value = (Double)this.getAttribute(AccessibleAttribute.MIN_VALUE, new Object[0]);
        return value != null ? value : 0.0;
    }

    private double get_LargeChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 10.0;
    }

    private double get_SmallChange() {
        if (this.isDisposed()) {
            return 0.0;
        }
        return 3.0;
    }

    private void SetValueString(String val) {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TEXT_FIELD: 
                case TEXT_AREA: {
                    this.executeAction(AccessibleAction.SET_TEXT, val);
                    break;
                }
            }
        }
    }

    private String get_ValueString() {
        if (this.isDisposed()) {
            return null;
        }
        return (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0]);
    }

    private void Select() {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TAB_ITEM: 
                case PAGE_ITEM: {
                    this.executeAction(AccessibleAction.REQUEST_FOCUS, new Object[0]);
                    break;
                }
                case BUTTON: 
                case TOGGLE_BUTTON: 
                case INCREMENT_BUTTON: 
                case DECREMENT_BUTTON: 
                case RADIO_BUTTON: {
                    this.executeAction(AccessibleAction.FIRE, new Object[0]);
                    break;
                }
                case TABLE_CELL: 
                case LIST_ITEM: 
                case TREE_ITEM: 
                case TREE_TABLE_CELL: {
                    this.changeSelection(true, true);
                    break;
                }
            }
        }
    }

    private void AddToSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.changeSelection(true, false);
    }

    private void RemoveFromSelection() {
        if (this.isDisposed()) {
            return;
        }
        this.changeSelection(false, false);
    }

    private boolean get_IsSelected() {
        if (this.isDisposed()) {
            return false;
        }
        return Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.SELECTED, new Object[0]));
    }

    private long get_SelectionContainer() {
        if (this.isDisposed()) {
            return 0L;
        }
        WinAccessible acc = (WinAccessible)this.getContainer();
        return acc != null ? acc.getNativeAccessible() : 0L;
    }

    private long[] GetVisibleRanges() {
        if (this.isDisposed()) {
            return null;
        }
        return new long[]{this.get_DocumentRange()};
    }

    private long RangeFromChild(long childElement) {
        if (this.isDisposed()) {
            return 0L;
        }
        return 0L;
    }

    private long RangeFromPoint(double x, double y) {
        if (this.isDisposed()) {
            return 0L;
        }
        Integer offset = (Integer)this.getAttribute(AccessibleAttribute.OFFSET_AT_POINT, new Point2D(x, y));
        if (offset != null) {
            WinTextRangeProvider range = new WinTextRangeProvider(this);
            range.setRange(offset, offset);
            return range.getNativeProvider();
        }
        return 0L;
    }

    private long get_DocumentRange() {
        String text;
        if (this.isDisposed()) {
            return 0L;
        }
        if (this.documentRange == null) {
            this.documentRange = new WinTextRangeProvider(this);
        }
        if ((text = (String)this.getAttribute(AccessibleAttribute.TEXT, new Object[0])) == null) {
            return 0L;
        }
        this.documentRange.setRange(0, text.length());
        return this.documentRange.getNativeProvider();
    }

    private int get_SupportedTextSelection() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private int get_ColumnCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer count = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_COUNT, new Object[0]);
        return count != null ? count : 1;
    }

    private int get_RowCount() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer count = (Integer)this.getAttribute(AccessibleAttribute.ROW_COUNT, new Object[0]);
        return count != null ? count : 0;
    }

    private long GetItem(int row, int column) {
        if (this.isDisposed()) {
            return 0L;
        }
        Node node = (Node)this.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, row, column);
        return this.getNativeAccessible(node);
    }

    private int get_Column() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer result = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
        return result != null ? result : 0;
    }

    private int get_ColumnSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private long get_ContainingGrid() {
        if (this.isDisposed()) {
            return 0L;
        }
        WinAccessible acc = (WinAccessible)this.getContainer();
        return acc != null ? acc.getNativeAccessible() : 0L;
    }

    private int get_Row() {
        if (this.isDisposed()) {
            return 0;
        }
        Integer result = null;
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role != null) {
            switch (role) {
                case TABLE_ROW: 
                case LIST_ITEM: 
                case TREE_TABLE_ROW: {
                    result = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                    break;
                }
                case TABLE_CELL: 
                case TREE_TABLE_CELL: {
                    result = (Integer)this.getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
                    break;
                }
            }
        }
        return result != null ? result : 0;
    }

    private int get_RowSpan() {
        if (this.isDisposed()) {
            return 0;
        }
        return 1;
    }

    private long[] GetColumnHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private long[] GetRowHeaders() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private int get_RowOrColumnMajor() {
        if (this.isDisposed()) {
            return 0;
        }
        return 0;
    }

    private long[] GetColumnHeaderItems() {
        if (this.isDisposed()) {
            return null;
        }
        Integer columnIndex = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
        if (columnIndex == null) {
            return null;
        }
        Accessible acc = this.getContainer();
        if (acc == null) {
            return null;
        }
        Node column = (Node)acc.getAttribute(AccessibleAttribute.COLUMN_AT_INDEX, columnIndex);
        if (column == null) {
            return null;
        }
        return new long[]{this.getNativeAccessible(column)};
    }

    private long[] GetRowHeaderItems() {
        if (this.isDisposed()) {
            return null;
        }
        return null;
    }

    private void Toggle() {
        if (this.isDisposed()) {
            return;
        }
        this.executeAction(AccessibleAction.FIRE, new Object[0]);
    }

    private int get_ToggleState() {
        if (this.isDisposed()) {
            return 0;
        }
        if (Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.INDETERMINATE, new Object[0]))) {
            return 2;
        }
        boolean selected = Boolean.TRUE.equals(this.getAttribute(AccessibleAttribute.SELECTED, new Object[0]));
        return selected ? 1 : 0;
    }

    private void Collapse() {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == AccessibleRole.TOOL_BAR) {
            Node button = (Node)this.getAttribute(AccessibleAttribute.OVERFLOW_BUTTON, new Object[0]);
            if (button != null) {
                this.getAccessible(button).executeAction(AccessibleAction.FIRE, new Object[0]);
            }
            return;
        }
        if (role == AccessibleRole.TREE_TABLE_CELL) {
            Accessible row = this.getRow();
            if (row != null) {
                row.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
            }
            return;
        }
        this.executeAction(AccessibleAction.COLLAPSE, new Object[0]);
    }

    private void Expand() {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == AccessibleRole.TOOL_BAR) {
            Node button = (Node)this.getAttribute(AccessibleAttribute.OVERFLOW_BUTTON, new Object[0]);
            if (button != null) {
                this.getAccessible(button).executeAction(AccessibleAction.FIRE, new Object[0]);
            }
            return;
        }
        if (role == AccessibleRole.TREE_TABLE_CELL) {
            Accessible row = this.getRow();
            if (row != null) {
                row.executeAction(AccessibleAction.EXPAND, new Object[0]);
            }
            return;
        }
        this.executeAction(AccessibleAction.EXPAND, new Object[0]);
    }

    private int get_ExpandCollapseState() {
        Node button;
        if (this.isDisposed()) {
            return 0;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == AccessibleRole.TOOL_BAR && (button = (Node)this.getAttribute(AccessibleAttribute.OVERFLOW_BUTTON, new Object[0])) != null) {
            boolean visible = Boolean.TRUE.equals(this.getAccessible(button).getAttribute(AccessibleAttribute.VISIBLE, new Object[0]));
            return visible ? 0 : 1;
        }
        if (role == AccessibleRole.TREE_TABLE_CELL) {
            Accessible row = this.getRow();
            if (row == null) {
                return 3;
            }
            Object o = row.getAttribute(AccessibleAttribute.LEAF, new Object[0]);
            if (Boolean.TRUE.equals(o)) {
                return 3;
            }
            o = row.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]);
            boolean isExpanded = Boolean.TRUE.equals(o);
            return isExpanded ? 1 : 0;
        }
        Object o = this.getAttribute(AccessibleAttribute.LEAF, new Object[0]);
        if (Boolean.TRUE.equals(o)) {
            return 3;
        }
        o = this.getAttribute(AccessibleAttribute.EXPANDED, new Object[0]);
        boolean isExpanded = Boolean.TRUE.equals(o);
        return isExpanded ? 1 : 0;
    }

    private boolean get_CanMove() {
        return false;
    }

    private boolean get_CanResize() {
        return false;
    }

    private boolean get_CanRotate() {
        return false;
    }

    private void Move(double x, double y) {
    }

    private void Resize(double width, double height) {
    }

    private void Rotate(double degrees) {
    }

    private void Scroll(int horizontalAmount, int verticalAmount) {
        if (this.isDisposed()) {
            return;
        }
        if (this.get_VerticallyScrollable()) {
            Node vsb = (Node)this.getAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, new Object[0]);
            Accessible vsba = this.getAccessible(vsb);
            if (vsba == null) {
                return;
            }
            switch (verticalAmount) {
                case 3: {
                    vsba.executeAction(AccessibleAction.BLOCK_INCREMENT, new Object[0]);
                    break;
                }
                case 4: {
                    vsba.executeAction(AccessibleAction.INCREMENT, new Object[0]);
                    break;
                }
                case 0: {
                    vsba.executeAction(AccessibleAction.BLOCK_DECREMENT, new Object[0]);
                    break;
                }
                case 1: {
                    vsba.executeAction(AccessibleAction.DECREMENT, new Object[0]);
                    break;
                }
            }
        }
        if (this.get_HorizontallyScrollable()) {
            Node hsb = (Node)this.getAttribute(AccessibleAttribute.HORIZONTAL_SCROLLBAR, new Object[0]);
            Accessible hsba = this.getAccessible(hsb);
            if (hsba == null) {
                return;
            }
            switch (horizontalAmount) {
                case 3: {
                    hsba.executeAction(AccessibleAction.BLOCK_INCREMENT, new Object[0]);
                    break;
                }
                case 4: {
                    hsba.executeAction(AccessibleAction.INCREMENT, new Object[0]);
                    break;
                }
                case 0: {
                    hsba.executeAction(AccessibleAction.BLOCK_DECREMENT, new Object[0]);
                    break;
                }
                case 1: {
                    hsba.executeAction(AccessibleAction.DECREMENT, new Object[0]);
                    break;
                }
            }
        }
    }

    private void SetScrollPercent(double horizontalPercent, double verticalPercent) {
        Double max;
        Double min;
        Accessible acc;
        if (this.isDisposed()) {
            return;
        }
        if (verticalPercent != -1.0 && this.get_VerticallyScrollable()) {
            Node vsb = (Node)this.getAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, new Object[0]);
            acc = this.getAccessible(vsb);
            if (acc == null) {
                return;
            }
            min = (Double)acc.getAttribute(AccessibleAttribute.MIN_VALUE, new Object[0]);
            max = (Double)acc.getAttribute(AccessibleAttribute.MAX_VALUE, new Object[0]);
            if (min != null && max != null) {
                acc.executeAction(AccessibleAction.SET_VALUE, (max - min) * (verticalPercent / 100.0) + min);
            }
        }
        if (horizontalPercent != -1.0 && this.get_HorizontallyScrollable()) {
            Node hsb = (Node)this.getAttribute(AccessibleAttribute.HORIZONTAL_SCROLLBAR, new Object[0]);
            acc = this.getAccessible(hsb);
            if (acc == null) {
                return;
            }
            min = (Double)acc.getAttribute(AccessibleAttribute.MIN_VALUE, new Object[0]);
            max = (Double)acc.getAttribute(AccessibleAttribute.MAX_VALUE, new Object[0]);
            if (min != null && max != null) {
                acc.executeAction(AccessibleAction.SET_VALUE, (max - min) * (horizontalPercent / 100.0) + min);
            }
        }
    }

    private boolean get_HorizontallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        Node hsb = (Node)this.getAttribute(AccessibleAttribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        if (hsb == null) {
            return false;
        }
        Boolean visible = (Boolean)this.getAccessible(hsb).getAttribute(AccessibleAttribute.VISIBLE, new Object[0]);
        return Boolean.TRUE.equals(visible);
    }

    private double get_HorizontalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return -1.0;
        }
        Node hsb = (Node)this.getAttribute(AccessibleAttribute.HORIZONTAL_SCROLLBAR, new Object[0]);
        if (hsb != null) {
            Accessible hsba = this.getAccessible(hsb);
            Double value = (Double)hsba.getAttribute(AccessibleAttribute.VALUE, new Object[0]);
            if (value == null) {
                return 0.0;
            }
            Double max = (Double)hsba.getAttribute(AccessibleAttribute.MAX_VALUE, new Object[0]);
            if (max == null) {
                return 0.0;
            }
            Double min = (Double)hsba.getAttribute(AccessibleAttribute.MIN_VALUE, new Object[0]);
            if (min == null) {
                return 0.0;
            }
            return 100.0 * (value - min) / (max - min);
        }
        return 0.0;
    }

    private double get_HorizontalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_HorizontallyScrollable()) {
            return 100.0;
        }
        Node content = (Node)this.getAttribute(AccessibleAttribute.CONTENTS, new Object[0]);
        if (content == null) {
            return 100.0;
        }
        Bounds contentBounds = (Bounds)this.getAccessible(content).getAttribute(AccessibleAttribute.BOUNDS, new Object[0]);
        if (contentBounds == null) {
            return 0.0;
        }
        Bounds scrollPaneBounds = (Bounds)this.getAttribute(AccessibleAttribute.BOUNDS, new Object[0]);
        if (scrollPaneBounds == null) {
            return 0.0;
        }
        return scrollPaneBounds.getWidth() / contentBounds.getWidth() * 100.0;
    }

    private boolean get_VerticallyScrollable() {
        if (this.isDisposed()) {
            return false;
        }
        Node vsb = (Node)this.getAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, new Object[0]);
        if (vsb == null) {
            return false;
        }
        Boolean visible = (Boolean)this.getAccessible(vsb).getAttribute(AccessibleAttribute.VISIBLE, new Object[0]);
        return Boolean.TRUE.equals(visible);
    }

    private double get_VerticalScrollPercent() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return -1.0;
        }
        Node vsb = (Node)this.getAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, new Object[0]);
        if (vsb != null) {
            Accessible vsba = this.getAccessible(vsb);
            Double value = (Double)vsba.getAttribute(AccessibleAttribute.VALUE, new Object[0]);
            if (value == null) {
                return 0.0;
            }
            Double max = (Double)vsba.getAttribute(AccessibleAttribute.MAX_VALUE, new Object[0]);
            if (max == null) {
                return 0.0;
            }
            Double min = (Double)vsba.getAttribute(AccessibleAttribute.MIN_VALUE, new Object[0]);
            if (min == null) {
                return 0.0;
            }
            return 100.0 * (value - min) / (max - min);
        }
        return 0.0;
    }

    private double get_VerticalViewSize() {
        if (this.isDisposed()) {
            return 0.0;
        }
        if (!this.get_VerticallyScrollable()) {
            return 100.0;
        }
        double contentHeight = 0.0;
        Bounds scrollPaneBounds = (Bounds)this.getAttribute(AccessibleAttribute.BOUNDS, new Object[0]);
        if (scrollPaneBounds == null) {
            return 0.0;
        }
        double scrollPaneHeight = scrollPaneBounds.getHeight();
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return 0.0;
        }
        if (role == AccessibleRole.SCROLL_PANE) {
            Node content = (Node)this.getAttribute(AccessibleAttribute.CONTENTS, new Object[0]);
            if (content != null) {
                Bounds contentBounds = (Bounds)this.getAccessible(content).getAttribute(AccessibleAttribute.BOUNDS, new Object[0]);
                contentHeight = contentBounds == null ? 0.0 : contentBounds.getHeight();
            }
        } else {
            Integer itemCount = 0;
            switch (role) {
                case LIST_VIEW: {
                    itemCount = (Integer)this.getAttribute(AccessibleAttribute.ITEM_COUNT, new Object[0]);
                    break;
                }
                case TREE_TABLE_VIEW: 
                case TABLE_VIEW: 
                case TREE_VIEW: {
                    itemCount = (Integer)this.getAttribute(AccessibleAttribute.ROW_COUNT, new Object[0]);
                    break;
                }
            }
            contentHeight = itemCount == null ? 0.0 : (double)(itemCount * 24);
        }
        return contentHeight == 0.0 ? 0.0 : scrollPaneHeight / contentHeight * 100.0;
    }

    private void ScrollIntoView() {
        if (this.isDisposed()) {
            return;
        }
        AccessibleRole role = (AccessibleRole)((Object)this.getAttribute(AccessibleAttribute.ROLE, new Object[0]));
        if (role == null) {
            return;
        }
        Accessible container = this.getContainer();
        if (container == null) {
            return;
        }
        Node item = null;
        switch (role) {
            case LIST_ITEM: {
                Integer index = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                if (index == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.ITEM_AT_INDEX, index);
                break;
            }
            case TREE_ITEM: {
                Integer index = (Integer)this.getAttribute(AccessibleAttribute.INDEX, new Object[0]);
                if (index == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.ROW_AT_INDEX, index);
                break;
            }
            case TABLE_CELL: 
            case TREE_TABLE_CELL: {
                Integer rowIndex = (Integer)this.getAttribute(AccessibleAttribute.ROW_INDEX, new Object[0]);
                Integer columnIndex = (Integer)this.getAttribute(AccessibleAttribute.COLUMN_INDEX, new Object[0]);
                if (rowIndex == null || columnIndex == null) break;
                item = (Node)container.getAttribute(AccessibleAttribute.CELL_AT_ROW_COLUMN, rowIndex, columnIndex);
                break;
            }
        }
        if (item != null) {
            container.executeAction(AccessibleAction.SHOW_ITEM, item);
        }
    }

    static {
        WinAccessible._initIDs();
        idCount = 1;
    }
}

