/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;

class WinWindow
extends Window {
    public static final int RESIZE_DISABLE = 0;
    public static final int RESIZE_AROUND_ANCHOR = 1;
    public static final int RESIZE_TO_FX_ORIGIN = 2;
    public static final long ANCHOR_NO_CAPTURE = Long.MIN_VALUE;
    float fxReqWidth;
    float fxReqHeight;
    int pfReqWidth;
    int pfReqHeight;
    private boolean deferredClosing = false;
    private boolean closingRequested = false;

    private static native void _initIDs();

    protected WinWindow(Window owner, Screen screen, int styleMask) {
        super(owner, screen, styleMask);
    }

    @Override
    public void setBounds(float x, float y, boolean xSet, boolean ySet, float w, float h, float cw, float ch, float xGravity, float yGravity) {
        if (xSet || ySet || w > 0.0f || h > 0.0f || cw > 0.0f || ch > 0.0f) {
            int ph;
            float fx_ch;
            int pw;
            float fx_cw;
            int py;
            int px;
            long insets = this._getInsets(this.getRawHandle());
            int iLft = (int)(insets >> 48) & 0xFFFF;
            int iTop = (int)(insets >> 32) & 0xFFFF;
            int iRgt = (int)(insets >> 16) & 0xFFFF;
            int iBot = (int)insets & 0xFFFF;
            if (xSet || ySet) {
                if (xSet) {
                    px = this.screen.toPlatformX(x);
                } else {
                    px = this.x;
                    x = this.screen.fromPlatformX(px);
                }
                if (ySet) {
                    py = this.screen.toPlatformY(y);
                } else {
                    py = this.y;
                    y = this.screen.fromPlatformY(py);
                }
            } else {
                px = this.x;
                py = this.y;
            }
            if (w > 0.0f) {
                fx_cw = w - (float)(iLft + iRgt) / this.platformScaleX;
                pw = (int)Math.ceil(w * this.platformScaleX);
            } else {
                fx_cw = cw > 0.0f ? cw : this.fxReqWidth;
                pw = iLft + iRgt + (int)Math.ceil(fx_cw * this.platformScaleX);
            }
            this.fxReqWidth = fx_cw;
            if (h > 0.0f) {
                fx_ch = h - (float)(iTop + iBot) / this.platformScaleY;
                ph = (int)Math.ceil(h * this.platformScaleY);
            } else {
                fx_ch = ch > 0.0f ? ch : this.fxReqHeight;
                ph = iTop + iBot + (int)Math.ceil(fx_ch * this.platformScaleY);
            }
            this.fxReqHeight = fx_ch;
            long anchor = this._getAnchor(this.getRawHandle());
            int resizeMode = anchor == Long.MIN_VALUE ? 2 : 1;
            int anchorX = (int)(anchor >> 32);
            int anchorY = (int)anchor;
            int[] overrideDims = this.notifyMoving(px, py, pw, ph, x, y, anchorX, anchorY, resizeMode, iLft, iTop, iRgt, iBot);
            if (overrideDims != null) {
                px = overrideDims[0];
                py = overrideDims[1];
                pw = overrideDims[2];
                ph = overrideDims[3];
            }
            if (!xSet) {
                boolean bl = xSet = px != this.x;
            }
            if (!ySet) {
                ySet = py != this.y;
            }
            this.pfReqWidth = (int)Math.ceil(this.fxReqWidth * this.platformScaleX);
            this.pfReqHeight = (int)Math.ceil(this.fxReqHeight * this.platformScaleY);
            this._setBounds(this.getRawHandle(), px, py, xSet, ySet, pw, ph, 0, 0, xGravity, yGravity);
        }
    }

    protected int[] notifyMoving(int x, int y, int w, int h, float fx_x, float fx_y, int anchorX, int anchorY, int resizeMode, int iLft, int iTop, int iRgt, int iBot) {
        if (this.screen == null || !this.screen.containsPlatformRect(x, y, w, h)) {
            float bestPortion;
            float f = bestPortion = this.screen == null ? 0.0f : this.screen.portionIntersectsPlatformRect(x, y, w, h);
            if (bestPortion < 0.5f) {
                float relAnchorX = (float)anchorX / this.platformScaleX;
                float relAnchorY = (float)anchorY / this.platformScaleY;
                Screen bestScreen = this.screen;
                int bestx = x;
                int besty = y;
                int bestw = w;
                int besth = h;
                for (Screen scr : Screen.getScreens()) {
                    int newh;
                    int neww;
                    int newy;
                    int newx;
                    if (scr == this.screen) continue;
                    if (resizeMode == 0) {
                        newx = x;
                        newy = y;
                        neww = w;
                        newh = h;
                    } else {
                        int newcw = (int)Math.ceil(this.fxReqWidth * scr.getPlatformScaleX());
                        int newch = (int)Math.ceil(this.fxReqHeight * scr.getPlatformScaleY());
                        neww = newcw + iLft + iRgt;
                        newh = newch + iTop + iBot;
                        if (resizeMode == 1) {
                            newx = x + anchorX - Math.round(relAnchorX * scr.getPlatformScaleX());
                            newy = y + anchorY - Math.round(relAnchorY * scr.getPlatformScaleY());
                        } else {
                            newx = scr.toPlatformX(fx_x);
                            newy = scr.toPlatformY(fx_y);
                        }
                    }
                    float portion = scr.portionIntersectsPlatformRect(newx, newy, neww, newh);
                    if (this.screen != null && (!(portion > 0.6f) || !(portion > bestPortion))) continue;
                    bestPortion = portion;
                    bestScreen = scr;
                    bestx = newx;
                    besty = newy;
                    bestw = neww;
                    besth = newh;
                }
                if (bestScreen != this.screen) {
                    this.notifyMoveToAnotherScreen(bestScreen);
                    this.notifyScaleChanged(bestScreen.getPlatformScaleX(), bestScreen.getPlatformScaleY(), bestScreen.getRecommendedOutputScaleX(), bestScreen.getRecommendedOutputScaleY());
                    if (this.view != null) {
                        this.view.updateLocation();
                    }
                    if (resizeMode == 0) {
                        return null;
                    }
                    return new int[]{bestx, besty, bestw, besth};
                }
            }
        }
        return null;
    }

    @Override
    protected void notifyResize(int type, int width, int height) {
        float oldScaleX = this.platformScaleX;
        float oldScaleY = this.platformScaleY;
        long insets = this._getInsets(this.getRawHandle());
        int iLft = (int)(insets >> 48) & 0xFFFF;
        int iTop = (int)(insets >> 32) & 0xFFFF;
        int iRgt = (int)(insets >> 16) & 0xFFFF;
        int iBot = (int)insets & 0xFFFF;
        int pcw = width - iLft - iRgt;
        int pch = height - iTop - iBot;
        if (pcw != this.pfReqWidth || oldScaleX != this.platformScaleX) {
            this.fxReqWidth = (float)pcw / this.platformScaleX;
            this.pfReqWidth = pcw;
        }
        if (pch != this.pfReqHeight || oldScaleY != this.platformScaleY) {
            this.fxReqHeight = (float)pch / this.platformScaleY;
            this.pfReqHeight = pch;
        }
        super.notifyResize(type, width, height);
    }

    protected native boolean _setBackground2(long var1, float var3, float var4, float var5);

    @Override
    protected boolean _setBackground(long ptr, float r, float g, float b) {
        return true;
    }

    private native long _getInsets(long var1);

    private native long _getAnchor(long var1);

    @Override
    protected native long _createWindow(long var1, long var3, int var5);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native boolean _setView(long var1, View var3);

    @Override
    protected native boolean _setMenubar(long var1, long var3);

    @Override
    protected native boolean _minimize(long var1, boolean var3);

    @Override
    protected native boolean _maximize(long var1, boolean var3, boolean var4);

    @Override
    protected native void _setBounds(long var1, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, float var11, float var12);

    @Override
    protected native boolean _setVisible(long var1, boolean var3);

    @Override
    protected native boolean _setResizable(long var1, boolean var3);

    @Override
    protected native boolean _requestFocus(long var1, int var3);

    @Override
    protected native void _setFocusable(long var1, boolean var3);

    @Override
    protected native boolean _setTitle(long var1, String var3);

    @Override
    protected native void _setLevel(long var1, int var3);

    @Override
    protected native void _setAlpha(long var1, float var3);

    @Override
    protected native void _setEnabled(long var1, boolean var3);

    @Override
    protected native boolean _setMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMaximumSize(long var1, int var3, int var4);

    @Override
    protected native void _setIcon(long var1, Pixels var3);

    @Override
    protected native void _toFront(long var1);

    @Override
    protected native void _toBack(long var1);

    @Override
    protected native void _enterModal(long var1);

    @Override
    protected native void _enterModalWithWindow(long var1, long var3);

    @Override
    protected native void _exitModal(long var1);

    @Override
    protected native boolean _grabFocus(long var1);

    @Override
    protected native void _ungrabFocus(long var1);

    @Override
    protected native void _setCursor(long var1, Cursor var3);

    @Override
    protected void _requestInput(long ptr, String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long ptr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void setDeferredClosing(boolean dc) {
        this.deferredClosing = dc;
        if (!this.deferredClosing && this.closingRequested) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.deferredClosing) {
            super.close();
        } else {
            this.closingRequested = true;
            this.setVisible(false);
        }
    }

    static {
        WinWindow._initIDs();
    }
}

