/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.css.CompoundSelector;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.css.StyleClass;

public final class SelectorPartitioning {
    private final Map<PartitionKey, Partition> idMap = new HashMap<PartitionKey, Partition>();
    private final Map<PartitionKey, Partition> typeMap = new HashMap<PartitionKey, Partition>();
    private final Map<PartitionKey, Partition> styleClassMap = new HashMap<PartitionKey, Partition>();
    private int ordinal;
    private static final int ID_BIT = 4;
    private static final int TYPE_BIT = 2;
    private static final int STYLECLASS_BIT = 1;
    private static final PartitionKey WILDCARD = new PartitionKey<String>("*");
    private static final Comparator<Selector> COMPARATOR = (o1, o2) -> o1.getOrdinal() - o2.getOrdinal();

    public void reset() {
        this.idMap.clear();
        this.typeMap.clear();
        this.styleClassMap.clear();
        this.ordinal = 0;
    }

    private static Partition getPartition(PartitionKey id, Map<PartitionKey, Partition> map) {
        Partition treeNode = map.get(id);
        if (treeNode == null) {
            treeNode = new Partition(id);
            map.put(id, treeNode);
        }
        return treeNode;
    }

    public void partition(Selector selector) {
        SimpleSelector simpleSelector = null;
        if (selector instanceof CompoundSelector) {
            List<SimpleSelector> selectors = ((CompoundSelector)selector).getSelectors();
            int last = selectors.size() - 1;
            simpleSelector = selectors.get(last);
        } else {
            simpleSelector = (SimpleSelector)selector;
        }
        String selectorId = simpleSelector.getId();
        boolean hasId = selectorId != null && !selectorId.isEmpty();
        PartitionKey<String> idKey = hasId ? new PartitionKey<String>(selectorId) : null;
        String selectorType = simpleSelector.getName();
        boolean hasType = selectorType != null && !selectorType.isEmpty();
        PartitionKey<String> typeKey = hasType ? new PartitionKey<String>(selectorType) : null;
        Set<StyleClass> selectorStyleClass = simpleSelector.getStyleClassSet();
        boolean hasStyleClass = selectorStyleClass != null && selectorStyleClass.size() > 0;
        PartitionKey<Set<StyleClass>> styleClassKey = hasStyleClass ? new PartitionKey<Set<StyleClass>>(selectorStyleClass) : null;
        int c = (hasId ? 4 : 0) | (hasType ? 2 : 0) | (hasStyleClass ? 1 : 0);
        Partition partition = null;
        Slot slot = null;
        selector.setOrdinal(this.ordinal++);
        switch (c) {
            case 6: 
            case 7: {
                partition = SelectorPartitioning.getPartition(idKey, this.idMap);
                slot = partition.partition(typeKey, this.typeMap);
                if ((c & 1) == 1) {
                    slot = slot.partition(styleClassKey, this.styleClassMap);
                }
                slot.addSelector(selector);
                break;
            }
            case 2: 
            case 3: {
                partition = SelectorPartitioning.getPartition(typeKey, this.typeMap);
                if ((c & 1) == 1) {
                    slot = partition.partition(styleClassKey, this.styleClassMap);
                    slot.addSelector(selector);
                    break;
                }
                partition.addSelector(selector);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public List<Selector> match(String selectorId, String selectorType, Set<StyleClass> selectorStyleClass) {
        boolean hasId = selectorId != null && !selectorId.isEmpty();
        PartitionKey<String> idKey = hasId ? new PartitionKey<String>(selectorId) : null;
        boolean hasType = selectorType != null && !selectorType.isEmpty();
        PartitionKey typeKey = hasType ? new PartitionKey(selectorType) : null;
        boolean hasStyleClass = selectorStyleClass != null && selectorStyleClass.size() > 0;
        PartitionKey<Set<StyleClass>> styleClassKey = hasStyleClass ? new PartitionKey<Set<StyleClass>>(selectorStyleClass) : null;
        int c = (hasId ? 4 : 0) | (hasType ? 2 : 0) | (hasStyleClass ? 1 : 0);
        Partition partition = null;
        Slot slot = null;
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        block6: while (c != 0) {
            switch (c) {
                case 6: 
                case 7: {
                    Set other;
                    Set key;
                    PartitionKey typePK;
                    partition = this.idMap.get(idKey);
                    if (partition != null) {
                        if (partition.selectors != null) {
                            selectors.addAll(partition.selectors);
                        }
                        typePK = typeKey;
                        do {
                            if ((slot = partition.slots.get(typePK)) == null) continue;
                            if (slot.selectors != null) {
                                selectors.addAll(slot.selectors);
                            }
                            if ((c & 1) != 1) continue;
                            key = (Set)styleClassKey.key;
                            for (Slot s : slot.referents.values()) {
                                if (s.selectors == null || s.selectors.isEmpty() || !key.containsAll(other = (Set)s.partition.key.key)) continue;
                                selectors.addAll(s.selectors);
                            }
                        } while ((typePK = !WILDCARD.equals(typePK) ? WILDCARD : null) != null);
                    }
                    c -= 4;
                    continue block6;
                }
                case 4: 
                case 5: {
                    c -= 4;
                    continue block6;
                }
                case 2: 
                case 3: {
                    Set other;
                    Set key;
                    PartitionKey typePK = typeKey;
                    do {
                        if ((partition = this.typeMap.get(typePK)) == null) continue;
                        if (partition.selectors != null) {
                            selectors.addAll(partition.selectors);
                        }
                        if ((c & 1) != 1) continue;
                        key = (Set)styleClassKey.key;
                        for (Slot s : partition.slots.values()) {
                            if (s.selectors == null || s.selectors.isEmpty() || !key.containsAll(other = (Set)s.partition.key.key)) continue;
                            selectors.addAll(s.selectors);
                        }
                    } while ((typePK = !WILDCARD.equals(typePK) ? WILDCARD : null) != null);
                    c -= 2;
                    continue block6;
                }
                case 1: {
                    --c;
                    continue block6;
                }
            }
            assert (false);
        }
        Collections.sort(selectors, COMPARATOR);
        return selectors;
    }

    private static final class Slot {
        private final Partition partition;
        private final Map<PartitionKey, Slot> referents;
        private List<Selector> selectors;

        private Slot(Partition partition) {
            this.partition = partition;
            this.referents = new HashMap<PartitionKey, Slot>();
        }

        private void addSelector(Selector pair) {
            if (this.selectors == null) {
                this.selectors = new ArrayList<Selector>();
            }
            this.selectors.add(pair);
        }

        private Slot partition(PartitionKey id, Map<PartitionKey, Partition> map) {
            Slot slot = this.referents.get(id);
            if (slot == null) {
                Partition p = SelectorPartitioning.getPartition(id, map);
                slot = new Slot(p);
                this.referents.put(id, slot);
            }
            return slot;
        }
    }

    private static final class Partition {
        private final PartitionKey key;
        private final Map<PartitionKey, Slot> slots;
        private List<Selector> selectors;

        private Partition(PartitionKey key) {
            this.key = key;
            this.slots = new HashMap<PartitionKey, Slot>();
        }

        private void addSelector(Selector pair) {
            if (this.selectors == null) {
                this.selectors = new ArrayList<Selector>();
            }
            this.selectors.add(pair);
        }

        private Slot partition(PartitionKey id, Map<PartitionKey, Partition> map) {
            Slot slot = this.slots.get(id);
            if (slot == null) {
                Partition partition = SelectorPartitioning.getPartition(id, map);
                slot = new Slot(partition);
                this.slots.put(id, slot);
            }
            return slot;
        }
    }

    private static final class PartitionKey<K> {
        private final K key;

        private PartitionKey(K key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionKey other = (PartitionKey)obj;
            return this.key == other.key || this.key != null && this.key.equals(other.key);
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.key != null ? this.key.hashCode() : 0);
            return hash;
        }
    }
}

