/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.CanTransformVec3d;
import com.sun.javafx.geom.transform.Identity;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.geom.transform.Translate2D;

public abstract class BaseTransform
implements CanTransformVec3d {
    public static final BaseTransform IDENTITY_TRANSFORM = new Identity();
    protected static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_AFFINE2D_MASK = 127;
    public static final int TYPE_AFFINE_3D = 128;
    static final double EPSILON_ABSOLUTE = 1.0E-5;

    static void degreeError(Degree maxSupported) {
        throw new InternalError("does not support higher than " + maxSupported + " operations");
    }

    public static BaseTransform getInstance(BaseTransform tx) {
        if (tx.isIdentity()) {
            return IDENTITY_TRANSFORM;
        }
        if (tx.isTranslateOrIdentity()) {
            return new Translate2D(tx);
        }
        if (tx.is2D()) {
            return new Affine2D(tx);
        }
        return new Affine3D(tx);
    }

    public static BaseTransform getInstance(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz == 0.0 && myz == 0.0 && mzx == 0.0 && mzy == 0.0 && mzz == 1.0 && mzt == 0.0) {
            return BaseTransform.getInstance(mxx, myx, mxy, myy, mxt, myt);
        }
        return new Affine3D(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
    }

    public static BaseTransform getInstance(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx == 1.0 && myx == 0.0 && mxy == 0.0 && myy == 1.0) {
            return BaseTransform.getTranslateInstance(mxt, myt);
        }
        return new Affine2D(mxx, myx, mxy, myy, mxt, myt);
    }

    public static BaseTransform getTranslateInstance(double mxt, double myt) {
        if (mxt == 0.0 && myt == 0.0) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate2D(mxt, myt);
    }

    public static BaseTransform getScaleInstance(double mxx, double myy) {
        return BaseTransform.getInstance(mxx, 0.0, 0.0, myy, 0.0, 0.0);
    }

    public static BaseTransform getRotateInstance(double theta, double x, double y) {
        Affine2D a = new Affine2D();
        a.setToRotation(theta, x, y);
        return a;
    }

    public abstract Degree getDegree();

    public abstract int getType();

    public abstract boolean isIdentity();

    public abstract boolean isTranslateOrIdentity();

    public abstract boolean is2D();

    public abstract double getDeterminant();

    public double getMxx() {
        return 1.0;
    }

    public double getMxy() {
        return 0.0;
    }

    public double getMxz() {
        return 0.0;
    }

    public double getMxt() {
        return 0.0;
    }

    public double getMyx() {
        return 0.0;
    }

    public double getMyy() {
        return 1.0;
    }

    public double getMyz() {
        return 0.0;
    }

    public double getMyt() {
        return 0.0;
    }

    public double getMzx() {
        return 0.0;
    }

    public double getMzy() {
        return 0.0;
    }

    public double getMzz() {
        return 1.0;
    }

    public double getMzt() {
        return 0.0;
    }

    public abstract Point2D transform(Point2D var1, Point2D var2);

    public abstract Point2D inverseTransform(Point2D var1, Point2D var2) throws NoninvertibleTransformException;

    @Override
    public abstract Vec3d transform(Vec3d var1, Vec3d var2);

    public abstract Vec3d deltaTransform(Vec3d var1, Vec3d var2);

    public abstract Vec3d inverseTransform(Vec3d var1, Vec3d var2) throws NoninvertibleTransformException;

    public abstract Vec3d inverseDeltaTransform(Vec3d var1, Vec3d var2) throws NoninvertibleTransformException;

    public abstract void transform(float[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void transform(double[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void transform(float[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void transform(double[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void deltaTransform(float[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void deltaTransform(double[] var1, int var2, double[] var3, int var4, int var5);

    public abstract void inverseTransform(float[] var1, int var2, float[] var3, int var4, int var5) throws NoninvertibleTransformException;

    public abstract void inverseDeltaTransform(float[] var1, int var2, float[] var3, int var4, int var5) throws NoninvertibleTransformException;

    public abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4, int var5) throws NoninvertibleTransformException;

    public abstract BaseBounds transform(BaseBounds var1, BaseBounds var2);

    public abstract void transform(Rectangle var1, Rectangle var2);

    public abstract BaseBounds inverseTransform(BaseBounds var1, BaseBounds var2) throws NoninvertibleTransformException;

    public abstract void inverseTransform(Rectangle var1, Rectangle var2) throws NoninvertibleTransformException;

    public abstract Shape createTransformedShape(Shape var1);

    public abstract void setToIdentity();

    public abstract void setTransform(BaseTransform var1);

    public abstract void invert() throws NoninvertibleTransformException;

    public abstract void restoreTransform(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract void restoreTransform(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);

    public abstract BaseTransform deriveWithTranslation(double var1, double var3);

    public abstract BaseTransform deriveWithTranslation(double var1, double var3, double var5);

    public abstract BaseTransform deriveWithScale(double var1, double var3, double var5);

    public abstract BaseTransform deriveWithRotation(double var1, double var3, double var5, double var7);

    public abstract BaseTransform deriveWithPreTranslation(double var1, double var3);

    public abstract BaseTransform deriveWithConcatenation(double var1, double var3, double var5, double var7, double var9, double var11);

    public abstract BaseTransform deriveWithConcatenation(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);

    public abstract BaseTransform deriveWithPreConcatenation(BaseTransform var1);

    public abstract BaseTransform deriveWithConcatenation(BaseTransform var1);

    public abstract BaseTransform deriveWithNewTransform(BaseTransform var1);

    public abstract BaseTransform createInverse() throws NoninvertibleTransformException;

    public abstract BaseTransform copy();

    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        long bits = 0L;
        bits = bits * 31L + Double.doubleToLongBits(this.getMzz());
        bits = bits * 31L + Double.doubleToLongBits(this.getMzy());
        bits = bits * 31L + Double.doubleToLongBits(this.getMzx());
        bits = bits * 31L + Double.doubleToLongBits(this.getMyz());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxz());
        bits = bits * 31L + Double.doubleToLongBits(this.getMyy());
        bits = bits * 31L + Double.doubleToLongBits(this.getMyx());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxy());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxx());
        bits = bits * 31L + Double.doubleToLongBits(this.getMzt());
        bits = bits * 31L + Double.doubleToLongBits(this.getMyt());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxt());
        return (int)bits ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseTransform)) {
            return false;
        }
        BaseTransform a = (BaseTransform)obj;
        return this.getMxx() == a.getMxx() && this.getMxy() == a.getMxy() && this.getMxz() == a.getMxz() && this.getMxt() == a.getMxt() && this.getMyx() == a.getMyx() && this.getMyy() == a.getMyy() && this.getMyz() == a.getMyz() && this.getMyt() == a.getMyt() && this.getMzx() == a.getMzx() && this.getMzy() == a.getMzy() && this.getMzz() == a.getMzz() && this.getMzt() == a.getMzt();
    }

    static Point2D makePoint(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = new Point2D();
        }
        return dst;
    }

    public static boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    public String toString() {
        return "Matrix: degree " + this.getDegree() + "\n" + this.getMxx() + ", " + this.getMxy() + ", " + this.getMxz() + ", " + this.getMxt() + "\n" + this.getMyx() + ", " + this.getMyy() + ", " + this.getMyz() + ", " + this.getMyt() + "\n" + this.getMzx() + ", " + this.getMzy() + ", " + this.getMzz() + ", " + this.getMzt() + "\n";
    }

    public static enum Degree {
        IDENTITY,
        TRANSLATE_2D,
        AFFINE_2D,
        TRANSLATE_3D,
        AFFINE_3D;

    }
}

