/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import com.sun.javafx.util.DataURI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private static final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private static final ImageLoaderFactory[] loaderFactories;
    private static final boolean isIOS;
    private static int maxSignatureLength;

    public static ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] formats = new ImageFormatDescription[loaderFactories.length];
        for (int i = 0; i < loaderFactories.length; ++i) {
            formats[i] = loaderFactories[i].getFormatDescription();
        }
        return formats;
    }

    public static int getNumBands(ImageType type) {
        int numBands = -1;
        switch (type) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                numBands = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                numBands = 2;
                break;
            }
            case RGB: {
                numBands = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                numBands = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + type);
            }
        }
        return numBands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImageLoaderFactory(ImageLoaderFactory factory) {
        ImageFormatDescription desc = factory.getFormatDescription();
        for (ImageFormatDescription.Signature signature : desc.getSignatures()) {
            loaderFactoriesBySignature.put(signature, factory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            maxSignatureLength = -1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ImageFrame[] loadAll(InputStream input, ImageLoadListener listener, double width, double height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images;
        block8: {
            ImageLoader loader = null;
            images = null;
            try {
                loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(input) : ImageStorage.getLoaderBySignature(input, listener);
                if (loader != null) {
                    images = ImageStorage.loadAll(loader, width, height, preserveAspectRatio, pixelScale, smooth);
                    break block8;
                }
                throw new ImageStorageException("No loader for image data");
            }
            catch (ImageStorageException ise) {
                throw ise;
            }
            catch (IOException e) {
                throw new ImageStorageException(e.getMessage(), e);
            }
            finally {
                if (loader != null) {
                    loader.dispose();
                }
            }
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFrame[] loadAll(String input, ImageLoadListener listener, double width, double height, boolean preserveAspectRatio, float devPixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images;
        block21: {
            if (input == null || input.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            images = null;
            InputStream theStream = null;
            ImageLoader loader = null;
            try {
                float imgPixelScale = 1.0f;
                try {
                    if (devPixelScale >= 1.5f) {
                        try {
                            String name2x = ImageTools.getScaledImageName(input);
                            theStream = ImageTools.createInputStream(name2x);
                            imgPixelScale = 2.0f;
                        }
                        catch (IOException name2x) {
                            // empty catch block
                        }
                    }
                    if (theStream == null) {
                        try {
                            theStream = ImageTools.createInputStream(input);
                        }
                        catch (IOException ex) {
                            DataURI dataUri = DataURI.tryParse(input);
                            if (dataUri != null) {
                                String mimeType = dataUri.getMimeType();
                                if (mimeType != null && !"image".equalsIgnoreCase(dataUri.getMimeType())) {
                                    throw new IllegalArgumentException("Unexpected MIME type: " + dataUri.getMimeType());
                                }
                                theStream = new ByteArrayInputStream(dataUri.getData());
                            }
                            throw ex;
                        }
                    }
                    loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(theStream) : ImageStorage.getLoaderBySignature(theStream, listener);
                }
                catch (Exception e) {
                    throw new ImageStorageException(e.getMessage(), e);
                }
                if (loader != null) {
                    images = ImageStorage.loadAll(loader, width, height, preserveAspectRatio, imgPixelScale, smooth);
                    break block21;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                if (loader != null) {
                    loader.dispose();
                }
                try {
                    if (theStream != null) {
                        theStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return images;
    }

    private static synchronized int getMaxSignatureLength() {
        if (maxSignatureLength < 0) {
            maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature : loaderFactoriesBySignature.keySet()) {
                int signatureLength = signature.getLength();
                if (maxSignatureLength >= signatureLength) continue;
                maxSignatureLength = signatureLength;
            }
        }
        return maxSignatureLength;
    }

    private static ImageFrame[] loadAll(ImageLoader loader, double width, double height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images = null;
        ArrayList<ImageFrame> list = new ArrayList<ImageFrame>();
        int imageIndex = 0;
        ImageFrame image = null;
        int imgw = (int)Math.round(width * (double)pixelScale);
        int imgh = (int)Math.round(height * (double)pixelScale);
        while (true) {
            try {
                image = loader.load(imageIndex++, imgw, imgh, preserveAspectRatio, smooth);
            }
            catch (Exception e) {
                if (imageIndex > 1) break;
                throw new ImageStorageException(e.getMessage(), e);
            }
            if (image == null) break;
            image.setPixelScale(pixelScale);
            list.add(image);
        }
        int numImages = list.size();
        if (numImages > 0) {
            images = new ImageFrame[numImages];
            list.toArray(images);
        }
        return images;
    }

    private static ImageLoader getLoaderBySignature(InputStream stream, ImageLoadListener listener) throws IOException {
        byte[] header = new byte[ImageStorage.getMaxSignatureLength()];
        ImageTools.readFully(stream, header);
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> factoryRegistration : loaderFactoriesBySignature.entrySet()) {
            if (!factoryRegistration.getKey().matches(header)) continue;
            ByteArrayInputStream headerStream = new ByteArrayInputStream(header);
            SequenceInputStream seqStream = new SequenceInputStream(headerStream, stream);
            ImageLoader loader = factoryRegistration.getValue().createImageLoader(seqStream);
            if (listener != null) {
                loader.addListener(listener);
            }
            return loader;
        }
        return null;
    }

    private ImageStorage() {
    }

    static {
        isIOS = PlatformUtil.isIOS();
        loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
        loaderFactoriesBySignature = new HashMap(loaderFactories.length);
        for (int i = 0; i < loaderFactories.length; ++i) {
            ImageStorage.addImageLoaderFactory(loaderFactories[i]);
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

