/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.scene.LightBaseHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.util.Utils;
import javafx.scene.DirectionalLight;
import javafx.scene.Node;

public class DirectionalLightHelper
extends LightBaseHelper {
    private static final DirectionalLightHelper theInstance = new DirectionalLightHelper();
    private static DirectionalLightAccessor directionalLightAccessor;

    private static DirectionalLightHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(DirectionalLight directionalLight) {
        DirectionalLightHelper.setHelper(directionalLight, DirectionalLightHelper.getInstance());
    }

    @Override
    protected NGNode createPeerImpl(Node node) {
        return directionalLightAccessor.doCreatePeer(node);
    }

    @Override
    protected void updatePeerImpl(Node node) {
        super.updatePeerImpl(node);
        directionalLightAccessor.doUpdatePeer(node);
    }

    public static void setDirectionalLightAccessor(DirectionalLightAccessor newAccessor) {
        if (directionalLightAccessor != null) {
            throw new IllegalStateException("Accessor already exists");
        }
        directionalLightAccessor = newAccessor;
    }

    static {
        Utils.forceInit(DirectionalLight.class);
    }

    public static interface DirectionalLightAccessor {
        public NGNode doCreatePeer(Node var1);

        public void doUpdatePeer(Node var1);
    }
}

