/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public class TreeShowingExpression
extends BooleanExpression {
    private final ChangeListener<Boolean> windowShowingChangedListener = (obs, old, current) -> this.updateTreeShowing();
    private final ChangeListener<Window> sceneWindowChangedListener = (obs, old, current) -> this.windowChanged((Window)old, (Window)current);
    private final ChangeListener<Scene> nodeSceneChangedListener = (obs, old, current) -> this.sceneChanged((Scene)old, (Scene)current);
    private final Node node;
    private ExpressionHelper<Boolean> helper;
    private boolean valid;
    private boolean treeShowing;

    public TreeShowingExpression(Node node) {
        this.node = node;
        this.node.sceneProperty().addListener(this.nodeSceneChangedListener);
        NodeHelper.treeVisibleProperty(node).addListener(this.windowShowingChangedListener);
        this.sceneChanged(null, node.getScene());
    }

    public void dispose() {
        this.node.sceneProperty().removeListener(this.nodeSceneChangedListener);
        NodeHelper.treeVisibleProperty(this.node).removeListener(this.windowShowingChangedListener);
        this.valid = false;
        this.sceneChanged(this.node.getScene(), null);
    }

    public void addListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, (InvalidationListener)listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, (InvalidationListener)listener);
    }

    public void addListener(ChangeListener<? super Boolean> listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, listener);
    }

    public void removeListener(ChangeListener<? super Boolean> listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    protected void invalidate() {
        if (this.valid) {
            this.valid = false;
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }
    }

    public boolean get() {
        if (!this.valid) {
            this.updateTreeShowing();
            this.valid = true;
        }
        return this.treeShowing;
    }

    private void sceneChanged(Scene oldScene, Scene newScene) {
        if (oldScene != null) {
            oldScene.windowProperty().removeListener(this.sceneWindowChangedListener);
        }
        if (newScene != null) {
            newScene.windowProperty().addListener(this.sceneWindowChangedListener);
        }
        this.windowChanged(oldScene == null ? null : oldScene.getWindow(), newScene == null ? null : newScene.getWindow());
    }

    private void windowChanged(Window oldWindow, Window newWindow) {
        if (oldWindow != null) {
            oldWindow.showingProperty().removeListener(this.windowShowingChangedListener);
        }
        if (newWindow != null) {
            newWindow.showingProperty().addListener(this.windowShowingChangedListener);
        }
        this.updateTreeShowing();
    }

    private void updateTreeShowing() {
        boolean newValue = NodeHelper.isTreeShowing(this.node);
        if (newValue != this.treeShowing) {
            this.treeShowing = newValue;
            this.invalidate();
        }
    }
}

