/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.sg.prism.NGAmbientLight;
import com.sun.javafx.sg.prism.NGDirectionalLight;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPhongMaterial;
import com.sun.javafx.sg.prism.NGPointLight;
import com.sun.javafx.sg.prism.NGTriangleMesh;
import com.sun.javafx.util.Utils;
import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.MeshView;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;

public abstract class NGShape3D
extends NGNode {
    private NGPhongMaterial material;
    private DrawMode drawMode;
    private CullFace cullFace;
    private boolean materialDirty = false;
    private boolean drawModeDirty = false;
    NGTriangleMesh mesh;
    private MeshView meshView;

    public void setMaterial(NGPhongMaterial material) {
        this.material = material;
        this.materialDirty = true;
        this.visualsChanged();
    }

    public void setDrawMode(Object drawMode) {
        this.drawMode = (DrawMode)((Object)drawMode);
        this.drawModeDirty = true;
        this.visualsChanged();
    }

    public void setCullFace(Object cullFace) {
        this.cullFace = (CullFace)((Object)cullFace);
        this.visualsChanged();
    }

    void invalidate() {
        this.meshView = null;
        this.visualsChanged();
    }

    private void renderMeshView(Graphics g) {
        g.setup3DRendering();
        ResourceFactory rf = g.getResourceFactory();
        if (rf == null || rf.isDisposed()) {
            return;
        }
        if (this.meshView != null && !this.meshView.isValid()) {
            this.meshView.dispose();
            this.meshView = null;
        }
        if (this.meshView == null && this.mesh != null) {
            this.meshView = rf.createMeshView(this.mesh.createMesh(rf));
            this.drawModeDirty = true;
            this.materialDirty = true;
        }
        if (this.meshView == null || !this.mesh.validate()) {
            return;
        }
        Material mtl = this.material.createMaterial(rf);
        if (this.materialDirty) {
            this.meshView.setMaterial(mtl);
            this.materialDirty = false;
        }
        int cullingMode = this.cullFace.ordinal();
        if (this.cullFace.ordinal() != MeshView.CULL_NONE && g.getTransformNoClone().getDeterminant() < 0.0) {
            cullingMode = cullingMode == MeshView.CULL_BACK ? MeshView.CULL_FRONT : MeshView.CULL_BACK;
        }
        this.meshView.setCullingMode(cullingMode);
        if (this.drawModeDirty) {
            this.meshView.setWireframe(this.drawMode == DrawMode.LINE);
            this.drawModeDirty = false;
        }
        int lightIndex = 0;
        if (g.getLights() == null || g.getLights()[0] == null) {
            this.meshView.setAmbientLight(0.0f, 0.0f, 0.0f);
            Vec3d cameraPos = g.getCameraNoClone().getPositionInWorld(null);
            this.meshView.setLight(lightIndex++, (float)cameraPos.x, (float)cameraPos.y, (float)cameraPos.z, 1.0f, 1.0f, 1.0f, 1.0f, NGPointLight.getDefaultCa(), NGPointLight.getDefaultLa(), NGPointLight.getDefaultQa(), 1.0f, NGPointLight.getDefaultMaxRange(), (float)NGPointLight.getSimulatedDirection().getX(), (float)NGPointLight.getSimulatedDirection().getY(), (float)NGPointLight.getSimulatedDirection().getZ(), NGPointLight.getSimulatedInnerAngle(), NGPointLight.getSimulatedOuterAngle(), NGPointLight.getSimulatedFalloff());
        } else {
            float ambientRed = 0.0f;
            float ambientBlue = 0.0f;
            float ambientGreen = 0.0f;
            for (NGLightBase lightBase : g.getLights()) {
                NGLightBase light;
                if (lightBase == null) break;
                if (!lightBase.affects(this)) continue;
                float rL = lightBase.getColor().getRed();
                float gL = lightBase.getColor().getGreen();
                float bL = lightBase.getColor().getBlue();
                if (rL == 0.0f && gL == 0.0f && bL == 0.0f) continue;
                if (lightBase instanceof NGPointLight) {
                    light = (NGPointLight)lightBase;
                    Affine3D lightWT = light.getWorldTransform();
                    this.meshView.setLight(lightIndex++, (float)lightWT.getMxt(), (float)lightWT.getMyt(), (float)lightWT.getMzt(), rL, gL, bL, 1.0f, ((NGPointLight)light).getCa(), ((NGPointLight)light).getLa(), ((NGPointLight)light).getQa(), 1.0f, ((NGPointLight)light).getMaxRange(), (float)((NGPointLight)light).getDirection().getX(), (float)((NGPointLight)light).getDirection().getY(), (float)((NGPointLight)light).getDirection().getZ(), ((NGPointLight)light).getInnerAngle(), ((NGPointLight)light).getOuterAngle(), ((NGPointLight)light).getFalloff());
                    continue;
                }
                if (lightBase instanceof NGDirectionalLight) {
                    light = (NGDirectionalLight)lightBase;
                    this.meshView.setLight(lightIndex++, 0.0f, 0.0f, 0.0f, rL, gL, bL, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, Float.POSITIVE_INFINITY, (float)((NGDirectionalLight)light).getDirection().getX(), (float)((NGDirectionalLight)light).getDirection().getY(), (float)((NGDirectionalLight)light).getDirection().getZ(), 0.0f, 0.0f, 0.0f);
                    continue;
                }
                if (!(lightBase instanceof NGAmbientLight)) continue;
                ambientRed += rL;
                ambientGreen += gL;
                ambientBlue += bL;
            }
            ambientRed = Utils.clamp(0.0f, ambientRed, 1.0f);
            ambientGreen = Utils.clamp(0.0f, ambientGreen, 1.0f);
            ambientBlue = Utils.clamp(0.0f, ambientBlue, 1.0f);
            this.meshView.setAmbientLight(ambientRed, ambientGreen, ambientBlue);
        }
        while (lightIndex < 3) {
            this.meshView.setLight(lightIndex++, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        }
        this.meshView.render(g);
    }

    public void setMesh(NGTriangleMesh triangleMesh) {
        this.mesh = triangleMesh;
        this.meshView = null;
        this.visualsChanged();
    }

    @Override
    protected void renderContent(Graphics g) {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D) || this.material == null || g instanceof PrinterGraphics) {
            return;
        }
        this.renderMeshView(g);
    }

    @Override
    boolean isShape3D() {
        return true;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    @Override
    public void release() {
    }
}

