/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Vector;

class ShapeEvaluator {
    private Shape savedv0;
    private Shape savedv1;
    private Geometry geom0;
    private Geometry geom1;

    ShapeEvaluator() {
    }

    public Shape evaluate(Shape v0, Shape v1, float fraction) {
        if (this.savedv0 != v0 || this.savedv1 != v1) {
            if (this.savedv0 == v1 && this.savedv1 == v0) {
                Geometry gtmp = this.geom0;
                this.geom0 = this.geom1;
                this.geom1 = gtmp;
            } else {
                this.recalculate(v0, v1);
            }
            this.savedv0 = v0;
            this.savedv1 = v1;
        }
        return this.getShape(fraction);
    }

    private void recalculate(Shape v0, Shape v1) {
        this.geom0 = new Geometry(v0);
        this.geom1 = new Geometry(v1);
        float[] tvals0 = this.geom0.getTvals();
        float[] tvals1 = this.geom1.getTvals();
        float[] combinedTvals = ShapeEvaluator.mergeTvals(tvals0, tvals1);
        this.geom0.setTvals(combinedTvals);
        this.geom1.setTvals(combinedTvals);
    }

    private Shape getShape(float fraction) {
        return new MorphedShape(this.geom0, this.geom1, fraction);
    }

    private static float[] mergeTvals(float[] tvals0, float[] tvals1) {
        int count = ShapeEvaluator.sortTvals(tvals0, tvals1, null);
        float[] newtvals = new float[count];
        ShapeEvaluator.sortTvals(tvals0, tvals1, newtvals);
        return newtvals;
    }

    private static int sortTvals(float[] tvals0, float[] tvals1, float[] newtvals) {
        int i0 = 0;
        int i1 = 0;
        int numtvals = 0;
        while (i0 < tvals0.length && i1 < tvals1.length) {
            float t0 = tvals0[i0];
            float t1 = tvals1[i1];
            if (t0 <= t1) {
                if (newtvals != null) {
                    newtvals[numtvals] = t0;
                }
                ++i0;
            }
            if (t1 <= t0) {
                if (newtvals != null) {
                    newtvals[numtvals] = t1;
                }
                ++i1;
            }
            ++numtvals;
        }
        return numtvals;
    }

    private static float interp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }

    private static class Iterator
    implements PathIterator {
        BaseTransform at;
        Geometry g0;
        Geometry g1;
        float t;
        int cindex;

        public Iterator(BaseTransform at, Geometry g0, Geometry g1, float t) {
            this.at = at;
            this.g0 = g0;
            this.g1 = g1;
            this.t = t;
        }

        @Override
        public int getWindingRule() {
            return (double)this.t < 0.5 ? this.g0.getWindingRule() : this.g1.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.cindex > this.g0.getNumCoords();
        }

        @Override
        public void next() {
            this.cindex = this.cindex == 0 ? 2 : (this.cindex += 6);
        }

        @Override
        public int currentSegment(float[] coords) {
            int n;
            int type;
            if (this.cindex == 0) {
                type = 0;
                n = 2;
            } else if (this.cindex >= this.g0.getNumCoords()) {
                type = 4;
                n = 0;
            } else {
                type = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    coords[i] = ShapeEvaluator.interp(this.g0.getCoord(this.cindex + i), this.g1.getCoord(this.cindex + i), this.t);
                }
                if (this.at != null) {
                    this.at.transform(coords, 0, coords, 0, n / 2);
                }
            }
            return type;
        }
    }

    private static class MorphedShape
    extends Shape {
        Geometry geom0;
        Geometry geom1;
        float t;

        MorphedShape(Geometry geom0, Geometry geom1, float t) {
            this.geom0 = geom0;
            this.geom1 = geom1;
            this.t = t;
        }

        public Rectangle getRectangle() {
            return new Rectangle(this.getBounds());
        }

        @Override
        public RectBounds getBounds() {
            float ymax;
            float xmax;
            int n = this.geom0.getNumCoords();
            float xmin = xmax = ShapeEvaluator.interp(this.geom0.getCoord(0), this.geom1.getCoord(0), this.t);
            float ymin = ymax = ShapeEvaluator.interp(this.geom0.getCoord(1), this.geom1.getCoord(1), this.t);
            for (int i = 2; i < n; i += 2) {
                float x = ShapeEvaluator.interp(this.geom0.getCoord(i), this.geom1.getCoord(i), this.t);
                float y = ShapeEvaluator.interp(this.geom0.getCoord(i + 1), this.geom1.getCoord(i + 1), this.t);
                if (xmin > x) {
                    xmin = x;
                }
                if (ymin > y) {
                    ymin = y;
                }
                if (xmax < x) {
                    xmax = x;
                }
                if (!(ymax < y)) continue;
                ymax = y;
            }
            return new RectBounds(xmin, ymin, xmax, ymax);
        }

        @Override
        public boolean contains(float x, float y) {
            return Path2D.contains(this.getPathIterator(null), x, y);
        }

        @Override
        public boolean intersects(float x, float y, float w, float h) {
            return Path2D.intersects(this.getPathIterator(null), x, y, w, h);
        }

        @Override
        public boolean contains(float x, float y, float width, float height) {
            return Path2D.contains(this.getPathIterator(null), x, y, width, height);
        }

        @Override
        public PathIterator getPathIterator(BaseTransform at) {
            return new Iterator(at, this.geom0, this.geom1, this.t);
        }

        @Override
        public PathIterator getPathIterator(BaseTransform at, float flatness) {
            return new FlatteningPathIterator(this.getPathIterator(at), flatness);
        }

        @Override
        public Shape copy() {
            return new Path2D(this);
        }
    }

    private static class Geometry {
        static final float THIRD = 0.33333334f;
        static final float MIN_LEN = 0.001f;
        float[] bezierCoords = new float[20];
        int numCoords;
        int windingrule;
        float[] myTvals;

        public Geometry(Shape s) {
            int i;
            float newy;
            float newx;
            float movy;
            float movx;
            PathIterator pi = s.getPathIterator(null);
            this.windingrule = pi.getWindingRule();
            if (pi.isDone()) {
                this.numCoords = 8;
            }
            float[] coords = new float[6];
            int type = pi.currentSegment(coords);
            pi.next();
            if (type != 0) {
                throw new IllegalPathStateException("missing initial moveto");
            }
            float curx = movx = coords[0];
            this.bezierCoords[0] = movx;
            float cury = movy = coords[1];
            this.bezierCoords[1] = movy;
            Vector<Point2D> savedpathendpoints = new Vector<Point2D>();
            this.numCoords = 2;
            while (!pi.isDone()) {
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        if (curx != movx || cury != movy) {
                            this.appendLineTo(curx, cury, movx, movy);
                            curx = movx;
                            cury = movy;
                        }
                        newx = coords[0];
                        newy = coords[1];
                        if (curx == newx && cury == newy) break;
                        savedpathendpoints.add(new Point2D(movx, movy));
                        this.appendLineTo(curx, cury, newx, newy);
                        curx = movx = newx;
                        cury = movy = newy;
                        break;
                    }
                    case 4: {
                        if (curx == movx && cury == movy) break;
                        this.appendLineTo(curx, cury, movx, movy);
                        curx = movx;
                        cury = movy;
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        this.appendLineTo(curx, cury, newx, newy);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        float ctrlx = coords[0];
                        float ctrly = coords[1];
                        newx = coords[2];
                        newy = coords[3];
                        this.appendQuadTo(curx, cury, ctrlx, ctrly, newx, newy);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        curx = coords[4];
                        cury = coords[5];
                        this.appendCubicTo(coords[0], coords[1], coords[2], coords[3], curx, cury);
                    }
                }
                pi.next();
            }
            if (this.numCoords < 8 || curx != movx || cury != movy) {
                this.appendLineTo(curx, cury, movx, movy);
                curx = movx;
                cury = movy;
            }
            for (int i2 = savedpathendpoints.size() - 1; i2 >= 0; --i2) {
                Point2D p = (Point2D)savedpathendpoints.get(i2);
                newx = p.x;
                newy = p.y;
                if (curx == newx && cury == newy) continue;
                this.appendLineTo(curx, cury, newx, newy);
                curx = newx;
                cury = newy;
            }
            int minPt = 0;
            float minX = this.bezierCoords[0];
            float minY = this.bezierCoords[1];
            for (int ci = 6; ci < this.numCoords; ci += 6) {
                float x = this.bezierCoords[ci];
                float y = this.bezierCoords[ci + 1];
                if (!(y < minY) && (y != minY || !(x < minX))) continue;
                minPt = ci;
                minX = x;
                minY = y;
            }
            if (minPt > 0) {
                float[] newCoords = new float[this.numCoords];
                System.arraycopy(this.bezierCoords, minPt, newCoords, 0, this.numCoords - minPt);
                System.arraycopy(this.bezierCoords, 2, newCoords, this.numCoords - minPt, minPt);
                this.bezierCoords = newCoords;
            }
            float area = 0.0f;
            curx = this.bezierCoords[0];
            cury = this.bezierCoords[1];
            for (i = 2; i < this.numCoords; i += 2) {
                newx = this.bezierCoords[i];
                newy = this.bezierCoords[i + 1];
                area += curx * newy - newx * cury;
                curx = newx;
                cury = newy;
            }
            if (area < 0.0f) {
                i = 2;
                for (int j = this.numCoords - 4; i < j; i += 2, j -= 2) {
                    curx = this.bezierCoords[i];
                    cury = this.bezierCoords[i + 1];
                    this.bezierCoords[i] = this.bezierCoords[j];
                    this.bezierCoords[i + 1] = this.bezierCoords[j + 1];
                    this.bezierCoords[j] = curx;
                    this.bezierCoords[j + 1] = cury;
                }
            }
        }

        private void appendLineTo(float x0, float y0, float x1, float y1) {
            this.appendCubicTo(ShapeEvaluator.interp(x0, x1, 0.33333334f), ShapeEvaluator.interp(y0, y1, 0.33333334f), ShapeEvaluator.interp(x1, x0, 0.33333334f), ShapeEvaluator.interp(y1, y0, 0.33333334f), x1, y1);
        }

        private void appendQuadTo(float x0, float y0, float ctrlx, float ctrly, float x1, float y1) {
            this.appendCubicTo(ShapeEvaluator.interp(ctrlx, x0, 0.33333334f), ShapeEvaluator.interp(ctrly, y0, 0.33333334f), ShapeEvaluator.interp(ctrlx, x1, 0.33333334f), ShapeEvaluator.interp(ctrly, y1, 0.33333334f), x1, y1);
        }

        private void appendCubicTo(float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x1, float y1) {
            if (this.numCoords + 6 > this.bezierCoords.length) {
                int newsize = (this.numCoords - 2) * 2 + 2;
                float[] newCoords = new float[newsize];
                System.arraycopy(this.bezierCoords, 0, newCoords, 0, this.numCoords);
                this.bezierCoords = newCoords;
            }
            this.bezierCoords[this.numCoords++] = ctrlx1;
            this.bezierCoords[this.numCoords++] = ctrly1;
            this.bezierCoords[this.numCoords++] = ctrlx2;
            this.bezierCoords[this.numCoords++] = ctrly2;
            this.bezierCoords[this.numCoords++] = x1;
            this.bezierCoords[this.numCoords++] = y1;
        }

        public int getWindingRule() {
            return this.windingrule;
        }

        public int getNumCoords() {
            return this.numCoords;
        }

        public float getCoord(int i) {
            return this.bezierCoords[i];
        }

        public float[] getTvals() {
            if (this.myTvals != null) {
                return this.myTvals;
            }
            float[] tvals = new float[(this.numCoords - 2) / 6 + 1];
            float segx = this.bezierCoords[0];
            float segy = this.bezierCoords[1];
            float tlen = 0.0f;
            int ci = 2;
            int ti = 0;
            while (ci < this.numCoords) {
                float prevx = segx;
                float prevy = segy;
                float newx = this.bezierCoords[ci++];
                float newy = this.bezierCoords[ci++];
                float len = (float)Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += (float)Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                prevx = newx;
                prevy = newy;
                newx = this.bezierCoords[ci++];
                newy = this.bezierCoords[ci++];
                len += (float)Math.sqrt((prevx -= newx) * prevx + (prevy -= newy) * prevy);
                len += (float)Math.sqrt((segx -= newx) * segx + (segy -= newy) * segy);
                if ((len /= 2.0f) < 0.001f) {
                    len = 0.001f;
                }
                tvals[ti++] = tlen += len;
                segx = newx;
                segy = newy;
            }
            float prevt = tvals[0];
            tvals[0] = 0.0f;
            for (ti = 1; ti < tvals.length - 1; ++ti) {
                float nextt = tvals[ti];
                tvals[ti] = prevt / tlen;
                prevt = nextt;
            }
            tvals[ti] = 1.0f;
            this.myTvals = tvals;
            return tvals;
        }

        public void setTvals(float[] newTvals) {
            float y1;
            float x1;
            float[] oldCoords = this.bezierCoords;
            float[] newCoords = new float[2 + (newTvals.length - 1) * 6];
            float[] oldTvals = this.getTvals();
            int oldci = 0;
            float xc1 = x1 = oldCoords[oldci++];
            float xc0 = x1;
            float x0 = x1;
            float yc1 = y1 = oldCoords[oldci++];
            float yc0 = y1;
            float y0 = y1;
            int newci = 0;
            newCoords[newci++] = x0;
            newCoords[newci++] = y0;
            float t0 = 0.0f;
            float t1 = 0.0f;
            int oldti = 1;
            int newti = 1;
            while (newti < newTvals.length) {
                if (t0 >= t1) {
                    x0 = x1;
                    y0 = y1;
                    xc0 = oldCoords[oldci++];
                    yc0 = oldCoords[oldci++];
                    xc1 = oldCoords[oldci++];
                    yc1 = oldCoords[oldci++];
                    x1 = oldCoords[oldci++];
                    y1 = oldCoords[oldci++];
                    t1 = oldTvals[oldti++];
                }
                int n = newti++;
                float nt = newTvals[n];
                if (nt < t1) {
                    float relt = (nt - t0) / (t1 - t0);
                    newCoords[newci++] = x0 = ShapeEvaluator.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = ShapeEvaluator.interp(y0, yc0, relt);
                    xc0 = ShapeEvaluator.interp(xc0, xc1, relt);
                    yc0 = ShapeEvaluator.interp(yc0, yc1, relt);
                    xc1 = ShapeEvaluator.interp(xc1, x1, relt);
                    yc1 = ShapeEvaluator.interp(yc1, y1, relt);
                    newCoords[newci++] = x0 = ShapeEvaluator.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = ShapeEvaluator.interp(y0, yc0, relt);
                    xc0 = ShapeEvaluator.interp(xc0, xc1, relt);
                    yc0 = ShapeEvaluator.interp(yc0, yc1, relt);
                    newCoords[newci++] = x0 = ShapeEvaluator.interp(x0, xc0, relt);
                    newCoords[newci++] = y0 = ShapeEvaluator.interp(y0, yc0, relt);
                } else {
                    newCoords[newci++] = xc0;
                    newCoords[newci++] = yc0;
                    newCoords[newci++] = xc1;
                    newCoords[newci++] = yc1;
                    newCoords[newci++] = x1;
                    newCoords[newci++] = y1;
                }
                t0 = nt;
            }
            this.bezierCoords = newCoords;
            this.numCoords = newCoords.length;
            this.myTvals = newTvals;
        }
    }
}

