/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.impl.Disposer;

final class PresentingPainter
extends ViewPainter {
    PresentingPainter(ViewScene view) {
        super(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean locked = false;
        boolean valid = false;
        boolean errored = false;
        try {
            valid = this.validateStageGraphics();
            if (!valid) {
                if (QuantumToolkit.verbose) {
                    System.err.println("PresentingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            this.sceneState.lock();
            locked = true;
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                this.sceneState.getScene().entireSceneNeedsRepaint();
                this.factory = null;
                return;
            }
            if (this.presentable != null && this.presentable.lockResources(this.sceneState)) {
                this.disposePresentable();
            }
            if (this.presentable == null) {
                this.presentable = this.factory.createPresentable(this.sceneState);
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.freshBackBuffer = true;
            }
            if (this.presentable != null) {
                Graphics g = this.presentable.createGraphics();
                ViewScene vs = (ViewScene)this.sceneState.getScene();
                if (g != null) {
                    this.paintImpl(g);
                    this.freshBackBuffer = false;
                }
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.newPhase((String)"Presenting");
                }
                if (!this.presentable.prepare(null)) {
                    this.disposePresentable();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    return;
                }
                if (vs.getDoPresent() && !this.presentable.present()) {
                    this.disposePresentable();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                }
            }
        }
        catch (Throwable th) {
            errored = true;
            th.printStackTrace(System.err);
        }
        finally {
            Disposer.cleanUp();
            if (locked) {
                this.sceneState.unlock();
            }
            ViewScene viewScene = (ViewScene)this.sceneState.getScene();
            viewScene.setPainting(false);
            if (this.factory != null) {
                this.factory.getTextureResourcePool().freeDisposalRequestedAndCheckResources(errored);
            }
            renderLock.unlock();
        }
    }
}

