/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.input.DragboardHelper;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.text.PrismTextLayoutFactory;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PathIteratorHelper;
import com.sun.javafx.tk.quantum.PerformanceTrackerImpl;
import com.sun.javafx.tk.quantum.PrimaryTimer;
import com.sun.javafx.tk.quantum.PrismImageLoader2;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import java.io.File;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javafx.application.ConditionalFeature;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public final class QuantumToolkit
extends Toolkit {
    public static final boolean verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.verbose"));
    public static final boolean pulseDebug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.pulse"));
    private static final boolean multithreaded = AccessController.doPrivileged(() -> {
        String value = System.getProperty("quantum.multithreaded");
        if (value == null) {
            return true;
        }
        boolean result = Boolean.parseBoolean(value);
        if (verbose) {
            System.out.println(result ? "Multi-Threading Enabled" : "Multi-Threading Disabled");
        }
        return result;
    });
    private static boolean debug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.debug"));
    private static Integer pulseHZ = AccessController.doPrivileged(() -> Integer.getInteger("javafx.animation.pulse"));
    static final boolean liveResize = AccessController.doPrivileged(() -> {
        boolean isSWT = "swt".equals(System.getProperty("glass.platform"));
        String result = (PlatformUtil.isMac() || PlatformUtil.isWindows()) && !isSWT ? "true" : "false";
        return "true".equals(System.getProperty("javafx.live.resize", result));
    });
    static final boolean drawInPaint = AccessController.doPrivileged(() -> {
        boolean isSWT = "swt".equals(System.getProperty("glass.platform"));
        String result = PlatformUtil.isMac() && isSWT ? "true" : "false";
        return "true".equals(System.getProperty("javafx.draw.in.paint", result));
    });
    private static boolean singleThreaded = AccessController.doPrivileged(() -> {
        Boolean result = Boolean.getBoolean("quantum.singlethreaded");
        if (result.booleanValue()) {
            System.out.println("Warning: Single GUI Threadiong is enabled, FPS should be slower");
        }
        return result;
    });
    private static boolean noRenderJobs = AccessController.doPrivileged(() -> {
        Boolean result = Boolean.getBoolean("quantum.norenderjobs");
        if (result.booleanValue()) {
            System.out.println("Warning: Quantum will not submit render jobs, nothing should draw");
        }
        return result;
    });
    private AtomicBoolean toolkitRunning = new AtomicBoolean(false);
    private PulseTask animationRunning = new PulseTask(false);
    private PulseTask nextPulseRequested = new PulseTask(false);
    private AtomicBoolean pulseRunning = new AtomicBoolean(false);
    private int inPulse = 0;
    private CountDownLatch launchLatch = new CountDownLatch(1);
    final int PULSE_INTERVAL = (int)(TimeUnit.SECONDS.toMillis(1L) / (long)this.getRefreshRate());
    final int FULLSPEED_INTERVAL = 1;
    boolean nativeSystemVsync = false;
    private long firstPauseRequestTime = 0L;
    private boolean pauseRequested = false;
    private static final long PAUSE_THRESHOLD_DURATION = 250L;
    private float _maxPixelScale;
    private Runnable pulseRunnable;
    private Runnable userRunnable;
    private Runnable timerRunnable;
    private Timer pulseTimer = null;
    private Thread shutdownHook = null;
    private PaintCollector collector;
    private QuantumRenderer renderer;
    private GraphicsPipeline pipeline;
    private ClassLoader ccl;
    private HashMap<Object, EventLoop> eventLoopMap = null;
    private final PerformanceTracker perfTracker = new PerformanceTrackerImpl();
    private static ScreenConfigurationAccessor screenAccessor = new ScreenConfigurationAccessor(){

        @Override
        public int getMinX(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getX();
        }

        @Override
        public int getMinY(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getY();
        }

        @Override
        public int getWidth(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getWidth();
        }

        @Override
        public int getHeight(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getHeight();
        }

        @Override
        public int getVisualMinX(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getVisibleX();
        }

        @Override
        public int getVisualMinY(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getVisibleY();
        }

        @Override
        public int getVisualWidth(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getVisibleWidth();
        }

        @Override
        public int getVisualHeight(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getVisibleHeight();
        }

        @Override
        public float getDPI(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getResolutionX();
        }

        @Override
        public float getRecommendedOutputScaleX(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getRecommendedOutputScaleX();
        }

        @Override
        public float getRecommendedOutputScaleY(Object obj) {
            return ((com.sun.glass.ui.Screen)obj).getRecommendedOutputScaleY();
        }
    };
    private Map<Object, Object> contextMap = Collections.synchronizedMap(new HashMap());
    private DelayedRunnable animationRunnable;
    static BasicStroke tmpStroke = new BasicStroke();
    private QuantumClipboard clipboard;
    private GlassSystemMenu systemMenu = new GlassSystemMenu();

    @Override
    public boolean init() {
        this.renderer = QuantumRenderer.getInstance();
        this.collector = PaintCollector.createInstance(this);
        this.pipeline = GraphicsPipeline.getPipeline();
        this.shutdownHook = new Thread("Glass/Prism Shutdown Hook"){

            @Override
            public void run() {
                QuantumToolkit.this.dispose();
            }
        };
        Void dummy = AccessController.doPrivileged(() -> {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            return null;
        });
        return true;
    }

    @Override
    public void startup(Runnable userStartupRunnable) {
        this.ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.userRunnable = userStartupRunnable;
            Application.run(() -> this.runToolkit());
        }
        catch (RuntimeException ex) {
            if (verbose) {
                ex.printStackTrace();
            }
            throw ex;
        }
        catch (Throwable t) {
            if (verbose) {
                t.printStackTrace();
            }
            throw new RuntimeException(t);
        }
        try {
            this.launchLatch.await();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    private void assertToolkitRunning() {
    }

    boolean shouldWaitForRenderingToComplete() {
        return !multithreaded;
    }

    private static void initSceneGraph() {
        Screen.getPrimary();
    }

    void runToolkit() {
        Thread user = Thread.currentThread();
        if (!this.toolkitRunning.getAndSet(true)) {
            user.setName("JavaFX Application Thread");
            user.setContextClassLoader(this.ccl);
            QuantumToolkit.setFxUserThread(user);
            QuantumToolkit.assignScreensAdapters();
            this.renderer.createResourceFactory();
            this.pulseRunnable = () -> this.pulseFromQueue();
            this.timerRunnable = () -> {
                try {
                    this.postPulse();
                }
                catch (Throwable th) {
                    th.printStackTrace(System.err);
                }
            };
            this.pulseTimer = Application.GetApplication().createTimer(this.timerRunnable);
            Application.GetApplication().setEventHandler(new Application.EventHandler(){

                @Override
                public void handleQuitAction(Application app, long time) {
                    GlassStage.requestClosingAllWindows();
                }

                @Override
                public boolean handleThemeChanged(String themeName) {
                    String highContrastSchemeName = Application.GetApplication().getHighContrastScheme(themeName);
                    return PlatformImpl.setAccessibilityTheme(highContrastSchemeName);
                }
            });
        }
        QuantumToolkit.initSceneGraph();
        this.launchLatch.countDown();
        try {
            Application.invokeAndWait(this.userRunnable);
            this.userRunnable = null;
            if (this.getPrimaryTimer().isFullspeed()) {
                this.pulseTimer.start(1);
            } else {
                boolean bl = this.nativeSystemVsync = com.sun.glass.ui.Screen.getVideoRefreshPeriod() != 0.0;
                if (this.nativeSystemVsync) {
                    this.pulseTimer.start();
                } else {
                    this.pulseTimer.start(this.PULSE_INTERVAL);
                }
            }
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        finally {
            if (PrismSettings.verbose) {
                System.err.println(" vsync: " + PrismSettings.isVsyncEnabled + " vpipe: " + this.pipeline.isVsyncSupported());
            }
            PerformanceTracker.logEvent("Toolkit.startup - finished");
        }
    }

    public static <T> T runWithoutRenderLock(Supplier<T> supplier) {
        boolean locked = ViewPainter.renderLock.isHeldByCurrentThread();
        try {
            if (locked) {
                ViewPainter.renderLock.unlock();
            }
            T t = supplier.get();
            return t;
        }
        finally {
            if (locked) {
                ViewPainter.renderLock.lock();
            }
        }
    }

    public static <T> T runWithRenderLock(Supplier<T> supplier) {
        ViewPainter.renderLock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            ViewPainter.renderLock.unlock();
        }
    }

    boolean hasNativeSystemVsync() {
        return this.nativeSystemVsync;
    }

    boolean isVsyncEnabled() {
        return PrismSettings.isVsyncEnabled && this.pipeline.isVsyncSupported();
    }

    @Override
    public void checkFxUserThread() {
        super.checkFxUserThread();
        this.renderer.checkRendererIdle();
    }

    protected static Thread getFxUserThread() {
        return Toolkit.getFxUserThread();
    }

    @Override
    public Future addRenderJob(RenderJob r) {
        if (noRenderJobs) {
            CompletionListener listener = r.getCompletionListener();
            if (r instanceof PaintRenderJob) {
                ((PaintRenderJob)r).getScene().setPainting(false);
            }
            if (listener != null) {
                try {
                    listener.done(r);
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            return null;
        }
        if (singleThreaded) {
            r.run();
            return null;
        }
        return this.renderer.submitRenderJob(r);
    }

    void postPulse() {
        if (this.toolkitRunning.get() && (this.animationRunning.get() || this.nextPulseRequested.get()) && !this.setPulseRunning()) {
            Application.invokeLater(this.pulseRunnable);
            if (debug) {
                System.err.println("QT.postPulse@(" + System.nanoTime() + "): " + this.pulseString());
            }
        } else if (!(this.animationRunning.get() || this.nextPulseRequested.get() || this.pulseRunning.get())) {
            this.pauseTimer();
        } else if (debug) {
            System.err.println("QT.postPulse#(" + System.nanoTime() + "): DROP : " + this.pulseString());
        }
    }

    private synchronized void pauseTimer() {
        if (!this.pauseRequested) {
            this.pauseRequested = true;
            this.firstPauseRequestTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.firstPauseRequestTime >= 250L) {
            this.pulseTimer.pause();
            if (debug) {
                System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pausing Timer : " + this.pulseString());
            }
        } else if (debug) {
            System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pause Timer : DROP : " + this.pulseString());
        }
    }

    private synchronized void resumeTimer() {
        this.pauseRequested = false;
        this.pulseTimer.resume();
    }

    private String pulseString() {
        return (this.toolkitRunning.get() ? "T" : "t") + (this.animationRunning.get() ? "A" : "a") + (this.pulseRunning.get() ? "P" : "p") + (this.nextPulseRequested.get() ? "N" : "n");
    }

    private boolean setPulseRunning() {
        return this.pulseRunning.getAndSet(true);
    }

    private void endPulseRunning() {
        this.pulseRunning.set(false);
        if (debug) {
            System.err.println("QT.endPulse: " + System.nanoTime());
        }
    }

    void pulseFromQueue() {
        try {
            this.pulse();
        }
        finally {
            this.endPulseRunning();
        }
    }

    protected void pulse() {
        this.pulse(true);
    }

    void pulse(boolean collect) {
        try {
            ++this.inPulse;
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.pulseStart();
            }
            if (!this.toolkitRunning.get()) {
                return;
            }
            this.nextPulseRequested.set(false);
            if (this.animationRunnable != null) {
                this.animationRunning.set(true);
                this.animationRunnable.run();
            } else {
                this.animationRunning.set(false);
            }
            this.firePulse();
            if (collect) {
                this.collector.renderAll();
            }
        }
        finally {
            --this.inPulse;
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.pulseEnd();
            }
        }
    }

    void vsyncHint() {
        if (this.isVsyncEnabled()) {
            if (debug) {
                System.err.println("QT.vsyncHint: postPulse: " + System.nanoTime());
            }
            this.postPulse();
        }
    }

    @Override
    public TKStage createTKStage(Window peerWindow, boolean securityDialog, StageStyle stageStyle, boolean primary, Modality modality, TKStage owner, boolean rtl, AccessControlContext acc) {
        this.assertToolkitRunning();
        WindowStage stage = new WindowStage(peerWindow, securityDialog, stageStyle, modality, owner);
        stage.setSecurityContext(acc);
        if (primary) {
            stage.setIsPrimary();
        }
        stage.setRTL(rtl);
        stage.init(this.systemMenu);
        return stage;
    }

    @Override
    public boolean canStartNestedEventLoop() {
        return this.inPulse == 0;
    }

    @Override
    public Object enterNestedEventLoop(Object key) {
        this.checkFxUserThread();
        if (key == null) {
            throw new NullPointerException();
        }
        if (!this.canStartNestedEventLoop()) {
            throw new IllegalStateException("Cannot enter nested loop during animation or layout processing");
        }
        if (this.eventLoopMap == null) {
            this.eventLoopMap = new HashMap();
        }
        if (this.eventLoopMap.containsKey(key)) {
            throw new IllegalArgumentException("Key already associated with a running event loop: " + key);
        }
        EventLoop eventLoop = Application.GetApplication().createEventLoop();
        this.eventLoopMap.put(key, eventLoop);
        Object ret = eventLoop.enter();
        if (!this.isNestedLoopRunning()) {
            this.notifyLastNestedLoopExited();
        }
        return ret;
    }

    @Override
    public void exitNestedEventLoop(Object key, Object rval) {
        this.checkFxUserThread();
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.eventLoopMap == null || !this.eventLoopMap.containsKey(key)) {
            throw new IllegalArgumentException("Key not associated with a running event loop: " + key);
        }
        EventLoop eventLoop = this.eventLoopMap.get(key);
        this.eventLoopMap.remove(key);
        eventLoop.leave(rval);
    }

    @Override
    public void exitAllNestedEventLoops() {
        this.checkFxUserThread();
        for (EventLoop eventLoop : this.eventLoopMap.values()) {
            eventLoop.leave(null);
        }
        this.eventLoopMap.clear();
        this.eventLoopMap = null;
    }

    @Override
    public TKStage createTKPopupStage(Window peerWindow, StageStyle popupStyle, TKStage owner, AccessControlContext acc) {
        this.assertToolkitRunning();
        boolean securityDialog = owner instanceof WindowStage ? ((WindowStage)owner).isSecurityDialog() : false;
        WindowStage stage = new WindowStage(peerWindow, securityDialog, popupStyle, null, owner);
        stage.setSecurityContext(acc);
        stage.setIsPopup();
        stage.init(this.systemMenu);
        return stage;
    }

    @Override
    public TKStage createTKEmbeddedStage(HostInterface host, AccessControlContext acc) {
        this.assertToolkitRunning();
        EmbeddedStage stage = new EmbeddedStage(host);
        stage.setSecurityContext(acc);
        return stage;
    }

    @Override
    public ScreenConfigurationAccessor setScreenConfigurationListener(final TKScreenConfigurationListener listener) {
        com.sun.glass.ui.Screen.setEventHandler(new Screen.EventHandler(){

            @Override
            public void handleSettingsChanged() {
                QuantumToolkit.notifyScreenListener(listener);
            }
        });
        return screenAccessor;
    }

    private static void assignScreensAdapters() {
        GraphicsPipeline pipeline = GraphicsPipeline.getPipeline();
        for (com.sun.glass.ui.Screen screen : com.sun.glass.ui.Screen.getScreens()) {
            screen.setAdapterOrdinal(pipeline.getAdapterOrdinal(screen));
        }
    }

    private static void notifyScreenListener(TKScreenConfigurationListener listener) {
        QuantumToolkit.assignScreensAdapters();
        listener.screenConfigurationChanged();
    }

    @Override
    public Object getPrimaryScreen() {
        return com.sun.glass.ui.Screen.getMainScreen();
    }

    @Override
    public List<?> getScreens() {
        return com.sun.glass.ui.Screen.getScreens();
    }

    @Override
    public ScreenConfigurationAccessor getScreenConfigurationAccessor() {
        return screenAccessor;
    }

    @Override
    public PerformanceTracker getPerformanceTracker() {
        return this.perfTracker;
    }

    @Override
    public PerformanceTracker createPerformanceTracker() {
        return new PerformanceTrackerImpl();
    }

    private float getMaxRenderScale() {
        if (this._maxPixelScale == 0.0f) {
            for (Object o : this.getScreens()) {
                this._maxPixelScale = Math.max(this._maxPixelScale, ((com.sun.glass.ui.Screen)o).getRecommendedOutputScaleX());
                this._maxPixelScale = Math.max(this._maxPixelScale, ((com.sun.glass.ui.Screen)o).getRecommendedOutputScaleY());
            }
        }
        return this._maxPixelScale;
    }

    @Override
    public ImageLoader loadImage(String url, double width, double height, boolean preserveRatio, boolean smooth) {
        return new PrismImageLoader2(url, width, height, preserveRatio, this.getMaxRenderScale(), smooth);
    }

    @Override
    public ImageLoader loadImage(InputStream stream, double width, double height, boolean preserveRatio, boolean smooth) {
        return new PrismImageLoader2(stream, width, height, preserveRatio, smooth);
    }

    public AbstractRemoteResource<? extends ImageLoader> loadImageAsync(AsyncOperationListener listener, String url, double width, double height, boolean preserveRatio, boolean smooth) {
        return new PrismImageLoader2.AsyncImageLoader(listener, url, width, height, preserveRatio, smooth);
    }

    @Override
    public void defer(Runnable runnable) {
        if (!this.toolkitRunning.get()) {
            return;
        }
        Application.invokeLater(runnable);
    }

    @Override
    public void exit() {
        this.checkFxUserThread();
        this.pulseTimer.stop();
        PaintCollector.getInstance().waitForRenderingToComplete();
        this.notifyShutdownHooks();
        QuantumToolkit.runWithRenderLock(() -> {
            Application app = Application.GetApplication();
            app.terminate();
            return null;
        });
        this.dispose();
        super.exit();
    }

    public void dispose() {
        if (this.toolkitRunning.compareAndSet(true, false)) {
            this.pulseTimer.stop();
            this.renderer.stopRenderer();
            try {
                AccessController.doPrivileged(() -> {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    return null;
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isForwardTraversalKey(KeyEvent e) {
        return e.getCode() == KeyCode.TAB && e.getEventType() == KeyEvent.KEY_PRESSED && !e.isShiftDown();
    }

    @Override
    public boolean isBackwardTraversalKey(KeyEvent e) {
        return e.getCode() == KeyCode.TAB && e.getEventType() == KeyEvent.KEY_PRESSED && e.isShiftDown();
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public int getRefreshRate() {
        if (pulseHZ == null) {
            return 60;
        }
        return pulseHZ;
    }

    @Override
    public void setAnimationRunnable(DelayedRunnable animationRunnable) {
        if (animationRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = animationRunnable;
    }

    @Override
    public void requestNextPulse() {
        this.nextPulseRequested.set(true);
    }

    @Override
    public void waitFor(Toolkit.Task t) {
        if (t.isFinished()) {
            return;
        }
    }

    @Override
    protected Object createColorPaint(Color color) {
        return new com.sun.prism.paint.Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    private com.sun.prism.paint.Color toPrismColor(Color color) {
        return (com.sun.prism.paint.Color)Toolkit.getPaintAccessor().getPlatformPaint(color);
    }

    private List<Stop> convertStops(List<javafx.scene.paint.Stop> paintStops) {
        ArrayList<Stop> stops = new ArrayList<Stop>(paintStops.size());
        for (javafx.scene.paint.Stop s : paintStops) {
            stops.add(new Stop(this.toPrismColor(s.getColor()), (float)s.getOffset()));
        }
        return stops;
    }

    @Override
    protected Object createLinearGradientPaint(javafx.scene.paint.LinearGradient paint) {
        int cmi = 2;
        CycleMethod cycleMethod = paint.getCycleMethod();
        if (cycleMethod == CycleMethod.NO_CYCLE) {
            cmi = 0;
        } else if (cycleMethod == CycleMethod.REFLECT) {
            cmi = 1;
        }
        List<Stop> stops = this.convertStops(paint.getStops());
        return new LinearGradient((float)paint.getStartX(), (float)paint.getStartY(), (float)paint.getEndX(), (float)paint.getEndY(), null, paint.isProportional(), cmi, stops);
    }

    @Override
    protected Object createRadialGradientPaint(javafx.scene.paint.RadialGradient paint) {
        float cx = (float)paint.getCenterX();
        float cy = (float)paint.getCenterY();
        float fa = (float)paint.getFocusAngle();
        float fd = (float)paint.getFocusDistance();
        int cmi = 0;
        cmi = paint.getCycleMethod() == CycleMethod.NO_CYCLE ? 0 : (paint.getCycleMethod() == CycleMethod.REFLECT ? 1 : 2);
        List<Stop> stops = this.convertStops(paint.getStops());
        return new RadialGradient(cx, cy, fa, fd, (float)paint.getRadius(), null, paint.isProportional(), cmi, stops);
    }

    @Override
    protected Object createImagePatternPaint(ImagePattern paint) {
        if (paint.getImage() == null) {
            return com.sun.prism.paint.Color.TRANSPARENT;
        }
        return new com.sun.prism.paint.ImagePattern((com.sun.prism.Image)Toolkit.getImageAccessor().getPlatformImage(paint.getImage()), (float)paint.getX(), (float)paint.getY(), (float)paint.getWidth(), (float)paint.getHeight(), paint.isProportional(), Toolkit.getPaintAccessor().isMutable(paint));
    }

    private void initStroke(StrokeType pgtype, double strokewidth, StrokeLineCap pgcap, StrokeLineJoin pgjoin, float miterLimit, float[] dashArray, float dashOffset) {
        int type = pgtype == StrokeType.CENTERED ? 0 : (pgtype == StrokeType.INSIDE ? 1 : 2);
        int cap = pgcap == StrokeLineCap.BUTT ? 0 : (pgcap == StrokeLineCap.SQUARE ? 2 : 1);
        int join = pgjoin == StrokeLineJoin.BEVEL ? 2 : (pgjoin == StrokeLineJoin.MITER ? 0 : 1);
        tmpStroke.set(type, (float)strokewidth, cap, join, miterLimit);
        if (dashArray != null && dashArray.length > 0) {
            tmpStroke.set(dashArray, dashOffset);
        } else {
            tmpStroke.set((float[])null, 0.0f);
        }
    }

    @Override
    public void accumulateStrokeBounds(Shape shape, float[] bbox, StrokeType pgtype, double strokewidth, StrokeLineCap pgcap, StrokeLineJoin pgjoin, float miterLimit, BaseTransform tx) {
        this.initStroke(pgtype, strokewidth, pgcap, pgjoin, miterLimit, null, 0.0f);
        if (tx.isTranslateOrIdentity()) {
            tmpStroke.accumulateShapeBounds(bbox, shape, tx);
        } else {
            Shape.accumulate(bbox, tmpStroke.createStrokedShape(shape), tx);
        }
    }

    @Override
    public boolean strokeContains(Shape shape, double x, double y, StrokeType pgtype, double strokewidth, StrokeLineCap pgcap, StrokeLineJoin pgjoin, float miterLimit) {
        this.initStroke(pgtype, strokewidth, pgcap, pgjoin, miterLimit, null, 0.0f);
        return tmpStroke.createStrokedShape(shape).contains((float)x, (float)y);
    }

    @Override
    public Shape createStrokedShape(Shape shape, StrokeType pgtype, double strokewidth, StrokeLineCap pgcap, StrokeLineJoin pgjoin, float miterLimit, float[] dashArray, float dashOffset) {
        this.initStroke(pgtype, strokewidth, pgcap, pgjoin, miterLimit, dashArray, dashOffset);
        return tmpStroke.createStrokedShape(shape);
    }

    @Override
    public Dimension2D getBestCursorSize(int preferredWidth, int preferredHeight) {
        return CursorUtils.getBestCursorSize(preferredWidth, preferredHeight);
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    public int getKeyCodeForChar(String character) {
        return character.length() == 1 ? com.sun.glass.events.KeyEvent.getKeyCodeForChar(character.charAt(0)) : 0;
    }

    @Override
    public PathElement[] convertShapeToFXPath(Object shape) {
        if (shape == null) {
            return new PathElement[0];
        }
        ArrayList<MoveTo> elements = new ArrayList<MoveTo>();
        Shape geomShape = (Shape)shape;
        PathIterator itr = geomShape.getPathIterator(null);
        PathIteratorHelper helper = new PathIteratorHelper(itr);
        PathIteratorHelper.Struct struct = new PathIteratorHelper.Struct();
        while (!helper.isDone()) {
            PathElement el;
            boolean windEvenOdd = helper.getWindingRule() == 0;
            int type = helper.currentSegment(struct);
            if (type == 0) {
                el = new MoveTo(struct.f0, struct.f1);
            } else if (type == 1) {
                el = new LineTo(struct.f0, struct.f1);
            } else if (type == 2) {
                el = new QuadCurveTo(struct.f0, struct.f1, struct.f2, struct.f3);
            } else if (type == 3) {
                el = new CubicCurveTo(struct.f0, struct.f1, struct.f2, struct.f3, struct.f4, struct.f5);
            } else if (type == 4) {
                el = new ClosePath();
            } else {
                throw new IllegalStateException("Invalid element type: " + type);
            }
            helper.next();
            elements.add((MoveTo)el);
        }
        return elements.toArray(new PathElement[elements.size()]);
    }

    @Override
    public Filterable toFilterable(Image img) {
        return PrImage.create((com.sun.prism.Image)Toolkit.getImageAccessor().getPlatformImage(img));
    }

    @Override
    public FilterContext getFilterContext(Object config) {
        if (config == null || !(config instanceof com.sun.glass.ui.Screen)) {
            return PrFilterContext.getDefaultInstance();
        }
        com.sun.glass.ui.Screen screen = (com.sun.glass.ui.Screen)config;
        return PrFilterContext.getInstance(screen);
    }

    @Override
    public AbstractPrimaryTimer getPrimaryTimer() {
        return PrimaryTimer.getInstance();
    }

    @Override
    public FontLoader getFontLoader() {
        return PrismFontLoader.getInstance();
    }

    @Override
    public TextLayoutFactory getTextLayoutFactory() {
        return PrismTextLayoutFactory.getFactory();
    }

    @Override
    public Object createSVGPathObject(SVGPath svgpath) {
        int windingRule = svgpath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path = new Path2D(windingRule);
        path.appendSVGPath(svgpath.getContent());
        return path;
    }

    @Override
    public Path2D createSVGPath2D(SVGPath svgpath) {
        int windingRule = svgpath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path = new Path2D(windingRule);
        path.appendSVGPath(svgpath.getContent());
        return path;
    }

    @Override
    public boolean imageContains(Object image, float x, float y) {
        if (image == null) {
            return false;
        }
        com.sun.prism.Image pImage = (com.sun.prism.Image)image;
        int intX = (int)x + pImage.getMinX();
        int intY = (int)y + pImage.getMinY();
        if (pImage.isOpaque()) {
            return true;
        }
        if (pImage.getPixelFormat() == com.sun.prism.PixelFormat.INT_ARGB_PRE) {
            IntBuffer ib = (IntBuffer)pImage.getPixelBuffer();
            int index = intX + intY * pImage.getRowLength();
            if (index >= ib.limit()) {
                return false;
            }
            return (ib.get(index) & 0xFF000000) != 0;
        }
        if (pImage.getPixelFormat() == com.sun.prism.PixelFormat.BYTE_BGRA_PRE) {
            ByteBuffer bb = (ByteBuffer)pImage.getPixelBuffer();
            int index = intX * pImage.getBytesPerPixelUnit() + intY * pImage.getScanlineStride() + 3;
            if (index >= bb.limit()) {
                return false;
            }
            return (bb.get(index) & 0xFF) != 0;
        }
        if (pImage.getPixelFormat() == com.sun.prism.PixelFormat.BYTE_ALPHA) {
            ByteBuffer bb = (ByteBuffer)pImage.getPixelBuffer();
            int index = intX * pImage.getBytesPerPixelUnit() + intY * pImage.getScanlineStride();
            if (index >= bb.limit()) {
                return false;
            }
            return (bb.get(index) & 0xFF) != 0;
        }
        return true;
    }

    @Override
    public boolean isNestedLoopRunning() {
        return Application.isNestedLoopRunning();
    }

    @Override
    public boolean isSupported(ConditionalFeature feature) {
        switch (feature) {
            case SCENE3D: {
                return GraphicsPipeline.getPipeline().is3DSupported();
            }
            case EFFECT: {
                return GraphicsPipeline.getPipeline().isEffectSupported();
            }
            case SHAPE_CLIP: {
                return true;
            }
            case INPUT_METHOD: {
                return Application.GetApplication().supportsInputMethods();
            }
            case TRANSPARENT_WINDOW: {
                return Application.GetApplication().supportsTransparentWindows();
            }
            case UNIFIED_WINDOW: {
                return Application.GetApplication().supportsUnifiedWindows();
            }
            case TWO_LEVEL_FOCUS: {
                return Application.GetApplication().hasTwoLevelFocus();
            }
            case VIRTUAL_KEYBOARD: {
                return Application.GetApplication().hasVirtualKeyboard();
            }
            case INPUT_TOUCH: {
                return Application.GetApplication().hasTouch();
            }
            case INPUT_MULTITOUCH: {
                return Application.GetApplication().hasMultiTouch();
            }
            case INPUT_POINTER: {
                return Application.GetApplication().hasPointer();
            }
        }
        return false;
    }

    @Override
    public boolean isMSAASupported() {
        return GraphicsPipeline.getPipeline().isMSAASupported();
    }

    private int toGlassKeyCode(KeyCode keyCode) {
        switch (keyCode) {
            case CAPS: {
                return 20;
            }
            case NUM_LOCK: {
                return 144;
            }
        }
        return 0;
    }

    @Override
    public Optional<Boolean> isKeyLocked(KeyCode keyCode) {
        return Application.GetApplication().isKeyLocked(this.toGlassKeyCode(keyCode));
    }

    static TransferMode clipboardActionToTransferMode(int action) {
        switch (action) {
            case 0: {
                return null;
            }
            case 1: 
            case 0x40000001: {
                return TransferMode.COPY;
            }
            case 2: 
            case 0x40000002: {
                return TransferMode.MOVE;
            }
            case 0x40000000: {
                return TransferMode.LINK;
            }
            case 0x4FFFFFFF: {
                return TransferMode.COPY;
            }
        }
        return null;
    }

    @Override
    public TKClipboard getSystemClipboard() {
        if (this.clipboard == null) {
            this.clipboard = QuantumClipboard.getClipboardInstance(new ClipboardAssistance("SYSTEM"));
        }
        return this.clipboard;
    }

    @Override
    public TKSystemMenu getSystemMenu() {
        return this.systemMenu;
    }

    @Override
    public TKClipboard getNamedClipboard(String name) {
        return null;
    }

    @Override
    public void startDrag(TKScene scene, Set<TransferMode> tm, TKDragSourceListener l, Dragboard dragboard) {
        if (dragboard == null) {
            throw new IllegalArgumentException("dragboard should not be null");
        }
        GlassScene view = (GlassScene)scene;
        view.setTKDragSourceListener(l);
        QuantumClipboard gc = (QuantumClipboard)DragboardHelper.getPeer(dragboard);
        gc.setSupportedTransferMode(tm);
        gc.flush();
        gc.close();
    }

    @Override
    public void enableDrop(TKScene s, TKDropTargetListener l) {
        assert (s instanceof GlassScene);
        GlassScene view = (GlassScene)s;
        view.setTKDropTargetListener(l);
    }

    @Override
    public void registerDragGestureListener(TKScene s, Set<TransferMode> tm, TKDragGestureListener l) {
        assert (s instanceof GlassScene);
        GlassScene view = (GlassScene)s;
        view.setTKDragGestureListener(l);
    }

    @Override
    public void installInputMethodRequests(TKScene scene, InputMethodRequests requests) {
        assert (scene instanceof GlassScene);
        GlassScene view = (GlassScene)scene;
        view.setInputMethodRequests(requests);
    }

    @Override
    public ImageLoader loadPlatformImage(Object platformImage) {
        if (platformImage instanceof QuantumImage) {
            return (QuantumImage)platformImage;
        }
        if (platformImage instanceof com.sun.prism.Image) {
            return new QuantumImage((com.sun.prism.Image)platformImage);
        }
        if (platformImage instanceof PixelBuffer) {
            return new QuantumImage((PixelBuffer)platformImage);
        }
        throw new UnsupportedOperationException("unsupported class for loadPlatformImage");
    }

    @Override
    public PlatformImage createPlatformImage(int w, int h) {
        ByteBuffer bytebuf = ByteBuffer.allocate(w * h * 4);
        return com.sun.prism.Image.fromByteBgraPreData(bytebuf, w, h);
    }

    @Override
    public Object renderToImage(Toolkit.ImageRenderingContext p) {
        Object saveImage = p.platformImage;
        final Toolkit.ImageRenderingContext params = p;
        final Paint currentPaint = p.platformPaint instanceof Paint ? (Paint)p.platformPaint : null;
        RenderJob re = new RenderJob(new Runnable(){

            private com.sun.prism.paint.Color getClearColor() {
                if (currentPaint == null) {
                    return com.sun.prism.paint.Color.WHITE;
                }
                if (currentPaint.getType() == Paint.Type.COLOR) {
                    return (com.sun.prism.paint.Color)currentPaint;
                }
                if (currentPaint.isOpaque()) {
                    return com.sun.prism.paint.Color.TRANSPARENT;
                }
                return com.sun.prism.paint.Color.WHITE;
            }

            private void draw(Graphics g, int x, int y, int w, int h) {
                g.setLights(params.lights);
                g.setDepthBuffer(params.depthBuffer);
                g.clear(this.getClearColor());
                if (currentPaint != null && currentPaint.getType() != Paint.Type.COLOR) {
                    g.getRenderTarget().setOpaque(currentPaint.isOpaque());
                    g.setPaint(currentPaint);
                    g.fillQuad(0.0f, 0.0f, w, h);
                }
                if (x != 0 || y != 0) {
                    g.translate(-x, -y);
                }
                if (params.transform != null) {
                    g.transform(params.transform);
                }
                if (params.root != null) {
                    if (params.camera != null) {
                        g.setCamera(params.camera);
                    }
                    NGNode ngNode = params.root;
                    ngNode.render(g);
                }
            }

            private void renderTile(int x, int xOffset, int y, int yOffset, int w, int h, IntBuffer buffer, ResourceFactory rf, QuantumImage tileImg, QuantumImage targetImg) {
                RTTexture rt = tileImg.getRT(w, h, rf);
                if (rt == null) {
                    return;
                }
                Graphics g = rt.createGraphics();
                this.draw(g, x + xOffset, y + yOffset, w, h);
                int[] pixels = rt.getPixels();
                if (pixels != null) {
                    buffer.put(pixels);
                } else {
                    rt.readPixels(buffer, rt.getContentX(), rt.getContentY(), w, h);
                }
                targetImg.image.setPixels(xOffset, yOffset, w, h, PixelFormat.getIntArgbPreInstance(), buffer, w);
                rt.unlock();
            }

            private void renderWholeImage(int x, int y, int w, int h, ResourceFactory rf, QuantumImage pImage) {
                RTTexture rt = pImage.getRT(w, h, rf);
                if (rt == null) {
                    return;
                }
                Graphics g = rt.createGraphics();
                this.draw(g, x, y, w, h);
                int[] pixels = rt.getPixels();
                if (pixels != null) {
                    pImage.setImage(com.sun.prism.Image.fromIntArgbPreData(pixels, w, h));
                } else {
                    IntBuffer ib = IntBuffer.allocate(w * h);
                    if (rt.readPixels(ib, rt.getContentX(), rt.getContentY(), w, h)) {
                        pImage.setImage(com.sun.prism.Image.fromIntArgbPreData(ib, w, h));
                    } else {
                        pImage.dispose();
                        pImage = null;
                    }
                }
                rt.unlock();
            }

            private int computeTileSize(int size, int maxSize) {
                for (int n = 1; n <= 3; ++n) {
                    int optimumSize = size / n;
                    if (optimumSize > maxSize || optimumSize * n != size) continue;
                    return optimumSize;
                }
                return maxSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ResourceFactory rf = GraphicsPipeline.getDefaultResourceFactory();
                if (!rf.isDeviceReady()) {
                    return;
                }
                int x = params.x;
                int y = params.y;
                int w = params.width;
                int h = params.height;
                if (w <= 0 || h <= 0) {
                    return;
                }
                boolean errored = false;
                QuantumImage tileRttCache = null;
                try {
                    QuantumImage pImage = params.platformImage instanceof QuantumImage ? (QuantumImage)params.platformImage : new QuantumImage((com.sun.prism.Image)null);
                    int maxTextureSize = rf.getMaximumTextureSize();
                    if (h > maxTextureSize || w > maxTextureSize) {
                        int bTileYOffset;
                        int bTileHeight;
                        tileRttCache = new QuantumImage((com.sun.prism.Image)null);
                        if (pImage.image == null) {
                            pImage.setImage(com.sun.prism.Image.fromIntArgbPreData(IntBuffer.allocate(w * h), w, h));
                        }
                        int mTileWidth = this.computeTileSize(w, maxTextureSize);
                        int mTileHeight = this.computeTileSize(h, maxTextureSize);
                        IntBuffer buffer = IntBuffer.allocate(mTileWidth * mTileHeight);
                        int mTileXOffset = 0;
                        int mTileYOffset = 0;
                        mTileXOffset = 0;
                        while (mTileXOffset + mTileWidth <= w) {
                            mTileYOffset = 0;
                            while (mTileYOffset + mTileHeight <= h) {
                                this.renderTile(x, mTileXOffset, y, mTileYOffset, mTileWidth, mTileHeight, buffer, rf, tileRttCache, pImage);
                                mTileYOffset += mTileHeight;
                            }
                            mTileXOffset += mTileWidth;
                        }
                        int rTileXOffset = mTileXOffset;
                        int rTileWidth = w - rTileXOffset;
                        if (rTileWidth > 0) {
                            int rTileYOffset = 0;
                            while (rTileYOffset + mTileHeight <= h) {
                                this.renderTile(x, rTileXOffset, y, rTileYOffset, rTileWidth, mTileHeight, buffer, rf, tileRttCache, pImage);
                                rTileYOffset += mTileHeight;
                            }
                        }
                        if ((bTileHeight = h - (bTileYOffset = mTileYOffset)) > 0) {
                            int bTileXOffset = 0;
                            while (bTileXOffset + mTileWidth <= w) {
                                this.renderTile(x, bTileXOffset, y, bTileYOffset, mTileWidth, bTileHeight, buffer, rf, tileRttCache, pImage);
                                bTileXOffset += mTileWidth;
                            }
                        }
                        if (rTileWidth > 0 && bTileHeight > 0) {
                            this.renderTile(x, rTileXOffset, y, bTileYOffset, rTileWidth, bTileHeight, buffer, rf, tileRttCache, pImage);
                        }
                    } else {
                        this.renderWholeImage(x, y, w, h, rf, pImage);
                    }
                    params.platformImage = pImage;
                }
                catch (Throwable t) {
                    errored = true;
                    t.printStackTrace(System.err);
                }
                finally {
                    if (tileRttCache != null) {
                        tileRttCache.dispose();
                    }
                    Disposer.cleanUp();
                    rf.getTextureResourcePool().freeDisposalRequestedAndCheckResources(errored);
                }
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        re.setCompletionListener(job -> latch.countDown());
        this.addRenderJob(re);
        while (true) {
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
        Object image = params.platformImage;
        params.platformImage = saveImage;
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonDialogs.FileChooserResult showFileChooser(TKStage ownerWindow, String title, File initialDirectory, String initialFileName, FileChooserType fileChooserType, List<FileChooser.ExtensionFilter> extensionFilters, FileChooser.ExtensionFilter selectedFilter) {
        WindowStage blockedStage = null;
        try {
            blockedStage = this.blockOwnerStage(ownerWindow);
            CommonDialogs.FileChooserResult fileChooserResult = CommonDialogs.showFileChooser(ownerWindow instanceof WindowStage ? ((WindowStage)ownerWindow).getPlatformWindow() : null, initialDirectory, initialFileName, title, fileChooserType == FileChooserType.SAVE ? 1 : 0, fileChooserType == FileChooserType.OPEN_MULTIPLE, QuantumToolkit.convertExtensionFilters(extensionFilters), extensionFilters.indexOf(selectedFilter));
            return fileChooserResult;
        }
        finally {
            if (blockedStage != null) {
                blockedStage.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File showDirectoryChooser(TKStage ownerWindow, String title, File initialDirectory) {
        WindowStage blockedStage = null;
        try {
            blockedStage = this.blockOwnerStage(ownerWindow);
            File file = CommonDialogs.showFolderChooser(ownerWindow instanceof WindowStage ? ((WindowStage)ownerWindow).getPlatformWindow() : null, initialDirectory, title);
            return file;
        }
        finally {
            if (blockedStage != null) {
                blockedStage.setEnabled(true);
            }
        }
    }

    private WindowStage blockOwnerStage(TKStage stage) {
        GlassStage ownerStage;
        if (stage instanceof WindowStage && (ownerStage = ((WindowStage)stage).getOwner()) instanceof WindowStage) {
            WindowStage ownerWindowStage = (WindowStage)ownerStage;
            ownerWindowStage.setEnabled(false);
            return ownerWindowStage;
        }
        return null;
    }

    private static List<CommonDialogs.ExtensionFilter> convertExtensionFilters(List<FileChooser.ExtensionFilter> extensionFilters) {
        CommonDialogs.ExtensionFilter[] glassExtensionFilters = new CommonDialogs.ExtensionFilter[extensionFilters.size()];
        int i = 0;
        for (FileChooser.ExtensionFilter extensionFilter : extensionFilters) {
            glassExtensionFilters[i++] = new CommonDialogs.ExtensionFilter(extensionFilter.getDescription(), extensionFilter.getExtensions());
        }
        return Arrays.asList(glassExtensionFilters);
    }

    @Override
    public long getMultiClickTime() {
        return View.getMultiClickTime();
    }

    @Override
    public int getMultiClickMaxX() {
        return View.getMultiClickMaxX();
    }

    @Override
    public int getMultiClickMaxY() {
        return View.getMultiClickMaxY();
    }

    @Override
    public String getThemeName() {
        return Application.GetApplication().getHighContrastTheme();
    }

    @Override
    public GlassRobot createRobot() {
        return Application.GetApplication().createRobot();
    }

    static class QuantumImage
    implements ImageLoader,
    ResourceFactoryListener {
        private RTTexture rt;
        private com.sun.prism.Image image;
        private ResourceFactory rf;

        QuantumImage(com.sun.prism.Image image) {
            this.image = image;
        }

        QuantumImage(PixelBuffer<Buffer> pixelBuffer) {
            switch (pixelBuffer.getPixelFormat().getType()) {
                case INT_ARGB_PRE: {
                    this.image = com.sun.prism.Image.fromPixelBufferPreData(com.sun.prism.PixelFormat.INT_ARGB_PRE, pixelBuffer.getBuffer(), pixelBuffer.getWidth(), pixelBuffer.getHeight());
                    break;
                }
                case BYTE_BGRA_PRE: {
                    this.image = com.sun.prism.Image.fromPixelBufferPreData(com.sun.prism.PixelFormat.BYTE_BGRA_PRE, pixelBuffer.getBuffer(), pixelBuffer.getWidth(), pixelBuffer.getHeight());
                    break;
                }
                default: {
                    throw new InternalError("Unsupported PixelFormat: " + pixelBuffer.getPixelFormat().getType());
                }
            }
        }

        RTTexture getRT(int w, int h, ResourceFactory rfNew) {
            boolean rttOk;
            boolean bl = rttOk = this.rt != null && this.rf == rfNew && this.rt.getContentWidth() == w && this.rt.getContentHeight() == h;
            if (rttOk) {
                this.rt.lock();
                if (this.rt.isSurfaceLost()) {
                    rttOk = false;
                }
            }
            if (!rttOk) {
                if (this.rt != null) {
                    this.rt.dispose();
                }
                if (this.rf != null) {
                    this.rf.removeFactoryListener(this);
                    this.rf = null;
                }
                this.rt = rfNew.createRTTexture(w, h, Texture.WrapMode.CLAMP_TO_ZERO);
                if (this.rt != null) {
                    this.rf = rfNew;
                    this.rf.addFactoryListener(this);
                }
            }
            return this.rt;
        }

        void dispose() {
            if (this.rt != null) {
                this.rt.dispose();
                this.rt = null;
            }
        }

        void setImage(com.sun.prism.Image img) {
            this.image = img;
        }

        @Override
        public Exception getException() {
            return this.image == null ? new IllegalStateException("Unitialized image") : null;
        }

        @Override
        public int getFrameCount() {
            return 1;
        }

        @Override
        public PlatformImage getFrame(int index) {
            return this.image;
        }

        @Override
        public int getFrameDelay(int index) {
            return 0;
        }

        @Override
        public int getLoopCount() {
            return 0;
        }

        @Override
        public double getWidth() {
            return this.image.getWidth();
        }

        @Override
        public double getHeight() {
            return this.image.getHeight();
        }

        @Override
        public void factoryReset() {
            this.dispose();
        }

        @Override
        public void factoryReleased() {
            this.dispose();
            if (this.rf != null) {
                this.rf.removeFactoryListener(this);
                this.rf = null;
            }
        }
    }

    private class PulseTask {
        private volatile boolean isRunning;

        PulseTask(boolean state) {
            this.isRunning = state;
        }

        synchronized void set(boolean state) {
            this.isRunning = state;
            if (this.isRunning) {
                QuantumToolkit.this.resumeTimer();
            }
        }

        boolean get() {
            return this.isRunning;
        }
    }
}

