/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.QueuedPixelSource;
import java.nio.IntBuffer;

final class UploadingPainter
extends ViewPainter
implements Runnable {
    private RTTexture rttexture;
    private RTTexture resolveRTT = null;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(true);
    private float penScaleX;
    private float penScaleY;

    UploadingPainter(GlassScene view) {
        super(view);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
        if (this.resolveRTT != null) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.sceneState.getRenderScaleX();
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.sceneState.getRenderScaleY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean errored = false;
        try {
            Graphics g;
            boolean needsReset;
            if (!this.validateStageGraphics()) {
                if (QuantumToolkit.verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                this.factory = null;
                return;
            }
            float scalex = this.getPixelScaleFactorX();
            float scaley = this.getPixelScaleFactorY();
            int bufWidth = this.sceneState.getRenderWidth();
            int bufHeight = this.sceneState.getRenderHeight();
            boolean bl = needsReset = this.penScaleX != scalex || this.penScaleY != scaley || this.penWidth != this.viewWidth || this.penHeight != this.viewHeight || this.rttexture == null || this.rttexture.getContentWidth() != bufWidth || this.rttexture.getContentHeight() != bufHeight;
            if (!needsReset) {
                this.rttexture.lock();
                if (this.rttexture.isSurfaceLost()) {
                    this.rttexture.unlock();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    needsReset = true;
                }
            }
            if (needsReset) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(bufWidth, bufHeight, Texture.WrapMode.CLAMP_NOT_NEEDED, this.sceneState.isMSAA());
                if (this.rttexture == null) {
                    return;
                }
                this.penScaleX = scalex;
                this.penScaleY = scaley;
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.freshBackBuffer = true;
            }
            if ((g = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            g.scale(scalex, scaley);
            this.paintImpl(g);
            this.freshBackBuffer = false;
            int outWidth = this.sceneState.getOutputWidth();
            int outHeight = this.sceneState.getOutputHeight();
            float outScaleX = this.sceneState.getOutputScaleX();
            float outScaleY = this.sceneState.getOutputScaleY();
            RTTexture rtt = this.rttexture.isMSAA() || outWidth != bufWidth || outHeight != bufHeight ? this.resolveRenderTarget(g, outWidth, outHeight) : this.rttexture;
            Pixels pix = this.pixelSource.getUnusedPixels(outWidth, outHeight, outScaleX, outScaleY);
            IntBuffer bits = (IntBuffer)pix.getPixels();
            int[] rawbits = rtt.getPixels();
            if (rawbits != null) {
                bits.put(rawbits, 0, outWidth * outHeight);
            } else if (!rtt.readPixels(bits)) {
                this.sceneState.getScene().entireSceneNeedsRepaint();
                this.disposeRTTexture();
                pix = null;
            }
            if (this.rttexture != null) {
                this.rttexture.unlock();
            }
            if (pix != null) {
                this.pixelSource.enqueuePixels(pix);
                this.sceneState.uploadPixels(this.pixelSource);
            }
        }
        catch (Throwable th) {
            errored = true;
            th.printStackTrace(System.err);
        }
        finally {
            if (this.rttexture != null && this.rttexture.isLocked()) {
                this.rttexture.unlock();
            }
            if (this.resolveRTT != null && this.resolveRTT.isLocked()) {
                this.resolveRTT.unlock();
            }
            Disposer.cleanUp();
            this.sceneState.getScene().setPainting(false);
            if (this.factory != null) {
                this.factory.getTextureResourcePool().freeDisposalRequestedAndCheckResources(errored);
            }
            renderLock.unlock();
        }
    }

    private RTTexture resolveRenderTarget(Graphics g, int width, int height) {
        if (this.resolveRTT != null) {
            this.resolveRTT.lock();
            if (this.resolveRTT.isSurfaceLost() || this.resolveRTT.getContentWidth() != width || this.resolveRTT.getContentHeight() != height) {
                this.resolveRTT.unlock();
                this.resolveRTT.dispose();
                this.resolveRTT = null;
            }
        }
        if (this.resolveRTT == null) {
            this.resolveRTT = g.getResourceFactory().createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED, false);
        }
        int srcw = this.rttexture.getContentWidth();
        int srch = this.rttexture.getContentHeight();
        g.blit(this.rttexture, this.resolveRTT, 0, 0, srcw, srch, 0, 0, width, height);
        return this.resolveRTT;
    }
}

