/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

public class ModuleHelper {
    private static final Method getModuleMethod;
    private static final Method addReadsMethod;
    private static final Method addExportsMethod;
    private static final boolean verbose;

    public static Object getModule(Class clazz) {
        if (getModuleMethod != null) {
            try {
                return getModuleMethod.invoke((Object)clazz, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static void addReads(Object thisModule, Object targetModule) {
        if (addReadsMethod != null) {
            try {
                addReadsMethod.invoke(thisModule, targetModule);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void addExports(Object thisModule, String packageName, Object targetModule) {
        if (addExportsMethod != null) {
            try {
                addExportsMethod.invoke(thisModule, packageName, targetModule);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static {
        boolean tmp = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        verbose = tmp;
        if (verbose) {
            System.err.println(ModuleHelper.class.getName() + " : <clinit>");
        }
        Method mGetModule = null;
        Method mAddReads = null;
        Method mAddExports = null;
        try {
            mGetModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = mGetModule.getReturnType();
            mAddReads = moduleClass.getMethod("addReads", moduleClass);
            mAddExports = moduleClass.getMethod("addExports", String.class, moduleClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getModuleMethod = mGetModule;
        addReadsMethod = mAddReads;
        addExportsMethod = mAddExports;
        if (verbose) {
            System.err.println("getModuleMethod = " + getModuleMethod);
            System.err.println("addReadsMethod = " + addReadsMethod);
            System.err.println("addExportsMethod = " + addExportsMethod);
        }
    }
}

