/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class FloatArrayCache
implements MarlinConst {
    final boolean clean;
    private final int bucketCapacity;
    private WeakReference<Bucket[]> refBuckets = null;
    final ArrayCacheConst.CacheStats stats;

    FloatArrayCache(boolean clean, int bucketCapacity) {
        this.clean = clean;
        this.bucketCapacity = bucketCapacity;
        this.stats = DO_STATS ? new ArrayCacheConst.CacheStats(FloatArrayCache.getLogPrefix(clean) + "FloatArrayCache") : null;
    }

    Bucket getCacheBucket(int length) {
        int bucket = ArrayCacheConst.getBucket(length);
        return this.getBuckets()[bucket];
    }

    private Bucket[] getBuckets() {
        Bucket[] buckets;
        Bucket[] bucketArray = buckets = this.refBuckets != null ? (Bucket[])this.refBuckets.get() : null;
        if (buckets == null) {
            buckets = new Bucket[8];
            for (int i = 0; i < 8; ++i) {
                buckets[i] = new Bucket(this.clean, ArrayCacheConst.ARRAY_SIZES[i], this.bucketCapacity, DO_STATS ? this.stats.bucketStats[i] : null);
            }
            this.refBuckets = new WeakReference<Bucket[]>(buckets);
        }
        return buckets;
    }

    Reference createRef(int initialSize) {
        return new Reference(this, initialSize);
    }

    static float[] createArray(int length) {
        return new float[length];
    }

    static void fill(float[] array, int fromIndex, int toIndex, float value) {
        Arrays.fill(array, fromIndex, toIndex, value);
        if (DO_CHECKS) {
            FloatArrayCache.check(array, fromIndex, toIndex, value);
        }
    }

    public static void check(float[] array, int fromIndex, int toIndex, float value) {
        if (DO_CHECKS) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == value) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + array[i] + " from: " + fromIndex + " to: " + toIndex + "\n" + Arrays.toString(array), new Throwable());
                Arrays.fill(array, value);
                return;
            }
        }
    }

    static String getLogPrefix(boolean clean) {
        return clean ? "Clean" : "Dirty";
    }

    static final class Bucket {
        private int tail = 0;
        private final int arraySize;
        private final boolean clean;
        private final float[][] arrays;
        private final ArrayCacheConst.BucketStats stats;

        Bucket(boolean clean, int arraySize, int capacity, ArrayCacheConst.BucketStats stats) {
            this.arraySize = arraySize;
            this.clean = clean;
            this.stats = stats;
            this.arrays = new float[capacity][];
        }

        float[] getArray() {
            if (MarlinConst.DO_STATS) {
                ++this.stats.getOp;
            }
            if (this.tail != 0) {
                float[] array = this.arrays[--this.tail];
                this.arrays[this.tail] = null;
                return array;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.createOp;
            }
            return FloatArrayCache.createArray(this.arraySize);
        }

        void putArray(float[] array) {
            if (MarlinConst.DO_CHECKS && array.length != this.arraySize) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: bad length = " + array.length);
                return;
            }
            if (MarlinConst.DO_STATS) {
                ++this.stats.returnOp;
            }
            if (this.arrays.length > this.tail) {
                this.arrays[this.tail++] = array;
                if (MarlinConst.DO_STATS) {
                    this.stats.updateMaxSize(this.tail);
                }
            } else if (MarlinConst.DO_CHECKS) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: array capacity exceeded !");
            }
        }
    }

    static final class Reference {
        final float[] initial;
        private final boolean clean;
        private final FloatArrayCache cache;

        Reference(FloatArrayCache cache, int initialSize) {
            this.cache = cache;
            this.clean = cache.clean;
            this.initial = FloatArrayCache.createArray(initialSize);
            if (MarlinConst.DO_STATS) {
                cache.stats.totalInitial += (long)initialSize;
            }
        }

        float[] getArray(int length) {
            if (length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                return this.cache.getCacheBucket(length).getArray();
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.oversize;
            }
            if (MarlinConst.DO_LOG_OVERSIZE) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: getArray[oversize]: length=\t" + length);
            }
            return FloatArrayCache.createArray(length);
        }

        float[] widenArray(float[] array, int usedSize, int needSize) {
            int length = array.length;
            if (MarlinConst.DO_CHECKS && length >= needSize) {
                return array;
            }
            if (MarlinConst.DO_STATS) {
                ++this.cache.stats.resize;
            }
            float[] res = this.getArray(ArrayCacheConst.getNewSize(usedSize, needSize));
            System.arraycopy(array, 0, res, 0, usedSize);
            this.putArray(array, 0, usedSize);
            if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
                MarlinUtils.logInfo(FloatArrayCache.getLogPrefix(this.clean) + "FloatArrayCache: widenArray[" + res.length + "]: usedSize=\t" + usedSize + "\tlength=\t" + length + "\tneeded length=\t" + needSize);
            }
            return res;
        }

        float[] putArray(float[] array) {
            return this.putArray(array, 0, array.length);
        }

        float[] putArray(float[] array, int fromIndex, int toIndex) {
            if (array.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
                if (this.clean && toIndex != 0) {
                    FloatArrayCache.fill(array, fromIndex, toIndex, 0.0f);
                }
                if (array != this.initial) {
                    this.cache.getCacheBucket(array.length).putArray(array);
                }
            }
            return this.initial;
        }
    }
}

