/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGDefaultCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.MeshView;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DFrameStats;
import com.sun.prism.d3d.D3DPipeline;
import com.sun.prism.d3d.D3DRenderTarget;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;

class D3DContext
extends BaseShaderContext {
    public static final int D3DERR_DEVICEREMOVED = -2005530512;
    public static final int D3DERR_DEVICENOTRESET = -2005530519;
    public static final int D3DERR_DEVICELOST = -2005530520;
    public static final int E_FAIL = -2147467259;
    public static final int D3DERR_OUTOFVIDEOMEMORY = -2005532292;
    public static final int D3D_OK = 0;
    public static final int D3DCOMPMODE_CLEAR = 0;
    public static final int D3DCOMPMODE_SRC = 1;
    public static final int D3DCOMPMODE_SRCOVER = 2;
    public static final int D3DCOMPMODE_DSTOUT = 3;
    public static final int D3DCOMPMODE_ADD = 4;
    public static final int D3DTADDRESS_NOP = 0;
    public static final int D3DTADDRESS_WRAP = 1;
    public static final int D3DTADDRESS_MIRROR = 2;
    public static final int D3DTADDRESS_CLAMP = 3;
    public static final int D3DTADDRESS_BORDER = 4;
    public static final int CULL_BACK = 110;
    public static final int CULL_FRONT = 111;
    public static final int CULL_NONE = 112;
    private static GeneralTransform3D scratchTx = new GeneralTransform3D();
    private static final Affine3D scratchAffine3DTx = new Affine3D();
    private static double[] tempAdjustClipSpaceMat = new double[16];
    private BaseShaderContext.State state;
    private boolean isLost = false;
    private final long pContext;
    private Vec3d cameraPos = new Vec3d();
    private GeneralTransform3D projViewTx = new GeneralTransform3D();
    private int targetWidth = 0;
    private int targetHeight = 0;
    private final D3DResourceFactory factory;
    public static final int NUM_QUADS = PrismSettings.superShader ? 4096 : 256;

    public static boolean FAILED(int hr) {
        return hr < 0;
    }

    D3DContext(long pContext, Screen screen, D3DResourceFactory factory) {
        super(screen, factory, NUM_QUADS);
        this.pContext = pContext;
        this.factory = factory;
    }

    @Override
    public D3DResourceFactory getResourceFactory() {
        return this.factory;
    }

    protected void initState() {
        this.init();
        this.state = new BaseShaderContext.State();
        D3DContext.validate(D3DContext.nSetBlendEnabled(this.pContext, 2));
        D3DContext.validate(D3DContext.nSetDeviceParametersFor2D(this.pContext));
    }

    long getContextHandle() {
        return this.pContext;
    }

    boolean isLost() {
        return this.isLost;
    }

    static void validate(int res) {
        if (PrismSettings.verbose && D3DContext.FAILED(res)) {
            System.err.println("D3D hresult failed :" + D3DContext.hResultToString(res));
            new Exception("Stack trace").printStackTrace(System.err);
        }
    }

    private void setLost() {
        this.isLost = true;
    }

    boolean testLostStateAndReset() {
        if (this.isDisposed()) {
            return false;
        }
        int hr = D3DResourceFactory.nTestCooperativeLevel(this.pContext);
        if (PrismSettings.verbose && D3DContext.FAILED(hr)) {
            System.err.print("D3DContext::testLostStateAndReset : ");
            switch (hr) {
                case 0: {
                    System.err.println("D3D_OK");
                    break;
                }
                case -2005530520: {
                    System.err.println("D3DERR_DEVICELOST");
                    break;
                }
                case -2005530512: {
                    System.err.println("D3DERR_DEVICEREMOVED");
                    break;
                }
                case -2005530519: {
                    System.err.println("D3DERR_DEVICENOTRESET");
                    break;
                }
                case -2147467259: {
                    System.err.println("E_FAIL");
                    break;
                }
                default: {
                    System.err.println(String.format("Unknown D3D error 0x%x", hr));
                }
            }
        }
        if (hr == -2005530520) {
            this.setLost();
        }
        if (hr == -2005530519) {
            boolean wasLost = this.isLost();
            this.setLost();
            this.disposeLCDBuffer();
            this.factory.notifyReset();
            hr = D3DResourceFactory.nResetDevice(this.pContext);
            if (hr == 0) {
                this.isLost = false;
                this.initState();
                if (!wasLost) {
                    return false;
                }
            }
        }
        if (hr == -2005530512) {
            this.setLost();
            D3DPipeline.getInstance().reinitialize();
        }
        return !D3DContext.FAILED(hr);
    }

    boolean validatePresent(int res) {
        if (res == -2005530520 || res == -2005530519) {
            this.setLost();
        } else {
            D3DContext.validate(res);
        }
        return !D3DContext.FAILED(res);
    }

    @Override
    public void dispose() {
        this.disposeLCDBuffer();
        this.state = null;
        super.dispose();
    }

    private GeneralTransform3D adjustClipSpace(GeneralTransform3D projViewTx) {
        double[] m = projViewTx.get(tempAdjustClipSpaceMat);
        m[8] = (m[8] + m[12]) / 2.0;
        m[9] = (m[9] + m[13]) / 2.0;
        m[10] = (m[10] + m[14]) / 2.0;
        m[11] = (m[11] + m[15]) / 2.0;
        projViewTx.set(m);
        return projViewTx;
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget target, NGCamera camera, boolean depthTest) {
        if (this.checkDisposed()) {
            return null;
        }
        long resourceHandle = ((D3DRenderTarget)((Object)target)).getResourceHandle();
        int res = D3DContext.nSetRenderTarget(this.pContext, resourceHandle, depthTest, target.isMSAA());
        D3DContext.validate(res);
        if (res == 0) {
            this.resetLastClip(this.state);
        }
        this.targetWidth = target.getPhysicalWidth();
        this.targetHeight = target.getPhysicalHeight();
        if (camera instanceof NGDefaultCamera) {
            ((NGDefaultCamera)camera).validate(this.targetWidth, this.targetHeight);
            this.projViewTx = this.adjustClipSpace(camera.getProjViewTx(this.projViewTx));
        } else {
            this.projViewTx = this.adjustClipSpace(camera.getProjViewTx(this.projViewTx));
            double vw = camera.getViewWidth();
            double vh = camera.getViewHeight();
            if ((double)this.targetWidth != vw || (double)this.targetHeight != vh) {
                this.projViewTx.scale(vw / (double)this.targetWidth, vh / (double)this.targetHeight, 1.0);
            }
        }
        res = D3DContext.nSetProjViewMatrix(this.pContext, depthTest, this.projViewTx.get(0), this.projViewTx.get(1), this.projViewTx.get(2), this.projViewTx.get(3), this.projViewTx.get(4), this.projViewTx.get(5), this.projViewTx.get(6), this.projViewTx.get(7), this.projViewTx.get(8), this.projViewTx.get(9), this.projViewTx.get(10), this.projViewTx.get(11), this.projViewTx.get(12), this.projViewTx.get(13), this.projViewTx.get(14), this.projViewTx.get(15));
        D3DContext.validate(res);
        this.cameraPos = camera.getPositionInWorld(this.cameraPos);
        return this.state;
    }

    @Override
    protected void updateTexture(int texUnit, Texture tex) {
        int wrapMode;
        boolean linear;
        long texHandle;
        if (tex != null) {
            D3DTexture d3dtex = (D3DTexture)tex;
            texHandle = d3dtex.getNativeSourceHandle();
            linear = tex.getLinearFiltering();
            switch (tex.getWrapMode()) {
                case CLAMP_NOT_NEEDED: {
                    wrapMode = 0;
                    break;
                }
                case CLAMP_TO_EDGE: 
                case CLAMP_TO_EDGE_SIMULATED: 
                case CLAMP_TO_ZERO_SIMULATED: {
                    wrapMode = 3;
                    break;
                }
                case CLAMP_TO_ZERO: {
                    wrapMode = 4;
                    break;
                }
                case REPEAT: 
                case REPEAT_SIMULATED: {
                    wrapMode = 1;
                    break;
                }
                default: {
                    throw new InternalError("Unrecognized wrap mode: " + tex.getWrapMode());
                }
            }
        } else {
            texHandle = 0L;
            linear = false;
            wrapMode = 3;
        }
        D3DContext.validate(D3DContext.nSetTexture(this.pContext, texHandle, texUnit, linear, wrapMode));
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform xform) {
        int res;
        if (xform == null) {
            xform = BaseTransform.IDENTITY_TRANSFORM;
        }
        GeneralTransform3D perspectiveTransform = this.getPerspectiveTransformNoClone();
        if (xform.isIdentity() && perspectiveTransform.isIdentity()) {
            res = D3DContext.nResetTransform(this.pContext);
        } else if (perspectiveTransform.isIdentity()) {
            res = D3DContext.nSetTransform(this.pContext, xform.getMxx(), xform.getMxy(), xform.getMxz(), xform.getMxt(), xform.getMyx(), xform.getMyy(), xform.getMyz(), xform.getMyt(), xform.getMzx(), xform.getMzy(), xform.getMzz(), xform.getMzt(), 0.0, 0.0, 0.0, 1.0);
        } else {
            scratchTx.setIdentity().mul(xform).mul(perspectiveTransform);
            res = D3DContext.nSetTransform(this.pContext, scratchTx.get(0), scratchTx.get(1), scratchTx.get(2), scratchTx.get(3), scratchTx.get(4), scratchTx.get(5), scratchTx.get(6), scratchTx.get(7), scratchTx.get(8), scratchTx.get(9), scratchTx.get(10), scratchTx.get(11), scratchTx.get(12), scratchTx.get(13), scratchTx.get(14), scratchTx.get(15));
        }
        D3DContext.validate(res);
    }

    @Override
    protected void updateWorldTransform(BaseTransform xform) {
        if (xform == null || xform.isIdentity()) {
            D3DContext.nSetWorldTransformToIdentity(this.pContext);
        } else {
            D3DContext.nSetWorldTransform(this.pContext, xform.getMxx(), xform.getMxy(), xform.getMxz(), xform.getMxt(), xform.getMyx(), xform.getMyy(), xform.getMyz(), xform.getMyt(), xform.getMzx(), xform.getMzy(), xform.getMzz(), xform.getMzt(), 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    protected void updateClipRect(Rectangle clipRect) {
        int res;
        if (clipRect == null || clipRect.isEmpty()) {
            res = D3DContext.nResetClipRect(this.pContext);
        } else {
            int x1 = clipRect.x;
            int y1 = clipRect.y;
            int x2 = x1 + clipRect.width;
            int y2 = y1 + clipRect.height;
            res = D3DContext.nSetClipRect(this.pContext, x1, y1, x2, y2);
        }
        D3DContext.validate(res);
    }

    @Override
    protected void updateCompositeMode(CompositeMode mode) {
        int d3dmode;
        switch (mode) {
            case CLEAR: {
                d3dmode = 0;
                break;
            }
            case SRC: {
                d3dmode = 1;
                break;
            }
            case SRC_OVER: {
                d3dmode = 2;
                break;
            }
            case DST_OUT: {
                d3dmode = 3;
                break;
            }
            case ADD: {
                d3dmode = 4;
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + mode);
            }
        }
        D3DContext.validate(D3DContext.nSetBlendEnabled(this.pContext, d3dmode));
    }

    D3DFrameStats getFrameStats(boolean reset, D3DFrameStats result) {
        if (result == null) {
            result = new D3DFrameStats();
        }
        return D3DContext.nGetFrameStats(this.pContext, result, reset) ? result : null;
    }

    private static native int nSetRenderTarget(long var0, long var2, boolean var4, boolean var5);

    private static native int nSetTexture(long var0, long var2, int var4, boolean var5, int var6);

    private static native int nResetTransform(long var0);

    private static native int nSetTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native void nSetWorldTransformToIdentity(long var0);

    private static native void nSetWorldTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native int nSetCameraPosition(long var0, double var2, double var4, double var6);

    private static native int nSetProjViewMatrix(long var0, boolean var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private static native int nResetClipRect(long var0);

    private static native int nSetClipRect(long var0, int var2, int var3, int var4, int var5);

    private static native int nSetBlendEnabled(long var0, int var2);

    private static native int nSetDeviceParametersFor2D(long var0);

    private static native int nSetDeviceParametersFor3D(long var0);

    private static native long nCreateD3DMesh(long var0);

    private static native void nReleaseD3DMesh(long var0, long var2);

    private static native boolean nBuildNativeGeometryShort(long var0, long var2, float[] var4, int var5, short[] var6, int var7);

    private static native boolean nBuildNativeGeometryInt(long var0, long var2, float[] var4, int var5, int[] var6, int var7);

    private static native long nCreateD3DPhongMaterial(long var0);

    private static native void nReleaseD3DPhongMaterial(long var0, long var2);

    private static native void nSetDiffuseColor(long var0, long var2, float var4, float var5, float var6, float var7);

    private static native void nSetSpecularColor(long var0, long var2, boolean var4, float var5, float var6, float var7, float var8);

    private static native void nSetMap(long var0, long var2, int var4, long var5);

    private static native long nCreateD3DMeshView(long var0, long var2);

    private static native void nReleaseD3DMeshView(long var0, long var2);

    private static native void nSetCullingMode(long var0, long var2, int var4);

    private static native void nSetMaterial(long var0, long var2, long var4);

    private static native void nSetWireframe(long var0, long var2, boolean var4);

    private static native void nSetAmbientLight(long var0, long var2, float var4, float var5, float var6);

    private static native void nSetLight(long var0, long var2, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22);

    private static native void nRenderMeshView(long var0, long var2);

    private static native int nDrawIndexedQuads(long var0, float[] var2, byte[] var3, int var4);

    private static native void nBlit(long var0, long var2, long var4, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    private static native boolean nGetFrameStats(long var0, D3DFrameStats var2, boolean var3);

    private static native boolean nIsRTTVolatile(long var0);

    public boolean isRTTVolatile() {
        if (this.checkDisposed()) {
            return false;
        }
        return D3DContext.nIsRTTVolatile(this.pContext);
    }

    public static String hResultToString(long hResult) {
        switch ((int)hResult) {
            case -2005530519: {
                return "D3DERR_DEVICENOTRESET";
            }
            case -2005530520: {
                return "D3DERR_DEVICELOST";
            }
            case -2005532292: {
                return "D3DERR_OUTOFVIDEOMEMORY";
            }
            case -2005530512: {
                return "D3DERR_DEVICEREMOVED";
            }
            case 0: {
                return "D3D_OK";
            }
        }
        return "D3D_ERROR " + Long.toHexString(hResult);
    }

    @Override
    public void setDeviceParametersFor2D() {
        if (this.checkDisposed()) {
            return;
        }
        D3DContext.nSetDeviceParametersFor2D(this.pContext);
    }

    @Override
    protected void setDeviceParametersFor3D() {
        if (this.checkDisposed()) {
            return;
        }
        D3DContext.nSetDeviceParametersFor3D(this.pContext);
    }

    long createD3DMesh() {
        if (this.checkDisposed()) {
            return 0L;
        }
        return D3DContext.nCreateD3DMesh(this.pContext);
    }

    void releaseD3DMesh(long nativeHandle) {
        D3DContext.nReleaseD3DMesh(this.pContext, nativeHandle);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, short[] indexBuffer, int indexBufferLength) {
        return D3DContext.nBuildNativeGeometryShort(this.pContext, nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    boolean buildNativeGeometry(long nativeHandle, float[] vertexBuffer, int vertexBufferLength, int[] indexBuffer, int indexBufferLength) {
        return D3DContext.nBuildNativeGeometryInt(this.pContext, nativeHandle, vertexBuffer, vertexBufferLength, indexBuffer, indexBufferLength);
    }

    long createD3DPhongMaterial() {
        return D3DContext.nCreateD3DPhongMaterial(this.pContext);
    }

    void releaseD3DPhongMaterial(long nativeHandle) {
        D3DContext.nReleaseD3DPhongMaterial(this.pContext, nativeHandle);
    }

    void setDiffuseColor(long nativePhongMaterial, float r, float g, float b, float a) {
        D3DContext.nSetDiffuseColor(this.pContext, nativePhongMaterial, r, g, b, a);
    }

    void setSpecularColor(long nativePhongMaterial, boolean set, float r, float g, float b, float a) {
        D3DContext.nSetSpecularColor(this.pContext, nativePhongMaterial, set, r, g, b, a);
    }

    void setMap(long nativePhongMaterial, int mapType, long nativeTexture) {
        D3DContext.nSetMap(this.pContext, nativePhongMaterial, mapType, nativeTexture);
    }

    long createD3DMeshView(long nativeMesh) {
        return D3DContext.nCreateD3DMeshView(this.pContext, nativeMesh);
    }

    void releaseD3DMeshView(long nativeMeshView) {
        D3DContext.nReleaseD3DMeshView(this.pContext, nativeMeshView);
    }

    void setCullingMode(long nativeMeshView, int cullMode) {
        int cm;
        if (cullMode == MeshView.CULL_NONE) {
            cm = 112;
        } else if (cullMode == MeshView.CULL_BACK) {
            cm = 110;
        } else if (cullMode == MeshView.CULL_FRONT) {
            cm = 111;
        } else {
            throw new IllegalArgumentException("illegal value for CullMode: " + cullMode);
        }
        D3DContext.nSetCullingMode(this.pContext, nativeMeshView, cm);
    }

    void setMaterial(long nativeMeshView, long nativePhongMaterial) {
        D3DContext.nSetMaterial(this.pContext, nativeMeshView, nativePhongMaterial);
    }

    void setWireframe(long nativeMeshView, boolean wireframe) {
        D3DContext.nSetWireframe(this.pContext, nativeMeshView, wireframe);
    }

    void setAmbientLight(long nativeMeshView, float r, float g, float b) {
        D3DContext.nSetAmbientLight(this.pContext, nativeMeshView, r, g, b);
    }

    void setLight(long nativeMeshView, int index, float x, float y, float z, float r, float g, float b, float w, float ca, float la, float qa, float isAttenuated, float maxRange, float dirX, float dirY, float dirZ, float innerAngle, float outerAngle, float falloff) {
        D3DContext.nSetLight(this.pContext, nativeMeshView, index, x, y, z, r, g, b, w, ca, la, qa, isAttenuated, maxRange, dirX, dirY, dirZ, innerAngle, outerAngle, falloff);
    }

    @Override
    protected void renderQuads(float[] coordArray, byte[] colorArray, int numVertices) {
        int res = D3DContext.nDrawIndexedQuads(this.pContext, coordArray, colorArray, numVertices);
        D3DContext.validate(res);
    }

    void renderMeshView(long nativeMeshView, Graphics g) {
        scratchTx = scratchTx.set(this.projViewTx);
        float pixelScaleFactorX = g.getPixelScaleFactorX();
        float pixelScaleFactorY = g.getPixelScaleFactorY();
        if ((double)pixelScaleFactorX != 1.0 || (double)pixelScaleFactorY != 1.0) {
            scratchTx.scale(pixelScaleFactorX, pixelScaleFactorY, 1.0);
        }
        int res = D3DContext.nSetProjViewMatrix(this.pContext, g.isDepthTest(), scratchTx.get(0), scratchTx.get(1), scratchTx.get(2), scratchTx.get(3), scratchTx.get(4), scratchTx.get(5), scratchTx.get(6), scratchTx.get(7), scratchTx.get(8), scratchTx.get(9), scratchTx.get(10), scratchTx.get(11), scratchTx.get(12), scratchTx.get(13), scratchTx.get(14), scratchTx.get(15));
        D3DContext.validate(res);
        res = D3DContext.nSetCameraPosition(this.pContext, this.cameraPos.x, this.cameraPos.y, this.cameraPos.z);
        D3DContext.validate(res);
        BaseTransform xform = g.getTransformNoClone();
        if ((double)pixelScaleFactorX != 1.0 || (double)pixelScaleFactorY != 1.0) {
            scratchAffine3DTx.setToIdentity();
            scratchAffine3DTx.scale(1.0 / (double)pixelScaleFactorX, 1.0 / (double)pixelScaleFactorY);
            scratchAffine3DTx.concatenate(xform);
            this.updateWorldTransform(scratchAffine3DTx);
        } else {
            this.updateWorldTransform(xform);
        }
        D3DContext.nRenderMeshView(this.pContext, nativeMeshView);
    }

    @Override
    public void blit(RTTexture srcRTT, RTTexture dstRTT, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        long dstNativeHandle = dstRTT == null ? 0L : ((D3DTexture)((Object)dstRTT)).getNativeSourceHandle();
        long srcNativeHandle = ((D3DTexture)((Object)srcRTT)).getNativeSourceHandle();
        D3DContext.nBlit(this.pContext, srcNativeHandle, dstNativeHandle, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1);
    }
}

