/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DContextSource;
import com.sun.prism.d3d.D3DGraphics;
import com.sun.prism.d3d.D3DRTTexture;
import com.sun.prism.d3d.D3DRenderTarget;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.d3d.D3DResourceFactory;

class D3DSwapChain
extends D3DResource
implements D3DRenderTarget,
Presentable,
D3DContextSource {
    private final D3DRTTexture texBackBuffer;
    private final float pixelScaleFactorX;
    private final float pixelScaleFactorY;

    D3DSwapChain(D3DContext context, long pResource, D3DRTTexture rtt, float pixelScaleX, float pixelScaleY) {
        super(new D3DResource.D3DRecord(context, pResource));
        this.texBackBuffer = rtt;
        this.pixelScaleFactorX = pixelScaleX;
        this.pixelScaleFactorY = pixelScaleY;
    }

    @Override
    public void dispose() {
        this.texBackBuffer.dispose();
        super.dispose();
    }

    @Override
    public boolean prepare(Rectangle dirtyregion) {
        D3DContext context = this.getContext();
        context.flushVertexBuffer();
        D3DGraphics g = (D3DGraphics)D3DGraphics.create(this, context);
        if (g == null) {
            return false;
        }
        int sw = this.texBackBuffer.getContentWidth();
        int sh = this.texBackBuffer.getContentHeight();
        int dw = this.getContentWidth();
        int dh = this.getContentHeight();
        if (this.isMSAA()) {
            context.flushVertexBuffer();
            g.blit(this.texBackBuffer, null, 0, 0, sw, sh, 0, 0, dw, dh);
        } else {
            g.setCompositeMode(CompositeMode.SRC);
            g.drawTexture(this.texBackBuffer, 0.0f, 0.0f, dw, dh, 0.0f, 0.0f, sw, sh);
        }
        context.flushVertexBuffer();
        this.texBackBuffer.unlock();
        return true;
    }

    @Override
    public boolean present() {
        D3DContext context = this.getContext();
        if (context.isDisposed()) {
            return false;
        }
        int res = D3DSwapChain.nPresent(context.getContextHandle(), this.d3dResRecord.getResource());
        return context.validatePresent(res);
    }

    @Override
    public long getResourceHandle() {
        return this.d3dResRecord.getResource();
    }

    @Override
    public int getPhysicalWidth() {
        return D3DResourceFactory.nGetTextureWidth(this.d3dResRecord.getResource());
    }

    @Override
    public int getPhysicalHeight() {
        return D3DResourceFactory.nGetTextureHeight(this.d3dResRecord.getResource());
    }

    @Override
    public int getContentWidth() {
        return this.getPhysicalWidth();
    }

    @Override
    public int getContentHeight() {
        return this.getPhysicalHeight();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    private static native int nPresent(long var0, long var2);

    @Override
    public D3DContext getContext() {
        return this.d3dResRecord.getContext();
    }

    @Override
    public boolean lockResources(PresentableState pState) {
        if (pState.getRenderWidth() != this.texBackBuffer.getContentWidth() || pState.getRenderHeight() != this.texBackBuffer.getContentHeight() || pState.getRenderScaleX() != this.pixelScaleFactorX || pState.getRenderScaleY() != this.pixelScaleFactorY) {
            return true;
        }
        this.texBackBuffer.lock();
        return this.texBackBuffer.isSurfaceLost();
    }

    @Override
    public Graphics createGraphics() {
        Graphics g = D3DGraphics.create(this.texBackBuffer, this.getContext());
        g.scale(this.pixelScaleFactorX, this.pixelScaleFactorY);
        return g;
    }

    public RTTexture getRTTBackBuffer() {
        return this.texBackBuffer;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.getContext().getAssociatedScreen();
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.pixelScaleFactorX;
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.pixelScaleFactorY;
    }

    @Override
    public boolean isOpaque() {
        return this.texBackBuffer.isOpaque();
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.texBackBuffer.setOpaque(opaque);
    }

    @Override
    public boolean isMSAA() {
        return this.texBackBuffer != null ? this.texBackBuffer.isMSAA() : false;
    }
}

