/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.DMarlinRenderingEngine;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MaskMarlinAlphaConsumer;
import com.sun.marlin.RendererContext;
import com.sun.prism.BasicStroke;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.shape.DMarlinPrismUtils;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeRasterizer;

public final class DMarlinRasterizer
implements ShapeRasterizer {
    private static final MaskData EMPTY_MASK = MaskData.create(new byte[1], 0, 0, 1, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MaskData getMaskData(Shape shape, BasicStroke stroke, RectBounds xformBounds, BaseTransform xform, boolean close, boolean antialiasedShape) {
        if (stroke != null && stroke.getType() != 0) {
            shape = stroke.createStrokedShape(shape);
            stroke = null;
        }
        if (xformBounds == null) {
            if (stroke != null) {
                shape = stroke.createStrokedShape(shape);
                stroke = null;
            }
            xformBounds = new RectBounds();
            xformBounds = (RectBounds)xform.transform(shape.getBounds(), xformBounds);
        }
        if (xformBounds.isEmpty()) {
            return EMPTY_MASK;
        }
        RendererContext rdrCtx = DMarlinRenderingEngine.getRendererContext();
        MarlinRenderer renderer = null;
        try {
            Rectangle rclip = rdrCtx.clip;
            rclip.setBounds(xformBounds);
            renderer = DMarlinPrismUtils.setupRenderer(rdrCtx, shape, stroke, xform, rclip, antialiasedShape);
            int outpix_xmin = renderer.getOutpixMinX();
            int outpix_xmax = renderer.getOutpixMaxX();
            int outpix_ymin = renderer.getOutpixMinY();
            int outpix_ymax = renderer.getOutpixMaxY();
            int w = outpix_xmax - outpix_xmin;
            int h = outpix_ymax - outpix_ymin;
            if (w <= 0 || h <= 0) {
                MaskData maskData = EMPTY_MASK;
                return maskData;
            }
            MaskMarlinAlphaConsumer consumer = rdrCtx.consumer;
            if (consumer == null || w * h > consumer.getAlphaLength()) {
                int csize = w * h + 4095 & 0xFFFFF000;
                rdrCtx.consumer = consumer = new MaskMarlinAlphaConsumer(csize);
                if (PrismSettings.verbose) {
                    System.out.println("new alphas with length = " + csize);
                }
            }
            consumer.setBoundsNoClone(outpix_xmin, outpix_ymin, w, h);
            renderer.produceAlphas(consumer);
            MaskData maskData = consumer.getMaskData();
            return maskData;
        }
        finally {
            if (renderer != null) {
                renderer.dispose();
            }
            DMarlinRenderingEngine.returnRendererContext(rdrCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Shape createCenteredStrokedShape(Shape s, BasicStroke stroke) {
        float lw = stroke.getType() == 0 ? stroke.getLineWidth() : stroke.getLineWidth() * 2.0f;
        RendererContext rdrCtx = DMarlinRenderingEngine.getRendererContext();
        try {
            Path2D p2d = rdrCtx.getPath2D();
            DMarlinPrismUtils.strokeTo(rdrCtx, s, stroke, lw, rdrCtx.transformerPC2D.wrapPath2D(p2d));
            Path2D path2D = new Path2D(p2d);
            return path2D;
        }
        finally {
            DMarlinRenderingEngine.returnRendererContext(rdrCtx);
        }
    }
}

