/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import com.sun.scenario.animation.shared.MultiLoopClipEnvelope;
import javafx.animation.Animation;
import javafx.util.Duration;

public class InfiniteClipEnvelope
extends MultiLoopClipEnvelope {
    protected InfiniteClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.autoReverse = animation.isAutoReverse();
        }
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration cycleDuration) {
        if (cycleDuration.isIndefinite()) {
            return InfiniteClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(cycleDuration);
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int cycleCount) {
        return cycleCount != -1 ? InfiniteClipEnvelope.create(this.animation) : this;
    }

    @Override
    public void setRate(double newRate) {
        Animation.Status status = this.animation.getStatus();
        if (status != Animation.Status.STOPPED) {
            this.setInternalCurrentRate(Math.abs(this.currentRate - this.rate) < 1.0E-12 ? newRate : -newRate);
            this.deltaTicks = this.ticks - this.ticksRateChange(newRate);
            if (this.isDirectionChanged(newRate)) {
                long delta = 2L * this.cycleTicks - this.cyclePos;
                this.deltaTicks += delta;
                this.ticks += delta;
            }
            this.abortCurrentPulse();
        }
        this.rate = newRate;
    }

    @Override
    protected double calculateCurrentRate() {
        return !this.autoReverse ? this.rate : (this.isDuringEvenCycle() ? this.rate : -this.rate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePulse(long currentTick) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            long cycleDelta;
            long oldTicks = this.ticks;
            long ticksChange = Math.round((double)currentTick * Math.abs(this.rate));
            this.ticks = Math.max(0L, this.deltaTicks + ticksChange);
            long overallDelta = this.ticks - oldTicks;
            if (overallDelta == 0L) {
                return;
            }
            long l = cycleDelta = this.currentRate > 0.0 ? this.cycleTicks - this.cyclePos : this.cyclePos;
            while (overallDelta >= cycleDelta) {
                if (cycleDelta > 0L) {
                    this.cyclePos = this.currentRate > 0.0 ? this.cycleTicks : 0L;
                    overallDelta -= cycleDelta;
                    AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
                    if (this.aborted) {
                        return;
                    }
                }
                if (this.autoReverse) {
                    this.setCurrentRate(-this.currentRate);
                } else {
                    this.cyclePos = this.currentRate > 0.0 ? 0L : this.cycleTicks;
                    AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
                }
                cycleDelta = this.cycleTicks;
            }
            if (overallDelta > 0L) {
                this.cyclePos += this.currentRate > 0.0 ? overallDelta : -overallDelta;
                AnimationAccessor.getDefault().playTo(this.animation, this.cyclePos, this.cycleTicks);
            }
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long newTicks) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long oldTicks = this.ticks;
        this.ticks = Math.max(0L, newTicks) % (2L * this.cycleTicks);
        long delta = this.ticks - oldTicks;
        if (delta != 0L) {
            this.deltaTicks += delta;
            if (this.autoReverse) {
                if (this.ticks > this.cycleTicks) {
                    this.cyclePos = 2L * this.cycleTicks - this.ticks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(-this.rate);
                    }
                } else {
                    this.cyclePos = this.ticks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(this.rate);
                    }
                }
            } else {
                this.cyclePos = this.ticks % this.cycleTicks;
                if (this.cyclePos == 0L) {
                    this.cyclePos = this.ticks;
                }
            }
            AnimationAccessor.getDefault().jumpTo(this.animation, this.cyclePos, this.cycleTicks, false);
            this.abortCurrentPulse();
        }
    }
}

