/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.shared.ClipEnvelope;
import com.sun.scenario.animation.shared.PulseReceiver;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Objects;
import javafx.animation.AnimationAccessorImpl;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoublePropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.util.Duration;

public abstract class Animation {
    public static final int INDEFINITE = -1;
    private static final double EPSILON = 1.0E-12;
    private long startTime;
    private long pauseTime;
    private boolean paused = false;
    private final AbstractPrimaryTimer timer;
    private AccessControlContext accessCtrlCtx = null;
    final PulseReceiver pulseReceiver = new PulseReceiver(){

        @Override
        public void timePulse(long now) {
            long elapsedTime = now - Animation.this.startTime;
            if (elapsedTime < 0L) {
                return;
            }
            if (Animation.this.accessCtrlCtx == null) {
                throw new IllegalStateException("Error: AccessControlContext not captured");
            }
            AccessController.doPrivileged(() -> {
                Animation.this.doTimePulse(elapsedTime);
                return null;
            }, Animation.this.accessCtrlCtx);
        }
    };
    Animation parent = null;
    ClipEnvelope clipEnvelope;
    private boolean lastPlayedFinished = true;
    private boolean lastPlayedForward = true;
    private DoubleProperty rate;
    private static final double DEFAULT_RATE = 1.0;
    private double oldRate = 1.0;
    private ReadOnlyDoubleProperty currentRate;
    private static final double DEFAULT_CURRENT_RATE = 0.0;
    private ReadOnlyObjectProperty<Duration> cycleDuration;
    private static final Duration DEFAULT_CYCLE_DURATION;
    private ReadOnlyObjectProperty<Duration> totalDuration;
    private static final Duration DEFAULT_TOTAL_DURATION;
    private CurrentTimeProperty currentTime;
    private long currentTicks;
    private ObjectProperty<Duration> delay;
    private static final Duration DEFAULT_DELAY;
    private IntegerProperty cycleCount;
    private static final int DEFAULT_CYCLE_COUNT = 1;
    private BooleanProperty autoReverse;
    private static final boolean DEFAULT_AUTO_REVERSE = false;
    private ReadOnlyObjectProperty<Status> status;
    private static final Status DEFAULT_STATUS;
    private ObjectProperty<EventHandler<ActionEvent>> onFinished;
    private static final EventHandler<ActionEvent> DEFAULT_ON_FINISHED;
    private ObservableMap<String, Duration> cuePoints;
    private final double targetFramerate;
    private final int resolution;
    private long lastPulse;

    static final boolean isNearZero(double rate) {
        return Math.abs(rate) < 1.0E-12;
    }

    private static boolean areNearEqual(double rate1, double rate2) {
        return Animation.isNearZero(rate2 - rate1);
    }

    private long now() {
        return TickCalculation.fromNano(this.timer.nanos());
    }

    private void addPulseReceiver() {
        this.accessCtrlCtx = AccessController.getContext();
        this.timer.addPulseReceiver(this.pulseReceiver);
    }

    void startReceiver(long delay) {
        this.paused = false;
        this.startTime = this.now() + delay;
        this.addPulseReceiver();
    }

    void pauseReceiver() {
        if (!this.paused) {
            this.pauseTime = this.now();
            this.paused = true;
            this.timer.removePulseReceiver(this.pulseReceiver);
        }
    }

    void resumeReceiver() {
        if (this.paused) {
            long deltaTime = this.now() - this.pauseTime;
            this.startTime += deltaTime;
            this.paused = false;
            this.addPulseReceiver();
        }
    }

    public final void setRate(double value) {
        if (this.rate != null || !Animation.areNearEqual(value, 1.0)) {
            this.rateProperty().set(value);
        }
    }

    public final double getRate() {
        return this.rate == null ? 1.0 : this.rate.get();
    }

    public final DoubleProperty rateProperty() {
        if (this.rate == null) {
            this.rate = new DoublePropertyBase(1.0){

                public void invalidated() {
                    double newRate = Animation.this.getRate();
                    if (Animation.this.isRunningEmbedded()) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(Animation.this.oldRate);
                        throw new IllegalArgumentException("Cannot set rate of embedded animation while running.");
                    }
                    if (Animation.isNearZero(newRate)) {
                        if (Animation.this.isRunning()) {
                            Animation.this.lastPlayedForward = Animation.areNearEqual(Animation.this.getCurrentRate(), Animation.this.oldRate);
                        }
                        Animation.this.doSetCurrentRate(0.0);
                        Animation.this.pauseReceiver();
                    } else {
                        if (Animation.this.isRunning()) {
                            double currentRate = Animation.this.getCurrentRate();
                            if (Animation.isNearZero(currentRate)) {
                                Animation.this.doSetCurrentRate(Animation.this.lastPlayedForward ? newRate : -newRate);
                                Animation.this.resumeReceiver();
                            } else {
                                boolean playingForward = Animation.areNearEqual(currentRate, Animation.this.oldRate);
                                Animation.this.doSetCurrentRate(playingForward ? newRate : -newRate);
                            }
                        }
                        Animation.this.oldRate = newRate;
                    }
                    Animation.this.clipEnvelope.setRate(newRate);
                }

                public Object getBean() {
                    return Animation.this;
                }

                public String getName() {
                    return "rate";
                }
            };
        }
        return this.rate;
    }

    private boolean isRunningEmbedded() {
        if (this.parent == null) {
            return false;
        }
        return !this.parent.isStopped() || this.parent.isRunningEmbedded();
    }

    public final double getCurrentRate() {
        return this.currentRate == null ? 0.0 : this.currentRate.get();
    }

    public final ReadOnlyDoubleProperty currentRateProperty() {
        if (this.currentRate == null) {
            this.currentRate = new CurrentRateProperty();
        }
        return this.currentRate;
    }

    void setCurrentRate(double currentRate) {
        this.doSetCurrentRate(currentRate);
    }

    private void doSetCurrentRate(double value) {
        if (this.currentRate != null || !Animation.areNearEqual(value, 0.0)) {
            ((CurrentRateProperty)this.currentRateProperty()).set(value);
        }
    }

    protected final void setCycleDuration(Duration value) {
        if (this.cycleDuration != null || !DEFAULT_CYCLE_DURATION.equals((Object)value)) {
            if (value.lessThan(Duration.ZERO)) {
                throw new IllegalArgumentException("Cycle duration cannot be negative");
            }
            ((AnimationReadOnlyProperty)this.cycleDurationProperty()).set(value);
            this.updateTotalDuration();
        }
    }

    public final Duration getCycleDuration() {
        return this.cycleDuration == null ? DEFAULT_CYCLE_DURATION : (Duration)this.cycleDuration.get();
    }

    public final ReadOnlyObjectProperty<Duration> cycleDurationProperty() {
        if (this.cycleDuration == null) {
            this.cycleDuration = new AnimationReadOnlyProperty<Duration>("cycleDuration", DEFAULT_CYCLE_DURATION);
        }
        return this.cycleDuration;
    }

    public final Duration getTotalDuration() {
        return this.totalDuration == null ? DEFAULT_TOTAL_DURATION : (Duration)this.totalDuration.get();
    }

    public final ReadOnlyObjectProperty<Duration> totalDurationProperty() {
        if (this.totalDuration == null) {
            this.totalDuration = new AnimationReadOnlyProperty<Duration>("totalDuration", DEFAULT_TOTAL_DURATION);
        }
        return this.totalDuration;
    }

    private void updateTotalDuration() {
        int cycleCount = this.getCycleCount();
        Duration cycleDuration = this.getCycleDuration();
        Duration newTotalDuration = Duration.ZERO.equals((Object)cycleDuration) ? Duration.ZERO : (cycleCount == -1 ? Duration.INDEFINITE : (cycleCount <= 1 ? cycleDuration : cycleDuration.multiply((double)cycleCount)));
        if (this.totalDuration != null || !DEFAULT_TOTAL_DURATION.equals((Object)newTotalDuration)) {
            ((AnimationReadOnlyProperty)this.totalDurationProperty()).set(newTotalDuration);
        }
        if (this.isStopped()) {
            this.syncClipEnvelope();
            if (newTotalDuration.lessThan(this.getCurrentTime())) {
                this.clipEnvelope.jumpTo(TickCalculation.fromDuration(newTotalDuration));
            }
        }
    }

    public final Duration getCurrentTime() {
        return TickCalculation.toDuration(this.currentTicks);
    }

    public final ReadOnlyObjectProperty<Duration> currentTimeProperty() {
        if (this.currentTime == null) {
            this.currentTime = new CurrentTimeProperty();
        }
        return this.currentTime;
    }

    public final void setDelay(Duration value) {
        if (this.delay != null || !DEFAULT_DELAY.equals((Object)value)) {
            this.delayProperty().set((Object)value);
        }
    }

    public final Duration getDelay() {
        return this.delay == null ? DEFAULT_DELAY : (Duration)this.delay.get();
    }

    public final ObjectProperty<Duration> delayProperty() {
        if (this.delay == null) {
            this.delay = new ObjectPropertyBase<Duration>(DEFAULT_DELAY){

                protected void invalidated() {
                    Duration newDuration = (Duration)this.get();
                    if (newDuration.lessThan(Duration.ZERO)) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(Duration.ZERO);
                        throw new IllegalArgumentException("Cannot set delay to negative value. Setting to Duration.ZERO");
                    }
                }

                public Object getBean() {
                    return Animation.this;
                }

                public String getName() {
                    return "delay";
                }
            };
        }
        return this.delay;
    }

    public final void setCycleCount(int value) {
        if (this.cycleCount != null || value != 1) {
            this.cycleCountProperty().set(value);
        }
    }

    public final int getCycleCount() {
        return this.cycleCount == null ? 1 : this.cycleCount.get();
    }

    public final IntegerProperty cycleCountProperty() {
        if (this.cycleCount == null) {
            this.cycleCount = new IntegerPropertyBase(1){

                public void invalidated() {
                    Animation.this.updateTotalDuration();
                }

                public Object getBean() {
                    return Animation.this;
                }

                public String getName() {
                    return "cycleCount";
                }
            };
        }
        return this.cycleCount;
    }

    public final void setAutoReverse(boolean value) {
        if (this.autoReverse != null || value) {
            this.autoReverseProperty().set(value);
        }
    }

    public final boolean isAutoReverse() {
        return this.autoReverse == null ? false : this.autoReverse.get();
    }

    public final BooleanProperty autoReverseProperty() {
        if (this.autoReverse == null) {
            this.autoReverse = new BooleanPropertyBase(false){

                public Object getBean() {
                    return Animation.this;
                }

                public String getName() {
                    return "autoReverse";
                }
            };
        }
        return this.autoReverse;
    }

    protected final void setStatus(Status value) {
        if (this.status != null || !DEFAULT_STATUS.equals((Object)value)) {
            ((AnimationReadOnlyProperty)this.statusProperty()).set(value);
        }
    }

    public final Status getStatus() {
        return this.status == null ? DEFAULT_STATUS : (Status)((Object)this.status.get());
    }

    public final ReadOnlyObjectProperty<Status> statusProperty() {
        if (this.status == null) {
            this.status = new AnimationReadOnlyProperty<Status>("status", Status.STOPPED);
        }
        return this.status;
    }

    boolean isStopped() {
        return this.getStatus() == Status.STOPPED;
    }

    boolean isPaused() {
        return this.getStatus() == Status.PAUSED;
    }

    boolean isRunning() {
        return this.getStatus() == Status.RUNNING;
    }

    public final void setOnFinished(EventHandler<ActionEvent> value) {
        if (this.onFinished != null || value != DEFAULT_ON_FINISHED) {
            this.onFinishedProperty().set(value);
        }
    }

    public final EventHandler<ActionEvent> getOnFinished() {
        return this.onFinished == null ? DEFAULT_ON_FINISHED : (EventHandler)this.onFinished.get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onFinishedProperty() {
        if (this.onFinished == null) {
            this.onFinished = new ObjectPropertyBase<EventHandler<ActionEvent>>(DEFAULT_ON_FINISHED){

                public Object getBean() {
                    return Animation.this;
                }

                public String getName() {
                    return "onFinished";
                }
            };
        }
        return this.onFinished;
    }

    public final ObservableMap<String, Duration> getCuePoints() {
        if (this.cuePoints == null) {
            this.cuePoints = FXCollections.observableHashMap();
        }
        return this.cuePoints;
    }

    public void jumpTo(Duration time) {
        Objects.requireNonNull(time, "Time needs to be specified");
        if (time.isUnknown()) {
            throw new IllegalArgumentException("The time is invalid");
        }
        if (this.parent != null) {
            throw new IllegalStateException("Cannot jump when embedded in another animation");
        }
        this.lastPlayedFinished = false;
        double millis = time.isIndefinite() ? this.getCycleDuration().toMillis() : Utils.clamp(0.0, time.toMillis(), this.getTotalDuration().toMillis());
        long ticks = TickCalculation.fromMillis(millis);
        if (this.isStopped()) {
            this.syncClipEnvelope();
        }
        this.clipEnvelope.jumpTo(ticks);
    }

    public void jumpTo(String cuePoint) {
        Objects.requireNonNull(cuePoint, "CuePoint needs to be specified");
        if ("start".equalsIgnoreCase(cuePoint)) {
            this.jumpTo(Duration.ZERO);
        } else if ("end".equalsIgnoreCase(cuePoint)) {
            this.jumpTo(this.getTotalDuration());
        } else {
            Duration target = (Duration)this.getCuePoints().get((Object)cuePoint);
            if (target != null) {
                this.jumpTo(target);
            }
        }
    }

    public void playFrom(String cuePoint) {
        this.jumpTo(cuePoint);
        this.play();
    }

    public void playFrom(Duration time) {
        this.jumpTo(time);
        this.play();
    }

    public void playFromStart() {
        this.stop();
        this.setRate(Math.abs(this.getRate()));
        this.jumpTo(Duration.ZERO);
        this.play();
    }

    public void play() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot start when embedded in another animation");
        }
        switch (this.getStatus()) {
            case STOPPED: {
                if (this.startable(true)) {
                    double rate = this.getRate();
                    if (this.lastPlayedFinished) {
                        this.jumpTo(rate < 0.0 ? this.getTotalDuration() : Duration.ZERO);
                    }
                    this.doStart(true);
                    this.startReceiver(TickCalculation.fromDuration(this.getDelay()));
                    if (!Animation.isNearZero(rate)) break;
                    this.pauseReceiver();
                    break;
                }
                this.runHandler(this.getOnFinished());
                break;
            }
            case PAUSED: {
                this.doResume();
                if (Animation.isNearZero(this.getRate())) break;
                this.resumeReceiver();
                break;
            }
        }
    }

    void doStart(boolean forceSync) {
        this.sync(forceSync);
        this.setStatus(Status.RUNNING);
        this.clipEnvelope.start();
        this.doSetCurrentRate(this.clipEnvelope.getCurrentRate());
        this.lastPulse = 0L;
    }

    void doResume() {
        this.setStatus(Status.RUNNING);
        this.doSetCurrentRate(this.lastPlayedForward ? this.getRate() : -this.getRate());
    }

    public void stop() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot stop when embedded in another animation");
        }
        if (!this.isStopped()) {
            this.clipEnvelope.abortCurrentPulse();
            this.doStop();
            this.jumpTo(Duration.ZERO);
            this.lastPlayedFinished = true;
        }
    }

    void doStop() {
        if (!this.paused) {
            this.timer.removePulseReceiver(this.pulseReceiver);
        }
        this.setStatus(Status.STOPPED);
        this.doSetCurrentRate(0.0);
    }

    public void pause() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot pause when embedded in another animation");
        }
        if (this.isRunning()) {
            this.clipEnvelope.abortCurrentPulse();
            this.pauseReceiver();
            this.doPause();
        }
    }

    void doPause() {
        double currentRate = this.getCurrentRate();
        if (!Animation.isNearZero(currentRate)) {
            this.lastPlayedForward = Animation.areNearEqual(this.getCurrentRate(), this.getRate());
        }
        this.doSetCurrentRate(0.0);
        this.setStatus(Status.PAUSED);
    }

    final void finished() {
        this.lastPlayedFinished = true;
        this.doStop();
        this.runHandler(this.getOnFinished());
    }

    void runHandler(EventHandler<ActionEvent> handler) {
        if (handler != null) {
            try {
                handler.handle((Event)new ActionEvent((Object)this, null));
            }
            catch (Exception ex) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex);
            }
        }
    }

    public final double getTargetFramerate() {
        return this.targetFramerate;
    }

    protected Animation(double targetFramerate) {
        this.targetFramerate = targetFramerate;
        this.resolution = (int)Math.max(1L, Math.round(6000.0 / targetFramerate));
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = Toolkit.getToolkit().getPrimaryTimer();
    }

    protected Animation() {
        this.resolution = 1;
        this.targetFramerate = 6000 / Toolkit.getToolkit().getPrimaryTimer().getDefaultResolution();
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = Toolkit.getToolkit().getPrimaryTimer();
    }

    Animation(AbstractPrimaryTimer timer) {
        this.resolution = 1;
        this.targetFramerate = 6000 / timer.getDefaultResolution();
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = timer;
    }

    Animation(AbstractPrimaryTimer timer, ClipEnvelope clipEnvelope, int resolution) {
        this.resolution = resolution;
        this.targetFramerate = 6000 / resolution;
        this.clipEnvelope = clipEnvelope;
        this.timer = timer;
    }

    boolean startable(boolean forceSync) {
        return TickCalculation.fromDuration(this.getCycleDuration()) > 0L || !forceSync && this.clipEnvelope.wasSynched();
    }

    void sync(boolean forceSync) {
        if (forceSync || !this.clipEnvelope.wasSynched()) {
            this.syncClipEnvelope();
        }
    }

    private void syncClipEnvelope() {
        int publicCycleCount = this.getCycleCount();
        int internalCycleCount = publicCycleCount <= 0 && publicCycleCount != -1 ? 1 : publicCycleCount;
        this.clipEnvelope = this.clipEnvelope.setCycleCount(internalCycleCount);
        this.clipEnvelope.setCycleDuration(this.getCycleDuration());
        this.clipEnvelope.setAutoReverse(this.isAutoReverse());
    }

    void doTimePulse(long elapsedTime) {
        if (this.resolution == 1) {
            this.clipEnvelope.timePulse(elapsedTime);
        } else if (elapsedTime - this.lastPulse >= (long)this.resolution) {
            this.lastPulse = elapsedTime / (long)this.resolution * (long)this.resolution;
            this.clipEnvelope.timePulse(elapsedTime);
        }
    }

    abstract void doPlayTo(long var1, long var3);

    abstract void doJumpTo(long var1, long var3, boolean var5);

    void setCurrentTicks(long ticks) {
        this.currentTicks = ticks;
        if (this.currentTime != null) {
            this.currentTime.fireValueChangedEvent();
        }
    }

    static {
        AnimationAccessorImpl.DEFAULT = new AnimationAccessorImpl();
        DEFAULT_CYCLE_DURATION = Duration.ZERO;
        DEFAULT_TOTAL_DURATION = Duration.ZERO;
        DEFAULT_DELAY = Duration.ZERO;
        DEFAULT_STATUS = Status.STOPPED;
        DEFAULT_ON_FINISHED = null;
    }

    private class CurrentTimeProperty
    extends ReadOnlyObjectPropertyBase<Duration> {
        private CurrentTimeProperty() {
        }

        public Object getBean() {
            return Animation.this;
        }

        public String getName() {
            return "currentTime";
        }

        public Duration get() {
            return Animation.this.getCurrentTime();
        }

        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private class AnimationReadOnlyProperty<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private T value;

        private AnimationReadOnlyProperty(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public Object getBean() {
            return Animation.this;
        }

        public String getName() {
            return this.name;
        }

        public T get() {
            return this.value;
        }

        private void set(T value) {
            this.value = value;
            this.fireValueChangedEvent();
        }
    }

    private class CurrentRateProperty
    extends ReadOnlyDoublePropertyBase {
        private double value;

        private CurrentRateProperty() {
        }

        public Object getBean() {
            return Animation.this;
        }

        public String getName() {
            return "currentRate";
        }

        public double get() {
            return this.value;
        }

        private void set(double value) {
            this.value = value;
            this.fireValueChangedEvent();
        }
    }

    public static enum Status {
        PAUSED,
        RUNNING,
        STOPPED;

    }
}

