/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.shared.TimelineClipCore;
import java.util.Collection;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Duration;

public final class Timeline
extends Animation {
    final TimelineClipCore clipCore;
    private final ObservableList<KeyFrame> keyFrames = new TrackableObservableList<KeyFrame>(){

        protected void onChanged(ListChangeListener.Change<KeyFrame> c) {
            while (c.next()) {
                String cuePoint;
                if (c.wasPermutated()) continue;
                for (KeyFrame keyFrame : c.getRemoved()) {
                    cuePoint = keyFrame.getName();
                    if (cuePoint == null) continue;
                    Timeline.this.getCuePoints().remove((Object)cuePoint);
                }
                for (KeyFrame keyFrame : c.getAddedSubList()) {
                    cuePoint = keyFrame.getName();
                    if (cuePoint == null) continue;
                    Timeline.this.getCuePoints().put((Object)cuePoint, (Object)keyFrame.getTime());
                }
                Duration duration = Timeline.this.clipCore.setKeyFrames((Collection<KeyFrame>)Timeline.this.getKeyFrames());
                Timeline.this.setCycleDuration(duration);
            }
        }
    };

    public final ObservableList<KeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public Timeline(double targetFramerate, KeyFrame ... keyFrames) {
        super(targetFramerate);
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((Object[])keyFrames);
    }

    public Timeline(KeyFrame ... keyFrames) {
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((Object[])keyFrames);
    }

    public Timeline(double targetFramerate) {
        super(targetFramerate);
        this.clipCore = new TimelineClipCore(this);
    }

    public Timeline() {
        this.clipCore = new TimelineClipCore(this);
    }

    Timeline(AbstractPrimaryTimer timer) {
        super(timer);
        this.clipCore = new TimelineClipCore(this);
    }

    @Override
    void doPlayTo(long currentTicks, long cycleTicks) {
        this.clipCore.playTo(currentTicks);
    }

    @Override
    void doJumpTo(long currentTicks, long cycleTicks, boolean forceJump) {
        this.sync(false);
        this.setCurrentTicks(currentTicks);
        this.clipCore.jumpTo(currentTicks, forceJump);
    }

    @Override
    void setCurrentRate(double currentRate) {
        super.setCurrentRate(currentRate);
        this.clipCore.notifyCurrentRateChanged();
    }

    @Override
    void doStart(boolean forceSync) {
        super.doStart(forceSync);
        this.clipCore.start(forceSync);
    }

    @Override
    public void stop() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot stop when embedded in another animation");
        }
        if (this.getStatus() == Animation.Status.RUNNING) {
            this.clipCore.abort();
        }
        super.stop();
    }
}

