/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.parser.LexerState;
import com.sun.javafx.css.parser.Recognizer;
import com.sun.javafx.css.parser.Token;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

final class CssLexer {
    static final int STRING = 10;
    static final int IDENT = 11;
    static final int FUNCTION = 12;
    static final int NUMBER = 13;
    static final int CM = 14;
    static final int EMS = 15;
    static final int EXS = 16;
    static final int IN = 17;
    static final int MM = 18;
    static final int PC = 19;
    static final int PT = 20;
    static final int PX = 21;
    static final int PERCENTAGE = 22;
    static final int DEG = 23;
    static final int GRAD = 24;
    static final int RAD = 25;
    static final int TURN = 26;
    static final int GREATER = 27;
    static final int LBRACE = 28;
    static final int RBRACE = 29;
    static final int SEMI = 30;
    static final int COLON = 31;
    static final int SOLIDUS = 32;
    static final int STAR = 33;
    static final int LPAREN = 34;
    static final int RPAREN = 35;
    static final int COMMA = 36;
    static final int HASH = 37;
    static final int DOT = 38;
    static final int IMPORTANT_SYM = 39;
    static final int WS = 40;
    static final int NL = 41;
    static final int FONT_FACE = 42;
    static final int URL = 43;
    static final int IMPORT = 44;
    static final int SECONDS = 45;
    static final int MS = 46;
    static final int AT_KEYWORD = 47;
    private final Recognizer A = c -> c == 97 || c == 65;
    private final Recognizer B = c -> c == 98 || c == 66;
    private final Recognizer C = c -> c == 99 || c == 67;
    private final Recognizer D = c -> c == 100 || c == 68;
    private final Recognizer E = c -> c == 101 || c == 69;
    private final Recognizer F = c -> c == 102 || c == 70;
    private final Recognizer G = c -> c == 103 || c == 71;
    private final Recognizer H = c -> c == 104 || c == 72;
    private final Recognizer I = c -> c == 105 || c == 73;
    private final Recognizer J = c -> c == 106 || c == 74;
    private final Recognizer K = c -> c == 107 || c == 75;
    private final Recognizer L = c -> c == 108 || c == 76;
    private final Recognizer M = c -> c == 109 || c == 77;
    private final Recognizer N = c -> c == 110 || c == 78;
    private final Recognizer O = c -> c == 111 || c == 79;
    private final Recognizer P = c -> c == 112 || c == 80;
    private final Recognizer Q = c -> c == 113 || c == 81;
    private final Recognizer R = c -> c == 114 || c == 82;
    private final Recognizer S = c -> c == 115 || c == 83;
    private final Recognizer T = c -> c == 116 || c == 84;
    private final Recognizer U = c -> c == 117 || c == 85;
    private final Recognizer V = c -> c == 118 || c == 86;
    private final Recognizer W = c -> c == 119 || c == 87;
    private final Recognizer X = c -> c == 120 || c == 88;
    private final Recognizer Y = c -> c == 121 || c == 89;
    private final Recognizer Z = c -> c == 122 || c == 90;
    private final Recognizer ALPHA = c -> 97 <= c && c <= 122 || 65 <= c && c <= 90;
    private final Recognizer NON_ASCII = c -> 128 <= c && c <= 65535;
    private final Recognizer DOT_CHAR = c -> c == 46;
    private final Recognizer GREATER_CHAR = c -> c == 62;
    private final Recognizer LBRACE_CHAR = c -> c == 123;
    private final Recognizer RBRACE_CHAR = c -> c == 125;
    private final Recognizer SEMI_CHAR = c -> c == 59;
    private final Recognizer COLON_CHAR = c -> c == 58;
    private final Recognizer SOLIDUS_CHAR = c -> c == 47;
    private final Recognizer MINUS_CHAR = c -> c == 45;
    private final Recognizer PLUS_CHAR = c -> c == 43;
    private final Recognizer STAR_CHAR = c -> c == 42;
    private final Recognizer LPAREN_CHAR = c -> c == 40;
    private final Recognizer RPAREN_CHAR = c -> c == 41;
    private final Recognizer COMMA_CHAR = c -> c == 44;
    private final Recognizer UNDERSCORE_CHAR = c -> c == 95;
    private final Recognizer HASH_CHAR = c -> c == 35;
    private final Recognizer WS_CHARS = c -> c == 32 || c == 9 || c == 13 || c == 10 || c == 12;
    private final Recognizer NL_CHARS = c -> c == 13 || c == 10;
    private final Recognizer DIGIT = c -> 48 <= c && c <= 57;
    private final Recognizer HEX_DIGIT = c -> 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    final LexerState initState = new LexerState("initState", null, new Recognizer[0]){

        @Override
        public boolean accepts(int c) {
            return true;
        }
    };
    final LexerState hashState = new LexerState("hashState", this.HASH_CHAR, new Recognizer[0]);
    final LexerState minusState = new LexerState("minusState", this.MINUS_CHAR, new Recognizer[0]);
    final LexerState plusState = new LexerState("plusState", this.PLUS_CHAR, new Recognizer[0]);
    final LexerState dotState = new LexerState(38, "dotState", this.DOT_CHAR, new Recognizer[0]);
    final LexerState nmStartState = new LexerState(11, "nmStartState", this.UNDERSCORE_CHAR, this.ALPHA);
    final LexerState nmCharState = new LexerState(11, "nmCharState", this.UNDERSCORE_CHAR, this.ALPHA, this.DIGIT, this.MINUS_CHAR);
    final LexerState hashNameCharState = new LexerState(37, "hashNameCharState", this.UNDERSCORE_CHAR, this.ALPHA, this.DIGIT, this.MINUS_CHAR);
    final LexerState lparenState = new LexerState(12, "lparenState", this.LPAREN_CHAR, new Recognizer[0]){

        @Override
        public int getType() {
            if (CssLexer.this.text.indexOf("url(") == 0) {
                try {
                    return CssLexer.this.consumeUrl();
                }
                catch (IOException ioe) {
                    return 0;
                }
            }
            return super.getType();
        }
    };
    final LexerState leadingDigitsState = new LexerState(13, "leadingDigitsState", this.DIGIT, new Recognizer[0]);
    final LexerState decimalMarkState = new LexerState("decimalMarkState", this.DOT_CHAR, new Recognizer[0]);
    final LexerState trailingDigitsState = new LexerState(13, "trailingDigitsState", this.DIGIT, new Recognizer[0]);
    final LexerState unitsState = new UnitsState();
    private int pos = 0;
    private int offset = 0;
    private int line = 1;
    private int lastc = -1;
    private int ch;
    private boolean charNotConsumed = false;
    private Reader reader;
    private Token token;
    private final Map<LexerState, LexerState[]> stateMap = this.createStateMap();
    private LexerState currentState;
    private final StringBuilder text = new StringBuilder(64);

    private Map<LexerState, LexerState[]> createStateMap() {
        HashMap<LexerState, LexerState[]> map = new HashMap<LexerState, LexerState[]>();
        map.put(this.initState, new LexerState[]{this.hashState, this.minusState, this.nmStartState, this.plusState, this.minusState, this.leadingDigitsState, this.dotState});
        map.put(this.minusState, new LexerState[]{this.nmStartState, this.leadingDigitsState, this.decimalMarkState});
        map.put(this.hashState, new LexerState[]{this.hashNameCharState});
        map.put(this.hashNameCharState, new LexerState[]{this.hashNameCharState});
        map.put(this.nmStartState, new LexerState[]{this.nmCharState});
        map.put(this.nmCharState, new LexerState[]{this.nmCharState, this.lparenState});
        map.put(this.plusState, new LexerState[]{this.leadingDigitsState, this.decimalMarkState});
        map.put(this.leadingDigitsState, new LexerState[]{this.leadingDigitsState, this.decimalMarkState, this.unitsState});
        map.put(this.dotState, new LexerState[]{this.trailingDigitsState});
        map.put(this.decimalMarkState, new LexerState[]{this.trailingDigitsState});
        map.put(this.trailingDigitsState, new LexerState[]{this.trailingDigitsState, this.unitsState});
        map.put(this.unitsState, new LexerState[]{this.unitsState});
        return map;
    }

    CssLexer() {
        this.currentState = this.initState;
    }

    void setReader(Reader reader) {
        this.reader = reader;
        this.lastc = -1;
        this.offset = 0;
        this.pos = 0;
        this.line = 1;
        this.currentState = this.initState;
        this.token = null;
        try {
            this.ch = this.readChar();
        }
        catch (IOException ioe) {
            this.token = Token.EOF_TOKEN;
        }
    }

    private Token scanImportant() throws IOException {
        Recognizer[] important_sym = new Recognizer[]{this.I, this.M, this.P, this.O, this.R, this.T, this.A, this.N, this.T};
        int current = 0;
        this.text.append((char)this.ch);
        this.ch = this.readChar();
        block5: while (true) {
            switch (this.ch) {
                case -1: {
                    this.token = Token.EOF_TOKEN;
                    return this.token;
                }
                case 47: {
                    this.ch = this.readChar();
                    if (this.ch == 42) {
                        this.skipComment();
                        continue block5;
                    }
                    if (this.ch == 47) {
                        this.skipEOL();
                        continue block5;
                    }
                    this.text.append('/').append((char)this.ch);
                    int temp = this.offset;
                    this.offset = this.pos;
                    return new Token(0, this.text.toString(), this.line, temp);
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.ch = this.readChar();
                    continue block5;
                }
            }
            break;
        }
        boolean accepted = true;
        while (accepted && current < important_sym.length) {
            accepted = important_sym[current++].recognize(this.ch);
            this.text.append((char)this.ch);
            this.ch = this.readChar();
        }
        if (accepted) {
            int temp = this.offset;
            this.offset = this.pos - 1;
            return new Token(39, "!important", this.line, temp);
        }
        while (this.ch != 59 && this.ch != 125 && this.ch != -1) {
            this.ch = this.readChar();
        }
        if (this.ch != -1) {
            int temp = this.offset;
            this.offset = this.pos - 1;
            return new Token(1, this.text.toString(), this.line, temp);
        }
        return Token.EOF_TOKEN;
    }

    private int consumeUrl() throws IOException {
        this.text.delete(0, this.text.length());
        while (this.WS_CHARS.recognize(this.ch)) {
            this.ch = this.readChar();
        }
        if (this.ch == -1) {
            return -1;
        }
        if (this.ch == 39 || this.ch == 34) {
            int endQuote = this.ch;
            this.ch = this.readChar();
            while (this.ch != endQuote && this.ch != -1 && !this.NL_CHARS.recognize(this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.readChar();
                    if (this.NL_CHARS.recognize(this.ch)) {
                        while (this.NL_CHARS.recognize(this.ch)) {
                            this.ch = this.readChar();
                        }
                        continue;
                    }
                    if (this.ch == -1) continue;
                    this.text.append((char)this.ch);
                    this.ch = this.readChar();
                    continue;
                }
                this.text.append((char)this.ch);
                this.ch = this.readChar();
            }
            if (this.ch == endQuote) {
                this.ch = this.readChar();
                while (this.WS_CHARS.recognize(this.ch)) {
                    this.ch = this.readChar();
                }
                if (this.ch == 41) {
                    this.ch = this.readChar();
                    return 43;
                }
                if (this.ch == -1) {
                    return 43;
                }
            }
        } else {
            this.text.append((char)this.ch);
            this.ch = this.readChar();
            block4: while (true) {
                if (this.WS_CHARS.recognize(this.ch)) {
                    this.ch = this.readChar();
                    continue;
                }
                if (this.ch == 41) {
                    this.ch = this.readChar();
                    return 43;
                }
                if (this.ch == -1) {
                    return 43;
                }
                if (this.ch == 92) {
                    this.ch = this.readChar();
                    if (this.NL_CHARS.recognize(this.ch)) {
                        while (true) {
                            if (!this.NL_CHARS.recognize(this.ch)) continue block4;
                            this.ch = this.readChar();
                        }
                    }
                    if (this.ch == -1) continue;
                    this.text.append((char)this.ch);
                    this.ch = this.readChar();
                    continue;
                }
                if (this.ch == 39 || this.ch == 34 || this.ch == 40) break;
                this.text.append((char)this.ch);
                this.ch = this.readChar();
            }
        }
        while (true) {
            int lastCh = this.ch;
            if (this.ch == -1) {
                return -1;
            }
            if (this.ch == 41 && lastCh != 92) {
                this.ch = this.readChar();
                return 0;
            }
            lastCh = this.ch;
            this.ch = this.readChar();
        }
    }

    private void skipComment() throws IOException {
        while (this.ch != -1) {
            if (this.ch == 42) {
                this.ch = this.readChar();
                if (this.ch != 47) continue;
                this.offset = this.pos;
                this.ch = this.readChar();
                break;
            }
            this.ch = this.readChar();
        }
    }

    private void skipEOL() throws IOException {
        int lastc = this.ch;
        while (this.ch != -1) {
            this.ch = this.readChar();
            if (this.ch != 10 && (lastc != 13 || this.ch == 10)) continue;
            break;
        }
    }

    private int readChar() throws IOException {
        int c = this.reader.read();
        if (this.lastc == 10 || this.lastc == 13 && c != 10) {
            this.pos = 1;
            this.offset = 0;
            ++this.line;
        } else {
            ++this.pos;
        }
        this.lastc = c;
        return c;
    }

    Token nextToken() {
        Token tok = null;
        if (this.token != null) {
            tok = this.token;
            if (this.token.getType() != -1) {
                this.token = null;
            }
        } else {
            while ((tok = this.getToken()) != null && Token.SKIP_TOKEN.equals(tok)) {
            }
        }
        this.text.delete(0, this.text.length());
        this.currentState = this.initState;
        return tok;
    }

    /*
     * Unable to fully structure code
     */
    private Token getToken() {
        try {
            block22: while (true) {
                this.charNotConsumed = false;
                reachableStates = this.currentState != null ? this.stateMap.get(this.currentState) : null;
                max = reachableStates != null ? reachableStates.length : 0;
                newState = null;
                for (n = 0; n < max && newState == null; ++n) {
                    reachableState = reachableStates[n];
                    if (!reachableState.accepts(this.ch)) continue;
                    newState = reachableState;
                }
                if (newState != null) {
                    this.currentState = newState;
                    this.text.append((char)this.ch);
                    this.ch = this.readChar();
                    continue;
                }
                v0 = type = this.currentState != null ? this.currentState.getType() : 0;
                if (type != 0 || !this.currentState.equals(this.initState)) {
                    str = this.text.toString();
                    tok = new Token(type, str, this.line, this.offset);
                    this.offset = this.pos - 1;
                    return tok;
                }
                switch (this.ch) {
                    case -1: {
                        this.token = Token.EOF_TOKEN;
                        return this.token;
                    }
                    case 34: 
                    case 39: {
                        this.text.append((char)this.ch);
                        endq = this.ch;
                        while ((this.ch = this.readChar()) != -1) {
                            this.text.append((char)this.ch);
                            if (this.ch != endq) continue;
                        }
                        if (this.ch != -1) {
                            this.token = new Token(10, this.text.toString(), this.line, this.offset);
                            this.offset = this.pos;
                            break block22;
                        }
                        this.token = new Token(0, this.text.toString(), this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 47: {
                        this.ch = this.readChar();
                        if (this.ch == 42) {
                            this.skipComment();
                            if (this.ch != -1) continue block22;
                            this.token = Token.EOF_TOKEN;
                            return this.token;
                        }
                        if (this.ch == 47) {
                            this.skipEOL();
                            if (this.ch == -1) ** break;
                            continue block22;
                            this.token = Token.EOF_TOKEN;
                            return this.token;
                        }
                        this.token = new Token(32, "/", this.line, this.offset);
                        this.offset = this.pos;
                        this.charNotConsumed = true;
                        break block22;
                    }
                    case 62: {
                        this.token = new Token(27, ">", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 123: {
                        this.token = new Token(28, "{", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 125: {
                        this.token = new Token(29, "}", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 59: {
                        this.token = new Token(30, ";", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 58: {
                        this.token = new Token(31, ":", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 42: {
                        this.token = new Token(33, "*", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 40: {
                        this.token = new Token(34, "(", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 41: {
                        this.token = new Token(35, ")", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 44: {
                        this.token = new Token(36, ",", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 46: {
                        this.token = new Token(38, ".", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 9: 
                    case 12: 
                    case 32: {
                        this.token = new Token(40, Character.toString((char)this.ch), this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    case 13: {
                        this.token = new Token(41, "\\r", this.line, this.offset);
                        this.ch = this.readChar();
                        if (this.ch == 10) {
                            this.token = new Token(41, "\\r\\n", this.line, this.offset);
                            break block22;
                        }
                        tok = this.token;
                        this.token = this.ch == -1 ? Token.EOF_TOKEN : null;
                        return tok;
                    }
                    case 10: {
                        this.token = new Token(41, "\\n", this.line, this.offset);
                        break block22;
                    }
                    case 33: {
                        tok = this.scanImportant();
                        return tok;
                    }
                    case 64: {
                        this.token = new Token(47, "@", this.line, this.offset);
                        this.offset = this.pos;
                        break block22;
                    }
                    default: {
                        this.token = new Token(0, Character.toString((char)this.ch), this.line, this.offset);
                        this.offset = this.pos;
                    }
                }
                break;
            }
            if (this.token == null) {
                this.token = new Token(0, null, this.line, this.offset);
                this.offset = this.pos;
            } else if (this.token.getType() == -1) {
                return this.token;
            }
            if (this.ch != -1 && !this.charNotConsumed) {
                this.ch = this.readChar();
            }
            tok = this.token;
            this.token = null;
            return tok;
        }
        catch (IOException ioe) {
            this.token = Token.EOF_TOKEN;
            return this.token;
        }
    }

    private class UnitsState
    extends LexerState {
        private final Recognizer[][] units;
        private int unitsMask;
        private int index;

        UnitsState() {
            super(-1, "UnitsState", null, new Recognizer[0]);
            this.units = new Recognizer[][]{{CssLexer.this.C, CssLexer.this.M}, {CssLexer.this.D, CssLexer.this.E, CssLexer.this.G}, {CssLexer.this.E, CssLexer.this.M}, {CssLexer.this.E, CssLexer.this.X}, {CssLexer.this.G, CssLexer.this.R, CssLexer.this.A, CssLexer.this.D}, {CssLexer.this.I, CssLexer.this.N}, {CssLexer.this.M, CssLexer.this.M}, {CssLexer.this.M, CssLexer.this.S}, {CssLexer.this.P, CssLexer.this.C}, {CssLexer.this.P, CssLexer.this.T}, {CssLexer.this.P, CssLexer.this.X}, {CssLexer.this.R, CssLexer.this.A, CssLexer.this.D}, {CssLexer.this.S}, {CssLexer.this.T, CssLexer.this.U, CssLexer.this.R, CssLexer.this.N}, {c -> c == 37}};
            this.unitsMask = Short.MAX_VALUE;
            this.index = -1;
        }

        @Override
        public int getType() {
            int type = 0;
            switch (this.unitsMask) {
                case 1: {
                    type = 14;
                    break;
                }
                case 2: {
                    type = 23;
                    break;
                }
                case 4: {
                    type = 15;
                    break;
                }
                case 8: {
                    type = 16;
                    break;
                }
                case 16: {
                    type = 24;
                    break;
                }
                case 32: {
                    type = 17;
                    break;
                }
                case 64: {
                    type = 18;
                    break;
                }
                case 128: {
                    type = 46;
                    break;
                }
                case 256: {
                    type = 19;
                    break;
                }
                case 512: {
                    type = 20;
                    break;
                }
                case 1024: {
                    type = 21;
                    break;
                }
                case 2048: {
                    type = 25;
                    break;
                }
                case 4096: {
                    type = 45;
                    break;
                }
                case 8192: {
                    type = 26;
                    break;
                }
                case 16384: {
                    type = 22;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            this.unitsMask = Short.MAX_VALUE;
            this.index = -1;
            return type;
        }

        @Override
        public boolean accepts(int c) {
            if (!CssLexer.this.ALPHA.recognize(c) && c != 37) {
                return false;
            }
            if (this.unitsMask == 0) {
                return true;
            }
            ++this.index;
            for (int n = 0; n < this.units.length; ++n) {
                int u = 1 << n;
                if ((this.unitsMask & u) == 0 || this.index < this.units[n].length && this.units[n][this.index].recognize(c)) continue;
                this.unitsMask &= ~u;
            }
            return true;
        }
    }
}

