/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.Logging;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.paint.CycleMethod;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;

public final class EnumConverter<E extends Enum<E>>
extends StyleConverter<String, E> {
    final Class<E> enumClass;
    private static Map<String, StyleConverter<?, ?>> converters;

    public EnumConverter(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public E convert(ParsedValue<String, E> value, Font not_used) {
        if (this.enumClass == null) {
            return null;
        }
        String string = value.getValue();
        int dotPos = string.lastIndexOf(46);
        if (dotPos > -1) {
            string = string.substring(dotPos + 1);
        }
        try {
            string = string.replace('-', '_');
            return Enum.valueOf(this.enumClass, string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return Enum.valueOf(this.enumClass, string);
        }
    }

    @Override
    public void writeBinary(DataOutputStream os, StyleConverter.StringStore sstore) throws IOException {
        super.writeBinary(os, sstore);
        String ename = this.enumClass.getName();
        int index = sstore.addString(ename);
        os.writeShort(index);
    }

    public static StyleConverter<?, ?> readBinary(DataInputStream is, String[] strings) throws IOException {
        String ename;
        short index = is.readShort();
        String string = ename = 0 <= index && index <= strings.length ? strings[index] : null;
        if (ename == null || ename.isEmpty()) {
            return null;
        }
        if (converters == null || !converters.containsKey(ename)) {
            PlatformLogger logger;
            StyleConverter<?, ?> converter = EnumConverter.getInstance(ename);
            if (converter == null && (logger = Logging.getCSSLogger()).isLoggable(PlatformLogger.Level.SEVERE)) {
                logger.severe("could not deserialize EnumConverter for " + ename);
            }
            if (converters == null) {
                converters = new HashMap();
            }
            converters.put(ename, converter);
            return converter;
        }
        return converters.get(ename);
    }

    public static StyleConverter<?, ?> getInstance(String ename) {
        EnumConverter<Enum> converter = null;
        switch (ename) {
            case "com.sun.javafx.cursor.CursorType": {
                converter = new EnumConverter<CursorType>(CursorType.class);
                break;
            }
            case "javafx.scene.layout.BackgroundRepeat": 
            case "com.sun.javafx.scene.layout.region.Repeat": {
                converter = new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class);
                break;
            }
            case "javafx.geometry.HPos": {
                converter = new EnumConverter<HPos>(HPos.class);
                break;
            }
            case "javafx.geometry.Orientation": {
                converter = new EnumConverter<Orientation>(Orientation.class);
                break;
            }
            case "javafx.geometry.Pos": {
                converter = new EnumConverter<Pos>(Pos.class);
                break;
            }
            case "javafx.geometry.Side": {
                converter = new EnumConverter<Side>(Side.class);
                break;
            }
            case "javafx.geometry.VPos": {
                converter = new EnumConverter<VPos>(VPos.class);
                break;
            }
            case "javafx.scene.effect.BlendMode": {
                converter = new EnumConverter<BlendMode>(BlendMode.class);
                break;
            }
            case "javafx.scene.effect.BlurType": {
                converter = new EnumConverter<BlurType>(BlurType.class);
                break;
            }
            case "javafx.scene.paint.CycleMethod": {
                converter = new EnumConverter<CycleMethod>(CycleMethod.class);
                break;
            }
            case "javafx.scene.shape.ArcType": {
                converter = new EnumConverter<ArcType>(ArcType.class);
                break;
            }
            case "javafx.scene.shape.StrokeLineCap": {
                converter = new EnumConverter<StrokeLineCap>(StrokeLineCap.class);
                break;
            }
            case "javafx.scene.shape.StrokeLineJoin": {
                converter = new EnumConverter<StrokeLineJoin>(StrokeLineJoin.class);
                break;
            }
            case "javafx.scene.shape.StrokeType": {
                converter = new EnumConverter<StrokeType>(StrokeType.class);
                break;
            }
            case "javafx.scene.text.FontPosture": {
                converter = new EnumConverter<FontPosture>(FontPosture.class);
                break;
            }
            case "javafx.scene.text.FontSmoothingType": {
                converter = new EnumConverter<FontSmoothingType>(FontSmoothingType.class);
                break;
            }
            case "javafx.scene.text.FontWeight": {
                converter = new EnumConverter<FontWeight>(FontWeight.class);
                break;
            }
            case "javafx.scene.text.TextAlignment": {
                converter = new EnumConverter<TextAlignment>(TextAlignment.class);
                break;
            }
            default: {
                assert (false) : "EnumConverter<" + ename + "> not expected";
                PlatformLogger logger = Logging.getCSSLogger();
                if (!logger.isLoggable(PlatformLogger.Level.SEVERE)) break;
                logger.severe("EnumConverter : converter Class is null for : " + ename);
            }
        }
        return converter;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof EnumConverter)) {
            return false;
        }
        return this.enumClass.equals(((EnumConverter)other).enumClass);
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    public String toString() {
        return "EnumConverter[" + this.enumClass.getName() + "]";
    }
}

