/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import javafx.application.Application;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.converter.StringConverter;
import javafx.scene.text.Font;

public final class URLConverter
extends StyleConverter<ParsedValue[], String> {
    public static StyleConverter<ParsedValue[], String> getInstance() {
        return Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public String convert(ParsedValue<ParsedValue[], String> value, Font font) {
        String url = null;
        ParsedValue[] values = value.getValue();
        String resource = values.length > 0 ? StringConverter.getInstance().convert(values[0], font) : null;
        String string = resource = resource != null ? resource.trim() : null;
        if (resource != null && !resource.isEmpty()) {
            String stylesheetURL;
            URL resolvedURL;
            if (DataURI.matchScheme(resource = resource.startsWith("url(") ? Utils.stripQuotes(resource.substring(4, resource.length() - 1)) : Utils.stripQuotes(resource))) {
                url = resource;
            } else if (!resource.isEmpty() && (resolvedURL = this.resolve(stylesheetURL = values.length > 1 && values[1] != null ? (String)values[1].getValue() : null, resource)) != null) {
                url = resolvedURL.toExternalForm();
            }
        }
        return url;
    }

    private URL resolve(String stylesheetUrl, String resource) {
        try {
            String stylesheetPath;
            URI resourceUri = new URI(resource);
            if (resourceUri.isAbsolute()) {
                return resourceUri.toURL();
            }
            URL rtJarUrl = this.resolveRuntimeImport(resourceUri);
            if (rtJarUrl != null) {
                return rtJarUrl;
            }
            String path = resourceUri.getPath();
            if (path.startsWith("/")) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                return contextClassLoader.getResource(path.substring(1));
            }
            String string = stylesheetPath = stylesheetUrl != null ? stylesheetUrl.trim() : null;
            if (stylesheetPath != null && !stylesheetPath.isEmpty()) {
                URI stylesheetUri = new URI(stylesheetPath);
                if (!stylesheetUri.isOpaque()) {
                    URI resolved = stylesheetUri.resolve(resourceUri);
                    return resolved.toURL();
                }
                URL url = stylesheetUri.toURL();
                return new URL(url, resourceUri.getPath());
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return contextClassLoader.getResource(path);
        }
        catch (MalformedURLException | URISyntaxException e) {
            PlatformLogger cssLogger = Logging.getCSSLogger();
            if (cssLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                cssLogger.warning(e.getLocalizedMessage());
            }
            return null;
        }
    }

    private URL resolveRuntimeImport(URI resourceUri) {
        String resourcePath;
        String path = resourceUri.getPath();
        String string = resourcePath = path.startsWith("/") ? path.substring(1) : path;
        if ((resourcePath.startsWith("com/sun/javafx/scene/control/skin/modena/") || resourcePath.startsWith("com/sun/javafx/scene/control/skin/caspian/")) && (resourcePath.endsWith(".css") || resourcePath.endsWith(".bss"))) {
            System.err.println("WARNING: resolveRuntimeImport cannot resolve: " + resourcePath);
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                URL resolved = contextClassLoader.getResource(resourcePath);
                return resolved;
            }
            try {
                URL rtJarURL = AccessController.doPrivileged(() -> {
                    ProtectionDomain protectionDomain = Application.class.getProtectionDomain();
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    return codeSource.getLocation();
                });
                URI rtJarURI = rtJarURL.toURI();
                String scheme = rtJarURI.getScheme();
                String rtJarPath = rtJarURI.getPath();
                if ("file".equals(scheme) && rtJarPath.endsWith(".jar") && "file".equals(scheme)) {
                    scheme = "jar:file";
                    rtJarPath = rtJarPath.concat("!/");
                }
                rtJarPath = rtJarPath.concat(resourcePath);
                String rtJarUserInfo = rtJarURI.getUserInfo();
                String rtJarHost = rtJarURI.getHost();
                int rtJarPort = rtJarURI.getPort();
                URI resolved = new URI(scheme, rtJarUserInfo, rtJarHost, rtJarPort, rtJarPath, null, null);
                return resolved.toURL();
            }
            catch (MalformedURLException | URISyntaxException | PrivilegedActionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        return "URLType";
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(ParsedValue<ParsedValue<ParsedValue[], String>[], String[]> value, Font font) {
            ParsedValue<ParsedValue[], String>[] layers = value.getValue();
            String[] urls = new String[layers.length];
            for (int layer = 0; layer < layers.length; ++layer) {
                urls[layer] = URLConverter.getInstance().convert(layers[layer], font);
            }
            return urls;
        }

        public String toString() {
            return "URLSeqType";
        }
    }

    private static class Holder {
        static final URLConverter INSTANCE = new URLConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

