/*
 * Decompiled with CFR 0.152.
 */
package javafx.print;

import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.print.Collation;
import javafx.print.PageLayout;
import javafx.print.PageRange;
import javafx.print.PaperSource;
import javafx.print.PrintColor;
import javafx.print.PrintQuality;
import javafx.print.PrintResolution;
import javafx.print.PrintSides;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.print.PrinterJob;

public final class JobSettings {
    private PrinterJob job;
    private Printer printer;
    private PrinterAttributes printerCaps;
    private boolean defaultCopies = true;
    private boolean hasOldCopies = false;
    private int oldCopies;
    private boolean defaultSides = true;
    private boolean hasOldSides = false;
    private PrintSides oldSides;
    private boolean defaultCollation = true;
    private boolean hasOldCollation = false;
    private Collation oldCollation;
    private boolean defaultPrintColor = true;
    private boolean hasOldPrintColor = false;
    private PrintColor oldPrintColor;
    private boolean defaultPrintQuality = true;
    private boolean hasOldPrintQuality = false;
    private PrintQuality oldPrintQuality;
    private boolean defaultPrintResolution = true;
    private boolean hasOldPrintResolution = false;
    private PrintResolution oldPrintResolution;
    private boolean defaultPaperSource = true;
    private boolean hasOldPaperSource = false;
    private PaperSource oldPaperSource;
    private boolean defaultPageLayout = true;
    private boolean hasOldPageLayout = false;
    private PageLayout oldPageLayout;
    private static final String DEFAULT_JOBNAME = "JavaFX Print Job";
    private SimpleStringProperty jobName;
    private SimpleStringProperty outputFile;
    private IntegerProperty copies;
    private ObjectProperty<PageRange[]> pageRanges = null;
    private ObjectProperty<PrintSides> sides = null;
    private ObjectProperty<Collation> collation = null;
    private ObjectProperty<PrintColor> color = null;
    private ObjectProperty<PrintQuality> quality = null;
    private ObjectProperty<PrintResolution> resolution = null;
    private ObjectProperty<PaperSource> paperSource = null;
    private ObjectProperty<PageLayout> layout = null;

    JobSettings(Printer printer) {
        this.printer = printer;
        this.printerCaps = printer.getPrinterAttributes();
    }

    void setPrinterJob(PrinterJob job) {
        this.job = job;
    }

    private boolean isJobNew() {
        return this.job == null || this.job.isJobNew();
    }

    void updateForPrinter(Printer printer) {
        this.printer = printer;
        this.printerCaps = printer.getPrinterAttributes();
        if (this.defaultCopies) {
            if (this.getCopies() != this.printerCaps.getDefaultCopies()) {
                this.setCopies(this.printerCaps.getDefaultCopies());
                this.defaultCopies = true;
            }
        } else {
            int copies = this.getCopies();
            if (this.hasOldCopies && this.oldCopies > copies) {
                copies = this.oldCopies;
            }
            int maxCopies = this.printerCaps.getMaxCopies();
            if (!this.hasOldCopies && this.getCopies() > maxCopies) {
                this.hasOldCopies = true;
                this.oldCopies = this.getCopies();
            }
            if (copies > maxCopies) {
                copies = maxCopies;
            }
            this.setCopies(copies);
        }
        PrintSides currSides = this.getPrintSides();
        PrintSides defSides = this.printerCaps.getDefaultPrintSides();
        Set<PrintSides> suppSides = this.printerCaps.getSupportedPrintSides();
        if (this.defaultSides) {
            if (currSides != defSides) {
                this.setPrintSides(defSides);
                this.defaultSides = true;
            }
        } else if (this.hasOldSides) {
            if (suppSides.contains((Object)this.oldSides)) {
                this.setPrintSides(this.oldSides);
                this.hasOldSides = false;
            } else {
                this.setPrintSides(defSides);
            }
        } else if (!suppSides.contains((Object)currSides)) {
            this.hasOldSides = true;
            this.oldSides = currSides;
            this.setPrintSides(defSides);
        }
        Collation currColl = this.getCollation();
        Collation defColl = this.printerCaps.getDefaultCollation();
        Set<Collation> suppColl = this.printerCaps.getSupportedCollations();
        if (this.defaultCollation) {
            if (currColl != defColl) {
                this.setCollation(defColl);
                this.defaultCollation = true;
            }
        } else if (this.hasOldCollation) {
            if (suppColl.contains((Object)this.oldCollation)) {
                this.setCollation(this.oldCollation);
                this.hasOldCollation = false;
            } else {
                this.setCollation(defColl);
            }
        } else if (!suppColl.contains((Object)currColl)) {
            this.hasOldCollation = true;
            this.oldCollation = currColl;
            this.setCollation(defColl);
        }
        PrintColor currColor = this.getPrintColor();
        PrintColor defColor = this.printerCaps.getDefaultPrintColor();
        Set<PrintColor> suppColors = this.printerCaps.getSupportedPrintColors();
        if (this.defaultPrintColor) {
            if (currColor != defColor) {
                this.setPrintColor(defColor);
                this.defaultPrintColor = true;
            }
        } else if (this.hasOldPrintColor) {
            if (suppColors.contains((Object)this.oldPrintColor)) {
                this.setPrintColor(this.oldPrintColor);
                this.hasOldPrintColor = false;
            } else {
                this.setPrintColor(defColor);
            }
        } else if (!suppColors.contains((Object)currColor)) {
            this.hasOldPrintColor = true;
            this.oldPrintColor = currColor;
            this.setPrintColor(defColor);
        }
        PrintQuality currQuality = this.getPrintQuality();
        PrintQuality defQuality = this.printerCaps.getDefaultPrintQuality();
        Set<PrintQuality> suppQuality = this.printerCaps.getSupportedPrintQuality();
        if (this.defaultPrintQuality) {
            if (currQuality != defQuality) {
                this.setPrintQuality(defQuality);
                this.defaultPrintQuality = true;
            }
        } else if (this.hasOldPrintQuality) {
            if (suppQuality.contains((Object)this.oldPrintQuality)) {
                this.setPrintQuality(this.oldPrintQuality);
                this.hasOldPrintQuality = false;
            } else {
                this.setPrintQuality(defQuality);
            }
        } else if (!suppQuality.contains((Object)currQuality)) {
            this.hasOldPrintQuality = true;
            this.oldPrintQuality = currQuality;
            this.setPrintQuality(defQuality);
        }
        PrintResolution currRes = this.getPrintResolution();
        PrintResolution defResolution = this.printerCaps.getDefaultPrintResolution();
        Set<PrintResolution> suppRes = this.printerCaps.getSupportedPrintResolutions();
        if (this.defaultPrintResolution) {
            if (currRes != defResolution) {
                this.setPrintResolution(defResolution);
                this.defaultPrintResolution = true;
            }
        } else if (this.hasOldPrintResolution) {
            if (suppRes.contains(this.oldPrintResolution)) {
                this.setPrintResolution(this.oldPrintResolution);
                this.hasOldPrintResolution = false;
            } else {
                this.setPrintResolution(defResolution);
            }
        } else if (!suppRes.contains(currRes)) {
            this.hasOldPrintResolution = true;
            this.oldPrintResolution = currRes;
            this.setPrintResolution(defResolution);
        }
        PaperSource currSource = this.getPaperSource();
        PaperSource defSource = this.printerCaps.getDefaultPaperSource();
        Set<PaperSource> suppSources = this.printerCaps.getSupportedPaperSources();
        if (this.defaultPaperSource) {
            if (currSource != defSource) {
                this.setPaperSource(defSource);
                this.defaultPaperSource = true;
            }
        } else if (this.hasOldPaperSource) {
            if (suppSources.contains(this.oldPaperSource)) {
                this.setPaperSource(this.oldPaperSource);
                this.hasOldPaperSource = false;
            } else {
                this.setPaperSource(defSource);
            }
        } else if (!suppSources.contains(currSource)) {
            this.hasOldPaperSource = true;
            this.oldPaperSource = currSource;
            this.setPaperSource(defSource);
        }
        PageLayout currPageLayout = this.getPageLayout();
        PageLayout defPageLayout = printer.getDefaultPageLayout();
        if (this.defaultPageLayout) {
            if (!currPageLayout.equals(defPageLayout)) {
                this.setPageLayout(defPageLayout);
                this.defaultPageLayout = true;
            }
        } else if (this.hasOldPageLayout) {
            PageLayout valPageLayout = this.job.validatePageLayout(this.oldPageLayout);
            if (valPageLayout.equals(this.oldPageLayout)) {
                this.setPageLayout(this.oldPageLayout);
                this.hasOldPageLayout = false;
            } else {
                this.setPageLayout(defPageLayout);
            }
        } else {
            PageLayout valPageLayout = this.job.validatePageLayout(currPageLayout);
            if (!valPageLayout.equals(currPageLayout)) {
                this.hasOldPageLayout = true;
                this.oldPageLayout = currPageLayout;
                this.setPageLayout(defPageLayout);
            }
        }
    }

    public final StringProperty jobNameProperty() {
        if (this.jobName == null) {
            this.jobName = new SimpleStringProperty(this, "jobName", DEFAULT_JOBNAME){

                public void set(String value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        value = JobSettings.DEFAULT_JOBNAME;
                    }
                    super.set(value);
                }

                public void bind(ObservableValue<? extends String> rawObservable) {
                    throw new RuntimeException("Jobname property cannot be bound");
                }

                public void bindBidirectional(Property<String> other) {
                    throw new RuntimeException("Jobname property cannot be bound");
                }

                public String toString() {
                    return this.get();
                }
            };
        }
        return this.jobName;
    }

    public final String getJobName() {
        return (String)this.jobNameProperty().get();
    }

    public final void setJobName(String name) {
        this.jobNameProperty().set((Object)name);
    }

    public final StringProperty outputFileProperty() {
        if (this.outputFile == null) {
            this.outputFile = new SimpleStringProperty(this, "outputFile", ""){

                public void set(String value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        value = "";
                    }
                    super.set(value);
                }

                public void bind(ObservableValue<? extends String> rawObservable) {
                    throw new RuntimeException("OutputFile property cannot be bound");
                }

                public void bindBidirectional(Property<String> other) {
                    throw new RuntimeException("OutputFile property cannot be bound");
                }

                public String toString() {
                    return this.get();
                }
            };
        }
        return this.outputFile;
    }

    public final String getOutputFile() {
        return (String)this.outputFileProperty().get();
    }

    public final void setOutputFile(String filePath) {
        this.outputFileProperty().set((Object)filePath);
    }

    public final IntegerProperty copiesProperty() {
        if (this.copies == null) {
            this.copies = new SimpleIntegerProperty(this, "copies", this.printerCaps.getDefaultCopies()){

                public void set(int value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value <= 0) {
                        if (JobSettings.this.defaultCopies) {
                            return;
                        }
                        super.set(JobSettings.this.printerCaps.getDefaultCopies());
                        JobSettings.this.defaultCopies = true;
                        return;
                    }
                    super.set(value);
                    JobSettings.this.defaultCopies = false;
                }

                public void bind(ObservableValue<? extends Number> rawObservable) {
                    throw new RuntimeException("Copies property cannot be bound");
                }

                public void bindBidirectional(Property<Number> other) {
                    throw new RuntimeException("Copies property cannot be bound");
                }

                public String toString() {
                    return "" + this.get();
                }
            };
        }
        return this.copies;
    }

    public final int getCopies() {
        return this.copiesProperty().get();
    }

    public final void setCopies(int nCopies) {
        this.copiesProperty().set(nCopies);
    }

    public final ObjectProperty pageRangesProperty() {
        if (this.pageRanges == null) {
            this.pageRanges = new SimpleObjectProperty(this, "pageRanges", null){

                public void set(Object o) {
                    try {
                        this.set((PageRange[])o);
                    }
                    catch (ClassCastException e) {
                        return;
                    }
                }

                public void set(PageRange[] value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null || value.length == 0 || value[0] == null) {
                        value = null;
                    } else {
                        int len = value.length;
                        PageRange[] arr = new PageRange[len];
                        int curr = 0;
                        for (int i = 0; i < len; ++i) {
                            PageRange r = value[i];
                            if (r == null || curr >= r.getStartPage()) {
                                return;
                            }
                            curr = r.getEndPage();
                            arr[i] = r;
                        }
                        value = arr;
                    }
                    super.set((Object)value);
                }

                public void bind(ObservableValue rawObservable) {
                    throw new RuntimeException("PageRanges property cannot be bound");
                }

                public void bindBidirectional(Property other) {
                    throw new RuntimeException("PageRanges property cannot be bound");
                }

                public String toString() {
                    PageRange[] ranges = (PageRange[])this.get();
                    if (ranges == null || ranges.length == 0) {
                        return "null";
                    }
                    Object s = "";
                    int len = ranges.length;
                    for (int r = 0; r < len; ++r) {
                        s = (String)s + ranges[r];
                        s = r + 1 < len ? (String)s + ", " : (String)s + ".";
                    }
                    return s;
                }
            };
        }
        return this.pageRanges;
    }

    public final PageRange[] getPageRanges() {
        return (PageRange[])this.pageRangesProperty().get();
    }

    public final void setPageRanges(PageRange ... pages) {
        this.pageRangesProperty().set((Object)pages);
    }

    public final ObjectProperty<PrintSides> printSidesProperty() {
        if (this.sides == null) {
            this.sides = new SimpleObjectProperty<PrintSides>((Object)this, "printSides", this.printerCaps.getDefaultPrintSides()){

                public void set(PrintSides value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultSides) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultPrintSides());
                        JobSettings.this.defaultSides = true;
                    }
                    if (JobSettings.this.printerCaps.getSupportedPrintSides().contains((Object)value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultSides = false;
                    }
                }

                public void bind(ObservableValue<? extends PrintSides> rawObservable) {
                    throw new RuntimeException("PrintSides property cannot be bound");
                }

                public void bindBidirectional(Property<PrintSides> other) {
                    throw new RuntimeException("PrintSides property cannot be bound");
                }

                public String toString() {
                    return ((PrintSides)((Object)this.get())).toString();
                }
            };
        }
        return this.sides;
    }

    public final PrintSides getPrintSides() {
        return (PrintSides)((Object)this.printSidesProperty().get());
    }

    public final void setPrintSides(PrintSides sides) {
        if (sides == this.getPrintSides()) {
            return;
        }
        this.printSidesProperty().set((Object)sides);
    }

    public final ObjectProperty<Collation> collationProperty() {
        if (this.collation == null) {
            Collation coll = this.printerCaps.getDefaultCollation();
            this.collation = new SimpleObjectProperty<Collation>((Object)this, "collation", coll){

                public void set(Collation value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultCollation) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultCollation());
                        JobSettings.this.defaultCollation = true;
                        return;
                    }
                    if (JobSettings.this.printerCaps.getSupportedCollations().contains((Object)value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultCollation = false;
                    }
                }

                public void bind(ObservableValue<? extends Collation> rawObservable) {
                    throw new RuntimeException("Collation property cannot be bound");
                }

                public void bindBidirectional(Property<Collation> other) {
                    throw new RuntimeException("Collation property cannot be bound");
                }

                public String toString() {
                    return ((Collation)((Object)this.get())).toString();
                }
            };
        }
        return this.collation;
    }

    public final Collation getCollation() {
        return (Collation)((Object)this.collationProperty().get());
    }

    public final void setCollation(Collation collation) {
        if (collation == this.getCollation()) {
            return;
        }
        this.collationProperty().set((Object)collation);
    }

    public final ObjectProperty<PrintColor> printColorProperty() {
        if (this.color == null) {
            this.color = new SimpleObjectProperty<PrintColor>((Object)this, "printColor", this.printerCaps.getDefaultPrintColor()){

                public void set(PrintColor value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultPrintColor) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultPrintColor());
                        JobSettings.this.defaultPrintColor = true;
                    }
                    if (JobSettings.this.printerCaps.getSupportedPrintColors().contains((Object)value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultPrintColor = false;
                    }
                }

                public void bind(ObservableValue<? extends PrintColor> rawObservable) {
                    throw new RuntimeException("PrintColor property cannot be bound");
                }

                public void bindBidirectional(Property<PrintColor> other) {
                    throw new RuntimeException("PrintColor property cannot be bound");
                }

                public String toString() {
                    return ((PrintColor)((Object)this.get())).toString();
                }
            };
        }
        return this.color;
    }

    public final PrintColor getPrintColor() {
        return (PrintColor)((Object)this.printColorProperty().get());
    }

    public final void setPrintColor(PrintColor color) {
        if (color == this.getPrintColor()) {
            return;
        }
        this.printColorProperty().set((Object)color);
    }

    public final ObjectProperty<PrintQuality> printQualityProperty() {
        if (this.quality == null) {
            this.quality = new SimpleObjectProperty<PrintQuality>((Object)this, "printQuality", this.printerCaps.getDefaultPrintQuality()){

                public void set(PrintQuality value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultPrintQuality) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultPrintQuality());
                        JobSettings.this.defaultPrintQuality = true;
                    }
                    if (JobSettings.this.printerCaps.getSupportedPrintQuality().contains((Object)value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultPrintQuality = false;
                    }
                }

                public void bind(ObservableValue<? extends PrintQuality> rawObservable) {
                    throw new RuntimeException("PrintQuality property cannot be bound");
                }

                public void bindBidirectional(Property<PrintQuality> other) {
                    throw new RuntimeException("PrintQuality property cannot be bound");
                }

                public String toString() {
                    return ((PrintQuality)((Object)this.get())).toString();
                }
            };
        }
        return this.quality;
    }

    public final PrintQuality getPrintQuality() {
        return (PrintQuality)((Object)this.printQualityProperty().get());
    }

    public final void setPrintQuality(PrintQuality quality) {
        if (quality == this.getPrintQuality()) {
            return;
        }
        this.printQualityProperty().set((Object)quality);
    }

    public final ObjectProperty<PrintResolution> printResolutionProperty() {
        if (this.resolution == null) {
            this.resolution = new SimpleObjectProperty<PrintResolution>((Object)this, "printResolution", this.printerCaps.getDefaultPrintResolution()){

                public void set(PrintResolution value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultPrintResolution) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultPrintResolution());
                        JobSettings.this.defaultPrintResolution = true;
                    }
                    if (JobSettings.this.printerCaps.getSupportedPrintResolutions().contains(value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultPrintResolution = false;
                    }
                }

                public void bind(ObservableValue<? extends PrintResolution> rawObservable) {
                    throw new RuntimeException("PrintResolution property cannot be bound");
                }

                public void bindBidirectional(Property<PrintResolution> other) {
                    throw new RuntimeException("PrintResolution property cannot be bound");
                }

                public String toString() {
                    return ((PrintResolution)this.get()).toString();
                }
            };
        }
        return this.resolution;
    }

    public final PrintResolution getPrintResolution() {
        return (PrintResolution)this.printResolutionProperty().get();
    }

    public final void setPrintResolution(PrintResolution resolution) {
        if (resolution == null || resolution == this.getPrintResolution()) {
            return;
        }
        this.printResolutionProperty().set((Object)resolution);
    }

    public final ObjectProperty<PaperSource> paperSourceProperty() {
        if (this.paperSource == null) {
            this.paperSource = new SimpleObjectProperty<PaperSource>((Object)this, "paperSource", this.printerCaps.getDefaultPaperSource()){

                public void set(PaperSource value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        if (JobSettings.this.defaultPaperSource) {
                            return;
                        }
                        super.set((Object)JobSettings.this.printerCaps.getDefaultPaperSource());
                        JobSettings.this.defaultPaperSource = true;
                    }
                    if (JobSettings.this.printerCaps.getSupportedPaperSources().contains(value)) {
                        super.set((Object)value);
                        JobSettings.this.defaultPaperSource = false;
                    }
                }

                public void bind(ObservableValue<? extends PaperSource> rawObservable) {
                    throw new RuntimeException("PaperSource property cannot be bound");
                }

                public void bindBidirectional(Property<PaperSource> other) {
                    throw new RuntimeException("PaperSource property cannot be bound");
                }

                public String toString() {
                    return ((PaperSource)this.get()).toString();
                }
            };
        }
        return this.paperSource;
    }

    public final PaperSource getPaperSource() {
        return (PaperSource)this.paperSourceProperty().get();
    }

    public final void setPaperSource(PaperSource value) {
        this.paperSourceProperty().set((Object)value);
    }

    public final ObjectProperty<PageLayout> pageLayoutProperty() {
        if (this.layout == null) {
            this.layout = new SimpleObjectProperty<PageLayout>((Object)this, "pageLayout", this.printer.getDefaultPageLayout()){

                public void set(PageLayout value) {
                    if (!JobSettings.this.isJobNew()) {
                        return;
                    }
                    if (value == null) {
                        return;
                    }
                    JobSettings.this.defaultPageLayout = false;
                    super.set((Object)value);
                }

                public void bind(ObservableValue<? extends PageLayout> rawObservable) {
                    throw new RuntimeException("PageLayout property cannot be bound");
                }

                public void bindBidirectional(Property<PageLayout> other) {
                    throw new RuntimeException("PageLayout property cannot be bound");
                }

                public String toString() {
                    return ((PageLayout)this.get()).toString();
                }
            };
        }
        return this.layout;
    }

    public final PageLayout getPageLayout() {
        return (PageLayout)this.pageLayoutProperty().get();
    }

    public final void setPageLayout(PageLayout pageLayout) {
        this.pageLayoutProperty().set((Object)pageLayout);
    }

    public String toString() {
        String nl = System.lineSeparator();
        return " Collation = " + this.getCollation() + nl + " Copies = " + this.getCopies() + nl + " Sides = " + this.getPrintSides() + nl + " JobName = " + this.getJobName() + nl + " Output file = " + this.getOutputFile() + nl + " Page ranges = " + this.pageRangesProperty().toString() + nl + " Print color = " + this.getPrintColor() + nl + " Print quality = " + this.getPrintQuality() + nl + " Print resolution = " + this.getPrintResolution() + nl + " Paper source = " + this.getPaperSource() + nl + " Page layout = " + this.getPageLayout();
    }
}

